/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_S_TimeExpense;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MTimeExpense
extends X_S_TimeExpense
implements DocAction {
    private static final long serialVersionUID = 1567303438502090279L;
    private int m_M_Locator_ID = 0;
    private MTimeExpenseLine[] m_lines = null;
    private int m_AD_User_ID = 0;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MTimeExpense(Properties ctx, int S_TimeExpense_ID, String trxName) {
        super(ctx, S_TimeExpense_ID, trxName);
        if (S_TimeExpense_ID == 0) {
            this.setDateReport(new Timestamp(System.currentTimeMillis()));
            this.setIsApproved(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MTimeExpense(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTimeExpenseLine[] getLines() {
        return this.getLines(true);
    }

    public MTimeExpenseLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MTimeExpense.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        int C_Currency_ID = this.getC_Currency_ID();
        ArrayList<MTimeExpenseLine> list = new ArrayList<MTimeExpenseLine>();
        String sql = "SELECT * FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getS_TimeExpense_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTimeExpenseLine te = new MTimeExpenseLine(this.getCtx(), rs, this.get_TrxName());
                te.setC_Currency_Report_ID(C_Currency_ID);
                list.add(te);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "getLines", ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        this.m_lines = new MTimeExpenseLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public int getM_Locator_ID() {
        if (this.m_M_Locator_ID != 0) {
            return this.m_M_Locator_ID;
        }
        String sql = "SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID=? AND IsActive='Y' ORDER BY IsDefault DESC, Created";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getM_Warehouse_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_M_Locator_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "getM_Locator_ID", ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        return this.m_M_Locator_ID;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE S_TimeExpenseLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE S_TimeExpense_ID=" + this.getS_TimeExpense_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - Lines=" + noLine);
    }

    @Override
    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "S_TimeExpense_ID") + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MTimeExpenseLine line;
        int i2;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateReport(), "API", this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MTimeExpenseLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal amt = Env.ZERO;
        for (i2 = 0; i2 < lines.length; ++i2) {
            line = lines[i2];
            amt = amt.add(line.getApprovalAmt());
        }
        this.setApprovalAmt(amt);
        for (i2 = 0; i2 < lines.length; ++i2) {
            line = lines[i2];
            if (!line.isInvoiced() || line.getC_BPartner_ID() != 0) continue;
            this.m_processMsg = "@Line@ " + line.getLine() + ": Invoiced, but no Business Partner";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.closeIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return this.m_processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        MUser[] users;
        if (this.m_AD_User_ID != 0) {
            return this.m_AD_User_ID;
        }
        if (this.getC_BPartner_ID() != 0 && (users = MUser.getOfBPartner(this.getCtx(), this.getC_BPartner_ID())).length > 0) {
            this.m_AD_User_ID = users[0].getAD_User_ID();
            return this.m_AD_User_ID;
        }
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        MPriceList pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), this.get_TrxName());
        return pl.getC_Currency_ID();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

