/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MProcess;
import org.compiere.model.MSequence;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

public class MTable
extends X_AD_Table {
    private static final long serialVersionUID = -2367316254623142732L;
    private static CCache<Integer, MTable> s_cache = new CCache("AD_Table", 20);
    private static CCache<String, Class<?>> s_classCache = new CCache("PO_Class", 20);
    private static CCache<String, Boolean> s_cachetrl = new CCache("Table_Trl", 20);
    private List<MColumn> columns = null;
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private static final String[] s_packages = new String[]{"org.compiere.model", "org.compiere.wf", "org.compiere.report", "org.compiere.print", "org.compiere.impexp", "compiere.model", "adempiere.model", "org.adempiere.model"};
    private static final String[] s_special = new String[]{"AD_Element", "org.compiere.model.M_Element", "AD_Registration", "org.compiere.model.M_Registration", "R_Category", "org.compiere.model.MRequestCategory", "GL_Category", "org.compiere.model.MGLCategory", "K_Category", "org.compiere.model.MKCategory", "C_ValidCombination", "org.compiere.model.MAccount", "C_Phase", "org.compiere.model.MProjectTypePhase", "C_Task", "org.compiere.model.MProjectTypeTask", "AD_View_Column", "org.adempiere.model.MViewColumn", "AD_View", "org.adempiere.model.MView", "AD_View_Definition", "org.adempiere.model.MViewDefinition", "AD_Browse", "org.adempiere.model.MBrowse", "AD_Browse_Field", "org.adempiere.model.MBrowseField", "T_Selection", "org.adempiere.model.X_T_Selection"};
    private static final String MSG_TableWithThatNameAlreadyExists = "@MTable_SyncErrorTableWithThatNameAlreadyExists@";
    private static final String MSG_WillUpdatePrimaryKey = "@MTable_WillUpdatePrimaryKey@";
    private static final String MSG_ErrorSynchronizingChanges = "@MTable_ErrorSynchronizingChanges@";
    private static final String MSG_CannotSyncView = "@MTable_CannotSyncView";

    public static MTable get(Properties ctx, int AD_Table_ID) {
        Integer key = new Integer(AD_Table_ID);
        MTable retValue = s_cache.get(key);
        if (retValue != null && retValue.getCtx() == ctx) {
            return retValue;
        }
        retValue = new MTable(ctx, AD_Table_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MTable get(Properties ctx, String tableName) {
        MTable retValue2;
        if (tableName == null) {
            return null;
        }
        for (MTable retValue2 : s_cache.values()) {
            if (!tableName.equalsIgnoreCase(retValue2.getTableName()) || retValue2.getCtx() != ctx) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, tableName.toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue2 = new MTable(ctx, rs, null);
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        if (retValue2 != null) {
            Integer key = new Integer(retValue2.getAD_Table_ID());
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static String getTableName(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    public static Class<?> getClass(String tableName) {
        String className;
        int index;
        MEntityType et;
        String etmodelpackage;
        if (tableName == null || tableName.endsWith("_Trl")) {
            return null;
        }
        Class<?> cache = s_classCache.get(tableName);
        if (cache != null) {
            if (cache.equals(Object.class)) {
                return null;
            }
            return cache;
        }
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        String entityType = table2.getEntityType();
        if (tableName.startsWith("I_")) {
            Class<?> clazz;
            MEntityType et2 = MEntityType.get(Env.getCtx(), entityType);
            String etmodelpackage2 = et2.getModelPackage();
            if (etmodelpackage2 == null || "D".equals(entityType)) {
                etmodelpackage2 = "org.compiere.model";
            }
            if ((clazz = MTable.getPOclass(etmodelpackage2 + ".X_" + tableName, tableName)) != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table: " + tableName);
            return null;
        }
        for (int i2 = 0; i2 < s_special.length; ++i2) {
            if (!s_special[i2++].equals(tableName)) continue;
            Class<?> clazz = MTable.getPOclass(s_special[i2], tableName);
            if (clazz == null) break;
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        if (!"D".equals(entityType) && (etmodelpackage = (et = MEntityType.get(Env.getCtx(), entityType)).getModelPackage()) != null) {
            Class<?> clazz = null;
            clazz = MTable.getPOclass(etmodelpackage + ".M" + Util.replace(tableName, "_", ""), tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            clazz = MTable.getPOclass(etmodelpackage + ".M" + tableName.substring(tableName.indexOf("_") + 1), tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            clazz = MTable.getPOclass(etmodelpackage + ".X_" + tableName, tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table with it entity: " + tableName);
        }
        if ((index = (className = tableName).indexOf(95)) > 0 && index < 3) {
            className = className.substring(index + 1);
        }
        className = Util.replace(className, "_", "");
        for (int i3 = 0; i3 < s_packages.length; ++i3) {
            StringBuffer name = new StringBuffer(s_packages[i3]).append(".M").append(className);
            Class<?> clazz = MTable.getPOclass(name.toString(), tableName);
            if (clazz == null) continue;
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        Class<?> clazz = MTable.getPOclass("adempiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("compiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("org.compiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        s_classCache.put(tableName, Object.class);
        return null;
    }

    private static Class<?> getPOclass(String className) {
        return MTable.getPOclass(className, null);
    }

    private static Class<?> getPOclass(String className, String tableName) {
        try {
            String classTableName;
            Class<?> clazz = Class.forName(className);
            if (tableName != null && !tableName.equals(classTableName = clazz.getField("Table_Name").get(null).toString())) {
                s_log.finest("Invalid class for table: " + className + " (tableName=" + tableName + ", classTableName=" + classTableName + ")");
                return null;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != PO.class) continue;
                s_log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_log.finest("Not found: " + className);
        return null;
    }

    public MTable(Properties ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setAccessLevel("4");
            this.setEntityType("U");
            this.setIsChangeLog(false);
            this.setIsDeleteable(false);
            this.setIsHighVolume(false);
            this.setIsSecurityEnabled(false);
            this.setIsView(false);
            this.setReplicationType("L");
        }
    }

    public MTable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn[] getColumns(boolean requery) {
        List<MColumn> columnList = this.getColumnsAsList(requery);
        MColumn[] columnArray = new MColumn[columnList.size()];
        this.columns.toArray(columnArray);
        return columnArray;
    }

    public List<MColumn> getColumnsAsList() {
        return this.getColumnsAsList(false);
    }

    public List<MColumn> getColumnsAsList(boolean requery) {
        if (this.columns != null && this.columns.size() != 0 && !requery) {
            return this.columns;
        }
        this.columns = new Query(this.getCtx(), "AD_Column", "AD_Table_ID = ?", this.get_TrxName()).setParameters(this.getAD_Table_ID()).setOrderBy("ColumnName").list();
        return this.columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            return null;
        }
        if (this.columns == null || this.columns.size() == 0) {
            this.getColumns(false);
        }
        for (MColumn column : this.columns) {
            if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
            return column;
        }
        return null;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        for (MColumn column : this.columns) {
            if (column.isKey()) {
                return new String[]{column.getColumnName()};
            }
            if (!column.isParent()) continue;
            list.add(column.getColumnName());
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public PO getPO(int Record_ID, String trxName) {
        String tableName = this.getTableName();
        if (Record_ID != 0 && !this.isSingleKey()) {
            this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
            return null;
        }
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.INFO, "Using GenericPO for " + tableName);
            GenericPO po = new GenericPO(tableName, this.getCtx(), (int)new Integer(Record_ID), trxName);
            return po;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                this.log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
            }
            PO po = (PO)constructor.newInstance(this.getCtx(), new Integer(Record_ID), trxName);
            if (po != null && po.get_ID() != Record_ID && Record_ID > 0) {
                return null;
            }
            return po;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, t);
                errorLogged = true;
                if (t instanceof Exception) {
                    this.log.saveError("Error", (Exception)e.getCause());
                } else {
                    this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                }
            } else {
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, e);
                errorLogged = true;
                this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            }
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName + ", Record_ID=" + Record_ID);
            }
            return null;
        }
    }

    public PO getPO(ResultSet rs, String trxName) {
        String tableName = this.getTableName();
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.INFO, "Using GenericPO for " + tableName);
            GenericPO po = new GenericPO(tableName, this.getCtx(), rs, trxName);
            return po;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
            PO po = (PO)constructor.newInstance(this.getCtx(), rs, trxName);
            return po;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "(rs) - Table=" + tableName + ",Class=" + clazz, e);
            errorLogged = true;
            this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(rs) - Not found - Table=" + tableName);
            }
            return null;
        }
    }

    public PO getPO(String whereClause, String trxName) {
        return this.getPO(whereClause, null, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PO getPO(String whereClause, Object[] params, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        PO po;
        block8: {
            if (whereClause == null || whereClause.length() == 0) {
                return null;
            }
            po = null;
            POInfo info = POInfo.getPOInfo(this.getCtx(), this.getAD_Table_ID(), trxName);
            if (info == null) {
                return null;
            }
            StringBuffer sqlBuffer = info.buildSelect();
            sqlBuffer.append(" WHERE ").append(whereClause);
            String sql = sqlBuffer.toString();
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                if (params != null && params.length > 0) {
                    for (int i2 = 0; i2 < params.length; ++i2) {
                        pstmt.setObject(i2 + 1, params[i2]);
                    }
                }
                if (!(rs = pstmt.executeQuery()).next()) break block8;
                po = this.getPO(rs, trxName);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    this.log.saveError("Error", e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return po;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        s_cache.remove(this.getAD_Table_ID());
        if ((this.isView() || this.isDocument()) && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        if (!this.isView() && (newRecord || this.is_ValueChanged("TableName"))) {
            if (this.isRequiresSync()) {
                if (this.getTableName().equals(this.getNameOldValue())) {
                    this.setRequiresSync(false);
                    this.setNameOldValue(null);
                }
            } else {
                this.setRequiresSync(true);
                this.setNameOldValue((String)this.get_ValueOld("TableName"));
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        s_cache.put(this.getAD_Table_ID(), this);
        if (this.isView()) {
            return success;
        }
        String oldTableName = (String)this.get_ValueOld("TableName");
        if (newRecord) {
            this.createMandatoryColumns();
            this.createMandatoryDocumentColumns();
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            }
        } else {
            if (this.is_ValueChanged("IsDocument")) {
                this.createMandatoryDocumentColumns();
            }
            MSequence seqOld = MSequence.get(this.getCtx(), oldTableName, this.get_TrxName());
            MSequence seqNew = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (!(seqOld != null && seqOld.get_ID() != 0 || seqNew != null && seqNew.get_ID() != 0)) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            } else if (!(seqOld == null || seqOld.get_ID() == 0 || seqNew != null && seqNew.get_ID() != 0 || seqOld.getName().equals(this.getTableName()))) {
                seqOld.setName(this.getTableName());
                seqOld.setDescription("Table " + this.getTableName());
                seqOld.saveEx();
            }
        }
        if (MColumn.isAutoSync() && this.isRequiresSync()) {
            this.syncDatabase(null);
        }
        return success;
    }

    public String getSQLCreate() {
        StringBuffer sb = new StringBuffer("CREATE TABLE ").append(this.getTableName()).append(" (");
        boolean hasPK = false;
        boolean hasParents = false;
        StringBuffer constraints = new StringBuffer();
        this.getColumns(true);
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            String constraint;
            MColumn column = this.columns.get(i2);
            String colSQL = column.getSQLDDL();
            if (colSQL == null) continue;
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(column.getSQLDDL());
            if (column.isKey()) {
                hasPK = true;
            }
            if (column.isParent()) {
                hasParents = true;
            }
            if ((constraint = column.getConstraint(this.getTableName())) == null || constraint.length() <= 0) continue;
            constraints.append(", ").append(constraint);
        }
        if (!hasPK && hasParents) {
            StringBuffer cols = new StringBuffer();
            for (MColumn column : this.columns) {
                if (!column.isParent()) continue;
                if (cols.length() > 0) {
                    cols.append(", ");
                }
                cols.append(column.getColumnName());
            }
            String tableName = this.getTableName();
            String constraintName = "";
            constraintName = tableName.length() > 26 ? tableName.substring(0, 26) + "_Key" : tableName + "_Key";
            sb.append(", CONSTRAINT ").append(constraintName).append(" PRIMARY KEY (").append(cols).append(")");
        }
        sb.append(constraints).append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTable_ID(String tableName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int retValue;
        block4: {
            retValue = 0;
            String SQL = "SELECT AD_Table_ID FROM AD_Table WHERE tablename = ?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(SQL, null);
                pstmt.setString(1, tableName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                retValue = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return retValue;
    }

    public Query createQuery(String whereClause, String trxName) {
        return new Query(this.getCtx(), this, whereClause, trxName);
    }

    public void createMandatoryColumns() {
        MColumn column = null;
        if (!(this.isView() || this.getTableName().endsWith("_Trl") || this.getTableName().endsWith("_Access"))) {
            M_Element element = M_Element.get(this.getCtx(), this.getTableName() + "_ID", this.get_TrxName());
            if (element == null) {
                element = new M_Element(this.getCtx(), 0, this.get_TrxName());
                element.setColumnName(this.getTableName() + "_ID");
                element.setName(this.getName() + " ID");
                element.setPrintName(this.getName() + " ID");
                element.setEntityType(this.getEntityType());
                element.saveEx();
            }
            column = new MColumn(this, element.getColumnName(), 22, 13, "");
            column.setAD_Element_ID(element.get_ID());
            column.setIsKey(true);
            column.setUpdateable(false);
            column.setIsMandatory(true);
            column.saveEx();
        }
        column = new MColumn(this, "AD_Client_ID", 22, 19, "@#AD_Client_ID@");
        column.setUpdateable(false);
        column.setAD_Val_Rule_ID(129);
        column.saveEx();
        column = new MColumn(this, "AD_Org_ID", 22, 19, "@#AD_Org_ID@");
        column.setUpdateable(true);
        column.setAD_Val_Rule_ID(104);
        column.saveEx();
        column = new MColumn(this, "IsActive", 1, 20, "Y");
        column.setUpdateable(true);
        column.saveEx();
        column = new MColumn(this, "Created", 7, 16, "");
        column.saveEx();
        column = new MColumn(this, "Updated", 7, 16, "");
        column.saveEx();
        column = new MColumn(this, "CreatedBy", 22, 18, "");
        column.setAD_Reference_Value_ID(110);
        column.saveEx();
        column = new MColumn(this, "UpdatedBy", 22, 18, "");
        column.setAD_Reference_Value_ID(110);
        column.saveEx();
        column = new MColumn(this, "UUID", 36, 10, "");
        column.setIsMandatory(false);
        column.saveEx();
    }

    private void createMandatoryDocumentColumns() {
        if (this.isDocument()) {
            MColumn column = null;
            String columnName = "C_DocType_ID";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 22, 19, "");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.setIsSelectionColumn(true);
                column.saveEx();
            }
            columnName = "DocumentNo";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 60, 10, "");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.setIsSelectionColumn(true);
                column.setIsIdentifier(true);
                column.setSeqNo(1);
                column.saveEx();
            }
            columnName = "DateDoc";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 7, 15, "@#Date@");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.setIsSelectionColumn(true);
                column.saveEx();
            }
            columnName = "Processed";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 1, 20, "N");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.saveEx();
            }
            columnName = "Processing";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 1, 20, "N");
                column.setIsMandatory(true);
                column.setUpdateable(true);
                column.setIsAlwaysUpdateable(true);
                column.saveEx();
            }
            columnName = "IsApproved";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 1, 20, "N");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.saveEx();
            }
            columnName = "Description";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 255, 14, "");
                column.setIsMandatory(false);
                column.setUpdateable(true);
                column.setIsAlwaysUpdateable(true);
                column.setIsSelectionColumn(true);
                column.saveEx();
            }
            columnName = "DocStatus";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 2, 17, "DR");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.setAD_Reference_Value_ID(131);
                column.setIsSelectionColumn(true);
                column.setIsIdentifier(true);
                column.setSeqNo(2);
                column.saveEx();
            }
            columnName = "DocAction";
            if (MColumn.getColumn_ID(this.getTableName(), columnName) <= 0) {
                column = new MColumn(this, columnName, 2, 28, "CO");
                column.setIsMandatory(true);
                column.setUpdateable(false);
                column.setAD_Reference_Value_ID(135);
                column.setAD_Process_ID(this.getworkFlowProcess());
                column.saveEx();
            }
        }
    }

    private int getworkFlowProcess() {
        int m_AD_Process_ID;
        MWorkflow workFlow = MWorkflow.getWorkFlowFromDocumentTable(this.getCtx(), this.getAD_Table_ID(), this.get_TrxName());
        if (workFlow == null) {
            workFlow = new MWorkflow(this.getCtx(), 0, this.get_TrxName());
            workFlow.setValue("Process_" + this.getName());
            workFlow.setName(workFlow.getValue());
            workFlow.setDescription("(Standard Process_" + this.getName() + ")");
            workFlow.setWorkflowType("P");
            workFlow.setAD_Table_ID(this.getAD_Table_ID());
            workFlow.setAccessLevel(this.getAccessLevel());
            workFlow.setEntityType(this.getEntityType());
            workFlow.setPublishStatus("T");
            workFlow.setAuthor("ADempiere");
            workFlow.setDuration(1);
            workFlow.saveEx();
            MWFNode wfNode_Start = new MWFNode(workFlow, "(Start)", "(Start)");
            wfNode_Start.setDescription(workFlow.getName());
            wfNode_Start.setEntityType(this.getEntityType());
            wfNode_Start.setJoinElement("X");
            wfNode_Start.setSplitElement("X");
            wfNode_Start.setAction("Z");
            wfNode_Start.saveEx();
            workFlow.setAD_WF_Node_ID(wfNode_Start.getAD_WF_Node_ID());
            workFlow.saveEx();
            MWFNode wfNode_Auto = new MWFNode(workFlow, "(DocAuto)", "(DocAuto)");
            wfNode_Auto.setDescription(workFlow.getName());
            wfNode_Auto.setEntityType(this.getEntityType());
            wfNode_Auto.setJoinElement("X");
            wfNode_Auto.setSplitElement("X");
            wfNode_Auto.setAction("D");
            wfNode_Auto.setDocAction("--");
            wfNode_Auto.saveEx();
            MWFNode wfNode_Prepare = new MWFNode(workFlow, "(DocPrepare)", "(DocPrepare)");
            wfNode_Prepare.setDescription(workFlow.getName());
            wfNode_Prepare.setEntityType(this.getEntityType());
            wfNode_Prepare.setJoinElement("X");
            wfNode_Prepare.setSplitElement("X");
            wfNode_Prepare.setAction("D");
            wfNode_Prepare.setDocAction("PR");
            wfNode_Prepare.saveEx();
            MWFNode wfNode_Complete = new MWFNode(workFlow, "(DocComplete)", "(DocComplete)");
            wfNode_Complete.setDescription(workFlow.getName());
            wfNode_Complete.setEntityType(this.getEntityType());
            wfNode_Complete.setJoinElement("X");
            wfNode_Complete.setSplitElement("X");
            wfNode_Complete.setAction("D");
            wfNode_Complete.setDocAction("CO");
            wfNode_Complete.saveEx();
            MWFNodeNext wfNodeNext = new MWFNodeNext(wfNode_Start, wfNode_Prepare.getAD_WF_Node_ID());
            wfNodeNext.setDescription("(Standard Approval)");
            wfNodeNext.setEntityType(this.getEntityType());
            wfNodeNext.setSeqNo(10);
            wfNodeNext.setIsStdUserWorkflow(true);
            wfNodeNext.saveEx();
            wfNodeNext = new MWFNodeNext(wfNode_Start, wfNode_Auto.getAD_WF_Node_ID());
            wfNodeNext.setDescription("(Standard Transition)");
            wfNodeNext.setEntityType(this.getEntityType());
            wfNodeNext.setSeqNo(100);
            wfNodeNext.setIsStdUserWorkflow(false);
            wfNodeNext.saveEx();
            wfNodeNext = new MWFNodeNext(wfNode_Prepare, wfNode_Complete.getAD_WF_Node_ID());
            wfNodeNext.setDescription("(Standard Transition)");
            wfNodeNext.setEntityType(this.getEntityType());
            wfNodeNext.setSeqNo(100);
            wfNodeNext.setIsStdUserWorkflow(false);
            wfNodeNext.saveEx();
        }
        if ((m_AD_Process_ID = MProcess.getProcess_ID(this.getTableName() + "_Process", this.get_TrxName())) <= 0) {
            MProcess workFlowProcess = new MProcess(this.getCtx(), 0, this.get_TrxName());
            workFlowProcess.setValue(this.getTableName() + "_Process");
            workFlowProcess.setName("Process " + this.getName());
            workFlowProcess.setEntityType(this.getEntityType());
            workFlowProcess.setAccessLevel(this.getAccessLevel());
            workFlowProcess.setAD_Workflow_ID(workFlow.getAD_Workflow_ID());
            workFlowProcess.saveEx();
            return workFlowProcess.getAD_Process_ID();
        }
        return m_AD_Process_ID;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }

    public static boolean hasTranslation(String tableName) {
        Boolean hasTrl = s_cachetrl.get(tableName);
        if (hasTrl == null) {
            hasTrl = new Query(Env.getCtx(), "AD_Column", "IsTranslated = 'Y' AND EXISTS(SELECT 1 FROM AD_Table t WHERE t.AD_Table_ID = AD_Column.AD_Table_ID AND t.TableName = ?)", null).setParameters(tableName).match();
            s_cachetrl.put(tableName, hasTrl);
        }
        return hasTrl;
    }

    public String getSQLAlter(String oldTableName, Connection conn) {
        if (oldTableName == null || oldTableName.length() == 0 || oldTableName.equals(this.getTableName())) {
            return "";
        }
        StringBuffer sb = new StringBuffer("ALTER TABLE IF EXISTS ").append(oldTableName).append(" RENAME TO ").append(this.getTableName()).append("; ");
        boolean hasPK = false;
        boolean hasParents = false;
        StringBuffer constraints = new StringBuffer();
        String constraintName = "";
        boolean closeConn = false;
        try {
            if (conn == null) {
                if (this.get_TrxName() != null && !this.get_TrxName().isEmpty()) {
                    conn = Trx.get(this.get_TrxName(), true).getConnection();
                } else {
                    conn = DB.getConnectionRO();
                    closeConn = true;
                }
            }
            DatabaseMetaData md = conn.getMetaData();
            String string = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = oldTableName;
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            ResultSet rs = md.getPrimaryKeys(string, schema, tableName);
            while (rs.next()) {
                if (rs.getString("PK_Name") == null || (constraintName = rs.getString("PK_Name")) == null || constraintName.length() <= 0) continue;
                constraints.append(" ").append("ALTER TABLE IF EXISTS ").append(this.getTableName()).append(" DROP CONSTRAINT IF EXISTS ").append(constraintName).append(" CASCADE").append("; ");
            }
            rs.close();
            rs = null;
        }
        catch (SQLException e) {
            throw new AdempiereException(e);
        }
        finally {
            if (closeConn && conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
                conn = null;
            }
        }
        this.getColumns(true);
        for (MColumn mColumn : this.columns) {
            String constraint;
            if (mColumn.isKey()) {
                hasPK = true;
            }
            if (mColumn.isParent()) {
                hasParents = true;
            }
            if ((constraint = mColumn.getConstraint(this.getTableName())) == null || constraint.length() <= 0) continue;
            constraints.append(" ").append("ALTER TABLE IF EXISTS ").append(this.getTableName()).append(" ADD ").append(constraint).append("; ");
        }
        if (!hasPK && hasParents) {
            StringBuffer cols = new StringBuffer();
            for (MColumn column : this.columns) {
                if (!column.isParent()) continue;
                if (cols.length() > 0) {
                    cols.append(", ");
                }
                cols.append(column.getColumnName());
            }
            String string = this.getTableName();
            constraintName = "";
            constraintName = string.length() > 26 ? string.substring(0, 26) + "_Key" : string + "_Key";
            constraints.append(" ").append("ALTER TABLE IF EXISTS ").append(this.getTableName()).append(" ADD CONSTRAINT ").append(constraintName).append(" PRIMARY KEY (").append(cols).append(")").append("; ");
        }
        sb.append(constraints);
        return sb.toString();
    }

    public String syncDatabase(Connection conn) {
        return this.syncDatabase(conn, false);
    }

    public String syncDatabase(Connection conn, boolean isOnlyReport) {
        String string;
        boolean onlySyncedIDColumn;
        String sql;
        String trxName;
        boolean closeConn;
        ResultSet rs;
        boolean errorOccured;
        String returnMessage;
        block44: {
            String oldTableName;
            if (this.isView()) {
                this.markSyncComplete();
                s_log.warning("Can't sync a column in a view. Table ID: " + this.get_Table_ID());
                return MSG_CannotSyncView;
            }
            if (this.get_ID() == 0) {
                throw new AdempiereException("@NotFound@ @AD_Table_ID@ " + this.getAD_Table_ID());
            }
            returnMessage = this.updatePrimaryKeyColumn(isOnlyReport);
            if (!returnMessage.isEmpty()) {
                returnMessage = returnMessage + "\n";
            }
            if ((oldTableName = this.getNameOldValue()) == null || oldTableName.length() == 0 || oldTableName.equals(this.getTableName())) {
                oldTableName = null;
            }
            boolean oldTableExists = false;
            boolean newTableExists = false;
            errorOccured = true;
            rs = null;
            closeConn = false;
            trxName = this.get_TrxName();
            if (conn == null) {
                if (trxName == null || trxName.isEmpty()) {
                    conn = DB.getConnectionRO();
                    closeConn = true;
                } else {
                    conn = Trx.get(trxName, true).getConnection();
                }
            }
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String[] tableTypes = new String[]{"TABLE"};
            String tableName = oldTableName;
            if (oldTableName != null) {
                if (md.storesUpperCaseIdentifiers()) {
                    tableName = tableName.toUpperCase();
                } else if (md.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                rs = md.getTables(catalog, schema, tableName, tableTypes);
                if (rs.next()) {
                    oldTableExists = true;
                }
                rs.close();
            }
            tableName = this.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            rs = md.getTables(catalog, schema, tableName, tableTypes);
            if (rs.next()) {
                newTableExists = true;
            }
            rs.close();
            rs = null;
            sql = null;
            onlySyncedIDColumn = false;
            if (!oldTableExists && !newTableExists) {
                onlySyncedIDColumn = false;
                sql = this.getSQLCreate();
            } else if (oldTableExists && !newTableExists) {
                onlySyncedIDColumn = true;
                sql = this.getSQLAlter(oldTableName, conn);
            } else {
                if (oldTableExists && newTableExists) {
                    s_log.severe("New table already exists: " + oldTableName + "->" + tableName);
                    throw new AdempiereException("@MTable_SyncErrorTableWithThatNameAlreadyExists@: " + oldTableName + "->" + tableName);
                }
                if (!oldTableExists && newTableExists) {
                    sql = null;
                }
            }
            if (sql != null && !sql.isEmpty()) break block44;
            if (!isOnlyReport) {
                this.markSyncComplete();
            }
            String string2 = returnMessage + "@MColumn_NoSQLNoChangesMade@";
            DB.close(rs);
            rs = null;
            if (closeConn && conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                conn = null;
            }
            return string2;
        }
        try {
            block45: {
                returnMessage = returnMessage + sql;
                if (!isOnlyReport) {
                    try {
                        this.log.info("Syncing table " + this.getTableName() + ": " + sql);
                        DB.executeUpdateMultiple(sql, false, trxName);
                        DB.commit(true, trxName);
                        Exception error = CLogger.retrieveException();
                        if (error == null) {
                            returnMessage = returnMessage + "<br>@MColumn_ChangesSuccessfullyApplied@";
                            errorOccured = false;
                        } else {
                            returnMessage = returnMessage + "<br>@Error@ @MTable_ErrorSynchronizingChanges@ " + error.toString();
                        }
                        POInfo.removeFromCache(this.getAD_Table_ID());
                        if (errorOccured) break block45;
                        this.markSyncComplete();
                        for (MColumn column : this.columns) {
                            if (onlySyncedIDColumn) {
                                if (!column.isKey()) continue;
                                column.markSyncComplete();
                                break;
                            }
                            column.markSyncComplete();
                        }
                    }
                    catch (Exception e) {
                        this.log.severe("Manual intervention required: Cannot sync table: " + this.getTableName());
                        returnMessage = returnMessage + "@Error@: @MTable_ErrorSynchronizingChanges@ " + this.getTableName();
                        returnMessage = returnMessage + "\n" + sql;
                        returnMessage = returnMessage + "\n" + e.getLocalizedMessage();
                    }
                }
            }
            string = returnMessage;
        }
        catch (SQLException e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                rs = null;
                if (closeConn && conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    conn = null;
                }
                throw throwable;
            }
        }
        DB.close(rs);
        rs = null;
        if (closeConn && conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            conn = null;
        }
        return string;
    }

    public void markSyncComplete() {
        if (this.isRequiresSync() || this.getNameOldValue() != null) {
            this.setIsDirectLoad(true);
            this.set_ValueNoCheck("RequiresSync", false);
            this.set_ValueNoCheck("NameOldValue", null);
            this.saveEx();
        }
    }

    private String updatePrimaryKeyColumn(boolean isOnlyReport) {
        if (this.isView()) {
            return "";
        }
        String oldTableName = this.getNameOldValue();
        if (oldTableName == null || oldTableName.length() == 0 || oldTableName.equals(this.getTableName())) {
            return "";
        }
        if (this.getTableName().endsWith("_Trl") || this.getTableName().endsWith("_Access")) {
            return "";
        }
        if (!this.isSingleKey()) {
            return "";
        }
        String keyColumnName = this.getKeyColumns()[0];
        if (!keyColumnName.endsWith("_ID")) {
            return "";
        }
        int AD_Column_ID = MColumn.getColumn_ID(oldTableName, keyColumnName);
        if (AD_Column_ID <= 0 && (AD_Column_ID = MColumn.getColumn_ID(this.getTableName(), keyColumnName)) <= 0) {
            throw new AdempiereException("@NotFound@ @" + keyColumnName + "@ @AD_Table@ " + oldTableName);
        }
        StringBuffer sb = new StringBuffer("ALTER TABLE IF EXISTS ").append(oldTableName).append(" RENAME COLUMN ").append(oldTableName + "_ID").append(" TO ").append(this.getTableName() + "_ID;");
        if (isOnlyReport) {
            return "@MTable_WillUpdatePrimaryKey@ " + oldTableName + "_ID->" + this.getTableName() + "_ID\n" + sb.toString();
        }
        MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
        column.set_TrxName(this.get_TrxName());
        column.set_ValueNoCheck("AD_Element_ID", 0);
        column.saveEx();
        M_Element element = M_Element.get(this.getCtx(), keyColumnName, this.get_TrxName());
        if (element != null) {
            element.setColumnName(this.getTableName() + "_ID");
            element.setName(this.getName() + " ID");
            element.setPrintName(this.getName() + " ID");
            element.setEntityType(this.getEntityType());
            element.setAD_Reference_ID(13);
            element.saveEx();
        } else {
            element = M_Element.get(this.getCtx(), this.getTableName() + "_ID", this.get_TrxName());
            if (element != null) {
                element.setName(this.getName());
                element.setPrintName(this.getName());
                element.setEntityType(this.getEntityType());
                element.setAD_Reference_ID(13);
                element.saveEx();
            } else {
                element = new M_Element(this.getCtx(), this.getTableName() + "_ID", this.getEntityType(), this.get_TrxName());
                element.setName(this.getName());
                element.setPrintName(this.getName());
                element.setAD_Reference_ID(13);
                element.saveEx();
            }
        }
        column.set_ValueNoCheck("AD_Element_ID", element.get_ID());
        column.set_ValueNoCheck("AD_Reference_ID", 13);
        column.setIsDirectLoad(true);
        column.set_ValueNoCheck("RequiresSync", false);
        column.set_ValueNoCheck("NameOldValue", null);
        column.saveEx();
        DB.executeUpdateEx(sb.toString(), this.get_TrxName());
        return sb.toString();
    }
}

