/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MReplicationDocument;
import org.compiere.model.MReplicationOrgAccess;
import org.compiere.model.MReplicationRoleAccess;
import org.compiere.model.MReplicationTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ReplicationDocument;
import org.compiere.model.X_AD_ReplicationStrategy;
import org.compiere.model.X_AD_ReplicationTable;
import org.compiere.util.CLogger;

public class MReplicationStrategy
extends X_AD_ReplicationStrategy {
    private static final long serialVersionUID = -3017484140206284805L;
    public static final int REPLICATION_TABLE = 0;
    public static final int REPLICATION_DOCUMENT = 1;
    private static CLogger s_log = CLogger.getCLogger(MReplicationStrategy.class);

    public MReplicationStrategy(Properties ctx, int AD_ReplicationStrategy_ID, String trxName) {
        super(ctx, AD_ReplicationStrategy_ID, trxName);
    }

    public MReplicationStrategy(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<X_AD_ReplicationTable> getReplicationTables() {
        String whereClause = "AD_ReplicationStrategy_ID=?";
        return new Query(this.getCtx(), "AD_ReplicationTable", "AD_ReplicationStrategy_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getAD_ReplicationStrategy_ID()).setOnlyActiveRecords(true).setApplyAccessFilter(false).list();
    }

    public List<X_AD_ReplicationDocument> getReplicationDocuments() {
        String whereClause = "AD_ReplicationStrategy_ID=?";
        return new Query(this.getCtx(), "AD_ReplicationDocument", "AD_ReplicationStrategy_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getAD_ReplicationStrategy_ID()).setOnlyActiveRecords(true).setApplyAccessFilter(false).list();
    }

    public static MReplicationTable getReplicationTable(Properties ctx, int AD_ReplicationStrategy_ID, int AD_Table_ID) {
        String whereClause = "AD_ReplicationStrategy_ID=? AND AD_Table_ID=?";
        return (MReplicationTable)new Query(ctx, "AD_ReplicationTable", "AD_ReplicationStrategy_ID=? AND AD_Table_ID=?", null).setClient_ID().setOnlyActiveRecords(true).setApplyAccessFilter(false).setParameters(AD_ReplicationStrategy_ID, AD_Table_ID).first();
    }

    public static MReplicationDocument getReplicationDocument(Properties ctx, int AD_ReplicationStrategy_ID, int AD_Table_ID) {
        String whereClause = "AD_ReplicationStrategy_ID=? AND AD_Table_ID=?";
        return (MReplicationDocument)new Query(ctx, "AD_ReplicationDocument", "AD_ReplicationStrategy_ID=? AND AD_Table_ID=?", null).setClient_ID().setOnlyActiveRecords(true).setApplyAccessFilter(false).setParameters(AD_ReplicationStrategy_ID, AD_Table_ID).first();
    }

    public static MReplicationDocument getReplicationDocument(Properties ctx, int AD_ReplicationStrategy_ID, int AD_Table_ID, int C_DocType_ID) {
        String whereClause = "AD_ReplicationStrategy_ID=? AND AD_Table_ID=? AND C_DocType_ID=?";
        return (MReplicationDocument)new Query(ctx, "AD_ReplicationDocument", "AD_ReplicationStrategy_ID=? AND AD_Table_ID=? AND C_DocType_ID=?", null).setClient_ID().setOnlyActiveRecords(true).setApplyAccessFilter(false).setParameters(AD_ReplicationStrategy_ID, AD_Table_ID, C_DocType_ID).first();
    }

    public static List<MReplicationStrategy> getByClient(Properties ctx, String trxName) {
        return new Query(ctx, "AD_ReplicationStrategy", null, trxName).setClient_ID().list();
    }

    public static List<MReplicationStrategy> getByOrgAndRole(Properties ctx, int orgId, int roleId, String trxName) {
        List<MReplicationStrategy> replicationStrategies = MReplicationStrategy.getByClient(ctx, trxName);
        return replicationStrategies.stream().filter(replicationStrategy -> replicationStrategy.validateOrganization(orgId) != false && replicationStrategy.validateRole(roleId) != false).collect(Collectors.toList());
    }

    public Boolean validateOrganization(int orgId) {
        return this.getOrgAccess().stream().anyMatch(replicationOrgAccess -> replicationOrgAccess.getAD_Org_ID() == orgId);
    }

    public Boolean validateRole(int roleId) {
        return this.getRoleAccess().stream().anyMatch(replicationRoleAccess -> replicationRoleAccess.getAD_Role_ID() == roleId);
    }

    public List<MReplicationOrgAccess> getOrgAccess() {
        return new Query(this.getCtx(), "AD_ReplicationOrgAccess", "AD_ReplicationStrategy_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).list();
    }

    public List<MReplicationRoleAccess> getRoleAccess() {
        return new Query(this.getCtx(), "AD_ReplicationRoleAccess", "AD_ReplicationStrategy_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).list();
    }
}

