/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Restriction;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class MQuery
implements Serializable {
    private static CLogger s_log = CLogger.getCLogger(MQuery.class);
    private static final long serialVersionUID = 4883859385509199306L;
    private String m_TableName = "";
    private int m_AD_PInstance_ID = 0;
    private int m_windowNo = 0;
    private ArrayList<Restriction> m_list = new ArrayList();
    private int m_recordCount = 999999;
    private boolean m_newRecord = false;
    private static final String NEWRECORD = "2=3";
    private String m_zoomTable;
    private String m_zoomColumn;
    private Object m_zoomValue;
    public static final String EQUAL = "=";
    public static final int EQUAL_INDEX = 0;
    public static final String NOT_EQUAL = "!=";
    public static final int NOT_EQUAL_INDEX = 1;
    public static final String LIKE = " LIKE ";
    public static final String NOT_LIKE = " NOT LIKE ";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final String BETWEEN = " BETWEEN ";
    public static final int BETWEEN_INDEX = 8;
    public static final String NOT_NULL = " IS NOT NULL ";
    public static final String NULL = " IS NULL ";
    public static final ValueNamePair[] OPERATORS = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(" LIKE ", " ~ "), new ValueNamePair(" NOT LIKE ", " !~ "), new ValueNamePair(">", " > "), new ValueNamePair(">=", " >= "), new ValueNamePair("<", " < "), new ValueNamePair("<=", " <= "), new ValueNamePair(" BETWEEN ", " >-< "), new ValueNamePair(" IS NULL ", " NULL "), new ValueNamePair(" IS NOT NULL ", " !NULL ")};
    public static final ValueNamePair[] OPERATORS_ID = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(">", " > "), new ValueNamePair(">=", " >= "), new ValueNamePair("<", " < "), new ValueNamePair("<=", " <= "), new ValueNamePair(" BETWEEN ", " >-< ")};
    public static final ValueNamePair[] OPERATORS_YN = new ValueNamePair[]{new ValueNamePair("=", " = ")};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQuery get(Properties ctx, int AD_PInstance_ID, String TableName) {
        boolean hasVT;
        s_log.info("AD_PInstance_ID=" + AD_PInstance_ID + ", TableName=" + TableName);
        MQuery query = new MQuery(TableName);
        boolean isTemporaryTable = false;
        MTable table = null;
        table = MTable.get(ctx, TableName);
        String localTableName = TableName;
        if (TableName.toLowerCase().endsWith("_v") && !Env.isBaseLanguage(ctx, TableName) && (hasVT = DB.isTableOrViewExists(localTableName + "t"))) {
            localTableName = localTableName + "t";
        }
        if (table.getColumn("AD_PInstance_ID") != null) {
            query.addRestriction(localTableName + ".AD_PInstance_ID=" + AD_PInstance_ID, true);
            isTemporaryTable = true;
        }
        boolean isFinancialReport = "T_Report".equals(TableName) || "T_ReportStatement".equals(TableName);
        query.m_AD_PInstance_ID = AD_PInstance_ID;
        String SQL = "SELECT COUNT(*) FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
        int rows = DB.getSQLValue(null, SQL, AD_PInstance_ID);
        if (rows < 1) {
            return query;
        }
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Process_Para");
        SQL = !trl ? "SELECT ip.ParameterName,ip.P_String,ip.P_String_To,ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, pp.Name, pp.IsRange FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND pp.IsActive='Y' AND ip.AD_PInstance_ID=?" : "SELECT ip.ParameterName,ip.P_String,ip.P_String_To, ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, ppt.Name, pp.IsRange FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp, AD_Process_Para_Trl ppt WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND pp.IsActive='Y' AND pp.AD_Process_Para_ID=ppt.AD_Process_Para_ID AND ip.AD_PInstance_ID=? AND ppt.AD_Language=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_PInstance_ID);
            if (trl) {
                pstmt.setString(2, Env.getAD_Language(ctx));
            }
            rs = pstmt.executeQuery();
            int row = 0;
            while (rs.next()) {
                if (row == rows) {
                    s_log.log(Level.SEVERE, "(Parameter) - more rows than expected");
                    break;
                }
                String ParameterName = rs.getString(1);
                String P_String = rs.getString(2);
                String P_String_To = rs.getString(3);
                Double P_Number = null;
                double d = rs.getDouble(4);
                if (!rs.wasNull()) {
                    P_Number = new Double(d);
                }
                Double P_Number_To = null;
                d = rs.getDouble(5);
                if (!rs.wasNull()) {
                    P_Number_To = new Double(d);
                }
                Timestamp P_Date = rs.getTimestamp(6);
                Timestamp P_Date_To = rs.getTimestamp(7);
                String Info2 = rs.getString(8);
                String Info_To = rs.getString(9);
                String Name2 = rs.getString(10);
                boolean isRange = "Y".equals(rs.getString(11));
                s_log.fine(ParameterName + " S=" + P_String + "-" + P_String_To + ", N=" + P_Number + "-" + P_Number_To + ", D=" + P_Date + "-" + P_Date_To + "; Name=" + Name2 + ", Info=" + Info2 + "-" + Info_To + ", Range=" + isRange);
                if (isTemporaryTable && !isFinancialReport && table != null && table.getColumn(ParameterName) == null) {
                    s_log.info("Skip parameter " + ParameterName + " because there is no column in table " + TableName);
                } else {
                    MColumn column;
                    if (table != null && table.getColumn(ParameterName) != null && (column = table.getColumn(ParameterName)) != null && !Util.isEmpty(column.getColumnSQL())) {
                        ParameterName = column.getColumnSQL();
                    }
                    if (P_String != null) {
                        if (P_String_To == null) {
                            if (P_String.indexOf(37) == -1) {
                                query.addRestriction(ParameterName, EQUAL, P_String, Name2, Info2);
                            } else {
                                query.addRestriction(ParameterName, LIKE, P_String, Name2, Info2);
                            }
                        } else {
                            query.addRangeRestriction(ParameterName, P_String, P_String_To, Name2, Info2, Info_To);
                        }
                    } else if (P_Number != null || P_Number_To != null) {
                        if (P_Number_To == null) {
                            if (isRange) {
                                query.addRestriction(ParameterName, GREATER_EQUAL, P_Number, Name2, Info2);
                            } else {
                                query.addRestriction(ParameterName, EQUAL, P_Number, Name2, Info2);
                            }
                        } else if (P_Number == null) {
                            query.addRestriction("TRUNC(" + ParameterName + ")", LESS_EQUAL, P_Number_To, Name2, Info2);
                        } else {
                            query.addRangeRestriction(ParameterName, P_Number, P_Number_To, Name2, Info2, Info_To);
                        }
                    } else if (P_Date != null || P_Date_To != null) {
                        if (P_Date_To == null) {
                            if (isRange) {
                                query.addRestriction("TRUNC(" + ParameterName + ", 'DD')", GREATER_EQUAL, P_Date, Name2, Info2);
                            } else {
                                query.addRestriction("TRUNC(" + ParameterName + ", 'DD')", EQUAL, P_Date, Name2, Info2);
                            }
                        } else if (P_Date == null) {
                            query.addRestriction("TRUNC(" + ParameterName + ", 'DD')", LESS_EQUAL, P_Date_To, Name2, Info2);
                        } else {
                            query.addRangeRestriction("TRUNC(" + ParameterName + ", 'DD')", P_Date, P_Date_To, Name2, Info2, Info_To);
                        }
                    }
                }
                ++row;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e2) {
            s_log.log(Level.SEVERE, SQL, e2);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        s_log.info(query.toString());
        return query;
    }

    public void clear() {
        if (this.getAD_PInstance_ID() != 0) {
            for (int i = 0; i < this.m_list.size(); ++i) {
                Restriction restriction = this.m_list.get(i);
                if (restriction.orignalClause) continue;
                this.m_list.remove(i);
            }
        }
    }

    public static String getZoomColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (columnName.equals("SalesRep_ID")) {
            return "AD_User_ID";
        }
        if (columnName.equals("C_DocTypeTarget_ID")) {
            return "C_DocType_ID";
        }
        if (columnName.equals("Bill_BPartner_ID")) {
            return "C_BPartner_ID";
        }
        if (columnName.equals("Bill_Location_ID")) {
            return "C_BPartner_Location_ID";
        }
        if (columnName.equals("Account_ID")) {
            return "C_ElementValue_ID";
        }
        if (columnName.equals("C_LocFrom_ID") || columnName.equals("C_LocTo_ID")) {
            return "C_Location_ID";
        }
        if (columnName.toUpperCase().endsWith("TO_ID")) {
            return columnName.substring(0, columnName.length() - 5) + "_ID";
        }
        if (columnName.toUpperCase().endsWith("_TO_ID")) {
            return columnName.substring(0, columnName.length() - 6) + "_ID";
        }
        if (columnName.equals("AD_OrgBP_ID") || columnName.equals("AD_OrgTrx_ID")) {
            return "AD_Org_ID";
        }
        return columnName;
    }

    public static String getZoomTableName(String columnName) {
        String tableName = MQuery.getZoomColumnName(columnName);
        int index = tableName.lastIndexOf("_ID");
        if (index != -1) {
            return tableName.substring(0, index);
        }
        return tableName;
    }

    public static MQuery getEqualQuery(String columnName, Object value) {
        MQuery query = new MQuery();
        query.addRestriction(columnName, EQUAL, value);
        query.setRecordCount(1);
        return query;
    }

    public static MQuery getEqualQuery(String columnName, int value) {
        MQuery query = new MQuery();
        if (columnName.endsWith("_ID")) {
            query.setTableName(columnName.substring(0, columnName.length() - 3));
        }
        query.addRestriction(columnName, EQUAL, new Integer(value));
        query.setRecordCount(1);
        return query;
    }

    public static MQuery getNoRecordQuery(String tableName, boolean newRecord) {
        MQuery query = new MQuery(tableName);
        if (newRecord) {
            query.addRestriction(NEWRECORD);
        } else {
            query.addRestriction("1=2");
        }
        query.setRecordCount(0);
        return query;
    }

    public MQuery() {
    }

    public MQuery(String TableName) {
        this.m_TableName = TableName;
    }

    public MQuery(int AD_Table_ID) {
        this.m_TableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    public void setRecordCount(int count) {
        this.m_recordCount = count;
    }

    public void addRestriction(String ColumnName, String Operator2, Object Code2, String InfoName, String InfoDisplay, boolean andCondition, int depth) {
        Restriction r = new Restriction(ColumnName, Operator2, Code2, InfoName, InfoDisplay, andCondition, depth);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator2, Object Code2, String InfoName, String InfoDisplay) {
        Restriction r = new Restriction(ColumnName, Operator2, Code2, InfoName, InfoDisplay, true, 0);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator2, Object Code2) {
        Restriction r = new Restriction(ColumnName, Operator2, Code2, null, null, true, 0);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator2, int Code2) {
        Restriction r = new Restriction(ColumnName, Operator2, new Integer(Code2), null, null, true, 0);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code2, Object Code_to, String InfoName, String InfoDisplay, String InfoDisplay_to, boolean andCondition, int depth) {
        Restriction r = new Restriction(ColumnName, Code2, Code_to, InfoName, InfoDisplay, InfoDisplay_to, andCondition, depth);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code2, Object Code_to, String InfoName, String InfoDisplay, String InfoDisplay_to) {
        Restriction r = new Restriction(ColumnName, Code2, Code_to, InfoName, InfoDisplay, InfoDisplay_to, true, 0);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code2, Object Code_to) {
        Restriction r = new Restriction(ColumnName, Code2, Code_to, null, null, null, true, 0);
        this.m_list.add(r);
    }

    protected void addRestriction(Restriction r) {
        this.m_list.add(r);
    }

    public void addRestriction(String whereClause, boolean andCondition, int joinDepth) {
        if (whereClause == null || whereClause.trim().length() == 0) {
            return;
        }
        Restriction r = new Restriction(whereClause, andCondition, joinDepth);
        this.m_list.add(r);
        this.m_newRecord = whereClause.equals(NEWRECORD);
    }

    public void addRestriction(String whereClause) {
        this.addRestriction(whereClause, false);
    }

    public void addRestriction(String whereClause, boolean p_OrignalClause) {
        if (whereClause == null || whereClause.trim().length() == 0) {
            return;
        }
        Restriction r = new Restriction(whereClause, true, 0, p_OrignalClause);
        this.m_list.add(r);
        this.m_newRecord = whereClause.equals(NEWRECORD);
    }

    public boolean isNewRecordQuery() {
        return this.m_newRecord;
    }

    public String getWhereClause() {
        return this.getWhereClause(false);
    }

    public String getWhereClause(boolean fullyQualified) {
        int currentDepth = 0;
        boolean qualified = fullyQualified;
        if (qualified && (this.m_TableName == null || this.m_TableName.length() == 0)) {
            qualified = false;
        }
        StringBuffer sb = new StringBuffer();
        if (!this.isActive()) {
            return sb.toString();
        }
        sb.append('(');
        for (int i = 0; i < this.m_list.size(); ++i) {
            Restriction r = this.m_list.get(i);
            if (i != 0) {
                sb.append(r.andCondition ? " AND " : " OR ");
            }
            while (currentDepth < r.joinDepth) {
                sb.append('(');
                ++currentDepth;
            }
            if (qualified) {
                sb.append(r.getSQL(this.m_TableName));
            } else {
                sb.append(r.getSQL(null));
            }
            while (currentDepth > r.joinDepth) {
                sb.append(')');
                --currentDepth;
            }
        }
        while (currentDepth > 0) {
            sb.append(')');
            --currentDepth;
        }
        sb.append(')');
        return sb.toString();
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        int currentDepth = 0;
        if (this.m_TableName != null) {
            sb.append(this.m_TableName).append(": ");
        }
        for (int i = 0; i < this.m_list.size(); ++i) {
            Restriction r = this.m_list.get(i);
            while (currentDepth < r.joinDepth) {
                sb.append('(');
                ++currentDepth;
            }
            while (currentDepth > r.joinDepth) {
                sb.append(')');
                --currentDepth;
            }
            if (i != 0) {
                sb.append(r.andCondition ? " AND " : " OR ");
            }
            sb.append(r.getInfoName()).append(r.getInfoOperator()).append(r.getInfoDisplayAll());
        }
        while (currentDepth > 0) {
            sb.append(')');
            --currentDepth;
        }
        return sb.toString();
    }

    public String getWhereClause(int index) {
        StringBuffer sb = new StringBuffer();
        if (index >= 0 && index < this.m_list.size()) {
            Restriction r = this.m_list.get(index);
            sb.append(r.getSQL(null));
        }
        return sb.toString();
    }

    public int getRestrictionCount() {
        return this.m_list.size();
    }

    public boolean isActive() {
        return this.m_list.size() != 0;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String TableName) {
        this.m_TableName = TableName;
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.ColumnName;
    }

    public Object getColumnCode(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.Code;
    }

    protected void setColumnName(int index, String ColumnName) {
        if (index < 0 || index >= this.m_list.size()) {
            return;
        }
        Restriction r = this.m_list.get(index);
        r.ColumnName = ColumnName;
    }

    public String getOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.Operator;
    }

    public Object getCode(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.Code;
    }

    public String getInfoDisplay(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoDisplay;
    }

    public String getInfoDisplay_to(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoDisplay_to;
    }

    public String getInfoName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoName;
    }

    public String getInfoOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.getInfoOperator();
    }

    public String getInfoDisplayAll(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.getInfoDisplayAll();
    }

    public String toString() {
        if (this.isActive()) {
            return this.getWhereClause(true);
        }
        return "MQuery[" + this.m_TableName + ",Restrictions=0]";
    }

    public String getDisplayName(Properties ctx) {
        String keyColumn = null;
        keyColumn = this.m_TableName != null ? this.m_TableName + "_ID" : this.getColumnName(0);
        String retValue = Msg.translate(ctx, keyColumn);
        if (retValue != null && retValue.length() > 0) {
            return retValue;
        }
        return this.m_TableName;
    }

    public MQuery deepCopy() {
        MQuery newQuery = new MQuery(this.m_TableName);
        for (int i = 0; i < this.m_list.size(); ++i) {
            newQuery.addRestriction(this.m_list.get(i));
        }
        return newQuery;
    }

    public int getAD_PInstance_ID() {
        return this.m_AD_PInstance_ID;
    }

    public void setZoomTableName(String tableName) {
        this.m_zoomTable = tableName;
    }

    public String getZoomTableName() {
        return this.m_zoomTable;
    }

    public void setZoomColumnName(String column) {
        this.m_zoomColumn = column;
    }

    public String getZoomColumnName() {
        return this.m_zoomColumn;
    }

    public void setZoomValue(Object value) {
        this.m_zoomValue = value;
    }

    public Object getZoomValue() {
        return this.m_zoomValue;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setWindowNo(int m_windowNo) {
        this.m_windowNo = m_windowNo;
    }
}

