/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatchLine;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MQualityTest;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductionLine
extends X_M_ProductionLine
implements IDocumentLine {
    private static final long serialVersionUID = 1L;
    private MProduction m_parent = null;
    private MProduct m_product = null;

    public MProductionLine(Properties ctx, int M_ProductionLine_ID, String trxName) {
        super(ctx, M_ProductionLine_ID, trxName);
        if (M_ProductionLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setM_ProductionLine_ID(0);
            this.setM_Production_ID(0);
            this.setMovementQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MProductionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLine(MProduction header) {
        super(header.getCtx(), 0, header.get_TrxName());
        this.setM_Production_ID(header.getM_Production_ID());
        this.setAD_Client_ID(header.getAD_Client_ID());
        this.setAD_Org_ID(header.getAD_Org_ID());
    }

    public String createTransactions(Timestamp date, boolean mustBeStocked) {
        MAttributeSetInstance slASI;
        String slASIString;
        BigDecimal lineQty;
        int deleted = this.deleteMA();
        this.log.log(Level.FINE, "Deleted " + deleted + " attribute records ");
        MProduct prod = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        this.log.log(Level.FINE, "Loaded Product " + prod.toString());
        if (prod.getProductType().compareTo("I") != 0) {
            this.log.log(Level.FINE, "Production Line " + this.getLine() + " does not require stock movement");
            return "";
        }
        StringBuffer errorString = new StringBuffer();
        MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        String asiString = asi.getDescription();
        if (asiString == null) {
            asiString = "";
        }
        this.log.log(Level.FINEST, "asi Description is: " + asiString);
        int batchLocatorID = this.getM_Production().getM_ProductionBatch().getM_Locator_ID();
        if (this.getMovementQty().compareTo(Env.ZERO) > 0) {
            MProductionLineMA lineMA = new MProductionLineMA(this, asi.get_ID(), this.getMovementQty());
            if (!lineMA.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                errorString.append("Could not save MA for " + this.toString() + "\n");
            }
            MTransaction matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P+", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), this.getMovementQty(), date, this.get_TrxName());
            matTrx.setM_ProductionLine_ID(this.get_ID());
            if (!matTrx.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                errorString.append("Could not save transaction for " + this.toString() + "\n");
            }
            MStorage storage = MStorage.getCreate(this.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), this.get_TrxName());
            storage.changeQtyOnHand(this.getMovementQty(), true);
            if (this.getM_Production().getReversal_ID() == 0) {
                if (!this.isEndProduct()) {
                    if (storage.getM_AttributeSetInstance_ID() == 0 && batchLocatorID == this.getM_Locator_ID()) {
                        storage.setQtyReserved(storage.getQtyReserved().subtract(this.getMovementQty()));
                    } else {
                        MStorage.add(this.getCtx(), this.getM_Production().getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), batchLocatorID, this.getM_Product_ID(), 0, 0, Env.ZERO, this.getMovementQty().negate(), Env.ZERO, this.get_TrxName());
                    }
                    this.setQtyReserved(Env.ZERO);
                } else if (storage.getM_AttributeSetInstance_ID() == 0 && batchLocatorID == this.getM_Locator_ID()) {
                    storage.setQtyOrdered(storage.getQtyOrdered().subtract(this.getMovementQty()));
                } else {
                    MStorage.add(this.getCtx(), this.getM_Production().getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), batchLocatorID, this.getM_Product_ID(), 0, 0, Env.ZERO, Env.ZERO, this.getMovementQty().negate(), this.get_TrxName());
                }
            }
            if (!storage.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                errorString.append("Could not save transaction for " + this.toString() + "\n");
            }
            this.log.log(Level.FINE, "Created finished goods line " + this.getLine());
            return errorString.toString();
        }
        MStorage[] storages = MStorage.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName());
        MProductionLineMA lineMA = null;
        MTransaction matTrx = null;
        BigDecimal qtyToMove = this.getMovementQty().negate();
        for (int sl = 0; sl < storages.length; ++sl) {
            lineQty = storages[sl].getQtyOnHand();
            this.log.log(Level.FINE, "QtyAvailable " + lineQty);
            if (lineQty.signum() > 0) {
                if (lineQty.compareTo(qtyToMove) > 0) {
                    lineQty = qtyToMove;
                }
                if ((slASIString = (slASI = new MAttributeSetInstance(this.getCtx(), storages[sl].getM_AttributeSetInstance_ID(), this.get_TrxName())).getDescription()) == null) {
                    slASIString = "";
                }
                this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                if (slASIString.compareTo(asiString) == 0 || asi.getM_AttributeSet_ID() == 0) {
                    lineMA = MProductionLineMA.get(this, storages[sl].getM_AttributeSetInstance_ID());
                    lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                    if (!lineMA.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                        errorString.append("Could not save MA for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved MA for " + this.toString());
                    }
                    matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), lineQty.negate(), date, this.get_TrxName());
                    matTrx.setM_ProductionLine_ID(this.get_ID());
                    if (!matTrx.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                        errorString.append("Could not save transaction for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                    }
                    storages[sl].changeQtyOnHand(lineQty, false);
                    if (!this.isEndProduct()) {
                        if (storages[sl].getM_AttributeSetInstance_ID() == 0 && batchLocatorID == this.getM_Locator_ID()) {
                            storages[sl].setQtyReserved(storages[sl].getQtyReserved().subtract(lineQty));
                        } else {
                            MStorage.add(this.getCtx(), this.getM_Production().getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), batchLocatorID, this.getM_Product_ID(), 0, 0, Env.ZERO, lineQty.negate(), Env.ZERO, this.get_TrxName());
                        }
                        this.setQtyReserved(this.getQtyReserved().subtract(lineQty));
                    }
                    if (!storages[sl].save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                        errorString.append("Could not update storage for " + this.toString() + "\n");
                    }
                    qtyToMove = qtyToMove.subtract(lineQty);
                    this.log.log(Level.FINE, this.getLine() + " Qty moved = " + lineQty + ", Remaining = " + qtyToMove);
                }
            }
            if (qtyToMove.signum() == 0) break;
        }
        if (qtyToMove.signum() != 0) {
            if (mustBeStocked) {
                MLocator loc = new MLocator(this.getCtx(), this.getM_Locator_ID(), this.get_TrxName());
                errorString.append("Insufficient qty on hand of " + prod.toString() + " at " + loc.toString() + "\n");
            } else {
                MStorage storage = MStorage.get(Env.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), 0, this.get_TrxName());
                if (storage == null) {
                    storage = new MStorage(Env.getCtx(), 0, this.get_TrxName());
                    storage.setM_Locator_ID(this.getM_Locator_ID());
                    storage.setM_Product_ID(this.getM_Product_ID());
                    storage.setM_AttributeSetInstance_ID(0);
                    storage.save();
                }
                lineQty = qtyToMove;
                slASI = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                slASIString = slASI.getDescription();
                if (slASIString == null) {
                    slASIString = "";
                }
                this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                if (slASIString.compareTo(asiString) == 0 || asi.getM_AttributeSet_ID() == 0) {
                    lineMA = MProductionLineMA.get(this, storage.getM_AttributeSetInstance_ID());
                    lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                    if (!lineMA.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                        errorString.append("Could not save MA for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved MA for " + this.toString());
                    }
                    matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), lineQty.negate(), date, this.get_TrxName());
                    matTrx.setM_ProductionLine_ID(this.get_ID());
                    if (!matTrx.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                        errorString.append("Could not save transaction for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                    }
                    storage.changeQtyOnHand(lineQty, false);
                    if (!this.isEndProduct()) {
                        if (storage.getM_AttributeSetInstance_ID() == 0 && batchLocatorID == this.getM_Locator_ID()) {
                            storage.setQtyReserved(storage.getQtyReserved().subtract(lineQty));
                        } else {
                            MStorage.add(this.getCtx(), this.getM_Production().getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), batchLocatorID, this.getM_Product_ID(), 0, 0, Env.ZERO, lineQty.negate(), Env.ZERO, this.get_TrxName());
                        }
                        this.setQtyReserved(this.getQtyReserved().subtract(lineQty));
                    }
                    if (!storage.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                        errorString.append("Could not update storage for " + this.toString() + "\n");
                    }
                    qtyToMove = qtyToMove.subtract(lineQty);
                    this.log.log(Level.FINE, this.getLine() + " Qty moved = " + lineQty + ", Remaining = " + qtyToMove);
                }
            }
        }
        return errorString.toString();
    }

    public Boolean createTransaction(MProductionLine pLine) {
        MProduct product = pLine.getProduct();
        String MovementType = pLine.isEndProduct() ? "P+" : "P-";
        BigDecimal Qty = pLine.getMovementQty();
        this.log.info("Line=" + pLine.getLine() + " - Qty=" + pLine.getMovementQty());
        if (product != null && product.isStocked() && product != null) {
            if (pLine.getM_Production().getReversal_ID() == 0) {
                this.getParent().checkMaterialPolicy(pLine, MovementType);
            }
            BigDecimal movementqty = pLine.getMovementQty();
            this.log.fine("Material Transaction");
            MTransaction mtrx = null;
            if (pLine.getM_AttributeSetInstance_ID() == 0) {
                MProductionLineMA[] list;
                for (MProductionLineMA ma : list = MProductionLineMA.get(this.getCtx(), pLine.getM_ProductionLine_ID(), this.get_TrxName())) {
                    if (pLine.getM_AttributeSetInstance_ID() != 0 && pLine.getM_AttributeSetInstance_ID() != ma.getM_AttributeSetInstance_ID()) continue;
                    BigDecimal QtyMA = ma.getMovementQty();
                    BigDecimal reservedQty = Env.ZERO;
                    BigDecimal orderedQty = Env.ZERO;
                    if (pLine.getProduct().isStocked()) {
                        if (pLine.isEndProduct()) {
                            orderedQty = QtyMA.negate();
                            reservedQty = Env.ZERO;
                        } else {
                            orderedQty = Env.ZERO;
                            reservedQty = QtyMA.negate();
                        }
                    }
                    if (!MStorage.add(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Locator_ID(), pLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, QtyMA.negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        return false;
                    }
                    mtrx = new MTransaction(this.getCtx(), pLine.getAD_Org_ID(), MovementType, pLine.getM_Locator_ID(), pLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), pLine.getParent().getMovementDate(), this.get_TrxName());
                    mtrx.setM_ProductionLine_ID(pLine.getM_ProductionLine_ID());
                    BigDecimal qtyreserved = this.getMovementQty();
                    MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getM_Production().getM_ProductionBatch_ID(), this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
                    pbLine.setQtyReserved(pbLine.getQtyReserved().add(qtyreserved));
                    pbLine.saveEx();
                    if (mtrx.save()) continue;
                    return false;
                }
            }
            if (mtrx == null) {
                MAttributeSetInstance asi = null;
                int reservationAttributeSetInstance_ID = pLine.getM_AttributeSetInstance_ID();
                int transactionAttributeSetInstance_ID = pLine.getM_AttributeSetInstance_ID();
                Boolean needSave = false;
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, pLine.getM_Locator_ID(), this.get_TrxName());
                if (pLine.getM_AttributeSetInstance_ID() == 0) {
                    MAttributeSet.validateAttributeSetInstanceMandatory(product, Table_ID, false, pLine.getM_AttributeSetInstance_ID());
                    asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    pLine.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                    transactionAttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    this.log.config("New ASI=" + pLine);
                    needSave = true;
                }
                BigDecimal reservedDiff = Env.ZERO;
                BigDecimal orderedDiff = Env.ZERO;
                if (MovementType.equals("P-")) {
                    reservedDiff = movementqty.negate();
                } else {
                    orderedDiff = movementqty;
                }
                if (!MStorage.add(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Locator_ID(), pLine.getM_Product_ID(), transactionAttributeSetInstance_ID, reservationAttributeSetInstance_ID, Qty, Env.ZERO, Env.ZERO, this.get_TrxName())) {
                    return false;
                }
                mtrx = new MTransaction(this.getCtx(), pLine.getAD_Org_ID(), MovementType, pLine.getM_Locator_ID(), pLine.getM_Product_ID(), pLine.getM_AttributeSetInstance_ID(), Qty, pLine.getParent().getMovementDate(), this.get_TrxName());
                mtrx.setM_ProductionLine_ID(pLine.getM_ProductionLine_ID());
                if (!mtrx.save()) {
                    return false;
                }
                BigDecimal qtyreserved = this.isEndProduct() ? this.getMovementQty() : this.getMovementQty().negate();
                MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getM_Production().getM_ProductionBatch_ID(), this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
                pbLine.setQtyReserved(pbLine.getQtyReserved().subtract(qtyreserved));
                pbLine.saveEx();
            }
        }
        return true;
    }

    public int deleteMA() {
        String sql = "DELETE FROM M_ProductionLineMA WHERE M_ProductionLine_ID = " + this.get_ID();
        int count = DB.executeUpdateEx(sql, this.get_TrxName());
        return count;
    }

    @Override
    public String toString() {
        if (this.getM_Product_ID() == 0) {
            return "No product defined for production line " + this.getLine();
        }
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        return "Production line:" + this.getLine() + " -- " + this.getMovementQty() + " of " + product.getValue();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getParent().getM_Product_ID() == this.getM_Product_ID() && this.getParent().getProductionQty().signum() == this.getMovementQty().signum()) {
            this.setIsEndProduct(true);
        } else {
            this.setIsEndProduct(false);
        }
        if (this.isEndProduct() && this.getM_AttributeSetInstance_ID() != 0) {
            String where = "M_QualityTest_ID IN (SELECT M_QualityTest_ID FROM M_Product_QualityTest WHERE M_Product_ID=?) AND M_QualityTest_ID NOT IN (SELECT M_QualityTest_ID FROM M_QualityTestResult WHERE M_AttributeSetInstance_ID=?)";
            List tests = new Query(this.getCtx(), "M_QualityTest", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID()).list();
            for (MQualityTest test : tests) {
                test.createResult(this.getM_AttributeSetInstance_ID());
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getM_Production().isProcessed()) {
            return false;
        }
        this.deleteMA();
        MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getParent().getM_ProductionBatch_ID(), this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
        if (pbLine != null) {
            BigDecimal qtyReserved = this.isEndProduct() ? this.getMovementQty().negate() : this.getMovementQty();
            pbLine.setQtyReserved(pbLine.getQtyReserved().add(qtyReserved));
            pbLine.saveEx();
        }
        return true;
    }

    public boolean isParent() {
        Boolean isParent = this.getM_Product_ID() == this.getM_ProductionPlan().getM_Product_ID();
        if (!isParent.booleanValue()) {
            isParent = this.getM_Product_ID() == this.getM_Production().getM_Product_ID();
        }
        return isParent;
    }

    @Override
    public Timestamp getDateAcct() {
        if (this.getM_ProductionPlan_ID() != 0) {
            return this.getM_ProductionPlan().getM_Production().getMovementDate();
        }
        return this.getM_Production().getMovementDate();
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public int getReversalLine_ID() {
        return -1;
    }

    @Override
    public BigDecimal getPriceActual() {
        return Env.ZERO;
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("DocBaseType").append("=?");
        return new Query(this.getCtx(), "C_DocType", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters("MMP").firstId();
    }

    protected void setParent(MProduction parent) {
        this.m_parent = parent;
    }

    public MProduction getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MProduction(this.getCtx(), this.getM_Production_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int M_ProductionBatch_ID = this.getParent().getM_ProductionBatch_ID();
        if (newRecord) {
            if (M_ProductionBatch_ID == 0) {
                return true;
            }
            MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(M_ProductionBatch_ID, this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
            if (pbLine != null) {
                BigDecimal movementQty = this.isEndProduct() ? this.getMovementQty() : this.getMovementQty().negate();
                pbLine.setQtyReserved(pbLine.getQtyReserved().add(movementQty));
                pbLine.saveEx();
                return true;
            }
            BigDecimal movementQty = this.isEndProduct() ? this.getMovementQty() : this.getMovementQty().negate();
            pbLine = new MProductionBatchLine(this.getCtx(), 0, this.get_TrxName());
            pbLine.setM_ProductionBatch_ID(M_ProductionBatch_ID);
            pbLine.setM_Product_ID(this.getM_Product_ID());
            pbLine.setQtyReserved(movementQty);
            pbLine.setIsEndProduct(this.isEndProduct());
            pbLine.saveEx();
            return true;
        }
        if (this.is_ValueChanged("MovementQty")) {
            BigDecimal oldValue = (BigDecimal)this.get_ValueOld("MovementQty");
            BigDecimal diff = this.getMovementQty().subtract(oldValue);
            diff = this.isEndProduct() ? diff : diff.negate();
            MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(M_ProductionBatch_ID, this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
            if (pbLine == null) {
                pbLine = new MProductionBatchLine(this.getCtx(), 0, this.get_TrxName());
                pbLine.setM_ProductionBatch_ID(M_ProductionBatch_ID);
                pbLine.setM_Product_ID(this.getM_Product_ID());
                pbLine.setQtyReserved(this.getMovementQty().negate());
                pbLine.saveEx();
            }
            pbLine.setQtyReserved(this.getQtyReserved().add(diff));
            pbLine.saveEx();
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        return BigDecimal.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        MClient client = MClient.get(this.getCtx());
        return client.getC_Currency_ID();
    }

    @Override
    public int getC_ConversionType_ID() {
        return MConversionType.getDefault(this.getAD_Client_ID());
    }

    @Override
    public boolean isReversalParent() {
        return this.getM_ProductionLine_ID() < this.getReversalLine_ID();
    }
}

