/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatchLine;
import org.compiere.model.MProductionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionBatch;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;

public class MProductionBatch
extends X_M_ProductionBatch
implements DocAction {
    private static final long serialVersionUID = -151106993468792872L;
    private MProduction[] m_productions = null;
    private MMovement[] m_moves = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MProductionBatchLine[] productionBatchLines = null;

    public MProductionBatch(Properties ctx, int M_ProductionBatch_ID, String trxName) {
        super(ctx, M_ProductionBatch_ID, trxName);
    }

    public MProductionBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean hasOpenOrder() {
        return false;
    }

    public MProduction[] getProductionArray(boolean requery) {
        if (this.m_productions != null && !requery) {
            MProductionBatch.set_TrxName(this.m_productions, this.get_TrxName());
            return this.m_productions;
        }
        List<MProduction> list = new Query(this.getCtx(), "M_Production", "M_ProductionBatch_ID = ?", this.get_TrxName()).setParameters(this.getM_ProductionBatch_ID()).setOrderBy("M_Production_ID").list();
        this.m_productions = new MProduction[list.size()];
        list.toArray(this.m_productions);
        return this.m_productions;
    }

    public MMovement[] getMovements(boolean requery) {
        if (this.m_moves != null && !requery) {
            MProductionBatch.set_TrxName(this.m_moves, this.get_TrxName());
            return this.m_moves;
        }
        List<MMovement> list = new Query(this.getCtx(), "M_Movement", "M_ProductionBatch_ID=?", this.get_TrxName()).setParameters(this.getM_ProductionBatch_ID()).setOrderBy("M_Movement_ID").list();
        this.m_moves = new MMovement[list.size()];
        list.toArray(this.m_moves);
        return this.m_moves;
    }

    public MProduction getOpenOrder() {
        MProduction[] productions;
        for (MProduction production : productions = this.getProductionArray(true)) {
            if (production.isProcessed()) continue;
            return production;
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return super.beforeSave(newRecord);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.is_ValueChanged("QtyReserved")) {
            // empty if block
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public boolean approveIt() {
        return true;
    }

    @Override
    public boolean rejectIt() {
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        return this.getDocumentNo();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx()).getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.getMovementDate().before(new Timestamp(System.currentTimeMillis()))) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MOP", this.getAD_Org_ID());
        }
        if (this.getTargetQty().compareTo(Env.ZERO) == 0) {
            this.m_processMsg = "@TargetQty@ = 0";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = this.createAutomaticProduction();
        if (this.m_processMsg != null) {
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        this.setDocStatus("CO");
        return "CO";
    }

    public String createAutomaticProduction() {
        if (!this.isAutoProduction()) {
            return null;
        }
        MProduction[] headers = this.getProductionArray(true);
        MProduction header = null;
        if (headers.length == 0) {
            header = new MProduction(this);
            header.setDocAction("PR");
            header.saveEx();
            header.processIt("PR");
        } else if (headers.length == 1) {
            header = headers[0];
            if (this.getTargetQty().compareTo(header.getProductionQty()) == 0) {
                if (!header.isCreated()) {
                    header.setDocAction("PR");
                    header.processIt("PR");
                }
            } else {
                header.setProductionQty(this.getTargetQty());
                header.setDocAction("PR");
                header.processIt("PR");
            }
        } else {
            return "ProductionBatchNotOne";
        }
        header.saveEx(this.get_TrxName());
        return null;
    }

    public MProduction createComplementProduction() {
        if (!this.isAutoProduction()) {
            return null;
        }
        MProduction[] productions = this.getProductionArray(true);
        BigDecimal qtyOrder = this.getTargetQty();
        BigDecimal qtyCompleted = BigDecimal.ZERO;
        int orderCount = 1;
        MProduction newProdOrder = null;
        for (MProduction production : productions) {
            qtyOrder = qtyOrder.subtract(production.getProductionQty());
            qtyCompleted = qtyCompleted.add(production.getProductionQty());
            ++orderCount;
        }
        this.setQtyOrdered(qtyOrder);
        this.setQtyCompleted(qtyCompleted);
        if (qtyOrder.compareTo(BigDecimal.ZERO) > 0) {
            this.setCountOrder(orderCount);
            newProdOrder = new MProduction(this);
            newProdOrder.setDocStatus("DR");
            newProdOrder.saveEx();
            newProdOrder.processIt("PR");
        }
        return newProdOrder;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getQtyReserved().compareTo(Env.ZERO) != 0) {
            this.freeStock();
            this.setQtyReserved(Env.ZERO);
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        StringBuffer errorMessage = new StringBuffer();
        Arrays.asList(this.getProductionArray(true)).stream().filter(production -> !production.getDocStatus().equals("RE") && !production.getDocStatus().equals("VO")).forEach(production -> errorMessage.append(Env.NL).append(production.getDocumentInfo()));
        if (errorMessage.length() > 0) {
            this.m_processMsg = "@SQLErrorReferenced@: " + errorMessage;
            return false;
        }
        MProductionBatch pBatch = new MProductionBatch(this.getCtx(), this.get_ID(), this.get_TrxName());
        if (pBatch.getQtyReserved() != null && pBatch.getQtyReserved().compareTo(Env.ZERO) > 0) {
            if (!this.reserveStock((MProduct)this.getM_Product(), pBatch.getQtyReserved().negate(), 0)) {
                this.m_processMsg = "Issue while releasing reserved stock";
                return false;
            }
            this.setQtyReserved(Env.ZERO);
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
            if (this.m_processMsg != null) {
                return false;
            }
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean reserveStock(MProduct fProduct, BigDecimal qty, int M_Production_ID) {
        String whereClause = "EXISTS(SELECT 1 FROM M_Production WHERE M_Production_ID = M_ProductionLine.M_Production_ID AND M_ProductionBatch_ID =?)";
        if (M_Production_ID != 0) {
            whereClause = whereClause + " AND M_Production_ID = " + M_Production_ID;
        }
        List list = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(this.getM_ProductionBatch_ID()).list();
        for (MProductionLine pLine : list) {
            MProduct product;
            if (pLine.isEndProduct()) continue;
            BigDecimal target = pLine.getMovementQty();
            BigDecimal difference = qty.signum() == -1 && this.getDocAction().equals("CL") || this.getDocAction().equals("VO") ? target : target.negate();
            if (difference.signum() == 0 || (product = pLine.getProduct()) == null) continue;
            if (product.isStocked()) {
                BigDecimal reserved = difference;
                int M_Locator_ID = 0;
                if (pLine.getM_AttributeSetInstance_ID() != 0) {
                    M_Locator_ID = MStorage.getM_Locator_ID(pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Product_ID(), pLine.getM_AttributeSetInstance_ID(), pLine.getMovementQty(), this.get_TrxName());
                }
                if (M_Locator_ID == 0) {
                    MWarehouse wh = MWarehouse.get(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID());
                    M_Locator_ID = product.getM_Locator_ID();
                    if (M_Locator_ID != 0) {
                        MLocator locator = new MLocator(this.getCtx(), product.getM_Locator_ID(), this.get_TrxName());
                        if (locator.getM_Warehouse_ID() != wh.get_ID()) {
                            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                        }
                    } else {
                        M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                    }
                }
                if (!MStorage.add(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), M_Locator_ID, pLine.getM_Product_ID(), 0, pLine.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, Env.ZERO, this.get_TrxName())) {
                    return false;
                }
            }
            if (pLine.save(this.get_TrxName())) continue;
            return false;
        }
        return true;
    }

    public MProductionBatchLine[] getProductionBatchLines(Boolean requery) {
        if (this.productionBatchLines != null && !requery.booleanValue()) {
            MProductionBatch.set_TrxName(this.productionBatchLines, this.get_TrxName());
            return this.productionBatchLines;
        }
        List<MProductionBatchLine> list = new Query(this.getCtx(), "M_ProductionBatchLine", "M_ProductionBatch_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.productionBatchLines = list.toArray(new MProductionBatchLine[list.size()]);
        return this.productionBatchLines;
    }

    private void freeStock() {
        int reservationAttributeSetInstance_ID = 0;
        BigDecimal reservationQty = Env.ZERO;
        for (MProductionBatchLine pBatchLine : this.getProductionBatchLines(true)) {
            if (pBatchLine.getQtyReserved().signum() == 0 || pBatchLine.isEndProduct()) continue;
            reservationQty = pBatchLine.getQtyReserved().negate();
            if (MStorage.add(this.getCtx(), this.getM_Locator().getM_Warehouse_ID(), this.getM_Locator_ID(), pBatchLine.getM_Product_ID(), 0, reservationAttributeSetInstance_ID, Env.ZERO, reservationQty, Env.ZERO, this.get_TrxName())) continue;
            return;
        }
    }

    @Override
    public String toString() {
        MDocType mDocType = new MDocType(this.getCtx(), this.getC_DocType_ID(), this.get_TrxName());
        StringBuffer sb = new StringBuffer("MProductionBatch[");
        sb.append(this.get_ID()).append("-").append(mDocType.getName()).append(" ").append(this.getDocumentNo()).append("]");
        return sb.toString();
    }
}

