/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_BOM;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MProductBOM
extends X_M_Product_BOM {
    private static final long serialVersionUID = 6029128559467083124L;
    private static CLogger s_log = CLogger.getCLogger(MProductBOM.class);
    private MProduct m_product = null;

    public static MProductBOM[] getBOMLines(MProduct product) {
        return MProductBOM.getBOMLines(product.getCtx(), product.getM_Product_ID(), product.get_TrxName());
    }

    public static MProductBOM[] getBOMLines(Properties ctx, int M_Product_ID, String trxName) {
        String whereClause = "M_Product_ID=?";
        List<MProductBOM> list = new Query(ctx, "M_Product_BOM", "M_Product_ID=?", trxName).setParameters(M_Product_ID).setOrderBy("Line").list();
        MProductBOM[] retValue = new MProductBOM[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProductBOM(Properties ctx, int M_Product_BOM_ID, String trxName) {
        super(ctx, M_Product_BOM_ID, trxName);
        if (M_Product_BOM_ID == 0) {
            this.setBOMQty(Env.ZERO);
        }
    }

    public MProductBOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_ProductBOM_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_ProductBOM_ID());
        }
        return this.m_product;
    }

    @Override
    public void setM_ProductBOM_ID(int M_ProductBOM_ID) {
        super.setM_ProductBOM_ID(M_ProductBOM_ID);
        this.m_product = null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProductBOM[");
        sb.append(this.get_ID()).append(",Line=").append(this.getLine()).append(",Type=").append(this.getBOMType()).append(",Qty=").append(this.getBOMQty());
        if (this.m_product == null) {
            sb.append(",M_Product_ID=").append(this.getM_ProductBOM_ID());
        } else {
            sb.append(",").append(this.m_product);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord || this.is_ValueChanged("M_ProductBOM_ID")) {
            MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
            if (this.get_TrxName() != null) {
                product.load(this.get_TrxName());
            }
            if (product.isVerified()) {
                product.setIsVerified(false);
                product.save(this.get_TrxName());
            }
        }
        return success;
    }
}

