/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MExpenseType;
import org.compiere.model.MMemo;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductCosting;
import org.compiere.model.MProductDownload;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_I_Product;
import org.compiere.model.X_M_Product;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MProduct
extends X_M_Product {
    private static final long serialVersionUID = 285926961771269935L;
    private static CCache<Integer, MProduct> s_cache = new CCache("M_Product", 40, 5);
    private MProductDownload[] m_downloads = null;
    private Integer m_precision = null;

    public static MProduct get(Properties ctx, int M_Product_ID) {
        if (M_Product_ID <= 0) {
            return null;
        }
        Integer key = new Integer(M_Product_ID);
        MProduct retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProduct(ctx, M_Product_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MProduct[] get(Properties ctx, String whereClause, String trxName) {
        List<MProduct> list = new Query(ctx, "M_Product", whereClause, trxName).setClient_ID().list();
        return list.toArray(new MProduct[list.size()]);
    }

    public static List<MProduct> getByUPC(Properties ctx, String upc, String trxName) {
        String whereClause = "UPC=?";
        Query q = new Query(ctx, "M_Product", "UPC=?", trxName);
        q.setParameters(upc).setClient_ID();
        return q.list();
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID) {
        return MProduct.forS_Resource_ID(ctx, S_Resource_ID, null);
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID, String trxName) {
        MProduct p;
        if (S_Resource_ID <= 0) {
            return null;
        }
        if (trxName == null) {
            for (MProduct p2 : s_cache.values()) {
                if (p2.getS_Resource_ID() != S_Resource_ID) continue;
                return p2;
            }
        }
        if ((p = (MProduct)new Query(ctx, "M_Product", "S_Resource_ID=?", trxName).setParameters(S_Resource_ID).firstOnly()) != null && trxName == null) {
            s_cache.put(p.getM_Product_ID(), p);
        }
        return p;
    }

    public static boolean isProductStocked(Properties ctx, int M_Product_ID) {
        MProduct product = MProduct.get(ctx, M_Product_ID);
        return product.isStocked();
    }

    public MProduct(Properties ctx, int M_Product_ID, String trxName) {
        super(ctx, M_Product_ID, trxName);
        if (M_Product_ID == 0) {
            this.setProductType("I");
            this.setIsBOM(false);
            this.setIsInvoicePrintDetails(false);
            this.setIsPickListPrintDetails(false);
            this.setIsPurchased(true);
            this.setIsSold(true);
            this.setIsStocked(true);
            this.setIsSummary(false);
            this.setIsVerified(false);
            this.setIsWebStoreFeatured(false);
            this.setIsSelfService(true);
            this.setIsExcludeAutoDelivery(false);
            this.setProcessing(false);
            this.setLowLevel(0);
        }
    }

    public MProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct(MExpenseType et) {
        this(et.getCtx(), 0, et.get_TrxName());
        this.setProductType("E");
        this.setExpenseType(et);
    }

    public MProduct(MResource resource, MResourceType resourceType) {
        this(resource.getCtx(), 0, resource.get_TrxName());
        this.setAD_Org_ID(resource.getAD_Org_ID());
        this.setProductType("R");
        this.setResource(resource);
        this.setResource(resourceType);
    }

    public MProduct(X_I_Product impP) {
        this(impP.getCtx(), 0, impP.get_TrxName());
        this.setClientOrg(impP);
        this.setUpdatedBy(impP.getUpdatedBy());
        this.setValue(impP.getValue());
        this.setName(impP.getName());
        this.setDescription(impP.getDescription());
        this.setDocumentNote(impP.getDocumentNote());
        this.setHelp(impP.getHelp());
        this.setUPC(impP.getUPC());
        this.setSKU(impP.getSKU());
        this.setC_UOM_ID(impP.getC_UOM_ID());
        this.setM_Product_Category_ID(impP.getM_Product_Category_ID());
        this.setProductType(impP.getProductType());
        this.setImageURL(impP.getImageURL());
        this.setDescriptionURL(impP.getDescriptionURL());
        this.setM_Product_Class_ID(impP.getM_Product_Class_ID());
        this.setM_Product_Classification_ID(impP.getM_Product_Classification_ID());
        this.setM_Product_Group_ID(impP.getM_Product_Group_ID());
    }

    public boolean setExpenseType(MExpenseType parent) {
        boolean changed = false;
        if (!"E".equals(this.getProductType())) {
            this.setProductType("E");
            changed = true;
        }
        if (parent.getS_ExpenseType_ID() != this.getS_ExpenseType_ID()) {
            this.setS_ExpenseType_ID(parent.getS_ExpenseType_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        if (parent.getC_TaxType_ID() != this.getC_TaxType_ID()) {
            this.setC_TaxType_ID(parent.getC_TaxType_ID());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResource parent) {
        boolean changed = false;
        if (!"R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getS_Resource_ID() != this.getS_Resource_ID()) {
            this.setS_Resource_ID(parent.getS_Resource_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResourceType parent) {
        boolean changed = false;
        if ("R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        if (parent.getC_TaxType_ID() != this.getC_TaxType_ID()) {
            this.setC_TaxType_ID(parent.getC_TaxType_ID());
            changed = true;
        }
        return changed;
    }

    public int getUOMPrecision() {
        if (this.m_precision == null) {
            int C_UOM_ID = this.getC_UOM_ID();
            if (C_UOM_ID == 0) {
                return 0;
            }
            this.m_precision = new Integer(MUOM.getPrecision(this.getCtx(), C_UOM_ID));
        }
        return this.m_precision;
    }

    public int getA_Asset_Group_ID() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID();
    }

    public boolean isCreateAsset() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID() != 0;
    }

    public MAttributeSet getAttributeSet() {
        if (this.getM_AttributeSet_ID() != 0) {
            return MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        }
        return null;
    }

    public boolean isInstanceAttribute() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet mas = MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        return mas.isInstanceAttribute();
    }

    public boolean isOneAssetPerUOM() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return false;
        }
        return pc.getA_Asset_Group().isOneAssetPerUOM();
    }

    public boolean isItem() {
        return "I".equals(this.getProductType());
    }

    @Override
    public boolean isStocked() {
        return super.isStocked() && this.isItem();
    }

    public boolean isService() {
        return !this.isItem();
    }

    public String getUOMSymbol() {
        int C_UOM_ID = this.getC_UOM_ID();
        if (C_UOM_ID == 0) {
            return "";
        }
        return MUOM.get(this.getCtx(), C_UOM_ID).getUOMSymbol();
    }

    public MProductDownload[] getProductDownloads(boolean requery) {
        if (this.m_downloads != null && !requery) {
            return this.m_downloads;
        }
        List<MProductDownload> list = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("Name").setParameters(this.get_ID()).list();
        this.m_downloads = list.toArray(new MProductDownload[list.size()]);
        return this.m_downloads;
    }

    public boolean hasDownloads() {
        return this.getProductDownloads(false).length > 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProduct[");
        sb.append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MAttributeSet attributeSet;
        if (!newRecord && (this.is_ValueChanged("IsActive") && !this.isActive() || this.is_ValueChanged("IsStocked") && !this.isStocked() || this.is_ValueChanged("ProductType") && "I".equals(this.get_ValueOld("ProductType")))) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            BigDecimal Reserved = Env.ZERO;
            for (int i = 0; i < storages.length; ++i) {
                OnHand = OnHand.add(storages[i].getQtyOnHand());
                Ordered = Ordered.add(storages[i].getQtyOrdered());
                Reserved = Reserved.add(storages[i].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (Reserved.signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("C_UOM_ID") && this.hasInventoryOrCost()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "SaveUomError"));
            return false;
        }
        if (!"I".equals(this.getProductType())) {
            this.setIsStocked(false);
        }
        if (this.m_precision != null && this.is_ValueChanged("C_UOM_ID")) {
            this.m_precision = null;
        }
        if (this.getM_AttributeSet_ID() > 0 && !(attributeSet = MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID())).isInstanceAttribute() && attributeSet.isMandatoryAlways() && this.getM_AttributeSetInstance_ID() == 0) {
            throw new AdempiereException("@M_AttributeSetInstance_ID@ @FillMandatory@ @M_AttributeSetInstance_ID@ : " + attributeSet.getName());
        }
        if (this.is_ValueChanged("M_AttributeSet_ID")) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(0);
            try {
                asi.deleteEx(true, this.get_TrxName());
            }
            catch (AdempiereException ex) {
                this.log.saveError("Error", "Error deleting the AttributeSetInstance");
                return false;
            }
        }
        return true;
    }

    protected boolean hasInventoryOrCost() {
        boolean hasTrx = new Query(this.getCtx(), "M_Transaction", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        if (hasTrx) {
            return true;
        }
        boolean hasCosts = new Query(this.getCtx(), "M_CostDetail", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        return hasCosts;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "M_Product_ID=" + this.getM_Product_ID(), this.get_TrxName());
        }
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description"))) {
            String sql = "UPDATE A_Asset a SET (Name, Description)=(SELECT SUBSTR((SELECT bp.Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=a.C_BPartner_ID) || ' - ' || p.Name,1,60), p.Description FROM M_Product p WHERE p.M_Product_ID=a.M_Product_ID) WHERE IsActive='Y'  AND M_Product_ID=" + this.getM_Product_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Asset Description updated #" + no);
        }
        if (newRecord) {
            this.insert_Accounting("M_Product_Acct", "M_Product_Category_Acct", "p.M_Product_Category_ID=" + this.getM_Product_Category_ID());
            MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
            for (int i = 0; i < mass.length; ++i) {
                MProductCosting pcOld = new MProductCosting(this, mass[i].getC_AcctSchema_ID());
                pcOld.saveEx();
            }
        }
        if (newRecord || this.is_ValueChanged("M_Product_Category_ID")) {
            MCost.create(this);
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        if ("R".equals(this.getProductType()) && this.getS_Resource_ID() > 0) {
            throw new AdempiereException("@S_Resource_ID@<>0");
        }
        if (this.isStocked() || "I".equals(this.getProductType())) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            Object Reserved = Env.ZERO;
            for (int i = 0; i < storages.length; ++i) {
                OnHand = OnHand.add(storages[i].getQtyOnHand());
                Ordered = OnHand.add(storages[i].getQtyOrdered());
                Reserved = OnHand.add(storages[i].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (((BigDecimal)Reserved).signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
                return false;
            }
        }
        MProductCosting[] costings = MProductCosting.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
        for (int i = 0; i < costings.length; ++i) {
            costings[i].delete(true, this.get_TrxName());
        }
        MCost.delete(this);
        String whereClause = "M_Product_ID=?";
        List conversions = new Query(this.getCtx(), "C_UOM_Conversion", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).setOnlyActiveRecords(false).list();
        for (Object conversion : conversions) {
            ((PO)conversion).deleteEx(true);
        }
        List downloads = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).setOnlyActiveRecords(false).list();
        for (MProductDownload download : downloads) {
            download.deleteEx(true);
        }
        List memos = new Query(this.getCtx(), "AD_Memo", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).setOnlyActiveRecords(false).list();
        for (MMemo memo : memos) {
            memo.deleteEx(true);
        }
        return this.delete_Accounting("M_Product_Acct");
    }

    public MAttributeInstance getAttributeInstance(String name, String trxName) {
        MAttributeInstance instance = null;
        MTable table = MTable.get(Env.getCtx(), MAttribute.Table_ID);
        MAttribute attribute = (MAttribute)table.getPO("Name = ?", new Object[]{name}, trxName);
        if (attribute == null) {
            return null;
        }
        table = MTable.get(Env.getCtx(), MAttributeInstance.Table_ID);
        instance = (MAttributeInstance)table.getPO("M_AttributeSetInstance_ID=? and M_Attribute_ID=?", new Object[]{this.getM_AttributeSetInstance_ID(), attribute.getM_Attribute_ID()}, trxName);
        return instance;
    }

    public String getMMPolicy() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        String MMPolicy = pc.getMMPolicy();
        if (MMPolicy == null || MMPolicy.length() == 0) {
            MMPolicy = MClient.get(this.getCtx()).getMMPolicy();
        }
        return MMPolicy;
    }

    public String getCostingLevel(MAcctSchema as) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), this.get_TrxName());
        String costingLevel = null;
        if (pca != null && (costingLevel = pca.getCostingLevel()) == null) {
            costingLevel = as.getCostingLevel();
        }
        return costingLevel;
    }

    public String getCostingLevel(MAcctSchema as, int AD_Org_ID) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), AD_Org_ID, this.get_TrxName());
        if (pca == null) {
            return this.getCostingLevel(as);
        }
        String costingLevel = pca.getCostingLevel();
        if (costingLevel == null) {
            costingLevel = as.getCostingLevel();
        }
        return costingLevel;
    }

    public String getCostingMethod(MAcctSchema accountSchema) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), accountSchema.get_ID(), this.get_TrxName());
        String costingMethod = pca.getCostingMethod();
        if (costingMethod == null) {
            costingMethod = accountSchema.getCostingMethod();
        }
        return costingMethod;
    }

    public String getCostingMethod(MAcctSchema assetSchema, int AD_Org_ID) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), assetSchema.get_ID(), AD_Org_ID, this.get_TrxName());
        String costingMethod = pca.getCostingMethod();
        if (costingMethod == null) {
            costingMethod = assetSchema.getCostingMethod();
        }
        return costingMethod;
    }

    public Integer getEnvAttributeSetInstance(Properties ctx, int WindowNo) {
        MAttributeSetInstance masi;
        Integer M_AttributeSetInstance_ID = 0;
        M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID");
        if (this.getM_AttributeSetInstance_ID() > 0) {
            M_AttributeSetInstance_ID = new Integer(this.getM_AttributeSetInstance_ID());
        } else if (this.getM_AttributeSet_ID() > 0 && M_AttributeSetInstance_ID > 0 && (masi = MAttributeSetInstance.get(Env.getCtx(), M_AttributeSetInstance_ID, this.getM_Product_ID())).getMAttributeSet().get_ID() != this.getAttributeSet().get_ID()) {
            M_AttributeSetInstance_ID = 0;
        }
        if (M_AttributeSetInstance_ID != 0) {
            return M_AttributeSetInstance_ID;
        }
        return null;
    }

    public static MProduct forNameAndPartType(Properties ctx, String name, String brand, int m_product_classification_id, int m_product_classification_id_2, int aux_M_Attribute_ID, int aux_M_PartType_ID, String trxName) {
        MProduct prod = null;
        if (name == null || name.trim().isEmpty() || brand == null || brand.trim().isEmpty() || aux_M_PartType_ID <= 0 || m_product_classification_id_2 <= 0 || m_product_classification_id <= 0 || aux_M_Attribute_ID <= 0) {
            throw new AdempiereException("Falta informaci\u00f3n para determinar el producto");
        }
        String sql2 = "select s.m_attributeset_id from m_attributeset s inner join m_attributeuse u on s.m_attributeset_id = u.m_attributeset_id where u.m_attribute_id = " + aux_M_Attribute_ID;
        int atrrSetID = DB.getSQLValueEx(trxName, sql2, new Object[0]);
        String sql = "SELECT M_Product_ID FROM M_Product prod JOIN M_Product_Classification c  ON (c.M_Product_Classification_ID=prod.M_Product_Classification_ID) WHERE upper(trim(prod.Name))='" + name.toUpperCase().trim() + "' AND upper(trim(prod." + "Classification" + "))='" + brand.toUpperCase().trim() + "' AND c." + "M_Classification_Parent_ID" + "=" + m_product_classification_id + " AND c." + "M_Product_Classification_ID" + "=" + m_product_classification_id_2 + " AND prod." + "M_AttributeSet_ID" + "=" + atrrSetID + " AND prod." + "M_PartType_ID" + "=" + aux_M_PartType_ID;
        CPreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = DB.prepareStatement(sql, trxName);
            rs = ps.executeQuery();
            if (rs.next()) {
                prod = new MProduct(ctx, rs.getInt("M_Product_ID"), trxName);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, ps);
                throw throwable;
            }
        }
        DB.close(rs, ps);
        return prod;
    }
}

