/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_PaymentProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPaymentProcessor
extends X_C_PaymentProcessor {
    private static final long serialVersionUID = 1825454310856682804L;
    private static CLogger s_log = CLogger.getCLogger(MPaymentProcessor.class);

    public static MPaymentProcessor[] find(Properties ctx, String tender, String CCType, int AD_Client_ID, int AD_Org_ID, int C_Currency_ID, BigDecimal Amt, String trxName) {
        return MPaymentProcessor.find(ctx, tender, CCType, AD_Client_ID, C_Currency_ID, Amt, trxName);
    }

    protected static MPaymentProcessor[] find(Properties ctx, String tender, String CCType, int AD_Client_ID, int C_Currency_ID, BigDecimal Amt, String trxName) {
        ArrayList<MPaymentProcessor> list = new ArrayList<MPaymentProcessor>();
        StringBuffer sql = new StringBuffer("SELECT * FROM C_PaymentProcessor WHERE AD_Client_ID=? AND IsActive='Y' AND (C_Currency_ID IS NULL OR C_Currency_ID=?) AND (MinimumAmt IS NULL OR MinimumAmt = 0 OR MinimumAmt <= ?)");
        if ("A".equals(tender)) {
            sql.append(" AND AcceptDirectDeposit='Y'");
        } else if ("D".equals(tender)) {
            sql.append(" AND AcceptDirectDebit='Y'");
        } else if ("K".equals(tender)) {
            sql.append(" AND AcceptCheck='Y'");
        } else if ("C".equals(CCType)) {
            sql.append(" AND AcceptATM='Y'");
        } else if ("A".equals(CCType)) {
            sql.append(" AND AcceptAMEX='Y'");
        } else if ("V".equals(CCType)) {
            sql.append(" AND AcceptVISA='Y'");
        } else if ("M".equals(CCType)) {
            sql.append(" AND AcceptMC='Y'");
        } else if ("D".equals(CCType)) {
            sql.append(" AND AcceptDiners='Y'");
        } else if ("N".equals(CCType)) {
            sql.append(" AND AcceptDiscover='Y'");
        } else if ("P".equals(CCType)) {
            sql.append(" AND AcceptCORPORATE='Y'");
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), trxName);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, C_Currency_ID);
            pstmt.setBigDecimal(3, Amt);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPaymentProcessor(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "find - " + sql, e);
            return null;
        }
        if (list.size() == 0) {
            s_log.warning("find - not found - AD_Client_ID=" + AD_Client_ID + ", C_Currency_ID=" + C_Currency_ID + ", Amt=" + Amt);
        } else {
            s_log.fine("find - #" + list.size() + " - AD_Client_ID=" + AD_Client_ID + ", C_Currency_ID=" + C_Currency_ID + ", Amt=" + Amt);
        }
        MPaymentProcessor[] retValue = new MPaymentProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPaymentProcessor(Properties ctx, int C_PaymentProcessor_ID, String trxName) {
        super(ctx, C_PaymentProcessor_ID, trxName);
        if (C_PaymentProcessor_ID == 0) {
            this.setCommission(Env.ZERO);
            this.setAcceptVisa(false);
            this.setAcceptMC(false);
            this.setAcceptAMEX(false);
            this.setAcceptDiners(false);
            this.setCostPerTrx(Env.ZERO);
            this.setAcceptCheck(false);
            this.setRequireVV(false);
            this.setAcceptCorporate(false);
            this.setAcceptDiscover(false);
            this.setAcceptATM(false);
            this.setAcceptDirectDeposit(false);
            this.setAcceptDirectDebit(false);
        }
    }

    public MPaymentProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentProcessor[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public boolean accepts(String TenderType, String CreditCardType) {
        return "A".equals(TenderType) && this.isAcceptDirectDeposit() || "D".equals(TenderType) && this.isAcceptDirectDebit() || "K".equals(TenderType) && this.isAcceptCheck() || "C".equals(CreditCardType) && this.isAcceptATM() || "A".equals(CreditCardType) && this.isAcceptAMEX() || "P".equals(CreditCardType) && this.isAcceptCorporate() || "D".equals(CreditCardType) && this.isAcceptDiners() || "N".equals(CreditCardType) && this.isAcceptDiscover() || "M".equals(CreditCardType) && this.isAcceptMC() || "V".equals(CreditCardType) && this.isAcceptVisa();
    }
}

