/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Obscure;
import org.compiere.model.PO;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.X_C_Payment;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public final class MPayment
extends X_C_Payment
implements DocAction,
DocumentReversalEnabled,
ProcessCall {
    private static final long serialVersionUID = 6200327948230438741L;
    private MPaymentProcessor[] m_mPaymentProcessors = null;
    private MPaymentProcessor m_mPaymentProcessor = null;
    private static CLogger s_log = CLogger.getCLogger(MPayment.class);
    private String m_errorMessage = null;
    public static String REVERSE_INDICATOR = "^";
    private String processMsg = null;
    private boolean justPrepared = false;
    private boolean isReversal = false;

    public static List<MPayment> getOfOrder(MOrder order) {
        return new Query(order.getCtx(), "C_Payment", "C_Order_ID=?", order.get_TrxName()).setClient_ID().setParameters(order.getC_Order_ID()).list();
    }

    public static MPayment[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        String whereClause = "C_BPartner_ID=?";
        List<MPayment> list = new Query(ctx, "C_Payment", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        MPayment[] retValue = new MPayment[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPayment(Properties ctx, int C_Payment_ID, String trxName) {
        super(ctx, C_Payment_ID, trxName);
        if (C_Payment_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setTrxType("S");
            this.setR_AvsAddr("X");
            this.setR_AvsZip("X");
            this.setIsReceipt(true);
            this.setIsApproved(false);
            this.setIsReconciled(false);
            this.setIsAllocated(false);
            this.setIsOnline(false);
            this.setIsSelfService(false);
            this.setIsDelayedCapture(false);
            this.setIsPrepayment(false);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setTaxAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsOverUnderPayment(true);
            this.setOverUnderAmt(Env.ZERO);
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setTenderType("K");
        }
    }

    public MPayment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void resetNew() {
        this.setC_Payment_ID(0);
        this.set_ValueNoCheck("DocumentNo", null);
        this.setDocAction("PR");
        this.setDocStatus("DR");
        this.setProcessed(false);
        this.setPosted(false);
        this.setIsReconciled(false);
        this.setIsAllocated(false);
        this.setIsOnline(false);
        this.setIsDelayedCapture(false);
        this.setC_Invoice_ID(0);
        this.setC_Order_ID(0);
        this.setC_Charge_ID(0);
        this.setC_Project_ID(0);
        this.setIsPrepayment(false);
    }

    public boolean isCashTrx() {
        return "X".equals(this.getTenderType());
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, int creditCardExpMM, int creditCardExpYY) {
        this.setTenderType("C");
        this.setTrxType(TrxType);
        this.setCreditCardType(creditCardType);
        this.setCreditCardNumber(creditCardNumber);
        this.setCreditCardVV(creditCardVV);
        this.setCreditCardExpMM(creditCardExpMM);
        this.setCreditCardExpYY(creditCardExpYY);
        int check = MPaymentValidate.validateCreditCardNumber(creditCardNumber, creditCardType).length() + MPaymentValidate.validateCreditCardExp(creditCardExpMM, creditCardExpYY).length();
        if (creditCardVV.length() > 0) {
            check += MPaymentValidate.validateCreditCardVV(creditCardVV, creditCardType).length();
        }
        return check == 0;
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, String creditCardExp) {
        return this.setCreditCard(TrxType, creditCardType, creditCardNumber, creditCardVV, MPaymentValidate.getCreditCardExpMM(creditCardExp), MPaymentValidate.getCreditCardExpYY(creditCardExp));
    }

    public boolean setBankACH(MPaySelectionCheck preparedPayment) {
        this.setC_BankAccount_ID(preparedPayment.getParent().getC_BankAccount_ID());
        int C_BP_BankAccount_ID = preparedPayment.getC_BP_BankAccount_ID();
        MBPBankAccount ba = new MBPBankAccount(preparedPayment.getCtx(), C_BP_BankAccount_ID, null);
        this.setRoutingNo(ba.getRoutingNo());
        this.setAccountNo(ba.getAccountNo());
        this.setDescription(preparedPayment.getC_PaySelection().getDescription());
        this.setIsReceipt("D".equals(preparedPayment.getPaymentRule()));
        if ("D".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("D");
        } else if ("T".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("A");
        }
        int check = MPaymentValidate.validateRoutingNo(this.getRoutingNo()).length() + MPaymentValidate.validateAccountNo(this.getAccountNo()).length();
        return check == 0;
    }

    public boolean setBankACH(int C_BankAccount_ID, boolean isReceipt, String tenderType, String routingNo, String accountNo) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo("");
        int check = MPaymentValidate.validateRoutingNo(routingNo).length() + MPaymentValidate.validateAccountNo(accountNo).length();
        return check == 0;
    }

    public boolean setBankCash(int C_BankAccount_ID, boolean isReceipt, String tenderType) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
        }
        return true;
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String checkNo) {
        return this.setBankCheck(C_BankAccount_ID, isReceipt, null, null, checkNo);
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String routingNo, String accountNo, String checkNo) {
        this.setTenderType("K");
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo(checkNo);
        int check = MPaymentValidate.validateRoutingNo(routingNo).length() + MPaymentValidate.validateAccountNo(accountNo).length() + MPaymentValidate.validateCheckNo(checkNo).length();
        return check == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBankAccountDetails(int C_BankAccount_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block5: {
            if (C_BankAccount_ID == 0) {
                return;
            }
            this.setC_BankAccount_ID(C_BankAccount_ID);
            String sql = "SELECT b.RoutingNo, ba.AccountNo FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE C_BankAccount_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, C_BankAccount_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                this.setRoutingNo(rs.getString(1));
                this.setAccountNo(rs.getString(2));
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public void setAccountAddress(String name, String street, String city, String state, String zip, String country) {
        this.setA_Name(name);
        this.setA_Street(street);
        this.setA_City(city);
        this.setA_State(state);
        this.setA_Zip(zip);
        this.setA_Country(country);
    }

    public boolean processOnline() {
        this.log.info("Amt=" + this.getPayAmt());
        this.setIsOnline(true);
        this.setErrorMessage(null);
        if (this.isApproved()) {
            this.log.info("Already processed - " + this.getR_Result() + " - " + this.getR_RespMsg());
            this.setErrorMessage("Payment already Processed");
            return true;
        }
        if (this.m_mPaymentProcessor == null) {
            this.setPaymentProcessor();
        }
        if (this.m_mPaymentProcessor == null) {
            this.log.log(Level.WARNING, "No Payment Processor Model");
            this.setErrorMessage("No Payment Processor Model");
            return false;
        }
        boolean approved = false;
        try {
            PaymentProcessor pp = PaymentProcessor.create(this.m_mPaymentProcessor, this);
            if (pp == null) {
                this.setErrorMessage("No Payment Processor");
            } else {
                String msg = pp.validate();
                if (msg != null && msg.trim().length() > 0) {
                    this.setErrorMessage(Msg.getMsg(this.getCtx(), msg));
                } else {
                    approved = pp.processCC();
                    if (approved) {
                        this.setErrorMessage(null);
                    } else {
                        this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_RespMsg());
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", e);
            this.setErrorMessage("Payment Processor Error: " + e.getMessage());
        }
        this.setIsApproved(approved);
        return approved;
    }

    @Override
    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        this.log.info("startProcess - " + pi.getRecord_ID());
        boolean retValue = false;
        if (pi.getRecord_ID() != this.get_ID()) {
            this.log.log(Level.SEVERE, "startProcess - Not same Payment - " + pi.getRecord_ID());
            return false;
        }
        retValue = this.processOnline();
        this.save();
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MBankAccount ba;
        if (this.isCashTrx() && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_CashBook_ID@"));
                return false;
            }
        } else if (this.getC_BankAccount_ID() <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_BankAccount_ID@"));
            return false;
        }
        if (this.getC_Charge_ID() != 0) {
            if (newRecord || this.is_ValueChanged("C_Charge_ID")) {
                this.setC_Order_ID(0);
                this.setC_Invoice_ID(0);
                this.setWriteOffAmt(Env.ZERO);
                this.setDiscountAmt(Env.ZERO);
                this.setIsOverUnderPayment(false);
                this.setOverUnderAmt(Env.ZERO);
                this.setIsPrepayment(false);
            }
        } else if (this.getC_BPartner_ID() == 0 && !this.isCashTrx() && this.getC_Invoice_ID() == 0 && this.getC_Order_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@: @C_BPartner_ID@"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Charge_ID") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID")) {
            this.setIsPrepayment(this.getC_Charge_ID() == 0 && this.getC_BPartner_ID() != 0 && (this.getC_Order_ID() != 0 || this.getC_Project_ID() != 0 && this.getC_Invoice_ID() == 0));
        }
        if (this.isPrepayment() && (newRecord || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID"))) {
            this.setWriteOffAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsOverUnderPayment(false);
            this.setOverUnderAmt(Env.ZERO);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        } else {
            MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
            this.setIsReceipt(dt.isSOTrx());
        }
        this.setDocumentNo();
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateTrx());
        }
        if (!this.isOverUnderPayment()) {
            this.setOverUnderAmt(Env.ZERO);
        }
        if ((newRecord || this.is_ValueChanged("C_BankAccount_ID")) && this.getC_Charge_ID() == 0 && (ba = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID())).getAD_Org_ID() != 0) {
            this.setAD_Org_ID(ba.getAD_Org_ID());
        }
        if (this.getC_BPartner_ID() != 0 && (this.getC_Invoice_ID() != 0 || this.getC_Order_ID() != 0)) {
            MOrder ord;
            MInvoice inv;
            if (this.getC_Invoice_ID() != 0 && (inv = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "BP different from BP Invoice"));
                return false;
            }
            if (this.getC_Order_ID() != 0 && (ord = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "BP different from BP Order"));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue = null;
        if (this.getC_Charge_ID() != 0) {
            return this.getPayAmt();
        }
        String sql = "SELECT SUM(currencyConvert(al.Amount,ah.C_Currency_ID, p.C_Currency_ID,ah.DateTrx,p.C_ConversionType_ID, al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID)  INNER JOIN C_Payment p ON (al.C_Payment_ID=p.C_Payment_ID) WHERE al.C_Payment_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Payment_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getAllocatedAmt", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = BigDecimal.ZERO;
        }
        return retValue;
    }

    public boolean testAllocation() {
        boolean change;
        BigDecimal alloc = this.getAllocatedAmt();
        if (alloc == null) {
            alloc = Env.ZERO;
        }
        BigDecimal total = this.getPayAmt();
        if (!this.isReceipt()) {
            total = total.negate();
        }
        boolean test = total.compareTo(alloc) == 0;
        boolean bl = change = test != this.isAllocated();
        if (change) {
            this.setIsAllocated(test);
        }
        this.log.fine("Allocated=" + test + " (" + alloc + "=" + total + ")");
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIsAllocated(Properties ctx, int C_BPartner_ID, String trxName) {
        int counter = 0;
        String sql = "SELECT * FROM C_Payment WHERE IsAllocated='N' AND DocStatus IN ('CO','CL')";
        sql = C_BPartner_ID > 1 ? sql + " AND C_BPartner_ID=?" : sql + " AND AD_Client_ID=" + Env.getAD_Client_ID(ctx);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            if (C_BPartner_ID > 1) {
                pstmt.setInt(1, C_BPartner_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MPayment pay = new MPayment(ctx, rs, trxName);
                if (!pay.testAllocation() || !pay.save()) continue;
                ++counter;
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        s_log.config("#" + counter);
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    @Override
    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        if (C_BankAccount_ID == 0) {
            this.setPaymentProcessor();
            if (this.getC_BankAccount_ID() == 0) {
                throw new IllegalArgumentException("Can't find Bank Account");
            }
        } else {
            super.setC_BankAccount_ID(C_BankAccount_ID);
        }
    }

    public boolean setPaymentProcessor() {
        return this.setPaymentProcessor(this.getTenderType(), this.getCreditCardType());
    }

    public boolean setPaymentProcessor(String tender, String CCType) {
        this.m_mPaymentProcessor = null;
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            this.m_mPaymentProcessors = MPaymentProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), this.getPayAmt(), this.get_TrxName());
        }
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            this.m_mPaymentProcessors = MPaymentProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), Env.ZERO, this.get_TrxName());
        }
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            return false;
        }
        for (int i = 0; i < this.m_mPaymentProcessors.length; ++i) {
            if (!this.m_mPaymentProcessors[i].accepts(tender, CCType)) continue;
            this.m_mPaymentProcessor = this.m_mPaymentProcessors[i];
        }
        if (this.m_mPaymentProcessor != null) {
            this.setC_BankAccount_ID(this.m_mPaymentProcessor.getC_BankAccount_ID());
        }
        return this.m_mPaymentProcessor != null;
    }

    public ValueNamePair[] getCreditCards() {
        return this.getCreditCards(this.getPayAmt());
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
                this.m_mPaymentProcessors = MPaymentProcessor.find(this.getCtx(), null, null, this.getAD_Client_ID(), this.getC_Currency_ID(), amt, this.get_TrxName());
            }
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            for (int i = 0; i < this.m_mPaymentProcessors.length; ++i) {
                if (this.m_mPaymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (!this.m_mPaymentProcessors[i].isAcceptVisa()) continue;
                map.put("V", this.getCreditCardPair("V"));
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + this.m_mPaymentProcessors.length);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    @Override
    public void setCreditCardNumber(String CreditCardNumber) {
        super.setCreditCardNumber(MPaymentValidate.checkNumeric(CreditCardNumber));
    }

    @Override
    public void setCreditCardVV(String newCreditCardVV) {
        super.setCreditCardVV(MPaymentValidate.checkNumeric(newCreditCardVV));
    }

    @Override
    public void setCreditCardExpMM(int CreditCardExpMM) {
        if (CreditCardExpMM >= 1 && CreditCardExpMM <= 12) {
            super.setCreditCardExpMM(CreditCardExpMM);
        }
    }

    @Override
    public void setCreditCardExpYY(int newCreditCardExpYY) {
        int CreditCardExpYY = newCreditCardExpYY;
        if (newCreditCardExpYY > 1999) {
            CreditCardExpYY = newCreditCardExpYY - 2000;
        }
        super.setCreditCardExpYY(CreditCardExpYY);
    }

    public boolean setCreditCardExp(String mmyy) {
        if (MPaymentValidate.validateCreditCardExp(mmyy).length() != 0) {
            return false;
        }
        String exp = MPaymentValidate.checkNumeric(mmyy);
        String mmStr = exp.substring(0, 2);
        String yyStr = exp.substring(2, 4);
        this.setCreditCardExpMM(Integer.parseInt(mmStr));
        this.setCreditCardExpYY(Integer.parseInt(yyStr));
        return true;
    }

    public String getCreditCardExp(String delimiter) {
        String mm = String.valueOf(this.getCreditCardExpMM());
        String yy = String.valueOf(this.getCreditCardExpYY());
        StringBuffer retValue = new StringBuffer();
        if (mm.length() == 1) {
            retValue.append("0");
        }
        retValue.append(mm);
        if (delimiter != null) {
            retValue.append(delimiter);
        }
        if (yy.length() == 1) {
            retValue.append("0");
        }
        retValue.append(yy);
        return retValue.toString();
    }

    @Override
    public void setMicr(String MICR) {
        super.setMicr(MPaymentValidate.checkNumeric(MICR));
    }

    @Override
    public void setRoutingNo(String RoutingNo) {
        super.setRoutingNo(RoutingNo);
    }

    @Override
    public void setAccountNo(String AccountNo) {
        super.setAccountNo(MPaymentValidate.checkNumeric(AccountNo));
    }

    @Override
    public void setCheckNo(String CheckNo) {
        super.setCheckNo(MPaymentValidate.checkNumeric(CheckNo));
    }

    private void setDocumentNo() {
        if ("X".equals(this.getTenderType())) {
            return;
        }
        String documentNo = this.getDocumentNo();
        if (documentNo != null && documentNo.indexOf(REVERSE_INDICATOR) >= 0) {
            return;
        }
        if (this.getR_PnRef() != null && this.getR_PnRef().length() > 0) {
            if (!this.getR_PnRef().equals(documentNo)) {
                this.setDocumentNo(this.getR_PnRef());
            }
            return;
        }
        documentNo = "";
        if ("C".equals(this.getTenderType())) {
            if (MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CREDIT_CARD", true, this.getAD_Client_ID())) {
                documentNo = this.getCreditCardType() + " " + Obscure.obscure(this.getCreditCardNumber()) + " " + this.getCreditCardExpMM() + "/" + this.getCreditCardExpYY();
            }
        } else if ("K".equals(this.getTenderType()) && !this.isReceipt() && this.getCheckNo() != null && this.getCheckNo().length() > 0) {
            if (MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_PAYMENT", true, this.getAD_Client_ID())) {
                documentNo = this.getCheckNo();
            }
        } else if ("K".equals(this.getTenderType()) && this.isReceipt() && MSysConfig.getBooleanValue("PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_RECEIPT", true, this.getAD_Client_ID())) {
            if (this.getRoutingNo() != null) {
                documentNo = this.getRoutingNo() + ": ";
            }
            if (this.getAccountNo() != null) {
                documentNo = documentNo + this.getAccountNo();
            }
            if (this.getCheckNo() != null) {
                if (documentNo.length() > 0) {
                    documentNo = documentNo + " ";
                }
                documentNo = documentNo + "#" + this.getCheckNo();
            }
        }
        if ((documentNo = documentNo.trim()).length() > 0) {
            this.setDocumentNo(documentNo);
        }
    }

    @Override
    public void setR_PnRef(String R_PnRef) {
        super.setR_PnRef(R_PnRef);
        if (R_PnRef != null) {
            this.setDocumentNo(R_PnRef);
        }
    }

    @Override
    public void setPayAmt(BigDecimal PayAmt) {
        super.setPayAmt(PayAmt == null ? Env.ZERO : PayAmt);
    }

    public void setAmount(int C_Currency_ID, BigDecimal payAmt) {
        if (C_Currency_ID == 0) {
            C_Currency_ID = MClient.get(this.getCtx()).getC_Currency_ID();
        }
        this.setC_Currency_ID(C_Currency_ID);
        this.setPayAmt(payAmt);
    }

    @Override
    public void setDiscountAmt(BigDecimal DiscountAmt) {
        super.setDiscountAmt(DiscountAmt == null ? Env.ZERO : DiscountAmt);
    }

    @Override
    public void setWriteOffAmt(BigDecimal WriteOffAmt) {
        super.setWriteOffAmt(WriteOffAmt == null ? Env.ZERO : WriteOffAmt);
    }

    @Override
    public void setOverUnderAmt(BigDecimal OverUnderAmt) {
        super.setOverUnderAmt(OverUnderAmt == null ? Env.ZERO : OverUnderAmt);
        this.setIsOverUnderPayment(this.getOverUnderAmt().compareTo(Env.ZERO) != 0);
    }

    @Override
    public void setTaxAmt(BigDecimal TaxAmt) {
        super.setTaxAmt(TaxAmt == null ? Env.ZERO : TaxAmt);
    }

    public void setBP_BankAccount(MBPBankAccount ba) {
        this.log.fine("" + ba);
        if (ba == null) {
            return;
        }
        this.setC_BPartner_ID(ba.getC_BPartner_ID());
        this.setAccountAddress(ba.getA_Name(), ba.getA_Street(), ba.getA_City(), ba.getA_State(), ba.getA_Zip(), ba.getA_Country());
        this.setA_EMail(ba.getA_EMail());
        this.setA_Ident_DL(ba.getA_Ident_DL());
        this.setA_Ident_SSN(ba.getA_Ident_SSN());
        if (ba.getCreditCardType() != null) {
            this.setCreditCardType(ba.getCreditCardType());
        }
        if (ba.getCreditCardNumber() != null) {
            this.setCreditCardNumber(ba.getCreditCardNumber());
        }
        if (ba.getCreditCardExpMM() != 0) {
            this.setCreditCardExpMM(ba.getCreditCardExpMM());
        }
        if (ba.getCreditCardExpYY() != 0) {
            this.setCreditCardExpYY(ba.getCreditCardExpYY());
        }
        if (ba.getCreditCardVV() != null) {
            this.setCreditCardVV(ba.getCreditCardVV());
        }
        if (ba.getAccountNo() != null) {
            this.setAccountNo(ba.getAccountNo());
        }
        if (ba.getRoutingNo() != null) {
            this.setRoutingNo(ba.getRoutingNo());
        }
    }

    public boolean saveToBP_BankAccount(MBPBankAccount ba) {
        if (ba == null) {
            return false;
        }
        ba.setA_Name(this.getA_Name());
        ba.setA_Street(this.getA_Street());
        ba.setA_City(this.getA_City());
        ba.setA_State(this.getA_State());
        ba.setA_Zip(this.getA_Zip());
        ba.setA_Country(this.getA_Country());
        ba.setA_EMail(this.getA_EMail());
        ba.setA_Ident_DL(this.getA_Ident_DL());
        ba.setA_Ident_SSN(this.getA_Ident_SSN());
        ba.setCreditCardType(this.getCreditCardType());
        ba.setCreditCardNumber(this.getCreditCardNumber());
        ba.setCreditCardExpMM(this.getCreditCardExpMM());
        ba.setCreditCardExpYY(this.getCreditCardExpYY());
        ba.setCreditCardVV(this.getCreditCardVV());
        if (this.getAccountNo() != null) {
            ba.setAccountNo(this.getAccountNo());
        }
        if (this.getRoutingNo() != null) {
            ba.setRoutingNo(this.getRoutingNo());
        }
        ba.setR_AvsAddr(this.getR_AvsAddr());
        ba.setR_AvsZip(this.getR_AvsZip());
        boolean ok = ba.save(this.get_TrxName());
        this.log.fine("saveToBP_BankAccount - " + ba);
        return ok;
    }

    private void setC_DocType_ID() {
        this.setC_DocType_ID(this.isReceipt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setC_DocType_ID(boolean isReceipt) {
        this.setIsReceipt(isReceipt);
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE IsActive = 'Y' AND AD_Client_ID = ? AND DocBaseType = ?";
        String where = "";
        String orderby = " ORDER BY IsDefault DESC";
        if (!isReceipt) {
            where = " AND IsDocNoControlled = 'N'";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql + where + orderby, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            if (isReceipt) {
                pstmt.setString(2, "ARR");
            } else {
                pstmt.setString(2, "APP");
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setC_DocType_ID(rs.getInt(1));
            } else {
                this.log.warning("setDocType - NOT found - isReceipt=" + isReceipt);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    @Override
    public void setC_DocType_ID(int C_DocType_ID) {
        super.setC_DocType_ID(C_DocType_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyDocType(MPaymentAllocate[] pAllocs) {
        MPaymentAllocate[] sql;
        if (this.getC_DocType_ID() == 0) {
            return false;
        }
        Boolean documentSO = null;
        if (this.getC_Invoice_ID() > 0) {
            sql = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (i.C_DocType_ID=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    documentSO = new Boolean("Y".equals(rs.getString(1)));
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, (String)sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        } else if (this.getC_Order_ID() > 0) {
            sql = "SELECT odt.IsSOTrx FROM C_Order o INNER JOIN C_DocType odt ON (o.C_DocType_ID=odt.C_DocType_ID) WHERE o.C_Order_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_Order_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    documentSO = new Boolean("Y".equals(rs.getString(1)));
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, (String)sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        } else if (this.getC_Charge_ID() <= 0 && pAllocs.length > 0) {
            for (MPaymentAllocate pAlloc : pAllocs) {
                String sql2 = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (i.C_DocType_ID=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql2, this.get_TrxName());
                    pstmt.setInt(1, pAlloc.getC_Invoice_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        if (documentSO != null) {
                            if (documentSO.booleanValue() != "Y".equals(rs.getString(1))) {
                                boolean bl = false;
                                DB.close(rs, pstmt);
                                rs = null;
                                pstmt = null;
                                return bl;
                            }
                        } else {
                            documentSO = new Boolean("Y".equals(rs.getString(1)));
                        }
                    }
                    DB.close(rs, pstmt);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql2, e);
                    continue;
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                rs = null;
                pstmt = null;
            }
        }
        Boolean paymentSO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql3 = "SELECT IsSOTrx FROM C_DocType WHERE C_DocType_ID=?";
        try {
            pstmt = DB.prepareStatement(sql3, this.get_TrxName());
            pstmt.setInt(1, this.getC_DocType_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                paymentSO = new Boolean("Y".equals(rs.getString(1)));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql3, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (paymentSO == null) {
            return false;
        }
        this.setIsReceipt(paymentSO);
        return documentSO == null || documentSO.booleanValue() == paymentSO.booleanValue();
    }

    private boolean verifyPaymentAllocateVsHeader(MPaymentAllocate[] pAllocs) {
        return pAllocs.length <= 0 || this.getC_Charge_ID() <= 0 && this.getC_Invoice_ID() <= 0 && this.getC_Order_ID() <= 0;
    }

    private boolean verifyPaymentAllocateSum(MPaymentAllocate[] pAllocs) {
        BigDecimal sumPaymentAllocates = Env.ZERO;
        if (pAllocs.length > 0) {
            for (MPaymentAllocate pAlloc : pAllocs) {
                sumPaymentAllocates = sumPaymentAllocates.add(pAlloc.getAmount());
            }
            if (this.getPayAmt().compareTo(sumPaymentAllocates) != 0) {
                return false;
            }
        }
        return true;
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public String getCreditCardName() {
        return this.getCreditCardName(this.getCreditCardType());
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public BigDecimal getPayAmt(boolean absolute) {
        if (this.isReceipt()) {
            return super.getPayAmt();
        }
        return super.getPayAmt().negate();
    }

    public int getPayAmtInCents() {
        BigDecimal bd = super.getPayAmt().multiply(Env.ONEHUNDRED);
        return bd.intValue();
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MPaymentAllocate[] pAllocs;
        MOrder order;
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!MPaySelectionCheck.deleteGeneratedDraft(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName())) {
            this.processMsg = "Could not delete draft generated payment selection lines";
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), this.isReceipt() ? "ARR" : "APP", this.getAD_Org_ID())) {
            this.processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.isOnline() && !this.isApproved()) {
            this.processMsg = this.getR_Result() != null ? "@OnlinePaymentFailed@" : "@PaymentNotProcessed@";
            return "IN";
        }
        if (this.getC_Order_ID() != 0 && this.getC_Invoice_ID() == 0 && "WP".equals((order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getDocStatus())) {
            order.setC_Payment_ID(this.getC_Payment_ID());
            order.setDocAction("WC");
            order.set_TrxName(this.get_TrxName());
            order.processIt("WC");
            this.processMsg = order.getProcessMsg();
            order.saveEx(this.get_TrxName());
            MInvoice[] invoices = order.getInvoices();
            int length = invoices.length;
            if (length > 0) {
                this.setC_Invoice_ID(invoices[length - 1].getC_Invoice_ID());
            }
            if (this.getC_Invoice_ID() == 0) {
                this.processMsg = "@NotFound@ @C_Invoice_ID@";
                return "IN";
            }
        }
        if (!this.verifyDocType(pAllocs = MPaymentAllocate.get(this))) {
            this.processMsg = "@PaymentDocTypeInvoiceInconsistent@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateVsHeader(pAllocs)) {
            this.processMsg = "@PaymentAllocateIgnored@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateSum(pAllocs)) {
            this.processMsg = "@PaymentAllocateSumInconsistent@";
            return "IN";
        }
        if (!this.isReceipt()) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MPayment counter;
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        if (this.getC_Charge_ID() != 0) {
            this.setIsAllocated(true);
        } else {
            this.allocateIt();
            this.testAllocation();
        }
        if (this.getC_Project_ID() != 0) {
            // empty if block
        }
        if (this.getC_BPartner_ID() != 0 && this.getC_Invoice_ID() == 0 && this.getC_Charge_ID() == 0 && MPaymentAllocate.get(this).length == 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            BigDecimal payAmt = MConversionRate.convertBase(this.getCtx(), this.getPayAmt(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if (payAmt == null) {
                this.processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to base C_Currency_ID=" + MClient.get(Env.getCtx()).getC_Currency_ID();
                return "IN";
            }
            BigDecimal newBalance = bp.getTotalOpenBalance(false);
            if (newBalance == null) {
                newBalance = Env.ZERO;
            }
            newBalance = this.isReceipt() ? newBalance.subtract(payAmt) : newBalance.add(payAmt);
            bp.setTotalOpenBalance(newBalance);
            bp.setSOCreditStatus();
            bp.saveEx();
        }
        if ((counter = this.createCounterDoc()) != null) {
            this.processMsg = this.processMsg + " @CounterDoc@: @C_Payment_ID@=" + counter.getDocumentNo();
        }
        if (this.isCashTrx() && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_CashBook_ID@"));
                this.processMsg = "@NoCashBook@";
                return "IN";
            }
            MCash cash = MCash.get(this.getCtx(), this.getC_CashBook_ID(), this.getDateAcct(), this.get_TrxName());
            if (cash == null || cash.get_ID() == 0) {
                this.processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setCashType("R");
            cl.setDescription("Generated From Payment #" + this.getDocumentNo());
            cl.setC_Currency_ID(this.getC_Currency_ID());
            cl.setC_Payment_ID(this.getC_Payment_ID());
            StringBuffer info = new StringBuffer();
            info.append("Cash journal ( ").append(cash.getDocumentNo()).append(" )");
            this.processMsg = info.toString();
            BigDecimal amt = this.getPayAmt();
            cl.setAmount(amt);
            cl.setDiscountAmt(Env.ZERO);
            cl.setWriteOffAmt(Env.ZERO);
            cl.setIsGenerated(true);
            if (!cl.save(this.get_TrxName())) {
                this.processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        Boolean isOverwrite;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (isOverwrite = Boolean.valueOf(!this.isReversal() || this.isReversal() && !dt.isCopyDocNoOnReversal())).booleanValue() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MPayment createCounterDoc() {
        if (this.getRef_Payment_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MPayment counter = new MPayment(this.getCtx(), 0, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setC_BPartner_ID(counterBP.getC_BPartner_ID());
        counter.setIsReceipt(!this.isReceipt());
        counter.setC_DocType_ID(C_DocTypeTarget_ID);
        counter.setTrxType(this.getTrxType());
        counter.setTenderType(this.getTenderType());
        counter.setPayAmt(this.getPayAmt());
        counter.setDiscountAmt(this.getDiscountAmt());
        counter.setTaxAmt(this.getTaxAmt());
        counter.setWriteOffAmt(this.getWriteOffAmt());
        counter.setIsOverUnderPayment(this.isOverUnderPayment());
        counter.setOverUnderAmt(this.getOverUnderAmt());
        counter.setC_Currency_ID(this.getC_Currency_ID());
        counter.setC_ConversionType_ID(this.getC_ConversionType_ID());
        counter.setDateTrx(this.getDateTrx());
        counter.setDateAcct(this.getDateAcct());
        counter.setRef_Payment_ID(this.getC_Payment_ID());
        String sql = "SELECT C_BankAccount_ID FROM C_BankAccount WHERE C_Currency_ID=? AND AD_Org_ID IN (0,?) AND IsActive='Y' ORDER BY IsDefault DESC";
        int C_BankAccount_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Currency_ID(), counterAD_Org_ID);
        counter.setC_BankAccount_ID(C_BankAccount_ID);
        counter.setC_Activity_ID(this.getC_Activity_ID());
        counter.setC_Campaign_ID(this.getC_Campaign_ID());
        counter.setC_Project_ID(this.getC_Project_ID());
        counter.setUser1_ID(this.getUser1_ID());
        counter.setUser2_ID(this.getUser2_ID());
        counter.setUser3_ID(this.getUser3_ID());
        counter.setUser4_ID(this.getUser4_ID());
        counter.saveEx(this.get_TrxName());
        this.log.fine(counter.toString());
        this.setRef_Payment_ID(counter.getC_Payment_ID());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    public boolean allocateIt() {
        if (this.getC_Invoice_ID() != 0) {
            return this.allocateInvoice();
        }
        if (this.getC_Order_ID() != 0) {
            return false;
        }
        if (this.allocatePaySelection()) {
            return true;
        }
        MPaymentAllocate[] pAllocs = MPaymentAllocate.get(this);
        if (pAllocs.length == 0) {
            return false;
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + this.getDocumentNo(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        if (!alloc.save()) {
            this.log.severe("P.Allocations not created");
            return false;
        }
        for (int i = 0; i < pAllocs.length; ++i) {
            MPaymentAllocate pa = pAllocs[i];
            MAllocationLine aLine = null;
            aLine = this.isReceipt() ? new MAllocationLine(alloc, pa.getAmount(), pa.getDiscountAmt(), pa.getWriteOffAmt(), pa.getOverUnderAmt()) : new MAllocationLine(alloc, pa.getAmount().negate(), pa.getDiscountAmt().negate(), pa.getWriteOffAmt().negate(), pa.getOverUnderAmt().negate());
            aLine.setDocInfo(pa.getC_BPartner_ID(), 0, pa.getC_Invoice_ID());
            aLine.setPaymentInfo(this.getC_Payment_ID(), 0);
            if (!aLine.save(this.get_TrxName())) {
                this.log.warning("P.Allocations - line not saved");
                continue;
            }
            pa.setC_AllocationLine_ID(aLine.getC_AllocationLine_ID());
            pa.saveEx();
        }
        alloc.processIt("CO");
        this.processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        return alloc.save(this.get_TrxName());
    }

    private boolean allocateInvoice() {
        BigDecimal allocationAmt = this.getPayAmt();
        if (this.getOverUnderAmt().signum() < 0 && this.getPayAmt().signum() > 0) {
            allocationAmt = allocationAmt.add(this.getOverUnderAmt());
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + this.getDocumentNo() + " [1]", this.get_TrxName());
        alloc.setAD_Client_ID(this.getAD_Client_ID());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDateAcct(this.getDateAcct());
        alloc.saveEx();
        MAllocationLine aLine = null;
        aLine = this.isReceipt() ? new MAllocationLine(alloc, allocationAmt, this.getDiscountAmt(), this.getWriteOffAmt(), this.getOverUnderAmt()) : new MAllocationLine(alloc, allocationAmt.negate(), this.getDiscountAmt().negate(), this.getWriteOffAmt().negate(), this.getOverUnderAmt().negate());
        aLine.setDocInfo(this.getC_BPartner_ID(), 0, this.getC_Invoice_ID());
        aLine.setC_Payment_ID(this.getC_Payment_ID());
        aLine.saveEx(this.get_TrxName());
        alloc.processIt("CO");
        alloc.saveEx(this.get_TrxName());
        this.processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        int C_Project_ID = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Project_ID) FROM C_Invoice WHERE C_Invoice_ID=?", this.getC_Invoice_ID());
        if (C_Project_ID > 0 && this.getC_Project_ID() == 0) {
            this.setC_Project_ID(C_Project_ID);
        } else if (C_Project_ID > 0 && this.getC_Project_ID() > 0 && C_Project_ID != this.getC_Project_ID()) {
            this.log.warning("Invoice C_Project_ID=" + C_Project_ID + " <> Payment C_Project_ID=" + this.getC_Project_ID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocatePaySelection() {
        MAllocationHdr alloc;
        block10: {
            alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + this.getDocumentNo() + " [n]", this.get_TrxName());
            alloc.setAD_Org_ID(this.getAD_Org_ID());
            alloc.setDateAcct(this.getDateAcct());
            String sql = "SELECT psc.C_BPartner_ID, psl.C_Invoice_ID, psl.IsSOTrx,  psl.PayAmt, psl.DiscountAmt, psl.DifferenceAmt, psl.OpenAmt FROM C_PaySelectionLine psl INNER JOIN C_PaySelectionCheck psc ON (psl.C_PaySelectionCheck_ID=psc.C_PaySelectionCheck_ID) WHERE psc.C_Payment_ID=? AND psl.C_Invoice_ID IS NOT NULL";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_Payment_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_BPartner_ID = rs.getInt(1);
                    int C_Invoice_ID = rs.getInt(2);
                    if (C_BPartner_ID == 0 && C_Invoice_ID == 0) continue;
                    boolean isSOTrx = "Y".equals(rs.getString(3));
                    BigDecimal PayAmt = rs.getBigDecimal(4);
                    BigDecimal DiscountAmt = rs.getBigDecimal(5);
                    BigDecimal WriteOffAmt = Env.ZERO;
                    BigDecimal OpenAmt = rs.getBigDecimal(7);
                    BigDecimal OverUnderAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                    if (alloc.get_ID() == 0 && !alloc.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not create Allocation Hdr");
                        rs.close();
                        pstmt.close();
                        boolean bl = false;
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        return bl;
                    }
                    MAllocationLine aLine = null;
                    aLine = isSOTrx ? new MAllocationLine(alloc, PayAmt, DiscountAmt, WriteOffAmt, OverUnderAmt) : new MAllocationLine(alloc, PayAmt.negate(), DiscountAmt.negate(), WriteOffAmt.negate(), OverUnderAmt.negate());
                    aLine.setDocInfo(C_BPartner_ID, 0, C_Invoice_ID);
                    aLine.setC_Payment_ID(this.getC_Payment_ID());
                    if (aLine.save(this.get_TrxName())) continue;
                    this.log.log(Level.SEVERE, "Could not create Allocation Line");
                }
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "allocatePaySelection", e);
                break block10;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            rs = null;
            pstmt = null;
        }
        boolean ok = true;
        if (alloc.get_ID() == 0) {
            this.log.fine("No Allocation created - C_Payment_ID=" + this.getC_Payment_ID());
            ok = false;
        } else {
            alloc.processIt("CO");
            ok = alloc.save(this.get_TrxName());
            this.processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        }
        return ok;
    }

    private void deAllocate(boolean isAccrual) {
        List<MAllocationHdr> allocations = Arrays.asList(MAllocationHdr.getOfPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName()));
        this.log.fine("#" + allocations.size());
        allocations.stream().filter(allocationHdr -> !allocationHdr.getDocStatus().equals("RE") || !allocationHdr.getDocStatus().equals("VO")).forEach(allocationHdr -> {
            allocationHdr.set_TrxName(this.get_TrxName());
            if (isAccrual) {
                allocationHdr.setDocAction("RA");
                if (!allocationHdr.processIt("RA")) {
                    throw new AdempiereException(allocationHdr.getProcessMsg());
                }
            } else {
                allocationHdr.setDocAction("RC");
                if (!allocationHdr.processIt("RC")) {
                    throw new AdempiereException(allocationHdr.getProcessMsg());
                }
            }
            allocationHdr.saveEx();
        });
        if (this.getC_Invoice_ID() != 0) {
            String sql = "UPDATE C_Invoice SET C_Payment_ID = NULL, IsPaid='N' WHERE C_Invoice_ID=" + this.getC_Invoice_ID() + " AND C_Payment_ID=" + this.getC_Payment_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            if (no != 0) {
                this.log.fine("Unlink Invoice #" + no);
            }
            if ((no = DB.executeUpdate(sql = "UPDATE C_Order o SET C_Payment_ID = NULL WHERE EXISTS (SELECT * FROM C_Invoice i WHERE o.C_Order_ID=i.C_Order_ID AND i.C_Invoice_ID=" + this.getC_Invoice_ID() + ") AND C_Payment_ID=" + this.getC_Payment_ID(), this.get_TrxName())) != 0) {
                this.log.fine("Unlink Order #" + no);
            }
        }
        this.setC_Invoice_ID(0);
        this.setIsAllocated(false);
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (this.getC_BankStatementLine_ID() > 0) {
            return this.reverseCorrectIt();
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.processMsg != null) {
                return false;
            }
            if (!this.voidOnlinePayment()) {
                return false;
            }
        } else {
            boolean isAccrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                isAccrual = true;
            }
            if (isAccrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + this.getPayAmt() + ")");
        this.setPayAmt(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setOverUnderAmt(Env.ZERO);
        this.setIsAllocated(false);
        this.deAllocate(false);
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMsg == null;
    }

    @Override
    public MPayment reverseIt(boolean isAccrual) {
        if (!this.voidOnlinePayment()) {
            return null;
        }
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElse(currentDate) : this.getDateAcct();
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, this.getC_DocType_ID(), this.getAD_Org_ID());
        boolean reconciled = this.getC_BankStatementLine_ID() == 0;
        MPayment reversal = new MPayment(this.getCtx(), 0, this.get_TrxName());
        MPayment.copyValues(this, reversal);
        reversal.setReversal(true);
        reversal.setClientOrg(this);
        reversal.setC_Invoice_ID(0);
        reversal.setDateAcct(reversalDate);
        reversal.set_ValueNoCheck("DocumentNo", null);
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reversal.setDocumentNo(this.getDocumentNo() + Msg.getMsg(this.getCtx(), "^"));
        }
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setPayAmt(this.getPayAmt().negate());
        reversal.setDiscountAmt(this.getDiscountAmt().negate());
        reversal.setWriteOffAmt(this.getWriteOffAmt().negate());
        reversal.setOverUnderAmt(this.getOverUnderAmt().negate());
        reversal.setIsAllocated(true);
        reversal.setIsReconciled(reconciled);
        reversal.setIsOnline(false);
        reversal.setIsApproved(true);
        reversal.setR_PnRef(null);
        reversal.setR_Result(null);
        reversal.setR_RespMsg(null);
        reversal.setR_AuthCode(null);
        reversal.setR_Info(null);
        reversal.setProcessing(false);
        reversal.setOProcessing("N");
        reversal.setProcessed(false);
        reversal.setPosted(false);
        reversal.setDescription(this.getDescription());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getC_Payment_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO")) {
            this.processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.save(this.get_TrxName());
        this.deAllocate(isAccrual);
        this.setIsReconciled(reconciled);
        this.setIsAllocated(true);
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setReversal_ID(reversal.getC_Payment_ID());
        MAllocationHdr allocationHdr = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Payment_ID") + ": " + reversal.getDocumentNo(), this.get_TrxName());
        allocationHdr.setAD_Org_ID(this.getAD_Org_ID());
        allocationHdr.setDateAcct(reversalDate);
        allocationHdr.saveEx(this.get_TrxName());
        MAllocationLine allocationLine = new MAllocationLine(allocationHdr, this.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        allocationLine.setDocInfo(this.getC_BPartner_ID(), 0, 0);
        allocationLine.setPaymentInfo(this.getC_Payment_ID(), 0);
        allocationLine.saveEx(this.get_TrxName());
        allocationLine = new MAllocationLine(allocationHdr, reversal.getPayAmt(true), Env.ZERO, Env.ZERO, Env.ZERO);
        allocationLine.setDocInfo(reversal.getC_BPartner_ID(), 0, 0);
        allocationLine.setPaymentInfo(reversal.getC_Payment_ID(), 0);
        allocationLine.saveEx(this.get_TrxName());
        if (!allocationHdr.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + allocationHdr.getProcessMsg());
        }
        allocationHdr.save(this.get_TrxName());
        StringBuffer info = new StringBuffer(reversal.getDocumentNo());
        info.append(" - @C_AllocationHdr_ID@: ").append(allocationHdr.getDocumentNo());
        if (this.getC_BPartner_ID() != 0) {
            MBPartner partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            partner.setTotalOpenBalance();
            partner.save(this.get_TrxName());
        }
        this.processMsg = info.toString();
        return reversal;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMsg != null) {
            return false;
        }
        if (this.reverseIt(false) == null) {
            return false;
        }
        this.reverseGeneratedPayments();
        StringBuilder info = new StringBuilder(this.processMsg);
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = info.toString();
        return true;
    }

    private void reverseGeneratedPayments() {
        MBankAccount bankAccount = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        MBank bank = MBank.get(this.getCtx(), bankAccount.getC_Bank_ID());
        if (!Util.isEmpty(bank.getBankType()) && bank.getBankType().equals("C") && !this.isReceipt()) {
            new Query(this.getCtx(), "C_Payment", "Ref_Payment_ID = ? AND DocStatus = ? AND IsReceipt = 'Y'AND EXISTS(SELECT 1 FROM C_Bank b\t\t\t\t\tINNER JOIN C_BankAccount ba ON(ba.C_Bank_ID = b.C_Bank_ID)\t\t\t\tWHERE ba.C_BankAccount_ID = C_Payment.C_BankAccount_ID\t\t\t\tAND b.BankType = ?)", this.get_TrxName()).setParameters(this.getC_Payment_ID(), "CO", "B").list().stream().forEach(deposit -> {
                deposit.processIt("RC");
                deposit.saveEx();
            });
        }
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMsg != null) {
            return false;
        }
        if (this.reverseIt(true) == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.processMsg == null;
    }

    private int getC_BankStatementLine_ID() {
        String sql = "SELECT C_BankStatementLine_ID FROM C_BankStatementLine WHERE C_Payment_ID=?";
        int id = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Payment_ID());
        if (id < 0) {
            return 0;
        }
        return id;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.processMsg == null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPayment[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Receipt=").append(this.isReceipt()).append(",PayAmt=").append(this.getPayAmt()).append(",Discount=").append(this.getDiscountAmt()).append(",WriteOff=").append(this.getWriteOffAmt()).append(",OverUnder=").append(this.getOverUnderAmt());
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "PayAmt")).append("=").append(this.getPayAmt()).append(",").append(Msg.translate(this.getCtx(), "WriteOffAmt")).append("=").append(this.getWriteOffAmt());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        if (this.isReceipt()) {
            return this.getWriteOffAmt();
        }
        return this.getPayAmt();
    }

    private boolean voidOnlinePayment() {
        if (this.getTenderType().equals("C") && this.isOnline()) {
            this.setOrig_TrxID(this.getR_PnRef());
            this.setTrxType("V");
            if (!this.processOnline()) {
                this.setTrxType("C");
                if (!this.processOnline()) {
                    this.log.log(Level.SEVERE, "Failed to cancel payment online");
                    this.processMsg = Msg.getMsg(this.getCtx(), "PaymentNotCancelled");
                    return false;
                }
            }
        }
        if (this.getC_Invoice_ID() != 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            invoice.setC_Payment_ID(0);
            invoice.saveEx();
        }
        if (this.getC_Order_ID() != 0) {
            MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
            order.setC_Payment_ID(0);
            order.saveEx();
        }
        return true;
    }

    @Override
    public void setReversal(boolean isReversal) {
        this.isReversal = isReversal;
    }

    @Override
    public boolean isReversal() {
        return this.isReversal;
    }
}

