/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MDocType;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_C_PaySelection;
import org.compiere.model.X_C_PaySelectionCheck;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;

public class MPaySelection
extends X_C_PaySelection
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -6521282913549455131L;
    public static final String DocBaseType_Standard = "APS";
    private List<MPaySelectionLine> paySelectionLines = new ArrayList<MPaySelectionLine>();
    private String processMessage = null;
    private boolean justPrepared = false;
    private HashMap<Integer, Boolean> linesPaid = null;
    private HashMap<Integer, Boolean> linesUsed = null;
    private boolean isPaidCompletely = false;
    private boolean isUsedCompletely = false;
    private boolean isPaid = false;
    private boolean isUsed = false;

    public MPaySelection(Properties ctx, int paySelectionId, String trxName) {
        super(ctx, paySelectionId, trxName);
        if (paySelectionId == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MPaySelection(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MPaySelectionLine> getLines(boolean requery) {
        if (this.paySelectionLines != null && !requery) {
            this.paySelectionLines.stream().filter(paySelectionLine -> paySelectionLine != null).forEach(paySelectionLine -> paySelectionLine.set_TrxName(this.get_TrxName()));
            return this.paySelectionLines;
        }
        return this.getLines(null, null);
    }

    public void setC_DocType_ID() {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocBaseType_Standard);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=" + DocBaseType_Standard);
        } else {
            this.log.fine("(APS) - APS");
            this.setC_DocType_ID(C_DocType_ID);
        }
    }

    public List<MPaySelectionLine> getLines(String whereClause, String orderClause) {
        StringBuffer whereClauseFinal = new StringBuffer("C_PaySelection_ID = ? ");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(whereClause);
        }
        if (Util.isEmpty(orderClause, true)) {
            orderClause = "Line";
        }
        this.paySelectionLines = new Query(this.getCtx(), "C_PaySelectionLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.getC_PaySelection_ID()).setOrderBy(orderClause).list();
        return this.paySelectionLines;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MPaySelection[");
        stringBuffer.append(this.get_ID()).append(",").append(this.getDocumentInfo()).append("]");
        return stringBuffer.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return docType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMessage = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMessage != null) {
            return "IN";
        }
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), docType.getDocBaseType(), this.getAD_Org_ID())) {
            this.processMessage = "@PeriodClosed@";
            return "IN";
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMessage != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMessage != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        if (this.getTotalAmt() == null || this.getTotalAmt().equals(Env.ZERO)) {
            this.processMessage = "@TotalAmt@ = 0";
            return "IN";
        }
        String erroMsg = this.validateConversion();
        if (erroMsg != null) {
            this.processMessage = erroMsg;
            return "IN";
        }
        this.createChecks();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.processMessage = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        for (MPaySelectionLine paySelectionLine : this.getLines(true)) {
            if (!processed && (this.isUsed(paySelectionLine.getC_PaySelectionLine_ID()) || this.isPaid(paySelectionLine.getC_PaySelectionLine_ID()))) continue;
            paySelectionLine.setProcessed(processed);
            paySelectionLine.saveEx();
        }
    }

    private void setDefiniteDocumentNo() {
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (docType.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int retValue;
        if (this.getC_BankAccount_ID() == 0 && this.getC_Currency_ID() == 0) {
            throw new AdempiereException("@C_Currency_ID@ @NotFound@");
        }
        if (this.getC_BankAccount_ID() != 0 && this.getC_Currency_ID() == 0) {
            MBankAccount bankAccount = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
            this.setC_Currency_ID(bankAccount.getC_Currency_ID());
        }
        if ((this.is_ValueChanged("C_Currency_ID") || this.is_ValueChanged("PayDate")) && (retValue = DB.getSQLValue(this.get_TrxName(), "SELECT 1 FROM C_PaySelection s INNER JOIN C_PaySelectionLine l ON(l.C_PaySelection_ID = s.C_PaySelection_ID) WHERE s.C_PaySelection_ID = ? AND (\t\t(l.C_Order_ID IS NOT NULL AND EXISTS(SELECT 1 FROM C_Order o WHERE o.C_Order_ID = l.C_Order_ID AND o.C_Currency_ID <> s.C_Currency_ID)) \t\tOR \t\t(l.C_Invoice_ID IS NOT NULL AND EXISTS(SELECT 1 FROM C_Invoice i WHERE i.C_Invoice_ID = l.C_Invoice_ID AND i.C_Currency_ID <> s.C_Currency_ID)))", this.getC_PaySelection_ID())) > 0) {
            throw new AdempiereException("@PSDocConverted@ (@C_Currency_ID@)");
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        }
        return super.beforeSave(newRecord);
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        if (this.isUsed()) {
            throw new AdempiereException("@C_PaySelection_ID@ @Processed@");
        }
        if (this.isPaid()) {
            throw new AdempiereException("@C_PaySelection_ID@ @IsPaid@");
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.setDocStatus("VO");
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        if (this.isCompletelyUsed()) {
            throw new AdempiereException("@C_PaySelection_ID@ @Processed@");
        }
        if (this.isCompletelyPaid()) {
            throw new AdempiereException("@C_PaySelection_ID@ @IsPaid@");
        }
        this.setProcessed(false);
        this.deleteChecks();
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMessage;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalAmt();
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "RE";
                options[index++] = "VO";
            }
        }
        return index;
    }

    private String validateConversion() {
        StringBuffer errorMsg = new StringBuffer();
        List<MPaySelectionLine> paySelectionLines = this.getLines(null, "C_BPartner_ID, PaymentRule, C_BP_BankAccount_ID, IsPrepayment, C_Charge_ID");
        paySelectionLines.stream().filter(paySelectionLine -> paySelectionLine != null && !paySelectionLine.isProcessed()).forEach(paySelectionLine -> {
            if (!paySelectionLine.isValidConversion()) {
                if (errorMsg.length() > 0) {
                    errorMsg.append(Env.NL);
                }
                MBPartner partner = MBPartner.get(this.getCtx(), paySelectionLine.getC_BPartner_ID());
                errorMsg.append("@C_Conversion_Rate_ID@ @NotFound@ [@Line@ ").append(paySelectionLine.getLine()).append(" @C_BPartner_ID@ ").append(partner.getName()).append("]");
            }
        });
        if (errorMsg.length() > 0) {
            return errorMsg.toString();
        }
        return null;
    }

    private void createChecks() {
        if (this.getC_BankAccount_ID() == 0) {
            return;
        }
        MDocType documentType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        int chargeId = 0;
        boolean isPrepayment = false;
        int bankAccountToId = 0;
        X_C_PaySelectionCheck paySelectionCheck = null;
        List<MPaySelectionLine> paySelectionLines = this.getLines(null, "C_BPartner_ID, PaymentRule, C_BP_BankAccount_ID, IsPrepayment, C_Charge_ID, C_BankAccountTo_ID");
        for (MPaySelectionLine paySelectionLine : paySelectionLines) {
            if (paySelectionLine.getC_PaySelectionCheck_ID() != 0) continue;
            if (documentType.isBankTransfer() && paySelectionLine.getC_BankAccountTo_ID() == 0) {
                throw new AdempiereException("@C_BankAccountTo_ID@ @NotFound@");
            }
            if (paySelectionCheck == null || paySelectionCheck.getC_BPartner_ID() != paySelectionLine.getC_BPartner_ID() || paySelectionLine.getC_BP_BankAccount_ID() != 0 && paySelectionCheck.getC_BP_BankAccount_ID() != paySelectionLine.getC_BP_BankAccount_ID() || !paySelectionCheck.getPaymentRule().equals(paySelectionLine.getPaymentRule()) || chargeId != paySelectionLine.getC_Charge_ID() || isPrepayment != paySelectionLine.isPrepayment() || bankAccountToId != paySelectionLine.getC_BankAccountTo_ID()) {
                paySelectionCheck = new MPaySelectionCheck(paySelectionLine, paySelectionLine.getPaymentRule());
                chargeId = paySelectionLine.getC_Charge_ID();
                isPrepayment = paySelectionLine.isPrepayment();
                bankAccountToId = paySelectionLine.getC_BankAccountTo_ID();
            } else {
                ((MPaySelectionCheck)paySelectionCheck).addLine(paySelectionLine);
            }
            paySelectionCheck.saveEx();
            paySelectionLine.setC_PaySelectionCheck_ID(paySelectionCheck.getC_PaySelectionCheck_ID());
            paySelectionLine.saveEx();
        }
    }

    private void deleteChecks() {
        for (MPaySelectionCheck paySelectionCheck : MPaySelectionCheck.get(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName())) {
            MPayment payment;
            if (paySelectionCheck.getC_Payment_ID() != 0 && !(payment = new MPayment(this.getCtx(), paySelectionCheck.getC_Payment_ID(), this.get_TrxName())).getDocStatus().equals("VO") && !payment.getDocStatus().equals("RE")) continue;
            DB.executeUpdate("UPDATE C_PaySelectionLine SET C_PaySelectionCheck_ID = NULL WHERE C_PaySelectionCheck_ID = ?", paySelectionCheck.getC_PaySelectionCheck_ID(), this.get_TrxName());
            paySelectionCheck.deleteEx(true);
        }
    }

    private void verifyIsPaid() {
        if (this.linesPaid != null) {
            return;
        }
        this.linesPaid = new HashMap();
        KeyNamePair[] pairs = DB.getKeyNamePairs("SELECT psl.C_PaySelectionLine_ID, (CASE \t\tWHEN COALESCE(\t\t\t\t\tSUM(CASE \t\t\t\t\t\t\tWHEN p.DocStatus NOT IN('VO', 'RE') \t\t\t\t\t\t\tTHEN 1 \t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\tEND\t\t\t\t\t), 0\t\t\t) > 0 \t\tTHEN 'Y' \t\tELSE 'N' \t\tEND) IsPaid FROM C_PaySelectionLine psl LEFT JOIN C_PaySelectionCheck psc ON(psc.C_PaySelectionCheck_ID = psl.C_PaySelectionCheck_ID) LEFT JOIN C_Payment p ON(p.C_Payment_ID = psc.C_Payment_ID) WHERE psl.C_PaySelection_ID = ? GROUP BY psl.C_PaySelectionLine_ID", false, this.getC_PaySelection_ID());
        boolean paidCompletely = true;
        boolean paid = false;
        for (KeyNamePair pair : pairs) {
            this.linesPaid.put(pair.getKey(), pair.getName().equals("Y"));
            if (!pair.getName().equals("Y") && paidCompletely) {
                paidCompletely = false;
                continue;
            }
            if (!pair.getName().equals("Y") || paid) continue;
            paid = true;
        }
        this.isPaidCompletely = paidCompletely;
        this.isPaid = paid;
    }

    private void verifyIsUsed() {
        if (this.linesUsed != null) {
            return;
        }
        this.linesUsed = new HashMap();
        KeyNamePair[] pairs = DB.getKeyNamePairs("SELECT psl.C_PaySelectionLine_ID, (CASE \t\tWHEN COALESCE(\t\t\t\t\tSUM(CASE \t\t\t\t\t\t\tWHEN cps.DocStatus NOT IN('VO', 'RE') \t\t\t\t\t\t\tTHEN 1 \t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\tEND\t\t\t\t\t), 0\t\t\t) > 0 \t\tTHEN 'Y' \t\tELSE 'N' \t\tEND) IsUsed FROM C_PaySelectionLine psl LEFT JOIN C_PaySelectionLine cpsl ON(cpsl.C_PaySelectionLine_Parent_ID = psl.C_PaySelectionLine_ID) LEFT JOIN C_PaySelection cps ON(cps.C_PaySelection_ID = cpsl.C_PaySelection_ID) WHERE psl.C_PaySelection_ID = ? GROUP BY psl.C_PaySelectionLine_ID", false, this.getC_PaySelection_ID());
        boolean usedCompletely = true;
        boolean used = false;
        for (KeyNamePair pair : pairs) {
            this.linesUsed.put(pair.getKey(), pair.getName().equals("Y"));
            if (!pair.getName().equals("Y") && usedCompletely) {
                usedCompletely = false;
                continue;
            }
            if (!pair.getName().equals("Y") || used) continue;
            used = true;
        }
        this.isUsedCompletely = usedCompletely;
        this.isUsed = used;
    }

    public boolean isCompletelyPaid() {
        this.verifyIsPaid();
        return this.isPaidCompletely;
    }

    public boolean isCompletelyUsed() {
        this.verifyIsUsed();
        return this.isUsedCompletely;
    }

    public boolean isPaid() {
        this.verifyIsPaid();
        return this.isPaid;
    }

    public boolean isUsed() {
        this.verifyIsUsed();
        return this.isUsed;
    }

    private boolean isPaid(int paySelectionLineId) {
        this.verifyIsPaid();
        Boolean isPaid = this.linesPaid.get(paySelectionLineId);
        if (isPaid == null) {
            return false;
        }
        return isPaid;
    }

    private boolean isUsed(int payselectionlineId) {
        this.verifyIsUsed();
        Boolean isUsed = this.linesUsed.get(payselectionlineId);
        if (isUsed == null) {
            return false;
        }
        return isUsed;
    }

    public int getLastLineNo() {
        int lastLineNo = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(psl.Line) As Line FROM C_PaySelectionLine psl WHERE psl.C_PaySelection_ID = ?", this.getC_PaySelection_ID());
        if (lastLineNo == -1) {
            lastLineNo = 0;
        }
        return lastLineNo;
    }
}

