/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovementLine;
import org.compiere.model.MPackage;
import org.compiere.model.X_M_PackageLine;
import org.compiere.util.Env;

public class MPackageLine
extends X_M_PackageLine {
    private static final long serialVersionUID = 6018805803189654348L;
    private MPackage parent = null;

    public MPackage getParent() {
        if (this.parent == null) {
            this.parent = new MPackage(this.getCtx(), this.getM_Package_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    public MPackageLine(Properties ctx, int M_PackageLine_ID, String trxName) {
        super(ctx, M_PackageLine_ID, trxName);
        if (M_PackageLine_ID == 0) {
            this.setQty(Env.ZERO);
        }
    }

    public MPackageLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPackageLine(MPackage parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_Package_ID(parent.getM_Package_ID());
    }

    public void setInOutLine(MInOutLine shipmentLine) {
        this.setM_InOutLine_ID(shipmentLine.getM_InOutLine_ID());
        this.setQty(shipmentLine.getMovementQty());
    }

    public void setMovementLine(MMovementLine movementLine) {
        this.setM_MovementLine_ID(movementLine.getM_MovementLine_ID());
        this.setQty(movementLine.getMovementQty());
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("Width") || this.is_ValueChanged("Height") || this.is_ValueChanged("Depth") || this.is_ValueChanged("Weight") || this.is_ValueChanged("Volume")) {
            return this.updateHeader();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        if (this.getParent().isProcessed()) {
            return false;
        }
        AtomicReference<BigDecimal> weight = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> volume = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> width = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> heigh = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> depth = new AtomicReference<BigDecimal>(Env.ZERO);
        this.getParent().getLines(true).forEach(packageLine -> {
            weight.updateAndGet(value -> value.add(packageLine.getWeight()));
            volume.updateAndGet(value -> value.add(packageLine.getVolume()));
            width.updateAndGet(value -> value.max(packageLine.getWidth()));
            heigh.updateAndGet(value -> value.max(packageLine.getHeight()));
            depth.updateAndGet(value -> value.max(packageLine.getDepth()));
        });
        this.parent.setWeight(weight.get());
        this.parent.setVolume(volume.get());
        this.parent.setWidth(width.get());
        this.parent.setHeight(heigh.get());
        this.parent.setDepth(depth.get());
        this.parent.saveEx();
        this.parent = null;
        this.log.fine("Header updated");
        return true;
    }
}

