/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Org;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MOrg
extends X_AD_Org {
    private static final long serialVersionUID = -5604686137606338725L;
    private static CCache<Integer, MOrg> s_cache = new CCache("AD_Org", 50);
    private Integer m_linkedBPartner = null;

    public static MOrg[] getOfClient(PO po) {
        List<MOrg> list = new Query(po.getCtx(), "AD_Org", "AD_Client_ID=?", null).setOrderBy("Value").setOnlyActiveRecords(true).setParameters(po.getAD_Client_ID()).list();
        for (MOrg org : list) {
            s_cache.put(org.get_ID(), org);
        }
        return list.toArray(new MOrg[list.size()]);
    }

    public static MOrg get(Properties ctx, int AD_Org_ID) {
        MOrg retValue = s_cache.get(AD_Org_ID);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MOrg(ctx, AD_Org_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(AD_Org_ID, retValue);
        }
        return retValue;
    }

    public MOrg(Properties ctx, int AD_Org_ID, String trxName) {
        super(ctx, AD_Org_ID, trxName);
        if (AD_Org_ID == 0) {
            this.setIsSummary(false);
        }
    }

    public MOrg(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOrg(MClient client, String value, String name) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setAD_Client_ID(client.getAD_Client_ID());
        this.setValue(value);
        this.setName(name);
    }

    public MOrgInfo getInfo() {
        return MOrgInfo.get(this.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            MOrgInfo info = new MOrgInfo(this);
            info.saveEx();
            MRoleOrgAccess.createForOrg(this);
            MRole role = MRole.getDefault(this.getCtx(), true);
            role.set_TrxName(this.get_TrxName());
            role.loadAccess(true);
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "AD_Org_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            if ("Y".equals(Env.getContext(this.getCtx(), "$Element_OT"))) {
                MAccount.updateValueDescription(this.getCtx(), "AD_OrgTrx_ID=" + this.getAD_Org_ID(), this.get_TrxName());
            }
        }
        return true;
    }

    public int getLinkedC_BPartner_ID(String trxName) {
        if (this.m_linkedBPartner == null) {
            int C_BPartner_ID = DB.getSQLValue(trxName, "SELECT C_BPartner_ID FROM C_BPartner WHERE AD_OrgBP_ID=?", this.getAD_Org_ID());
            if (C_BPartner_ID < 0) {
                C_BPartner_ID = 0;
            }
            this.m_linkedBPartner = new Integer(C_BPartner_ID);
        }
        return this.m_linkedBPartner;
    }
}

