/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMigrationStep;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Migration;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MMigration
extends X_AD_Migration {
    private static final long serialVersionUID = -5145941967716336078L;
    private ArrayList<Integer> columnList = new ArrayList();
    private CLogger log = CLogger.getCLogger(MMigration.class);
    private boolean isForce = true;

    public boolean isForce() {
        return this.isForce;
    }

    public void setIsForce(boolean isForce) {
        this.isForce = isForce;
    }

    public MMigration(Properties ctx, int AD_Migration_ID, String trxName) {
        super(ctx, AD_Migration_ID, trxName);
    }

    public MMigration(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String apply() {
        Boolean apply = false;
        this.updateStatus();
        if (this.getStatusCode() == null || this.getStatusCode().length() == 0) {
            this.setStatusCode("U");
        }
        if (this.getApply() == null || this.getApply().length() == 0) {
            this.setApply("A");
        }
        if ((this.getStatusCode().equals("A") || this.getStatusCode().equals("P")) && !this.getApply().equals("R")) {
            this.setApply("R");
        } else if (this.getStatusCode().equals("U") && !this.getApply().equals("A")) {
            this.setApply("A");
        }
        if (this.getStatusCode().equals("U")) {
            apply = true;
        }
        String retVal = this.toString();
        try {
            Env.setContext(Env.getCtx(), "MigrationScriptBatchInProgress", "Y");
            boolean all = true;
            for (int stepId : this.getStepIds(!all, apply == false)) {
                MMigrationStep step = new MMigrationStep(this.getCtx(), stepId, this.get_TrxName());
                step.setParent(this);
                if (!apply.booleanValue() && "U".equals(step.getStatusCode())) {
                    this.log.log(Level.CONFIG, step.toString() + " ---> Migration Step unapplied - skipping.");
                    continue;
                }
                try {
                    step.apply();
                }
                catch (Exception e) {
                    if (this.isForce) continue;
                    this.syncColumn();
                    throw e;
                }
            }
            this.syncColumn();
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            if (!this.isForce) {
                if (apply.booleanValue()) {
                    this.setStatusCode("F");
                    this.apply();
                }
                throw new AdempiereException(e.getMessage(), e);
            }
        }
        finally {
            Env.setContext(Env.getCtx(), "MigrationScriptBatchInProgress", "");
            this.updateStatus();
            retVal = apply.booleanValue() ? (this.getStatusCode().equals("A") ? retVal + "Migration successful" : (this.getStatusCode().equals("P") ? retVal + "Migration partially applied. Please review migration steps for errors." : (this.getStatusCode().equals("F") ? retVal + "Migration failed. Please review migration steps for errors." : (this.getStatusCode().equals("U") ? retVal + "Migration not applied. Please review migration steps for errors." : retVal + "Migration status unknown. Please review migration steps for errors.")))) : (this.getStatusCode().equals("U") ? retVal + "Migration rollback successful." : (this.getStatusCode().equals("P") || this.getStatusCode().equals("F") || this.getStatusCode().equals("A") ? retVal + "Migration rollback failed. Please review migration steps for errors." : retVal + "Migration status unknown. Please review migration steps for errors."));
        }
        return retVal;
    }

    public void updateStatus() {
        if (Env.getContext(this.getCtx(), "MigrationScriptBatchInProgress").equals("Y")) {
            return;
        }
        StringBuilder whereBase = new StringBuilder();
        whereBase.append("AD_Migration_ID").append("=?");
        int total = new Query(this.getCtx(), "AD_MigrationStep", whereBase.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_Migration_ID()).count();
        StringBuilder where = new StringBuilder(whereBase);
        where.append(" AND ").append("StatusCode").append("=?");
        int applied = new Query(this.getCtx(), "AD_MigrationStep", where.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_Migration_ID(), "A").count();
        where = new StringBuilder(whereBase);
        where.append(" AND ").append("StatusCode").append(" IN( ? , ? )");
        int unapplied = new Query(this.getCtx(), "AD_MigrationStep", where.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_Migration_ID(), "F", "U").count();
        String status = "";
        if (applied == total && applied > 0) {
            this.setStatusCode("A");
            this.setApply("R");
            status = "Applied";
        } else if (unapplied == total && unapplied > 0) {
            this.setStatusCode("U");
            this.setApply("A");
            status = "Unapplied";
        } else if (total > applied && applied > 0) {
            this.setStatusCode("P");
            this.setApply("R");
            status = "Partially Applied";
        }
        this.saveEx();
        this.log.log(Level.CONFIG, this.toString() + " ---> " + status + " (" + this.getStatusCode() + ")");
    }

    private int[] getStepIds(boolean all, boolean rollback) {
        String where = "AD_Migration_ID = " + this.getAD_Migration_ID();
        Object[] parameters = null;
        if (!all) {
            where = where + " AND (StatusCode=? OR StatusCode=?)";
            parameters = new Object[2];
            if (rollback) {
                parameters[0] = "A";
                parameters[1] = "F";
            } else {
                parameters[0] = "U";
                parameters[1] = "F";
            }
        }
        String order = rollback ? "SeqNo DESC" : "SeqNo ASC";
        return MTable.get(this.getCtx(), MMigrationStep.Table_ID).createQuery(where, null).setOnlyActiveRecords(true).setOrderBy(order).setParameters(parameters).getIDs();
    }

    public static List<MMigration> getMigrations(Properties ctx, Boolean processed, String trxName) {
        String where = "Processed = " + (processed != false ? "'Y'" : "'N'");
        return MTable.get(ctx, Table_ID).createQuery(where, trxName).setOnlyActiveRecords(true).list();
    }

    public static MMigration fromXmlNode(Properties ctx, Element element, String trxName) throws SQLException {
        if (!"Migration".equals(element.getLocalName())) {
            return null;
        }
        MColumn col = MColumn.get(ctx, MColumn.getColumn_ID("AD_Migration", "Name"));
        int length = col.getFieldLength();
        String name = element.getAttribute("Name");
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        name = name.trim();
        String seqNo = element.getAttribute("SeqNo").trim();
        String entityType = element.getAttribute("EntityType").trim();
        String releaseNo = element.getAttribute("ReleaseNo").trim();
        String where = "TRIM(both from Name) = ? AND SeqNo = ? AND TRIM(both from EntityType) = ? AND TRIM(both from ReleaseNo) = ?";
        MMigration mmigration = (MMigration)new Query(ctx, "AD_Migration", where, null).setParameters(name, Integer.parseInt(seqNo), entityType, releaseNo).firstOnly();
        if (mmigration != null) {
            return mmigration;
        }
        mmigration = new MMigration(ctx, 0, trxName);
        mmigration.setName(name);
        mmigration.setSeqNo(Integer.parseInt(seqNo));
        mmigration.setEntityType(entityType);
        mmigration.setReleaseNo(releaseNo);
        Element comment = (Element)element.getElementsByTagName("Comments").item(0);
        if (comment != null) {
            mmigration.setComments(comment.getTextContent());
        }
        mmigration.saveEx();
        NodeList children = element.getElementsByTagName("Step");
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Element step = (Element)children.item(i2);
            if ("Step".equals(step.getTagName())) {
                MMigrationStep.fromXmlNode(mmigration, step);
            }
            Trx.get(trxName, false).commit(true);
        }
        return mmigration;
    }

    public Node toXmlNode(Document document) throws ParserConfigurationException, SAXException {
        Element migration = document.createElement("Migration");
        migration.setAttribute("SeqNo", Integer.toString(this.getSeqNo()));
        migration.setAttribute("Name", this.getName());
        migration.setAttribute("EntityType", this.getEntityType());
        migration.setAttribute("ReleaseNo", this.getReleaseNo());
        if (this.getComments() != null) {
            Element comment = document.createElement("Comments");
            migration.appendChild(comment);
            comment.appendChild(document.createTextNode(this.getComments()));
        }
        for (int stepId : this.getStepIds(true, false)) {
            MMigrationStep step = new MMigrationStep(this.getCtx(), stepId, this.get_TrxName());
            this.log.log(Level.FINE, "Exporting step: " + step);
            migration.appendChild(step.toXmlNode(document));
        }
        return migration;
    }

    public void mergeMigration(MMigration from) {
        int lastSeq = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0) FROM AD_MigrationStep WHERE AD_Migration_ID = " + this.getAD_Migration_ID());
        String updateSql = "UPDATE AD_MigrationStep SET AD_Migration_ID = ?, SeqNo = SeqNo + ? WHERE AD_Migration_ID = ? ";
        Object[] params = new Object[]{this.getAD_Migration_ID(), lastSeq, from.getAD_Migration_ID()};
        DB.executeUpdateEx(updateSql, params, this.get_TrxName());
        try {
            DB.commit(false, this.get_TrxName());
            from.deleteEx(false, this.get_TrxName());
        }
        catch (IllegalStateException | SQLException e) {
            this.log.log(Level.SEVERE, "[" + this.get_TrxName() + "]", e);
        }
    }

    @Override
    protected boolean beforeDelete() {
        boolean all = true;
        for (int stepID : this.getStepIds(all, false)) {
            MMigrationStep step = new MMigrationStep(this.getCtx(), stepID, this.get_TrxName());
            step.deleteEx(true);
        }
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() > 0) {
            this.setAD_Client_ID(0);
        }
        if (this.getAD_Org_ID() > 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    public String toString() {
        return "Migration " + this.getSeqNo() + " - " + this.getName() + " - " + this.getReleaseNo() + " (" + this.getEntityType() + ") ";
    }

    public void clean() {
        if (this.getEntityType().equals("D") && this.getStatusCode().equals("A")) {
            this.log.log(Level.CONFIG, "Cleaning migration: " + this.toString());
            this.setProcessed(true);
            boolean all = true;
            for (int stepId : this.getStepIds(all, false)) {
                MMigrationStep step = new MMigrationStep(this.getCtx(), stepId, this.get_TrxName());
                this.log.log(Level.CONFIG, "   Deleting step: " + step.toString());
                step.deleteEx(true);
            }
            this.saveEx();
        }
    }

    public void addColumnToList(int p_AD_Column_ID) {
        this.columnList.add(p_AD_Column_ID);
    }

    public void syncColumn() {
        if (this.columnList.size() == 0) {
            return;
        }
        for (int columnId : this.columnList) {
            MColumn column = new MColumn(this.getCtx(), columnId, this.get_TrxName());
            this.log.log(Level.CONFIG, "Synchronizing column: " + column.toString() + " in table: " + MTable.get(Env.getCtx(), column.getAD_Table_ID()));
            column.syncDatabase();
        }
        this.columnList = new ArrayList();
    }
}

