/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_Locator;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MLocator
extends X_M_Locator {
    private static final long serialVersionUID = 6019655556196171287L;
    private static CCache<Integer, MLocator> s_cache;
    private static CLogger s_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLocator getDefault(Properties ctx, int M_Locator_ID) {
        String trxName = null;
        MLocator retValue = null;
        String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND  IsDefault='Y' AND EXISTS (SELECT * FROM M_Locator lx WHERE l.M_Warehouse_ID=lx.M_Warehouse_ID AND lx.M_Locator_ID=?) ORDER BY Created";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, M_Locator_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                retValue = new MLocator(ctx, rs, trxName);
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLocator getDefault(MWarehouse warehouse) {
        String trxName = null;
        MLocator retValue = null;
        String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND IsDefault='Y' AND l.M_Warehouse_ID=? ORDER BY PriorityNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, warehouse.getM_Warehouse_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                retValue = new MLocator(warehouse.getCtx(), rs, trxName);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLocator get(Properties ctx, int M_Warehouse_ID, String Value2, String X, String Y, String Z) {
        MLocator retValue = null;
        String sql = "SELECT * FROM M_Locator WHERE IsActive = 'Y' AND M_Warehouse_ID=? AND X=? AND Y=? AND Z=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setString(2, X);
            pstmt.setString(3, Y);
            pstmt.setString(4, Z);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MLocator(ctx, rs, null);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, "get", ex);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            MWarehouse wh = MWarehouse.get(ctx, M_Warehouse_ID);
            retValue = new MLocator(wh, Value2);
            retValue.setXYZ(X, Y, Z);
            retValue.saveEx();
        }
        return retValue;
    }

    public static MLocator get(Properties ctx, int M_Locator_ID) {
        Integer key;
        MLocator retValue;
        if (s_cache == null) {
            s_cache = new CCache("M_Locator", 20);
        }
        if ((retValue = s_cache.get(key = new Integer(M_Locator_ID))) != null) {
            return retValue;
        }
        retValue = new MLocator(ctx, M_Locator_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MLocator(Properties ctx, int M_Locator_ID, String trxName) {
        super(ctx, M_Locator_ID, trxName);
        if (M_Locator_ID == 0) {
            this.setIsDefault(false);
            this.setPriorityNo(50);
        }
    }

    public MLocator(MWarehouse warehouse, String Value2) {
        this(warehouse.getCtx(), 0, warehouse.get_TrxName());
        this.setClientOrg(warehouse);
        this.setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
        this.setValue(Value2);
        this.setXYZ("0", "0", "0");
    }

    public MLocator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public void setXYZ(String X, String Y, String Z) {
        this.setX(X);
        this.setY(Y);
        this.setZ(Z);
    }

    public String getWarehouseName() {
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        if (wh.get_ID() == 0) {
            return "<" + this.getM_Warehouse_ID() + ">";
        }
        return wh.getName();
    }

    public boolean isCanStoreProduct(int M_Product_ID) {
        return true;
    }

    static {
        s_log = CLogger.getCLogger(MLocator.class);
    }
}

