/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_GL_JournalBatch;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MJournalBatch
extends X_GL_JournalBatch
implements DocAction {
    public static boolean IsReturnBatch = false;
    private static final long serialVersionUID = -2494833602067696046L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MJournalBatch copyFrom(Properties ctx, int GL_JournalBatch_ID, Timestamp dateDoc, String trxName) {
        MJournalBatch from = new MJournalBatch(ctx, GL_JournalBatch_ID, trxName);
        if (from.getGL_JournalBatch_ID() == 0) {
            throw new IllegalArgumentException("From Journal Batch not found GL_JournalBatch_ID=" + GL_JournalBatch_ID);
        }
        MJournalBatch to = new MJournalBatch(ctx, 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.set_ValueNoCheck("C_Period_ID", null);
        to.setDateAcct(dateDoc);
        to.setDateDoc(dateDoc);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setIsApproved(false);
        to.setProcessed(false);
        to.saveEx();
        if (to.copyDetailsFrom(from) == 0) {
            throw new IllegalStateException("Could not create Journal Batch Details");
        }
        return to;
    }

    public MJournalBatch(Properties ctx, int GL_JournalBatch_ID, String trxName) {
        super(ctx, GL_JournalBatch_ID, trxName);
        if (GL_JournalBatch_ID == 0) {
            this.setPostingType("A");
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setIsApproved(false);
        }
    }

    public MJournalBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalBatch(MJournalBatch original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.set_ValueOfColumn("IsYearEndClosing", original.get_Value("IsYearEndClosing"));
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        if (this.getC_Period_ID() != 0) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), DateAcct, this.getAD_Org_ID());
        if (C_Period_ID == 0) {
            this.log.warning("Period not found");
        } else {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public MJournal[] getJournals(boolean requery) {
        ArrayList<MJournal> list = new ArrayList<MJournal>();
        String sql = "SELECT * FROM GL_Journal WHERE GL_JournalBatch_ID=? ORDER BY DocumentNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getGL_JournalBatch_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MJournal(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        pstmt = null;
        MJournal[] retValue = new MJournal[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyDetailsFrom(MJournalBatch jb) {
        if (this.isProcessed() || jb == null) {
            return 0;
        }
        int count = 0;
        int lineCount = 0;
        MJournal[] fromJournals = jb.getJournals(false);
        for (int i = 0; i < fromJournals.length; ++i) {
            MJournal toJournal = new MJournal(this.getCtx(), 0, jb.get_TrxName());
            PO.copyValues(fromJournals[i], toJournal, this.getAD_Client_ID(), this.getAD_Org_ID());
            toJournal.setGL_JournalBatch_ID(this.getGL_JournalBatch_ID());
            toJournal.set_ValueNoCheck("DocumentNo", null);
            toJournal.set_ValueNoCheck("C_Period_ID", null);
            toJournal.setDateDoc(this.getDateDoc());
            toJournal.setDateAcct(this.getDateAcct());
            toJournal.setDocStatus("DR");
            toJournal.setDocAction("CO");
            toJournal.setTotalCr(Env.ZERO);
            toJournal.setTotalDr(Env.ZERO);
            toJournal.setIsApproved(false);
            toJournal.setIsPrinted(false);
            toJournal.setPosted(false);
            toJournal.setProcessed(false);
            if (!toJournal.save()) continue;
            ++count;
            lineCount += toJournal.copyLinesFrom(fromJournals[i], this.getDateAcct(), 'x');
        }
        if (fromJournals.length != count) {
            this.log.log(Level.SEVERE, "Line difference - Journals=" + fromJournals.length + " <> Saved=" + count);
        }
        return count + lineCount;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        MJournal journal;
        int i;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MJournal[] journals = this.getJournals(false);
        if (journals.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal TotalDr = Env.ZERO;
        BigDecimal TotalCr = Env.ZERO;
        for (i = 0; i < journals.length; ++i) {
            journal = journals[i];
            if (!journal.isActive()) continue;
            if (!("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus()) || "CO".equals(journal.getDocStatus()))) {
                String status = journal.prepareIt();
                if (!"IP".equals(status)) {
                    journal.setDocStatus(status);
                    journal.saveEx();
                    this.m_processMsg = journal.getProcessMsg();
                    return status;
                }
                journal.setDocStatus("IP");
                journal.saveEx();
            }
            TotalDr = TotalDr.add(journal.getTotalDr());
            TotalCr = TotalCr.add(journal.getTotalCr());
        }
        this.setTotalDr(TotalDr);
        this.setTotalCr(TotalCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.m_processMsg = "@ControlAmtError@";
            return "IN";
        }
        for (i = 0; i < journals.length; ++i) {
            journal = journals[i];
            MJournalLine[] lines = journal.getLines(true);
            if (journal.getC_ConversionType_ID() <= 0) continue;
            for (int j = 0; j < lines.length; ++j) {
                MJournalLine line = lines[j];
                line.setC_ConversionType_ID(journal.getC_ConversionType_ID());
                line.saveEx();
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        this.log.info("completeIt - " + this.toString());
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.approveIt();
        MJournal[] journals = this.getJournals(true);
        BigDecimal TotalDr = Env.ZERO;
        BigDecimal TotalCr = Env.ZERO;
        for (int i = 0; i < journals.length; ++i) {
            MJournal journal = journals[i];
            if (!journal.isActive()) {
                journal.setProcessed(true);
                journal.setDocStatus("VO");
                journal.setDocAction("--");
                journal.saveEx();
                continue;
            }
            if (!("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus()) || "CO".equals(journal.getDocStatus()))) {
                journal.processIt("CO");
                journal.saveEx();
                if (!"CO".equals(journal.getDocStatus())) {
                    this.m_processMsg = journal.getProcessMsg();
                    return journal.getDocStatus();
                }
            }
            TotalDr = TotalDr.add(journal.getTotalDr());
            TotalCr = TotalCr.add(journal.getTotalCr());
        }
        this.setTotalDr(TotalDr);
        this.setTotalCr(TotalCr);
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MJournal[] journals = this.getJournals(true);
        for (int i = 0; i < journals.length; ++i) {
            MJournal journal = journals[i];
            if (!journal.isActive() && !journal.isProcessed()) {
                journal.setProcessed(true);
                journal.setDocStatus("VO");
                journal.setDocAction("--");
                journal.saveEx();
                continue;
            }
            if ("DR".equals(journal.getDocStatus()) || "IP".equals(journal.getDocStatus()) || "IN".equals(journal.getDocStatus())) {
                this.m_processMsg = "Journal not Completed: " + journal.getSummary();
                return false;
            }
            if ("CL".equals(journal.getDocStatus()) || "VO".equals(journal.getDocStatus()) || "RE".equals(journal.getDocStatus())) continue;
            if (!journal.closeIt()) {
                this.m_processMsg = "Cannot close: " + journal.getSummary();
                return false;
            }
            journal.saveEx();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean isOk = this.reverseBatch(false);
        if (!isOk) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.m_processMsg == null;
    }

    private boolean reverseBatch(boolean isAccrual) {
        MJournal[] journals;
        for (MJournal journal : journals = this.getJournals(true)) {
            if (!journal.isActive() || "CO".equals(journal.getDocStatus())) continue;
            this.m_processMsg = "All Journals need to be Completed: " + journal.getSummary();
            return false;
        }
        MJournalBatch reverse = new MJournalBatch(this);
        if (isAccrual) {
            reverse.setC_Period_ID(0);
            if (IsReturnBatch) {
                reverse.setDateAcct(TimeUtil.addDays(this.getDateAcct(), 1));
                reverse.setDateDoc(this.getDateDoc());
            } else {
                reverse.setDateAcct(reverse.getDateDoc());
                reverse.setDateDoc(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            reverse.setDateDoc(this.getDateDoc());
            reverse.setC_Period_ID(this.getC_Period_ID());
            reverse.setDateAcct(this.getDateAcct());
        }
        reverse.addDescription("** (->" + this.getDocumentNo() + ") **");
        reverse.setReversal_ID(this.getGL_JournalBatch_ID());
        reverse.setControlAmt(this.getControlAmt().negate());
        reverse.set_ValueNoCheck("DocumentNo", null);
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reverse.setDocumentNo(this.getDocumentNo() + Msg.getMsg(reverse.getCtx(), "^"));
        }
        reverse.saveEx();
        for (int i = 0; i < journals.length; ++i) {
            MJournal journal;
            journal = journals[i];
            if (!journal.isActive()) continue;
            if (isAccrual) {
                if (journal.reverseAccrualIt(reverse.getGL_JournalBatch_ID()) == null) {
                    this.m_processMsg = "Could not reverse " + journal;
                    return false;
                }
            } else if (journal.reverseCorrectIt(reverse.getGL_JournalBatch_ID()) == null) {
                this.m_processMsg = "Could not reverse " + journal;
                return false;
            }
            journal.saveEx();
        }
        reverse.setDocAction("--");
        reverse.setDocStatus("RE");
        reverse.setProcessed(true);
        reverse.saveEx();
        this.addDescription("** (" + reverse.getDocumentNo() + "<-) **");
        this.setReversal_ID(reverse.getGL_JournalBatch_ID());
        this.setDocAction("--");
        this.saveEx();
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean isOk = this.reverseBatch(true);
        if (!isOk) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        for (MJournal journal : this.getJournals(true)) {
            if (!"CO".equals(journal.getDocStatus())) continue;
            if (journal.processIt("RE")) {
                journal.saveEx();
                continue;
            }
            throw new AdempiereException(journal.getProcessMsg());
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate(this.getCtx(), "TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getJournals(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MJournalBatch[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }
}

