/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.FA.exceptions.AssetArrayException;
import org.compiere.FA.exceptions.AssetException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Entry;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class MDepreciationEntry
extends X_A_Depreciation_Entry
implements DocAction {
    private static final long serialVersionUID = 1L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MDepreciationEntry(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            MAcctSchema mAcctSchema = MClient.get(this.getCtx()).getAcctSchema();
            this.setC_AcctSchema_ID(mAcctSchema.get_ID());
            this.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
            this.setA_Entry_Type("DEP");
            this.setPostingType("A");
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
        }
    }

    public MDepreciationEntry(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        this.setC_Period_ID();
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return false;
        }
        if (!this.isProcessed() && (bl || this.is_ValueChanged("DateAcct"))) {
            this.selectLines();
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean bl) {
        if (!bl) {
            return false;
        }
        this.unselectLines();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod mPeriod = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
        if (mPeriod == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(mPeriod.get_ID());
    }

    private void unselectLines() {
        String string = "UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=NULL  WHERE A_Depreciation_Entry_ID=?";
        int n = this.get_ID();
        if (n <= 0) {
            n = this.get_IDOld();
        }
        int n2 = DB.executeUpdateEx(string, new Object[]{n}, this.get_TrxName());
        this.log.fine("Updated #" + n2);
    }

    private void selectLines() {
        this.unselectLines();
        Timestamp timestamp = TimeUtil.trunc(this.getDateAcct(), "MM");
        int n = DB.executeUpdateEx("UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=? WHERE A_Depreciation_Entry_ID IS NULL AND TRUNC(DateAcct,'MONTH') = ? AND AD_Client_ID=? AND AD_Org_ID=?", new Object[]{this.get_ID(), timestamp, this.getAD_Client_ID(), this.getAD_Org_ID()}, this.get_TrxName());
        this.log.fine("Updated #" + n);
    }

    public Iterator<MDepreciationExp> getLinesIterator(boolean bl) {
        String string = this.get_TrxName();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = "A_Depreciation_Entry_ID=?";
        arrayList.add(this.get_ID());
        if (bl) {
            string2 = string2 + " AND Processed=?";
            arrayList.add(false);
        }
        String string3 = "A_Asset_ID,PostingType,A_Period,A_Entry_Type";
        Iterator<MDepreciationExp> iterator = new Query(this.getCtx(), "A_Depreciation_Exp", string2, string).setOrderBy(string3).setParameters(arrayList).iterate();
        return iterator;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        this.m_justPrepared = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setDocAction("CO");
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        object = MPeriod.get(this.getCtx(), this.getC_Period_ID());
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        final Iterator<MDepreciationExp> iterator = this.getLinesIterator(true);
        while (iterator.hasNext()) {
            try {
                Trx.run(this.get_TrxName(), new TrxRunnable((MPeriod)object){
                    final /* synthetic */ MPeriod val$period;
                    {
                        this.val$period = mPeriod;
                    }

                    @Override
                    public void run(String string) {
                        MDepreciationExp mDepreciationExp = (MDepreciationExp)iterator.next();
                        if (!this.val$period.isInPeriod(mDepreciationExp.getDateAcct())) {
                            throw new AssetException("The date is not within this Period (" + mDepreciationExp + ", Data=" + mDepreciationExp.getDateAcct() + ", Period=" + this.val$period.getName() + ")");
                        }
                        mDepreciationExp.process();
                    }
                });
            }
            catch (Exception exception) {
                this.log.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                arrayList.add(exception);
            }
        }
        if (arrayList.size() > 0) {
            throw new AssetArrayException(arrayList);
        }
        String string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        return this.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public static void deleteFacts(MDepreciationExp mDepreciationExp) {
        Object[] objectArray = new Object[]{Table_ID, mDepreciationExp.getA_Depreciation_Entry_ID(), mDepreciationExp.get_ID()};
        DB.executeUpdateEx("DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?", objectArray, mDepreciationExp.get_TrxName());
    }
}

