/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostElement;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCostElement
extends X_M_CostElement {
    private static final long serialVersionUID = 3196322266971717530L;
    private static CCache<Integer, MCostElement> s_cache = new CCache("M_CostElement", 20);
    private static CLogger s_log = CLogger.getCLogger(MCostElement.class);

    public static List<MCostElement> getDefaultElements(PO po) {
        String whereClause = "IsDefault=?";
        List<MCostElement> elements = new Query(po.getCtx(), "M_CostElement", "IsDefault=?", po.get_TrxName()).setParameters(true).setClient_ID().setOnlyActiveRecords(true).setOrderBy("AD_Org_ID DESC").list();
        if (elements != null && elements.size() > 0) {
            return elements;
        }
        MCostElement costElement = MCostElement.getByMaterialCostElementType(po);
        if (costElement != null) {
            if (!costElement.isActive()) {
                costElement.setIsActive(true);
                costElement.saveEx();
            }
        } else {
            costElement = new MCostElement(po.getCtx(), 0, po.get_TrxName());
            costElement.setClientOrg(po.getAD_Client_ID(), 0);
            costElement.setName("Material");
            costElement.setIsDefault(true);
            costElement.setIsActive(true);
            costElement.setCostElementType("M");
            costElement.saveEx();
        }
        elements = new ArrayList<MCostElement>();
        elements.add(costElement);
        return elements;
    }

    public static MCostElement getByMaterialCostElementType(PO po) {
        String whereClause = "CostElementType=?";
        MCostElement retValue = (MCostElement)new Query(po.getCtx(), "M_CostElement", "CostElementType=?", po.get_TrxName()).setParameters("M").setClient_ID().setOrderBy("M_CostElement_ID ,IsDefault, AD_Org_ID DESC").first();
        return retValue;
    }

    public static List<MCostElement> getCostElement(Properties ctx, String trxName) {
        return new Query(ctx, "M_CostElement", null, trxName).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Created").list();
    }

    public static MCostElement getMaterialCostElement(PO po) {
        MCostElement costElement = MCostElement.getByMaterialCostElementType(po);
        if (costElement != null) {
            return costElement;
        }
        costElement = new MCostElement(po.getCtx(), 0, po.get_TrxName());
        costElement.setClientOrg(po.getAD_Client_ID(), 0);
        String name = MRefList.getListName(po.getCtx(), 338, "M");
        if (name == null || name.length() == 0) {
            name = "M";
        }
        costElement.setName(name);
        costElement.setCostElementType("M");
        costElement.saveEx();
        return costElement;
    }

    public static MCostElement get(Properties ctx, int M_CostElement_ID) {
        Integer key = new Integer(M_CostElement_ID);
        MCostElement retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(ctx, M_CostElement_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    @Deprecated
    public static MCostElement[] getElements(Properties ctx, String trxName) {
        int AD_Org_ID = 0;
        String whereClause = "AD_Client_ID = ? AND AD_Org_ID=?";
        List<MCostElement> list = new Query(ctx, "M_CostElement", "AD_Client_ID = ? AND AD_Org_ID=?", trxName).setParameters(Env.getAD_Client_ID(ctx), AD_Org_ID).list();
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MCostElement(Properties ctx, int M_CostElement_ID, String trxName) {
        super(ctx, M_CostElement_ID, trxName);
        if (M_CostElement_ID == 0) {
            this.setCostElementType("M");
            this.setIsCalculated(false);
        }
    }

    public MCostElement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (("M".equals(this.getCostElementType()) || "X".equals(this.getCostElementType())) && (newRecord || this.is_ValueChanged("CostingMethod"))) {
            String sql = "SELECT  COALESCE(MAX(M_CostElement_ID),0) FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=? AND CostElementType=?";
            int id = DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID(), this.getCostingMethod(), this.getCostElementType());
            if (id > 0 && id != this.get_ID()) {
                this.log.saveError("AlreadyExists", Msg.getElement(this.getCtx(), "CostingMethod"));
                return false;
            }
        }
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String cm = this.getCostingMethod();
        if (cm == null || !"M".equals(this.getCostElementType())) {
            return true;
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int i2 = 0; i2 < ass.length; ++i2) {
            if (!ass[i2].getCostingMethod().equals(this.getCostingMethod())) continue;
            this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "C_AcctSchema_ID") + " - " + ass[i2].getName());
            return false;
        }
        int M_Product_Category_ID = 0;
        String whereClause = "CostingMethod=?";
        MProductCategoryAcct retValue = (MProductCategoryAcct)new Query(this.getCtx(), "M_Product_Category_Acct", "CostingMethod=?", null).setParameters(this.getCostingMethod()).setClient_ID().first();
        if (retValue != null) {
            M_Product_Category_ID = retValue.getM_Product_Category_ID();
        }
        if (M_Product_Category_ID != 0) {
            this.log.saveError("CannotDeleteUsed", Msg.getElement(this.getCtx(), "M_Product_Category_ID") + " (ID=" + M_Product_Category_ID + ")");
            return false;
        }
        return true;
    }

    public boolean isCostingMethod() {
        return "M".equals(this.getCostElementType()) && this.getCostingMethod() != null;
    }

    public boolean isAverageInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("I") && "M".equals(this.getCostElementType());
    }

    public boolean isAveragePO() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("A") && "M".equals(this.getCostElementType());
    }

    public boolean isFifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("F") && "M".equals(this.getCostElementType());
    }

    public boolean isLastInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("i") && "M".equals(this.getCostElementType());
    }

    public boolean isLastPOPrice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("p") && "M".equals(this.getCostElementType());
    }

    public boolean isLifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("L") && "M".equals(this.getCostElementType());
    }

    public boolean isStandardCosting() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("S") && "M".equals(this.getCostElementType());
    }

    public boolean isUserDefined() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("U") && "M".equals(this.getCostElementType());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCostElement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getCostElementType()).append(",Method=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }
}

