/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.IDocumentLine;
import org.compiere.acct.DocLine;
import org.compiere.model.I_M_CostType;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostDetail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPCostCollector;

public class MCostDetail
extends X_M_CostDetail {
    private static final long serialVersionUID = -7882724307127281675L;
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);

    public static BigDecimal getCostByModel(int accountSchemaId, int costTypeId, int costElementId, IDocumentLine model) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? AND ");
        whereClause.append(CostEngine.getIDColumnName(model)).append("=? ");
        return new Query(model.getCtx(), "M_CostDetail", whereClause.toString(), model.get_TrxName()).setClient_ID().setParameters(accountSchemaId, costTypeId, costElementId, model.get_ID()).sum("(Amt+AmtLL)");
    }

    public static BigDecimal getQtyOnHandByASIAndSeqNo(Properties context, int productId, int costTypeId, int costElementId, int attributeSetInstanceId, int seqNo, String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=? AND ");
        parameters.add(productId);
        whereClause.append("M_CostType_ID").append("=? AND ");
        parameters.add(costTypeId);
        whereClause.append("M_CostElement_ID").append("=? AND ");
        parameters.add(costElementId);
        whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
        parameters.add(attributeSetInstanceId);
        whereClause.append("SeqNo").append("<=?");
        parameters.add(seqNo);
        return new Query(context, "M_CostDetail", whereClause.toString(), trxName).setParameters(parameters).sum("Qty");
    }

    public static List<MCostDetail> getByTransaction(MTransaction transaction, int accountSchemaId, int costTypeId, int costElementId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? AND ");
        whereClause.append("M_Transaction_ID").append("=?");
        return new Query(transaction.getCtx(), "M_CostDetail", whereClause.toString(), transaction.get_TrxName()).setParameters(accountSchemaId, costTypeId, costElementId, transaction.getM_Transaction_ID()).setOrderBy("SeqNo").list();
    }

    public static MCostDetail getCostDetail(MPPCostCollector cc, int M_CostElement_ID) {
        String whereClause = "PP_Cost_Collector_ID=? AND M_CostElement_ID=?";
        MCostDetail cd = (MCostDetail)new Query(cc.getCtx(), "M_CostDetail", "PP_Cost_Collector_ID=? AND M_CostElement_ID=?", cc.get_TrxName()).setClient_ID().setParameters(cc.getPP_Cost_Collector_ID(), M_CostElement_ID).firstOnly();
        return cd;
    }

    public static boolean existsCost(MCostDetail cost) {
        return cost.getCostAmt().add(cost.getCostAdjustment()).add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL()).signum() != 0;
    }

    public static BigDecimal getTotalCost(MCostDetail costDetail, MAcctSchema acctSchema) {
        return costDetail.getCostAmt().add(costDetail.getCostAdjustment()).add(costDetail.getCostAmtLL()).add(costDetail.getCostAdjustmentLL()).setScale(acctSchema.getCostingPrecision(), 4);
    }

    public static List<MCostDetail> getByCollectorCost(MPPCostCollector costCollector) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("PP_Cost_Collector_ID").append("=? ");
        return new Query(costCollector.getCtx(), "M_CostDetail", whereClause.toString(), costCollector.get_TrxName()).setClient_ID().setParameters(costCollector.getPP_Cost_Collector_ID()).list();
    }

    public static MCostDetail getLastTransaction(IDocumentLine model, MTransaction transaction, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, Timestamp dateAcct, String costingLevel) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        if (model instanceof MLandedCostAllocation || model instanceof MMatchInv) {
            if (model.getReversalLine_ID() != 0) {
                if (model.getDateAcct().compareTo(transaction.getDocumentLine().getDateAcct()) == 0) {
                    whereClause.append("M_Transaction_ID=? AND ");
                    params.add(transaction.getM_Transaction_ID());
                } else {
                    whereClause.append("DateAcct <= " + DB.TO_DATE(dateAcct) + " AND ");
                }
            } else {
                Timestamp dateacct = transaction.getDocumentLine().getDateAcct();
                MDocType dt = new MDocType(transaction.getCtx(), transaction.getDocumentLine().getC_DocType_ID(), transaction.get_TrxName());
                if (MPeriod.isOpen(transaction.getCtx(), dateacct, dt.getDocBaseType(), transaction.getAD_Org_ID())) {
                    whereClause.append("M_Transaction_ID=? AND ");
                    params.add(transaction.getM_Transaction_ID());
                } else {
                    whereClause.append("DateAcct <= " + DB.TO_DATE(dateAcct) + " AND ");
                }
                if (model instanceof MMatchInv) {
                    whereClause.append(" (M_MatchInv_ID <>? OR M_MatchInv_ID is null) AND ");
                    params.add(model.get_ID());
                }
            }
        } else {
            whereClause.append("DateAcct <= " + DB.TO_DATE(dateAcct) + " AND ");
        }
        orderBy.append("SeqNo").append(" DESC");
        whereClause.append("AD_Client_ID=? AND ");
        params.add(transaction.getAD_Client_ID());
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID=? AND ");
            params.add(transaction.getAD_Org_ID());
        }
        if ("W".equals(costingLevel)) {
            whereClause.append("M_Warehouse_ID=? AND ");
            params.add(transaction.getM_Warehouse_ID());
        }
        whereClause.append("C_AcctSchema_ID=? AND ");
        params.add(C_AcctSchema_ID);
        whereClause.append("M_Product_ID=? AND ");
        params.add(transaction.getM_Product_ID());
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID=? AND ");
            params.add(transaction.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostElement_ID=? AND ");
        params.add(M_CostElement_ID);
        whereClause.append("M_CostType_ID=? AND ");
        params.add(M_CostType_ID);
        whereClause.append("Processing = ? ");
        params.add(false);
        return (MCostDetail)new Query(transaction.getCtx(), "M_CostDetail", whereClause.toString(), transaction.get_TrxName()).setParameters(params).setOrderBy(orderBy.toString()).first();
    }

    public static MCostDetail getLastTransaction(MTransaction mtrx, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, String costingLevel) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND ");
        params.add(mtrx.getAD_Client_ID());
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID").append("=? AND ");
            params.add(mtrx.getAD_Org_ID());
        }
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        params.add(C_AcctSchema_ID);
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(mtrx.getM_Product_ID());
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
            params.add(mtrx.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(M_CostElement_ID);
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(M_CostType_ID);
        whereClause.append("M_Transaction_ID").append("<?  ");
        params.add(mtrx.getM_Transaction_ID());
        return (MCostDetail)new Query(mtrx.getCtx(), "M_CostDetail", whereClause.toString(), mtrx.get_TrxName()).setParameters(params).setOrderBy("SeqNo DESC").first();
    }

    public static boolean isEarlierTransaction(MCostDetail cd, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, String costingLevel) {
        MTransaction trx = new MTransaction(cd.getCtx(), cd.getM_Transaction_ID(), cd.get_TrxName());
        MCostDetail last_cd = MCostDetail.getLastTransaction(trx, C_AcctSchema_ID, M_CostType_ID, M_CostElement_ID, costingLevel);
        if (last_cd == null) {
            return false;
        }
        return cd.getSeqNo() <= last_cd.getSeqNo() && cd.getM_Transaction_ID() != last_cd.getM_Transaction_ID();
    }

    public static MCostDetail getByTransaction(IDocumentLine model, MTransaction mtrx, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND ");
        params.add(mtrx.getAD_Client_ID());
        whereClause.append("AD_Org_ID").append("=? AND ");
        params.add(mtrx.getAD_Org_ID());
        whereClause.append("M_Warehouse_ID").append("=? AND ");
        params.add(mtrx.getM_Warehouse_ID());
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        params.add(C_AcctSchema_ID);
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(mtrx.getM_Product_ID());
        if (mtrx.getM_AttributeSetInstance_ID() > 0) {
            whereClause.append("M_AttributeSetInstance_ID").append("=?  AND ");
            params.add(mtrx.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(M_CostElement_ID);
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(M_CostType_ID);
        whereClause.append("M_Transaction_ID").append("=? ");
        params.add(mtrx.getM_Transaction_ID());
        if (model instanceof MMatchPO) {
            MMatchPO matchInv = (MMatchPO)model;
            whereClause.append(" AND ").append("C_OrderLine_ID").append("=? ");
            params.add(matchInv.getC_OrderLine_ID());
        } else if (model instanceof MMatchInv) {
            MMatchInv matchInv = (MMatchInv)model;
            whereClause.append(" AND ").append("C_InvoiceLine_ID").append("=? AND ");
            params.add(matchInv.getC_InvoiceLine_ID());
            whereClause.append("Qty").append("=0 ");
        } else if (model instanceof MLandedCostAllocation) {
            whereClause.append(" AND ").append("C_LandedCostAllocation_ID").append("=? ");
            params.add(model.get_ID());
        } else {
            whereClause.append(" AND ").append(model.get_TableName()).append("_ID=? AND ");
            params.add(model.get_ID());
            whereClause.append("Qty").append("<>0 ");
        }
        return (MCostDetail)new Query(mtrx.getCtx(), "M_CostDetail", whereClause.toString(), mtrx.get_TrxName()).setParameters(params).setOrderBy("SeqNo DESC").first();
    }

    public static List<MCostDetail> getByDocLine(DocLine docLine, int accountSchemaId, int costTypeId, boolean isExcludeLandedCost) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Client_ID").append("=? AND ");
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        if (isExcludeLandedCost) {
            whereClause.append("C_LandedCostAllocation_ID").append(" IS NULL AND ");
        }
        whereClause.append(docLine.getTableName()).append("_ID=?");
        return new Query(docLine.getCtx(), "M_CostDetail", whereClause.toString(), docLine.getTrxName()).setParameters(docLine.getAD_Client_ID(), accountSchemaId, docLine.getM_Product_ID(), costTypeId, docLine.get_ID()).list();
    }

    public static List<MCostDetail> getAfterDate(MCostDetail costDetail, String costingLevel) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("C_AcctSchema_ID=? AND ");
        params.add(costDetail.getC_AcctSchema_ID());
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(costDetail.getM_Product_ID());
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID").append("=? AND ");
            params.add(costDetail.getAD_Org_ID());
        }
        if ("W".equals(costingLevel)) {
            whereClause.append("M_Warehouse_ID").append("=? AND ");
            params.add(costDetail.getM_Warehouse_ID());
        }
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
            params.add(costDetail.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(costDetail.getM_CostType_ID());
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(costDetail.getM_CostElement_ID());
        whereClause.append("M_CostDetail_ID").append("<>? AND ");
        params.add(costDetail.getM_CostDetail_ID());
        whereClause.append("M_Transaction_ID").append("<>? AND ");
        params.add(costDetail.getM_Transaction_ID());
        whereClause.append("SeqNo").append(">=? AND ");
        params.add(costDetail.getSeqNo());
        whereClause.append("Processing").append("=? ");
        params.add(false);
        List<MCostDetail> afterDateTransactions = new Query(costDetail.getCtx(), "M_CostDetail", whereClause.toString(), costDetail.get_TrxName()).setClient_ID().setParameters(params).setOrderBy("SeqNo ASC").list();
        return afterDateTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        MCostDetail retValue;
        block6: {
            int C_AcctSchema_ID;
            String sql = "SELECT * FROM M_CostDetail WHERE " + whereClause;
            MClientInfo clientInfo = MClientInfo.get(ctx);
            MAcctSchema primary = clientInfo.getMAcctSchema1();
            int n = C_AcctSchema_ID = primary != null ? primary.getC_AcctSchema_ID() : 0;
            if (C_AcctSchema_ID > 0) {
                sql = sql + " AND C_AcctSchema_ID=?";
            }
            retValue = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, ID);
                pstmt.setInt(2, M_AttributeSetInstance_ID);
                if (C_AcctSchema_ID > 0) {
                    pstmt.setInt(3, C_AcctSchema_ID);
                }
                if (!(rs = pstmt.executeQuery()).next()) break block6;
                retValue = new MCostDetail(ctx, rs, trxName);
            }
            catch (Exception e) {
                try {
                    s_log.log(Level.SEVERE, sql + " - " + ID, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return retValue;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        String localWhereClause = whereClause + " AND M_AttributeSetInstance_ID=? AND C_AcctSchema_ID=?";
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(ID, M_AttributeSetInstance_ID, C_AcctSchema_ID).first();
        return retValue;
    }

    public MCostDetail(Properties ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setProcessed(false);
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setIsSOTrx(false);
            this.setDeltaAmt(Env.ZERO);
            this.setDeltaQty(Env.ZERO);
        }
    }

    public MCostDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName, int M_CostType_ID) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setM_CostType_ID(M_CostType_ID);
        MCostType ct = new MCostType(as.getCtx(), M_CostType_ID, trxName);
        this.setCostingMethod(ct.getCostingMethod());
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    public MCostDetail(MTransaction transaction, int acctSchemaId, int costTypeId, int costElementId, BigDecimal amt, BigDecimal amtLL, BigDecimal qty, String trxName) {
        this(transaction.getCtx(), 0, trxName);
        this.setAD_Client_ID(transaction.getAD_Client_ID());
        this.setAD_Org_ID(transaction.getAD_Org_ID());
        this.setM_Warehouse_ID(transaction.getM_Warehouse_ID());
        this.setC_AcctSchema_ID(acctSchemaId);
        this.setM_Product_ID(transaction.getM_Product_ID());
        this.setM_CostType_ID(costTypeId);
        this.setM_CostElement_ID(costElementId);
        this.setM_AttributeSetInstance_ID(transaction.getM_AttributeSetInstance_ID());
        MCostType ct = new MCostType(transaction.getCtx(), costTypeId, transaction.get_TrxName());
        this.setCostingMethod(ct.getCostingMethod());
        this.setAmt(amt);
        this.setAmtLL(amtLL);
        this.setQty(qty);
        this.setCostAmt(BigDecimal.ZERO);
        this.setCostAmtLL(BigDecimal.ZERO);
        this.setCostAdjustment(Env.ZERO);
        this.setCostAdjustmentLL(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
        this.setCumulatedAmt(Env.ZERO);
        this.setCumulatedAmtLL(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
        this.setCurrentCostPrice(Env.ZERO);
        this.setCurrentCostPriceLL(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    @Override
    public void setAmt(BigDecimal Amt) {
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    @Override
    public void setQty(BigDecimal Qty) {
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCostDetail[");
        sb.append(this.get_ID());
        sb.append(",SeqNo=").append(this.getSeqNo());
        sb.append(",AD_Org_ID=").append(this.getAD_Org_ID());
        sb.append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID());
        sb.append(",M_CostType_ID=").append(this.getM_CostType_ID());
        sb.append(",M_CostElement_ID=").append(this.getM_CostElement_ID());
        sb.append(",M_Transaction_ID=").append(this.getM_Transaction_ID());
        sb.append(",DateAcct=").append(this.getDateAcct());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        if (this.getC_LandedCostAllocation_ID() != 0) {
            sb.append(",C_LandedCostAllocation_ID=").append(this.getC_LandedCostAllocation_ID());
        }
        sb.append(",Cost =").append(this.getAmt());
        sb.append(",Cost Amt=").append(this.getCostAmt());
        sb.append(",Qty=").append(this.getQty());
        sb.append(",CumulatedQty =").append(this.getCumulatedQty());
        sb.append(",Qty Onhand =").append(this.getQty().add(this.getCumulatedQty()));
        sb.append(",Current Qty =").append(this.getCurrentQty());
        sb.append(",Cumulated Amt =").append(this.getCumulatedAmt());
        sb.append(",Cumulated Amt LL =").append(this.getCumulatedAmtLL());
        sb.append(",Current Price =").append(this.getCurrentCostPrice());
        sb.append(",Current Proce TL =").append(this.getCurrentCostPriceLL());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean process(MAcctSchema as, MProduct product, MCostElement costElement, int OrgId, int warehouseId, int attributeSetInstanceId) {
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            boolean ok = false;
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            int organizationId = this.getAD_Org_ID();
            int warehouseId = this.getM_Warehouse_ID();
            int attributeSetInstanceId = this.getM_AttributeSetInstance_ID();
            if ("C".equals(CostingLevel)) {
                organizationId = 0;
                warehouseId = 0;
                attributeSetInstanceId = 0;
            } else if ("O".equals(CostingLevel)) {
                warehouseId = 0;
                attributeSetInstanceId = 0;
            } else if ("B".equals(CostingLevel)) {
                warehouseId = 0;
                organizationId = 0;
            }
            if (this.getM_CostElement_ID() == 0) {
                MCostElement costElement;
                Iterator<MCostElement> iterator = MCostElement.getCostElement(this.getCtx(), this.get_TrxName()).iterator();
                while (iterator.hasNext() && (ok = this.process(as, product, costElement = iterator.next(), organizationId, warehouseId, attributeSetInstanceId))) {
                }
            } else {
                MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
                ok = this.process(as, product, ce, organizationId, warehouseId, attributeSetInstanceId);
            }
            return ok;
        }
        return super.afterDelete(success);
    }

    private void setDateAcct(boolean force) {
        Timestamp dateAcct = this.getDateAcct();
        if (dateAcct != null && !force) {
            return;
        }
        String sql = null;
        int param1 = -1;
        if (this.getC_InvoiceLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE il.C_InvoiceLine_ID=?";
            param1 = this.getC_InvoiceLine_ID();
        } else if (this.getM_InOutLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM M_InOutLine il INNER JOIN M_InOut i ON (i.M_InOut_ID = il.M_InOut_ID) WHERE il.M_InOutLine_ID=?";
            param1 = this.getM_InOutLine_ID();
        } else if (this.getC_OrderLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_OrderLine il INNER JOIN C_Order i ON (i.C_Order_ID = il.C_Order_ID) WHERE il.C_OrderLine_ID=?";
            param1 = this.getC_OrderLine_ID();
        } else if (this.getM_InventoryLine_ID() > 0) {
            sql = "SELECT i.MovementDate FROM M_InventoryLine il INNER JOIN M_Inventory i ON (i.M_Inventory_ID = il.M_Inventory_ID) WHERE il.M_InventoryLine_ID=?";
            param1 = this.getM_InventoryLine_ID();
        } else if (this.getM_MovementLine_ID() > 0) {
            sql = "SELECT i.MovementDate FROM M_MovementLine il INNER JOIN M_Movement i ON (i.M_Movement_ID = il.M_Movement_ID) WHERE il.M_MovementLine_ID=?";
            param1 = this.getM_MovementLine_ID();
        } else if (this.getC_LandedCostAllocation_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_Invoice i INNER JOIN C_InvoiceLine il ON (i.C_Invoice_ID=il.C_Invoice_ID) INNER JOIN C_LandedCostAllocation la ON (il.C_InvoiceLine_ID=la.C_InvoiceLine_ID) WHERE la.C_LandedCostAllocation_ID=?";
            param1 = this.getC_LandedCostAllocation_ID();
        }
        dateAcct = DB.getSQLValueTSEx(this.get_TrxName(), sql, param1);
        this.setDateAcct(dateAcct);
    }

    private void rePosted() {
        if (this.getC_InvoiceLine_ID() > 0) {
            int id = DB.getSQLValue(this.get_TrxName(), "SELECT M_MatchInv_ID FROM M_MatchInv WHERE C_InvoiceLine_ID=?", this.getC_InvoiceLine_ID());
            if (id > 0) {
                DB.executeUpdate("UPDATE M_MatchInv SET Posted='N', Processing='N', ProcessedOn=null WHERE M_MatchInv_ID=? AND Processed='Y'", id, this.get_TrxName());
                MFactAcct.deleteEx(MMatchInv.Table_ID, id, this.get_TrxName());
            }
        } else if (this.getM_InOutLine_ID() > 0) {
            int id = DB.getSQLValue(this.get_TrxName(), "SELECT M_InOut_ID FROM M_InOutLine WHERE M_InOutLine_ID=? ", this.getM_InOutLine_ID());
            if (id > 0) {
                DB.executeUpdate("UPDATE M_InOut SET Posted='N', Processing='N', ProcessedOn=null WHERE M_InOut_ID=? AND Processed='Y'", id, this.get_TrxName());
                MFactAcct.deleteEx(MInOut.Table_ID, id, this.get_TrxName());
            }
        } else if (this.getC_OrderLine_ID() > 0) {
            int id = DB.getSQLValue(this.get_TrxName(), "SELECT M_MatchPO_ID FROM M_MatchPO WHERE C_OrderLine_ID=?", this.getC_OrderLine_ID());
            if (id > 0) {
                DB.executeUpdate("UPDATE M_MatchPO SET Posted='N', Processing='N', ProcessedOn=null WHERE M_MatchPO_ID=? AND Processed='Y'", id, this.get_TrxName());
                MFactAcct.deleteEx(MMatchPO.Table_ID, id, this.get_TrxName());
            }
        } else if (this.getM_InventoryLine_ID() > 0) {
            int id = DB.getSQLValue(this.get_TrxName(), "SELECT M_Inventory_ID FROM M_InventoryLine WHERE M_InventoryLine_ID=?", this.getM_InventoryLine_ID());
            if (id > 0) {
                DB.executeUpdate("UPDATE M_Inventory SET Posted='N', Processing='N', ProcessedOn=null WHERE M_Inventory_ID=? AND Processed='Y'", id, this.get_TrxName());
                MFactAcct.deleteEx(MInventory.Table_ID, id, this.get_TrxName());
            }
        } else if (this.getM_MovementLine_ID() > 0) {
            int id = DB.getSQLValue(this.get_TrxName(), "SELECT M_Movement_ID FROM M_MovementLine WHERE M_MovementLine_ID=?", this.getM_MovementLine_ID());
            if (id > 0) {
                DB.executeUpdate("UPDATE M_Movement SET Posted='N', Processing='N', ProcessedOn=null WHERE M_Movement_ID=? AND Processed='Y'", id, this.get_TrxName());
                MFactAcct.deleteEx(MMovement.Table_ID, id, this.get_TrxName());
            }
        } else if (this.getC_LandedCostAllocation_ID() > 0) {
            // empty if block
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setDateAcct(false);
        return true;
    }

    @Override
    public I_M_CostType getM_CostType() throws RuntimeException {
        return super.getM_CostType();
    }

    @Override
    public int getM_Warehouse_ID() {
        String whereClause = "SELECT l.M_Warehouse_ID FROM M_CostDetail cd INNER JOIN  M_Transaction t ON (cd.M_Transaction_ID=t.M_Transaction_ID) INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE cd.M_CostDetail_ID=? ";
        return DB.getSQLValue(this.get_TrxName(), "SELECT l.M_Warehouse_ID FROM M_CostDetail cd INNER JOIN  M_Transaction t ON (cd.M_Transaction_ID=t.M_Transaction_ID) INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE cd.M_CostDetail_ID=? ", this.getM_CostDetail_ID());
    }

    public static BigDecimal getByDocLineLandedCost(MLandedCostAllocation landedCostAllocation, int acctSchemaId, int costTypeId) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID").append("=? AND ").append("C_AcctSchema_ID").append("=? AND ").append("M_Product_ID").append("=? AND ").append("M_AttributeSetInstance_ID").append("=? AND ").append("M_CostType_ID").append("=? AND ").append("M_CostElement_ID").append("=? AND ").append("C_InvoiceLine_ID").append("=? AND ").append("M_InOutLine_ID").append("=? AND ").append("C_LandedCostAllocation_ID").append("=? ");
        return new Query(landedCostAllocation.getCtx(), "M_CostDetail", whereClause.toString(), landedCostAllocation.get_TrxName()).setParameters(landedCostAllocation.getAD_Client_ID(), acctSchemaId, landedCostAllocation.getM_Product_ID(), landedCostAllocation.getM_AttributeSetInstance_ID(), costTypeId, landedCostAllocation.getM_CostElement_ID(), landedCostAllocation.getC_InvoiceLine_ID(), landedCostAllocation.getM_InOutLine_ID(), landedCostAllocation.getC_LandedCostAllocation_ID()).aggregate("CostAmt + CostAdjustment + CostAmtLL + CostAdjustmentLL", "SUM");
    }

    public static BigDecimal getByDocLineMatchInv(MInvoiceLine invoiceLine, MInOutLine inOutLine, int acctSchemaId, int costTypeId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Client_ID").append("=? AND ").append("C_AcctSchema_ID").append("=? AND ").append("M_Product_ID").append("=? AND ").append("M_AttributeSetInstance_ID=? AND ").append("M_CostType_ID").append("=? AND ").append("C_InvoiceLine_ID").append("=? AND ").append("M_InOutLine_ID").append("=?");
        return new Query(invoiceLine.getCtx(), "M_CostDetail", whereClause.toString(), invoiceLine.get_TrxName()).setParameters(invoiceLine.getAD_Client_ID(), acctSchemaId, invoiceLine.getM_Product_ID(), invoiceLine.getM_AttributeSetInstance_ID(), costTypeId, invoiceLine.getC_InvoiceLine_ID(), inOutLine.getM_InOutLine_ID()).aggregate("CostAdjustment + CostAdjustmentLL", "SUM");
    }
}

