/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.X_C_CommissionDetail;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCommissionDetail
extends X_C_CommissionDetail {
    private static final long serialVersionUID = 1727857992121809494L;
    private MCommissionAmt parent = null;

    public MCommissionDetail(Properties ctx, int C_CommissionDetail_ID, String trxName) {
        super(ctx, C_CommissionDetail_ID, trxName);
        if (C_CommissionDetail_ID == -1) {
            C_CommissionDetail_ID = 0;
        }
        if (C_CommissionDetail_ID == 0) {
            this.setActualAmt(Env.ZERO);
            this.setActualQty(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
        this.log.fine(this.toString());
    }

    public MCommissionDetail(MCommissionAmt amt, int C_Currency_ID, BigDecimal Amt, BigDecimal Qty) {
        super(amt.getCtx(), 0, amt.get_TrxName());
        this.setClientOrg(amt);
        this.setC_CommissionAmt_ID(amt.getC_CommissionAmt_ID());
        this.setC_Currency_ID(C_Currency_ID);
        this.setActualAmt(Amt);
        this.setActualQty(Qty);
        this.setConvertedAmt(Env.ZERO);
        this.parent = amt;
    }

    public MCommissionDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setLineIDs(int C_OrderLine_ID, int C_InvoiceLine_ID) {
        if (C_OrderLine_ID != 0) {
            this.setC_OrderLine_ID(C_OrderLine_ID);
        }
        if (C_InvoiceLine_ID != 0) {
            this.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        }
    }

    public void setConvertedAmt(Timestamp date) {
        BigDecimal amt = MConversionRate.convertBase(this.getCtx(), this.getActualAmt(), this.getC_Currency_ID(), date, 0, this.getAD_Client_ID(), this.getAD_Org_ID());
        if (amt != null) {
            this.setConvertedAmt(amt);
        }
    }

    public void calculateCommission() {
        this.getParent();
        if (this.parent.getC_CommissionAmt_ID() <= 0 || this.parent.getC_CommissionLine_ID() <= 0) {
            return;
        }
        int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), MClient.get(this.getCtx()).getC_Currency_ID());
        MCommissionLine commissionLine = new MCommissionLine(this.getCtx(), this.parent.getC_CommissionLine_ID(), this.get_TrxName());
        BigDecimal convertedAmt = this.getConvertedAmt();
        BigDecimal commissionAmt = this.getConvertedAmt();
        BigDecimal actualQty = this.getActualQty();
        if (convertedAmt == null) {
            convertedAmt = Env.ZERO;
        }
        actualQty = actualQty.subtract(commissionLine.getQtySubtract());
        if (commissionLine.isPositiveOnly() && actualQty.signum() < 0) {
            actualQty = Env.ZERO;
        }
        actualQty = actualQty.multiply(commissionLine.getQtyMultiplier());
        commissionAmt = convertedAmt.subtract(commissionLine.getAmtSubtract());
        if (commissionLine.isPositiveOnly() && commissionAmt.signum() < 0) {
            commissionAmt = Env.ZERO;
        }
        if (this.parent.getMaxPercentage() != null && !this.parent.getMaxPercentage().equals(Env.ZERO) && this.parent.getPercentage() != null && this.parent.getPercentage().compareTo(this.parent.getMaxPercentage()) > 0) {
            commissionAmt = commissionAmt.multiply(Env.ONE.divide(this.parent.getPercentage(), MathContext.DECIMAL128)).multiply(Env.ONEHUNDRED);
            commissionAmt = commissionAmt.multiply(this.parent.getMaxPercentage().divide(Env.ONEHUNDRED, MathContext.DECIMAL128));
        }
        if ((commissionAmt = commissionAmt.multiply(commissionLine.getAmtMultiplier())).scale() > stdPrecision) {
            commissionAmt = commissionAmt.setScale(stdPrecision, 4);
        }
        this.setCommissionAmt(commissionAmt);
    }

    private MCommissionAmt getParent() {
        if (this.parent == null) {
            this.parent = new MCommissionAmt(this.getCtx(), this.getC_CommissionAmt_ID(), this.get_TrxName());
        }
        return this.parent;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            this.updateAmtHeader();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateAmtHeader();
        }
        return success;
    }

    private void updateAmtHeader() {
        MCommissionAmt amt = new MCommissionAmt(this.getCtx(), this.getC_CommissionAmt_ID(), this.get_TrxName());
        amt.updateCommissionAmount();
        amt.saveEx();
    }

    public static ArrayList<MCommissionDetail> getAlreadyProcessedCommissionDetails(Properties ctx, int clientId, int C_IvoiceLine_ID, String trxName) {
        ArrayList<MCommissionDetail> commisionDetails = new ArrayList<MCommissionDetail>();
        StringBuffer sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql.append("SELECT cd.C_CommissionDetail_ID  FROM C_CommissionDetail cd  INNER JOIN C_CommissionAmt ca on(cd.c_commissionamt_id=ca.c_commissionamt_id)  INNER JOIN C_CommissionRun cr on(ca.c_commissionrun_id=cr.c_commissionrun_id)  WHERE cd.C_InvoiceLine_ID=" + C_IvoiceLine_ID + " AND cr.DocStatus IN ('CL','CO') AND cr.AD_Client_ID = ?  ORDER BY cd.C_CommissionDetail_ID ");
        try {
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            pstmt.setInt(1, clientId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MCommissionDetail cd = new MCommissionDetail(ctx, rs.getInt(1), trxName);
                commisionDetails.add(cd);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("System Error: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return commisionDetails;
    }

    public static MCommissionDetail copy(Properties ctx, MCommissionDetail fromCommissionDetail, String trxName) {
        MCommissionDetail toCommissionDetail = new MCommissionDetail(ctx, 0, trxName);
        toCommissionDetail.setAD_Client_ID(fromCommissionDetail.getAD_Client_ID());
        toCommissionDetail.setAD_Org_ID(fromCommissionDetail.getAD_Org_ID());
        toCommissionDetail.setC_CommissionAmt_ID(fromCommissionDetail.getC_CommissionAmt_ID());
        toCommissionDetail.setC_Currency_ID(fromCommissionDetail.getC_Currency_ID());
        toCommissionDetail.setActualAmt(fromCommissionDetail.getActualAmt());
        toCommissionDetail.setActualQty(fromCommissionDetail.getActualQty());
        toCommissionDetail.setConvertedAmt(fromCommissionDetail.getConvertedAmt());
        toCommissionDetail.setInfo(fromCommissionDetail.getInfo());
        toCommissionDetail.setReference(fromCommissionDetail.getReference());
        toCommissionDetail.setC_OrderLine_ID(fromCommissionDetail.getC_OrderLine_ID());
        toCommissionDetail.setC_InvoiceLine_ID(fromCommissionDetail.getC_InvoiceLine_ID());
        toCommissionDetail.setIsActive(fromCommissionDetail.isActive());
        return toCommissionDetail;
    }

    protected void correctForRMA(BigDecimal qtyReturned) {
        ArrayList<MCommissionDetail> oldCommisionDetails = MCommissionDetail.getAlreadyProcessedCommissionDetails(this.getCtx(), this.getAD_Client_ID(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        for (MCommissionDetail oldCommisionDetail : oldCommisionDetails) {
            this.setActualAmt(this.getActualAmt().add(oldCommisionDetail.getActualAmt()));
            this.setActualQty(this.getActualQty().add(oldCommisionDetail.getActualQty()));
            this.setConvertedAmt(this.getConvertedAmt().add(oldCommisionDetail.getConvertedAmt()));
            this.setInfo(this.getInfo() + Msg.translate(Env.getAD_Language(this.getCtx()), "Commission") + ": " + oldCommisionDetail.getInfo() + ", ");
        }
        BigDecimal percentage = Env.ONE;
        if (this.getActualQty().compareTo(qtyReturned) == 1) {
            percentage = qtyReturned.divide(this.getActualQty(), 4, 4);
        }
        this.setActualAmt(this.getActualAmt().multiply(percentage).setScale(2, 4).negate());
        this.setActualQty(this.getActualQty().multiply(percentage).setScale(2, 4).negate());
        this.setConvertedAmt(this.getConvertedAmt().multiply(percentage).setScale(2, 4).negate());
    }
}

