/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.I_AD_Column;
import org.compiere.model.I_AD_Table;
import org.compiere.model.MClient;
import org.compiere.model.MField;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MColumn
extends X_AD_Column {
    private static final long serialVersionUID = 3455817869952578951L;
    public static final String SYSCONFIG_DATABASE_AUTO_SYNC = "DATABASE_AUTO_SYNC";
    public static final String MSG_CannotSyncVirtualColumn = "@MColumn_CannotSyncVirtualColumn@";
    public static final String MSG_CannotSyncView = "@MColumn_CannotSyncView@";
    public static final String MSG_SyncErrorColumnAlreadyExists = "@MColumn_SyncError_ColumnWithThatNameAlreadyExists@";
    public static final String MSG_NoSQLNOChangesMade = "@MColumn_NoSQLNoChangesMade@";
    public static final String MSG_ColumnAlreadyExists = "@MColumn_ColumnAlreadyExists@";
    public static final String MSG_ErrorSyncingColumn = "@MColumn_SyncError@";
    public static final String MSG_ColumnPartOfKeyButNotKeyOrParentInAD = "@MColumn_ColumnPartOfKeyConstraintButIsNotAKeyOrParentLink@";
    public static final String MSG_ColumnDoesNotExistAndWillBeAdded = "@MColumn_ColumnDoesNotExistAndWillBeAdded@";
    public static final String MSG_ColumnNameChanged = "@MColumn_ColumnNameChanged@";
    public static final String MSG_DataTypeChanged = "@MColumn_ColumnDataTypeChanged@";
    public static final String MSG_ManadatoryValueChanged = "@MColumn_ColumnMandatorySettingChanged@";
    public static final String MSG_DefaultValueChanged = "@MColumn_ColumnDefaultValueChanged@";
    public static final String MSG_SQLSuccessfullyApplied = "@MColumn_ChangesSuccessfullyApplied@";
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);
    private boolean isNewTable = false;

    public static boolean isEncrypted(int columnId) {
        String sql = "SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID = ?";
        return "Y".equals(DB.getSQLValueString(null, "SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID = ?", columnId));
    }

    public static I_AD_Column setAD_Column(Properties ctx, I_AD_Column column, String trxName) {
        String entityType;
        MTable table2 = (MTable)column.getAD_Table();
        M_Element element = new M_Element(ctx, column.getAD_Element_ID(), trxName);
        if (element.getAD_Reference_ID() == 13) {
            String columnName = table2.getTableName() + "_ID";
            String tableDir = element.getColumnName().replace("_ID", "");
            if (!columnName.equals(element.getColumnName()) && MTable.getTable_ID(tableDir) > 0) {
                column.setAD_Reference_ID(19);
            }
        }
        if ((entityType = column.getAD_Table().getEntityType()) == null) {
            throw new AdempiereException("@EntityType@ @@AD_Table_ID@ @NotFound@");
        }
        if (!"D".equals(entityType)) {
            column.setEntityType(entityType);
        }
        if (column.getColumnName() == null || column.getColumnName().length() <= 0) {
            column.setColumnName(element.getColumnName());
        }
        if (column.getFieldLength() <= 0) {
            column.setFieldLength(element.getFieldLength());
        }
        if (column.getAD_Reference_ID() <= 0) {
            column.setAD_Reference_ID(element.getAD_Reference_ID());
        }
        if (column.getAD_Reference_Value_ID() <= 0) {
            column.setAD_Reference_Value_ID(element.getAD_Reference_Value_ID());
        }
        if (column.getName() == null || column.getName().length() <= 0) {
            column.setName(element.getName());
        }
        if (column.getDescription() == null || column.getDescription().length() <= 0) {
            column.setDescription(element.getDescription());
        }
        if (column.getHelp() == null || column.getHelp().length() <= 0) {
            column.setHelp(element.getHelp());
        }
        return column;
    }

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public MColumn(MTable parent, String columnName, int length, int AD_Reference, String defaultValue) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
        this.setColumnName(columnName);
        M_Element AD_Element = M_Element.get(this.getCtx(), columnName);
        if (AD_Element != null) {
            this.setAD_Element_ID(AD_Element.get_ID());
        }
        this.setName(columnName);
        this.setIsActive(true);
        this.setVersion(Env.ONE);
        this.setIsMandatory(true);
        this.setIsAllowLogging(true);
        this.setFieldLength(length);
        this.setAD_Reference_ID(AD_Reference);
        this.setDefaultValue(defaultValue);
        this.setUpdateable(false);
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && !this.isDirectLoad()) {
            MColumn.setAD_Column(this.getCtx(), this, this.get_TrxName());
            if ("DocumentNo".equals(this.getColumnName()) || !this.isDirectLoad() && "Value".equals(this.getColumnName())) {
                String tableName = MTable.getTableName(this.getCtx(), this.getAD_Table_ID());
                String whereClause = "AD_Client_ID=? AND Name=? ";
                Arrays.stream(MClient.getAll(this.getCtx())).forEach(client -> {
                    MSequence sequence = (MSequence)new Query(this.getCtx(), "AD_Sequence", "AD_Client_ID=? AND Name=? ", this.get_TrxName()).setParameters(client.getAD_Client_ID(), "DocumentNo_" + tableName).first();
                    if (sequence == null || sequence.getAD_Sequence_ID() <= 0) {
                        sequence = new MSequence(this.getCtx(), client.getAD_Client_ID(), tableName, this.get_TrxName());
                        sequence.saveEx();
                    }
                });
            }
            this.setIsAllowCopy(MColumn.isAllowCopy(this.getColumnName(), this.getAD_Reference_ID()));
        }
        this.setFieldLength(DisplayType.getDBDataLength(this));
        if (!this.isDirectLoad() && this.get_Value("AD_Element_ID").equals(this.get_ValueOld("AD_Element_ID"))) {
            MColumn.validLookup(this.getColumnName(), this.getAD_Reference_ID(), this.getAD_Reference_Value_ID());
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            if (element.is_new()) {
                throw new AdempiereException("@AD_Element_ID@ " + this.getAD_Element_ID() + " @NotFound@");
            }
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        if (!this.isVirtualColumn() && (this.get_Table_ID() == I_AD_Table.Table_ID || this.get_Table_ID() == I_AD_Column.Table_ID || !this.getAD_Table().isView()) && !this.isDirectLoad() && (newRecord || this.is_ValueChanged("ColumnName") || this.is_ValueChanged("AD_Reference_ID") || this.is_ValueChanged("FieldLength") || this.is_ValueChanged("IsMandatory") || this.is_ValueChanged("IsKey") || this.is_ValueChanged("DefaultValue") || this.is_ValueChanged("ColumnSQL") || this.is_ValueChanged("IsParent"))) {
            if (this.isRequiresSync()) {
                if (this.getColumnName().equals(this.getNameOldValue())) {
                    this.setNameOldValue(null);
                }
            } else {
                this.setRequiresSync(true);
                this.setNameOldValue((String)this.get_ValueOld("ColumnName"));
            }
        }
        return true;
    }

    public static void validLookup(String p_ColumnName, int p_AD_Reference_ID, int p_AD_Reference_Value_ID) {
        if (p_ColumnName == null || p_ColumnName.trim().length() == 0 || !DisplayType.isLookup(p_AD_Reference_ID)) {
            return;
        }
        String m_TableName = p_ColumnName.replace("_ID", "");
        if (p_AD_Reference_ID == 19) {
            if (!p_ColumnName.endsWith("_ID")) {
                throw new AdempiereException("@Reference@ @of@ @ColumnName@ @NotValid@");
            }
            MTable table2 = MTable.get(Env.getCtx(), m_TableName);
            if (table2 == null) {
                throw new AdempiereException("@AD_Table_ID@ @NotFound@");
            }
        } else if (p_AD_Reference_ID == 18 || p_AD_Reference_ID == 30 ? p_AD_Reference_Value_ID == 0 && !M_Element.isLookupColumnName(p_ColumnName, p_AD_Reference_ID) : p_AD_Reference_ID == 17 && p_AD_Reference_Value_ID == 0) {
            throw new AdempiereException("@AD_Reference_Value_ID@ @IsMandatory@");
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.isRequiresSync() && MColumn.isAutoSync()) {
            this.syncDatabase();
        }
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help"))) {
            StringBuffer whereClause = new StringBuffer("AD_Column_ID=? ").append(" AND IsCentrallyMaintained=? ");
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(this.getAD_Column_ID());
            parameters.add(true);
            List fields = new Query(this.getCtx(), "AD_Field", whereClause.toString(), this.get_TrxName()).setParameters(parameters).list();
            int no = 0;
            for (MField field : fields) {
                field.setName(this.getName());
                field.setDescription(this.getDescription());
                field.setHelp(this.getHelp());
                field.saveEx();
                ++no;
            }
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table2) {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = null;
        if (!this.isMandatory() || this.isNewTable) {
            sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getSQLDDL());
        } else {
            sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getColumnName()).append(" ").append(this.getSQLDataType());
            if (this.getAD_Reference_ID() == 20) {
                sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
            }
            sql.append("; ");
            String defaultValue = this.getDefaultValueSQL();
            sql.append("ALTER TABLE ").append(table2.getTableName()).append(" ALTER ").append(this.getColumnName()).append(" SET DEFAULT ").append(defaultValue).append("; ");
            if (defaultValue != null && defaultValue.length() > 0 && !defaultValue.equals("NULL")) {
                StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
                sql.append(sqlSet).append("; ");
            }
            sql.append("ALTER TABLE ").append(table2.getTableName()).append(" ALTER ").append(this.getColumnName()).append(" SET NOT NULL").append("; ");
        }
        String constraint = this.getConstraint(table2.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer(this.getColumnName()).append(" ").append(this.getSQLDataType());
        sql.append(" DEFAULT ").append(this.getDefaultValueSQL());
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    private String getDefaultValueSQL() {
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null && defaultValue.length() > 0) {
            if (defaultValue.indexOf(64) != -1 || defaultValue.startsWith("#") || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1")) {
                defaultValue = "NULL";
            } else if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
        } else {
            defaultValue = "NULL";
        }
        return defaultValue;
    }

    public String getSQLModify(MTable table2, boolean setNullOption) {
        return this.getSQLModify(table2, null, setNullOption);
    }

    public String getSQLModify(MTable table2, String oldColumnName, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        if (oldColumnName != null) {
            sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" RENAME COLUMN ").append(oldColumnName).append(" TO ").append(this.getColumnName()).append("; ");
        }
        if (this.isKey() || this.getColumnName().endsWith("_ID") && this.getColumnName().replace("_ID", "").equals(table2.get_TableName())) {
            if (sql.length() == 0) {
                return null;
            }
            return sql.toString();
        }
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" MODIFY ").append(this.getColumnName());
        String defaultValue = this.getDefaultValueSQL();
        sql.append(sqlBase).append(" ").append(this.getSQLDataType()).append(" DEFAULT ").append(defaultValue);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0 && !defaultValue.equals("NULL")) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength(), this.getAD_Reference_Value_ID());
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            String constraintName = tableName.length() > 26 ? tableName.substring(0, 26) + "_Key" : tableName + "_Key";
            return "CONSTRAINT " + constraintName + " PRIMARY KEY (" + this.getColumnName() + ")";
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }

    public static int getColumn_ID(String tableName, String columnName) {
        int m_table_id = MTable.getTable_ID(tableName);
        if (m_table_id == 0) {
            return 0;
        }
        int retValue = 0;
        String SQL = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ?  AND columnname = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, m_table_id);
            pstmt.setString(2, columnName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public static int getTable_ID(Properties ctx, int AD_Column_ID, String trxName) {
        String sqlStmt = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
        return DB.getSQLValue(trxName, sqlStmt, AD_Column_ID);
    }

    public String syncDatabase() {
        return this.syncDatabase(null);
    }

    public String syncDatabase(Connection conn) {
        return this.syncDatabase(conn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String syncDatabase(Connection conn, boolean isOnlyReport) {
        String returnMessage;
        boolean errorOccured;
        block48: {
            s_log.config("");
            boolean closeConn = false;
            errorOccured = true;
            returnMessage = "";
            if (this.isVirtualColumn()) {
                this.markSyncComplete();
                return MSG_CannotSyncVirtualColumn;
            }
            MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
            if (table2.get_ID() == 0) {
                throw new AdempiereException("@NotFound@ @AD_Table_ID@ " + this.getAD_Table_ID());
            }
            if (table2.isView()) {
                this.markSyncComplete();
                return MSG_CannotSyncView;
            }
            table2.set_TrxName(this.get_TrxName());
            ResultSet rs = null;
            try {
                block50: {
                    block49: {
                        if (this.getAD_Table_ID() == Table_ID || this.getAD_Table_ID() == MTable.Table_ID) {
                            conn = DB.getConnectionRO();
                            closeConn = true;
                        } else if (conn == null) {
                            if (this.get_TrxName() != null && !this.get_TrxName().isEmpty()) {
                                conn = Trx.get(this.get_TrxName(), true).getConnection();
                            } else {
                                conn = DB.getConnectionRO();
                                closeConn = true;
                            }
                        }
                        returnMessage = table2.syncDatabase(conn, isOnlyReport);
                        returnMessage = MSG_NoSQLNOChangesMade.equals(returnMessage) ? "" : table2.getTableName() + ": " + returnMessage + "<br>";
                        this.load(this.get_TrxName());
                        String oldColumnName2332 = this.getNameOldValue();
                        if (oldColumnName2332 != null && oldColumnName2332.equalsIgnoreCase(this.getColumnName())) {
                            oldColumnName2332 = null;
                        }
                        DatabaseMetaData md = conn.getMetaData();
                        String catalog = DB.getDatabase().getCatalog();
                        String schema = DB.getDatabase().getSchema();
                        String tableName = table2.getTableName();
                        if (md.storesUpperCaseIdentifiers()) {
                            tableName = tableName.toUpperCase();
                        } else if (md.storesLowerCaseIdentifiers()) {
                            tableName = tableName.toLowerCase();
                        }
                        String sql = null;
                        Boolean oldColumnExists = false;
                        Boolean currentColumnExists = false;
                        Boolean oldNotNull = false;
                        Boolean currentNotNull = false;
                        int currentDataType = 0;
                        int currentColumnSize = 0;
                        String currentTypeName = null;
                        String currentColumnDefault = null;
                        String columnDefault = this.getDefaultValueSQL();
                        this.isNewTable = true;
                        rs = md.getTables(catalog, schema, tableName, null);
                        while (rs.next()) {
                            this.isNewTable = false;
                        }
                        rs.close();
                        if (this.isNewTable) {
                            sql = table2.getSQLCreate();
                        } else {
                            rs = md.getColumns(catalog, schema, tableName, null);
                            while (rs.next()) {
                                String columnName = rs.getString("COLUMN_NAME");
                                if (oldColumnName2332 != null && columnName.equalsIgnoreCase(oldColumnName2332)) {
                                    oldColumnExists = true;
                                    oldNotNull = 0 == rs.getInt("NULLABLE");
                                }
                                if (!columnName.equalsIgnoreCase(this.getColumnName())) continue;
                                currentColumnExists = true;
                                currentNotNull = 0 == rs.getInt("NULLABLE");
                                currentDataType = rs.getInt("DATA_TYPE");
                                currentTypeName = rs.getString("TYPE_NAME");
                                currentColumnSize = rs.getInt("COLUMN_SIZE");
                                currentColumnDefault = rs.getString("COLUMN_DEF");
                            }
                            rs.close();
                            rs = null;
                            boolean isDatabaseKey = false;
                            rs = md.getPrimaryKeys(catalog, schema, tableName);
                            while (rs.next()) {
                                if (!this.getColumnName().equalsIgnoreCase(rs.getString(4))) continue;
                                isDatabaseKey = true;
                                break;
                            }
                            if (isDatabaseKey && !this.isKey() && !this.isParent()) {
                                returnMessage = returnMessage + "@MColumn_ColumnPartOfKeyConstraintButIsNotAKeyOrParentLink@<br>";
                            }
                            if (!oldColumnExists.booleanValue() && !currentColumnExists.booleanValue()) {
                                returnMessage = returnMessage + "@MColumn_ColumnDoesNotExistAndWillBeAdded@<br>";
                                sql = this.getSQLAdd(table2);
                            } else if (oldColumnExists.booleanValue() && !currentColumnExists.booleanValue() || !oldColumnExists.booleanValue() && currentColumnExists.booleanValue()) {
                                boolean withDefault;
                                boolean bl = withDefault = columnDefault != null && columnDefault.length() > 0 && !columnDefault.equals("NULL");
                                if (oldColumnName2332 != null) {
                                    returnMessage = returnMessage + MSG_ColumnNameChanged + " " + oldColumnName2332 + " -> " + this.getColumnName() + "<br>";
                                }
                                if (!DisplayType.isSameType(this, currentDataType, currentColumnSize)) {
                                    returnMessage = returnMessage + "@MColumn_ColumnDataTypeChanged@ " + currentTypeName + "(" + currentColumnSize + ") -> " + this.getSQLDataType() + "<br>";
                                }
                                if (this.isMandatory() != currentNotNull.booleanValue()) {
                                    returnMessage = returnMessage + "@MColumn_ColumnMandatorySettingChanged@ " + currentNotNull + " -> " + this.isMandatory() + "<br>";
                                }
                                if (this.isMandatory() && withDefault && currentColumnDefault != null && !currentColumnDefault.startsWith(columnDefault)) {
                                    returnMessage = returnMessage + "@MColumn_ColumnDefaultValueChanged@ " + currentColumnDefault + " -> " + columnDefault + "<br>";
                                }
                                if (oldColumnName2332 != null || !DisplayType.isSameType(this, currentDataType, currentColumnSize) || this.isMandatory() != currentNotNull.booleanValue() || this.isMandatory() && withDefault && currentColumnDefault != null && !currentColumnDefault.startsWith(columnDefault)) {
                                    this.log.info(tableName + "." + this.getColumnName() + ": currentDataType: " + currentDataType + ", currentColumnSize: " + currentColumnSize + ", isMandatory(): " + this.isMandatory() + ", currentNotNull: " + currentNotNull + ", currentColumnDefault: " + currentColumnDefault + ", columnDefault: " + columnDefault);
                                    sql = this.getSQLModify(table2, null, this.isMandatory() != currentNotNull.booleanValue());
                                }
                            } else if (oldColumnExists.booleanValue() && currentColumnExists.booleanValue()) {
                                throw new AdempiereException(Msg.translate(this.getCtx(), MSG_SyncErrorColumnAlreadyExists) + " " + oldColumnName2332 + "->" + this.getColumnName());
                            }
                        }
                        String trxName = this.get_TrxName();
                        if (sql == null) break block49;
                        returnMessage = returnMessage + "SQL: " + sql;
                        if (!isOnlyReport) {
                            try {
                                this.log.info("Syncing column " + this.getColumnName() + ": " + sql);
                                this.log.info("Transaction: " + trxName + ", get_TrxName(): " + this.get_TrxName());
                                CLogger.resetLast();
                                DB.executeUpdateMultiple(sql, false, trxName);
                                DB.commit(true, trxName);
                                Exception error = CLogger.retrieveException();
                                if (error == null) {
                                    returnMessage = returnMessage + "<br>@MColumn_ChangesSuccessfullyApplied@";
                                    errorOccured = false;
                                } else {
                                    returnMessage = returnMessage + "<br>@Error@ @MColumn_SyncError@ " + error.toString();
                                }
                            }
                            catch (Exception e) {
                                this.log.severe("Manual intervention required: Cannot sync column: " + this.getColumnName());
                                returnMessage = returnMessage + "<br>@Error@: @MColumn_SyncError@ " + tableName + "." + this.getColumnName();
                                returnMessage = returnMessage + "<br>" + e.getLocalizedMessage();
                            }
                            if (this.getAD_Table_ID() == I_AD_Column.Table_ID || this.getAD_Table_ID() == I_AD_Table.Table_ID) {
                                s_log.config("There has been a change in the AD_Table or AD_Column structure.  Resetting the columns in POInfo");
                                POInfo.resetPOInfoColumnList();
                            }
                            POInfo.removeFromCache(this.getAD_Table_ID());
                        }
                        break block50;
                    }
                    returnMessage = returnMessage + MSG_NoSQLNOChangesMade;
                }
                DB.close(rs);
                if (!closeConn || conn == null) break block48;
            }
            catch (SQLException | DBException e) {
                if (e.getMessage() == null) throw new AdempiereException(e);
                if (!e.getMessage().contains("already exists")) throw new AdempiereException(e);
                returnMessage = returnMessage + MSG_ColumnAlreadyExists;
                break block48;
            }
            try {
                conn.close();
            }
            catch (Exception oldColumnName2332) {
                // empty catch block
            }
            conn = null;
            break block48;
            finally {
                DB.close(rs);
                if (closeConn && conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                    conn = null;
                }
            }
        }
        if (isOnlyReport) return returnMessage;
        if (errorOccured) return returnMessage;
        this.markSyncComplete();
        return returnMessage;
    }

    public static boolean isSuggestSelectionColumn(String columnName, boolean caseSensitive) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        if (columnName.equals("Value") || !caseSensitive && columnName.equalsIgnoreCase("Value")) {
            return true;
        }
        if (columnName.equals("Name") || !caseSensitive && columnName.equalsIgnoreCase("Name")) {
            return true;
        }
        if (columnName.equals("DocumentNo") || !caseSensitive && columnName.equalsIgnoreCase("DocumentNo")) {
            return true;
        }
        if (columnName.equals("Description") || !caseSensitive && columnName.equalsIgnoreCase("Description")) {
            return true;
        }
        return columnName.indexOf("Name") != -1 || !caseSensitive && columnName.toUpperCase().indexOf("Name".toUpperCase()) != -1;
    }

    public static boolean isForSynchronizeColumn(String columnName) {
        if (Util.isEmpty(columnName, true)) {
            return false;
        }
        return columnName.equals("IsMandatory") || columnName.equals("IsParent") || columnName.equals("ColumnName") || columnName.equals("AD_Reference_ID") || columnName.equals("FieldLength") || columnName.equals("IsKey") || columnName.equals("DefaultValue");
    }

    public static boolean isAllowCopy(Properties ctx, int p_AD_Column_ID) {
        MColumn column = MColumn.get(ctx, p_AD_Column_ID);
        if (column != null) {
            MColumn.isAllowCopy(column.getColumnName(), column.getAD_Reference_ID());
            return true;
        }
        return false;
    }

    public static boolean isAllowCopy(String columnName, int referenceId) {
        return 13 != referenceId && 21 != referenceId && !M_Element.isReservedColumnName(columnName);
    }

    public static Integer getKeyColumnFirstValue(String columnName) {
        Integer firstOK = null;
        if (columnName.endsWith("_ID")) {
            firstOK = columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("Record_ID") || columnName.equals("C_DocType_ID") || columnName.equals("Node_ID") || columnName.equals("AD_Role_ID") || columnName.equals("M_AttributeSet_ID") || columnName.equals("M_AttributeSetInstance_ID") || columnName.equals("M_Warehouse_ID") ? Integer.valueOf(0) : Integer.valueOf(1);
        }
        return firstOK;
    }

    public static boolean isAutoSync() {
        return !"N".equals(MSysConfig.getValue(SYSCONFIG_DATABASE_AUTO_SYNC, "N", Env.getAD_Client_ID(Env.getCtx())));
    }

    public void markSyncComplete() {
        if (this.isRequiresSync() || this.getNameOldValue() != null) {
            this.setIsDirectLoad(true);
            this.set_ValueNoCheck("RequiresSync", false);
            this.set_ValueNoCheck("NameOldValue", null);
            this.saveEx();
        }
    }
}

