/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAdvertisement;
import org.compiere.model.MClick;
import org.compiere.model.X_W_ClickCount;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.ValueNamePair;

public class MClickCount
extends X_W_ClickCount {
    private static final long serialVersionUID = -5233509415147834823L;
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat(15);
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat(11);

    public MClickCount(Properties ctx, int W_ClickCount_ID, String trxName) {
        super(ctx, W_ClickCount_ID, trxName);
        if (W_ClickCount_ID == 0) {
            // empty if block
        }
    }

    public MClickCount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MClickCount(MAdvertisement ad) {
        this(ad.getCtx(), 0, ad.get_TrxName());
        this.setName(ad.getName());
        this.setTargetURL("#");
        this.setC_BPartner_ID(ad.getC_BPartner_ID());
    }

    public MClick[] getMClicks() {
        ArrayList list = new ArrayList();
        MClick[] retValue = new MClick[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    protected ValueNamePair[] getCount(String DateFormat2) {
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        String sql = "SELECT TRUNC(Created, '" + DateFormat2 + "'), Count(*) FROM W_Click WHERE W_ClickCount_ID=? GROUP BY TRUNC(Created, '" + DateFormat2 + "')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getW_ClickCount_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String value = this.m_dateFormat.format(rs.getTimestamp(1));
                String name = this.m_intFormat.format(rs.getInt(2));
                ValueNamePair pp = new ValueNamePair(value, name);
                list.add(pp);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        pstmt = null;
        ValueNamePair[] retValue = new ValueNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public ValueNamePair[] getCountQuarter() {
        return this.getCount("Q");
    }

    public ValueNamePair[] getCountMonth() {
        return this.getCount("MM");
    }

    public ValueNamePair[] getCountWeek() {
        return this.getCount("DY");
    }

    public ValueNamePair[] getCountDay() {
        return this.getCount("J");
    }
}

