/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_BankStatementLine;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankStatementLine
extends X_C_BankStatementLine {
    private static final long serialVersionUID = 1914411222159254809L;
    private MBankStatement m_parent = null;

    public MBankStatementLine(Properties ctx, int C_BankStatementLine_ID, String trxName) {
        super(ctx, C_BankStatementLine_ID, trxName);
        if (C_BankStatementLine_ID == 0) {
            this.setStmtAmt(Env.ZERO);
            this.setTrxAmt(Env.ZERO);
            this.setInterestAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setIsReversal(false);
        }
    }

    public MBankStatementLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatementLine(MBankStatement statement) {
        this(statement.getCtx(), 0, statement.get_TrxName());
        this.setClientOrg(statement);
        this.setC_BankStatement_ID(statement.getC_BankStatement_ID());
        this.setStatementLineDate(statement.getStatementDate());
    }

    public MBankStatementLine(MBankStatement statement, X_I_BankStatement imp, int lineNo) {
        this(statement);
        MBankAccount account = MBankAccount.get(this.getCtx(), statement.getC_BankAccount_ID());
        if (account == null) {
            throw new AdempiereException("@C_BankAccount_ID@ @NotFound@");
        }
        this.setReferenceNo(imp.getReferenceNo());
        this.setDescription(imp.getLineDescription());
        this.setStatementLineDate(imp.getStatementLineDate());
        this.setDateAcct(imp.getStatementLineDate());
        if (imp.getValutaDate() != null) {
            this.setValutaDate(imp.getValutaDate());
        }
        this.setIsReversal(imp.isReversal());
        if (imp.getC_Currency_ID() != 0) {
            this.setC_Currency_ID(imp.getC_Currency_ID());
        } else {
            this.setC_Currency_ID(account.getC_Currency_ID());
        }
        this.setTrxAmt(imp.getTrxAmt());
        this.setStmtAmt(imp.getStmtAmt());
        if (imp.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(imp.getC_Charge_ID());
        }
        this.setInterestAmt(imp.getInterestAmt());
        this.setChargeAmt(imp.getChargeAmt());
        this.setMemo(imp.getMemo());
        if (imp.getC_Payment_ID() != 0) {
            this.setC_Payment_ID(imp.getC_Payment_ID());
        }
        this.setEftTrxID(imp.getEftTrxID());
        this.setEftTrxType(imp.getEftTrxType());
        this.setEftCheckNo(imp.getEftCheckNo());
        this.setEftReference(imp.getEftReference());
        this.setEftMemo(imp.getEftMemo());
        this.setEftPayee(imp.getEftPayee());
        this.setEftPayeeAccount(imp.getEftPayeeAccount());
        this.setEftStatementLineDate(imp.getEftStatementLineDate());
        this.setEftValutaDate(imp.getEftValutaDate());
        this.setEftCurrency(imp.getEftCurrency());
        this.setEftAmt(imp.getEftAmt());
        this.setLine(lineNo);
    }

    public MBankStatementLine(MBankStatement statement, int lineNo) {
        this(statement);
        this.setLine(lineNo);
    }

    @Override
    public void setStatementLineDate(Timestamp StatementLineDate) {
        super.setStatementLineDate(StatementLineDate);
        this.setValutaDate(StatementLineDate);
        this.setDateAcct(StatementLineDate);
    }

    public void setPayment(MPayment payment) {
        BigDecimal interestAmt;
        BigDecimal amt = payment.getPayAmt(true);
        int currencyId = payment.getC_Currency_ID();
        MBankAccount account = MBankAccount.get(this.getCtx(), this.getParent().getC_BankAccount_ID());
        if (account.getC_Currency_ID() != payment.getC_Currency_ID()) {
            currencyId = account.getC_Currency_ID();
            MCurrency currency = MCurrency.get(this.getCtx(), account.getC_Currency_ID());
            Timestamp ConvDate = this.getParent().getStatementDate();
            BigDecimal CurrencyRate = Env.ONE;
            CurrencyRate = MConversionRate.getRate(payment.getC_Currency_ID(), account.getC_Currency_ID(), ConvDate, payment.getC_ConversionType_ID(), payment.getAD_Client_ID(), payment.getAD_Org_ID());
            if (CurrencyRate != null) {
                amt = amt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            }
        }
        this.setC_Payment_ID(payment.getC_Payment_ID());
        this.setC_Currency_ID(currencyId);
        BigDecimal chargeAmt = this.getChargeAmt();
        if (chargeAmt == null) {
            chargeAmt = Env.ZERO;
        }
        if ((interestAmt = this.getInterestAmt()) == null) {
            interestAmt = Env.ZERO;
        }
        this.setTrxAmt(amt);
        this.setStmtAmt(amt.add(chargeAmt).add(interestAmt));
        this.setDescription(payment.getDescription());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_BankStatementLine"));
            return false;
        }
        if (this.getChargeAmt().signum() != 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
            return false;
        }
        if (this.getTrxAmt().signum() == 0 && this.getC_Payment_ID() > 0) {
            this.setC_Payment_ID(I_ZERO);
            this.setC_Invoice_ID(I_ZERO);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM C_BankStatementLine WHERE C_BankStatement_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_BankStatement_ID());
            this.setLine(ii);
        }
        if (this.getC_Payment_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            this.setC_BPartner_ID(payment.getC_BPartner_ID());
            if (payment.getC_Invoice_ID() != 0) {
                this.setC_Invoice_ID(payment.getC_Invoice_ID());
            }
            MBPartner partner = MBPartner.get(payment.getCtx(), payment.getC_BPartner_ID());
            String description = this.getDescription() != null ? this.getDescription() + " - " + payment.getDocumentInfo() + " - " + partner.getValue() + " - " + partner.getName() : payment.getDocumentInfo() + " - " + partner.getValue() + " - " + partner.getName();
            this.setDescription(description);
        }
        if (this.getC_Invoice_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
            String description = this.getDescription() != null ? this.getDescription() + " - " + invoice.getDocumentInfo() + " - " + invoice.getOpenAmt() : invoice.getDocumentInfo() + " - " + invoice.getOpenAmt();
            this.setDescription(description);
        }
        BigDecimal amt = this.getStmtAmt();
        amt = amt.subtract(this.getTrxAmt());
        if ((amt = amt.subtract(this.getInterestAmt())).compareTo(this.getChargeAmt()) != 0) {
            this.setChargeAmt(amt);
        }
        return true;
    }

    public MBankStatement getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MBankStatement(this.getCtx(), this.getC_BankStatement_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    private boolean updateHeader() {
        String sql = "UPDATE C_BankStatement bs SET StatementDifference=(SELECT COALESCE(SUM(StmtAmt),0) FROM C_BankStatementLine bsl WHERE bsl.C_BankStatement_ID=bs.C_BankStatement_ID AND bsl.IsActive='Y') WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("StatementDifference #" + no);
            return false;
        }
        sql = "UPDATE C_BankStatement bs SET EndingBalance=BeginningBalance+StatementDifference WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("Balance #" + no);
            return false;
        }
        return true;
    }
}

