/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.validator.routines.IBANValidator;
import org.compiere.model.MBank;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankAccount;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MBankAccount
extends X_C_BankAccount {
    private static final long serialVersionUID = -8742307130542608791L;
    private static CCache<Integer, MBankAccount> s_cache = new CCache("C_BankAccount", 5);

    public static MBankAccount get(Properties ctx, int C_BankAccount_ID) {
        Integer key = new Integer(C_BankAccount_ID);
        MBankAccount retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBankAccount(ctx, C_BankAccount_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MBankAccount(Properties ctx, int C_BankAccount_ID, String trxName) {
        super(ctx, C_BankAccount_ID, trxName);
        if (C_BankAccount_ID == 0) {
            this.setIsDefault(false);
            this.setBankAccountType("C");
            this.setCurrentBalance(Env.ZERO);
            this.setCreditLimit(Env.ZERO);
        }
    }

    public MBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBankAccount[").append(this.get_ID()).append("-").append(this.getAccountNo()).append("]");
        return sb.toString();
    }

    public MBank getBank() {
        return MBank.get(this.getCtx(), this.getC_Bank_ID());
    }

    public String getName() {
        return this.getBank().getName() + " " + this.getAccountNo();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        IBANValidator validator;
        if (newRecord && !Util.isEmpty(this.getIBAN()) && !(validator = IBANValidator.getInstance()).isValid(this.getIBAN().trim())) {
            throw new AdempiereException("@ValidationError@ (@Invalid@ @IBAN@)");
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            return this.insert_Accounting("C_BankAccount_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        return this.delete_Accounting("C_BankAccount_Acct");
    }

    public static MBankAccount getDefault(Properties ctx, int AD_Org_ID, String BankType) {
        ArrayList<Object> paramenters = new ArrayList<Object>();
        paramenters.add(AD_Org_ID);
        paramenters.add(BankType);
        String whereClause = " isDefault = 'Y'  AND AD_Org_ID=? AND Exists (select 1 from C_Bank b where b.banktype =? and b.c_Bank_ID=C_BankAccount.C_Bank_ID)";
        return (MBankAccount)new Query(ctx, "C_BankAccount", whereClause.toString(), null).setParameters(paramenters).setOrderBy("AccountNo").first();
    }
}

