/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.FA.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Transfer;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;

public class MAssetTransfer
extends X_A_Asset_Transfer
implements DocAction {
    private static final long serialVersionUID = 6542200284709386238L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetTransfer(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetTransfer(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        this.setC_Period_ID();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod mPeriod = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
        if (mPeriod == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(mPeriod.get_ID());
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + this.getDateAcct();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@DocumentNo@ #").append(this.getDocumentNo());
        return stringBuffer.toString();
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MAssetAcct mAssetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (mAssetAcct.getA_Asset_Acct() != this.getA_Asset_Acct() || mAssetAcct.getA_Accumdepreciation_Acct() != this.getA_Accumdepreciation_Acct() || mAssetAcct.getA_Depreciation_Acct() != this.getA_Depreciation_Acct() || mAssetAcct.getA_Disposal_Revenue_Acct() != this.getA_Disposal_Revenue_Acct() || mAssetAcct.getA_Disposal_Loss_Acct() != this.getA_Disposal_Loss_Acct()) {
            throw new AdempiereException("The accounts have been changed");
        }
        MAssetAcct mAssetAcct2 = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (mAssetAcct2.getA_Asset_Acct() == this.getA_Asset_New_Acct() && mAssetAcct2.getA_Accumdepreciation_Acct() == this.getA_Accumdepreciation_New_Acct() && mAssetAcct2.getA_Depreciation_Acct() == this.getA_Depreciation_New_Acct() && mAssetAcct2.getA_Disposal_Revenue_Acct() == this.getA_Disposal_Revenue_New_Acct() && mAssetAcct2.getA_Disposal_Loss_Acct() == this.getA_Disposal_Loss_New_Acct()) {
            throw new AdempiereException("An account has been changed");
        }
        if (mDepreciationWorkfile.getDateAcct().equals(this.getDateAcct())) {
            throw new AdempiereException("Last day of month. Accounts will be changed next month");
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        object = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        MAssetAcct mAssetAcct = new MAssetAcct(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)object, mAssetAcct);
        mAssetAcct.setA_Asset_Acct(this.getA_Asset_New_Acct());
        mAssetAcct.setA_Accumdepreciation_Acct(this.getA_Accumdepreciation_New_Acct());
        mAssetAcct.setValidFrom(this.getDateAcct());
        mAssetAcct.saveEx();
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        String string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean processIt(String string) throws Exception {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean unlockIt() {
        return false;
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public String getDocumentNo() {
        return null;
    }
}

