/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.I_C_AllocationHdr;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Payment;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_AllocationHdr;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class MAllocationHdr
extends X_C_AllocationHdr
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = 8726957992840702609L;
    private static final BigDecimal TOLERANCE = BigDecimal.valueOf(0.02);
    private static CLogger logger = CLogger.getCLogger(MAllocationHdr.class);
    private MAllocationLine[] m_lines = null;
    private String processMsg = null;
    private boolean justPrepared = false;
    private boolean isReversal = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAllocationHdr[] getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Payment_ID=?)";
        ArrayList<MAllocationHdr> list = new ArrayList<MAllocationHdr>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Payment_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAllocationHdr(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MAllocationHdr[] getOfInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Invoice_ID=?)";
        ArrayList<MAllocationHdr> list = new ArrayList<MAllocationHdr>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_Invoice_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAllocationHdr(ctx, rs, trxName));
            }
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MAllocationHdr[] getOfCash(Properties ctx, int C_Cash_ID, String trxName) {
        String whereClause = "IsActive='Y' AND EXISTS (SELECT 1 FROM C_CashLine cl, C_AllocationLine al where cl.C_Cash_ID=? and al.C_CashLine_ID=cl.C_CashLine_ID and C_AllocationHdr.C_AllocationHdr_ID=al.C_AllocationHdr_ID)";
        Query query = MTable.get(ctx, I_C_AllocationHdr.Table_ID).createQuery("IsActive='Y' AND EXISTS (SELECT 1 FROM C_CashLine cl, C_AllocationLine al where cl.C_Cash_ID=? and al.C_CashLine_ID=cl.C_CashLine_ID and C_AllocationHdr.C_AllocationHdr_ID=al.C_AllocationHdr_ID)", trxName);
        query.setParameters(C_Cash_ID);
        List<MAllocationHdr> list = query.list();
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAllocationHdr(Properties ctx, int C_AllocationHdr_ID, String trxName) {
        super(ctx, C_AllocationHdr_ID, trxName);
        if (C_AllocationHdr_ID == 0) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setApprovalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(false);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MAllocationHdr(Properties ctx, boolean IsManual, Timestamp DateTrx, int C_Currency_ID, String description, String trxName) {
        this(ctx, 0, trxName);
        this.setIsManual(IsManual);
        if (DateTrx != null) {
            this.setDateTrx(DateTrx);
            this.setDateAcct(DateTrx);
        }
        this.setC_Currency_ID(C_Currency_ID);
        if (description != null) {
            this.setDescription(description);
        }
    }

    public MAllocationHdr(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAllocationLine[] getLines(boolean requery) {
        if (this.m_lines != null && this.m_lines.length != 0 && !requery) {
            MAllocationHdr.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String sql = "SELECT * FROM C_AllocationLine WHERE C_AllocationHdr_ID=?";
        ArrayList<MAllocationLine> list = new ArrayList<MAllocationLine>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_AllocationHdr_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocationLine line = new MAllocationLine(this.getCtx(), rs, this.get_TrxName());
                line.setParent(this);
                list.add(line);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MAllocationLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE C_AllocationHdr SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_AllocationHdr_ID=" + this.getC_AllocationHdr_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - #" + no);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() <= 0) {
            Optional<MDocType> doctypeOptional = Arrays.stream(MDocType.getOfDocBaseType(this.getCtx(), "CMA")).sorted((docType1, docType2) -> Boolean.compare(docType2.isDefault(), docType1.isDefault())).findFirst();
            doctypeOptional.ifPresent(docType -> this.setC_DocType_ID(docType.getC_DocType_ID()));
            if (this.getC_DocType_ID() <= 0) {
                int docType_ID = DB.getSQLValueEx(this.get_TrxName(), "select c_doctype_id from c_doctype  where docbasetype = 'CMA' and isdefault = 'Y'", new Object[0]);
                if (docType_ID > 0) {
                    this.setC_DocType_ID(docType_ID);
                } else {
                    throw new AdempiereException("@C_DocType_ID@ @FillMandatory@");
                }
            }
        }
        if (!newRecord && this.is_ValueChanged("IsActive") && this.isActive()) {
            this.log.severe("Cannot Re-Activate deactivated Allocations");
            return false;
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String trxName = this.get_TrxName();
        if (trxName == null || trxName.length() == 0) {
            this.log.warning("No transaction");
        }
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "CMA", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), trxName);
        }
        this.setIsActive(false);
        String sql = "UPDATE C_AllocationHdr SET IsActive='N' WHERE C_AllocationHdr_ID=?";
        DB.executeUpdate(sql, this.getC_AllocationHdr_ID(), trxName);
        this.getLines(true);
        if (!this.updateBP(true)) {
            return false;
        }
        Arrays.stream(this.getLines(false)).forEach(allocationLine -> allocationLine.deleteEx(true));
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "CMA", this.getAD_Org_ID());
        this.getLines(false);
        if (this.m_lines.length == 0) {
            this.processMsg = "@NoLines@";
            return "IN";
        }
        List<MAllocationLine> allocationLines = Arrays.asList(this.getLines(false));
        if (!this.isReversal()) {
            allocationLines.stream().filter(allocationLine -> allocationLine.getC_Invoice_ID() != 0).forEach(allocationLine -> {
                String whereClause = "C_Invoice_ID=? AND IsPaid=? AND DocStatus NOT IN (?,?)";
                boolean InvoiceIsPaid = new Query(this.getCtx(), "C_Invoice", "C_Invoice_ID=? AND IsPaid=? AND DocStatus NOT IN (?,?)", this.get_TrxName()).setClient_ID().setParameters(allocationLine.getC_Invoice_ID(), "Y", "VO", "RE").match();
                if (InvoiceIsPaid) {
                    throw new AdempiereException("@ValidationError@ @C_Invoice_ID@ @IsPaid@");
                }
            });
        }
        AtomicReference<BigDecimal> approval = new AtomicReference<BigDecimal>(Env.ZERO);
        allocationLines.stream().forEach(allocationLine -> {
            I_C_Payment payment;
            I_C_Invoice invoice;
            approval.updateAndGet(approvalAmount -> approvalAmount.add(allocationLine.getWriteOffAmt()).add(allocationLine.getDiscountAmt()));
            if (allocationLine.getC_BPartner_ID() == 0) {
                this.processMsg = Msg.parseTranslation(this.getCtx(), "@C_BPartner_ID@ @NotFound@");
                throw new AdempiereException(this.processMsg);
            }
            if (allocationLine.getC_Invoice_ID() > 0 && (invoice = allocationLine.getC_Invoice()).getDateAcct().after(this.getDateAcct())) {
                this.processMsg = Msg.parseTranslation(this.getCtx(), "@ValidationError@   @C_Invoice_ID@ " + invoice.getDocumentNo() + " @DateAcct@" + invoice.getDateAcct() + " @C_AllocationHdr_ID@ " + this.getDocumentInfo() + " @DateAcct@ " + this.getDateAcct());
                throw new AdempiereException(this.processMsg);
            }
            if (allocationLine.getC_Payment_ID() > 0 && (payment = allocationLine.getC_Payment()).getDateAcct().after(this.getDateAcct())) {
                this.processMsg = Msg.parseTranslation(this.getCtx(), "@ValidationError@  @C_Payment_ID@ " + payment.getDocumentNo() + " @DateAcct@" + payment.getDateAcct() + " @C_AllocationHdr_ID@ " + this.getDocumentInfo() + " @DateAcct@ " + this.getDateAcct());
                throw new AdempiereException(this.processMsg);
            }
        });
        this.setApprovalAmt(approval.get());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.getLines(false);
        if (!this.updateBP(this.isReversal())) {
            return "IN";
        }
        Arrays.stream(this.getLines(false)).forEach(allocationLine -> allocationLine.processIt(this.isReversal()));
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        List<MAllocationLine> allocationLines;
        this.log.info(this.toString());
        boolean retValue = false;
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus())) {
            this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.processMsg != null) {
                return false;
            }
            allocationLines = Arrays.asList(this.getLines(true));
            if (!this.updateBP(true)) {
                return false;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "CMA", this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        allocationLines.stream().forEach(allocationLine -> {
            allocationLine.setAmount(Env.ZERO);
            allocationLine.setDiscountAmt(Env.ZERO);
            allocationLine.setWriteOffAmt(Env.ZERO);
            allocationLine.setOverUnderAmt(Env.ZERO);
            allocationLine.saveEx();
            allocationLine.processIt(true);
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        retValue = true;
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMsg != null) {
            return false;
        }
        MAllocationHdr reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMsg != null) {
            return false;
        }
        MAllocationHdr reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAllocationHdr[");
        sb.append(this.get_ID()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        return Msg.getElement(this.getCtx(), "C_AllocationHdr_ID") + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public MAllocationHdr reverseIt(boolean isAccrual) {
        if (!this.isActive() || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE")) {
            this.log.warning("Allocation already reversed (not active)");
            return null;
        }
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElse(currentDate) : this.getDateAcct();
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, "CMA", this.getAD_Org_ID());
        this.setReversal(true);
        if (isAccrual) {
            MAllocationHdr reversalAllocationHdr = MAllocationHdr.copyFrom(this, reversalDate, reversalDate, this.get_TrxName());
            if (reversalAllocationHdr == null) {
                this.processMsg = "Could not create Payment Allocation Reversal";
                return null;
            }
            Arrays.stream(reversalAllocationHdr.getLines(false)).forEach(reverseAllocationLine -> {
                reverseAllocationLine.setAmount(reverseAllocationLine.getAmount().negate());
                reverseAllocationLine.setDiscountAmt(reverseAllocationLine.getDiscountAmt().negate());
                reverseAllocationLine.setWriteOffAmt(reverseAllocationLine.getWriteOffAmt().negate());
                reverseAllocationLine.setOverUnderAmt(reverseAllocationLine.getOverUnderAmt().negate());
                reverseAllocationLine.saveEx(this.get_TrxName());
            });
            reversalAllocationHdr.setReversal(true);
            reversalAllocationHdr.setDocumentNo(this.getDocumentNo() + "^");
            reversalAllocationHdr.addDescription("{->" + this.getDocumentNo() + ")");
            reversalAllocationHdr.setReversal_ID(this.getC_AllocationHdr_ID());
            reversalAllocationHdr.saveEx();
            if (!DocumentEngine.processIt(reversalAllocationHdr, "CO")) {
                this.processMsg = "Reversal ERROR: " + reversalAllocationHdr.getProcessMsg();
                return null;
            }
            DocumentEngine.processIt(reversalAllocationHdr, "CL");
            reversalAllocationHdr.setProcessing(false);
            reversalAllocationHdr.setDocStatus("RE");
            reversalAllocationHdr.setDocAction("--");
            reversalAllocationHdr.saveEx();
            this.processMsg = reversalAllocationHdr.getDocumentNo();
            this.addDescription("(" + reversalAllocationHdr.getDocumentNo() + "<-)");
            this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
            this.setReversal_ID(reversalAllocationHdr.getReversal_ID());
            this.setProcessed(true);
            this.setDocStatus("RE");
            this.setDocAction("--");
            return reversalAllocationHdr;
        }
        this.setIsActive(false);
        if (!this.isPosted()) {
            this.setPosted(true);
        }
        this.setDocumentNo(this.getDocumentNo() + "^");
        this.setDocStatus("RE");
        if (!this.save() || this.isActive()) {
            throw new IllegalStateException("Cannot de-activate allocation");
        }
        MFactAcct.deleteEx(Table_ID, this.getC_AllocationHdr_ID(), this.get_TrxName());
        List<MAllocationLine> allocationLines = Arrays.asList(this.getLines(true));
        if (!this.updateBP(true)) {
            return null;
        }
        allocationLines.stream().forEach(allocationLine -> {
            allocationLine.setIsActive(false);
            allocationLine.setAmount(Env.ZERO);
            allocationLine.setDiscountAmt(Env.ZERO);
            allocationLine.setWriteOffAmt(Env.ZERO);
            allocationLine.setOverUnderAmt(Env.ZERO);
            allocationLine.saveEx();
            allocationLine.processIt(true);
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return this;
    }

    @Deprecated
    private void updateBP(HashSet<Integer> bps) {
        this.log.info("#" + bps.size());
        for (int C_BPartner_ID : bps) {
            MBPartner bp = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
            bp.setTotalOpenBalance();
            if (bp.save()) {
                this.log.fine(bp.toString());
                continue;
            }
            this.log.log(Level.SEVERE, "BP not updated - " + bp);
        }
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    private boolean updateBP(boolean isReverse) {
        List<MAllocationLine> allocationLines = Arrays.asList(this.getLines(false));
        allocationLines.stream().filter(allocationLine -> allocationLine.getC_BPartner_ID() != 0 || allocationLine.getC_Invoice_ID() != 0 && allocationLine.getC_Payment_ID() != 0).forEach(allocationLine -> {
            BigDecimal newBalance;
            boolean isSOTrxInvoice = false;
            MInvoice invoice = null;
            if (allocationLine.getC_Invoice_ID() > 0) {
                invoice = allocationLine.getC_Invoice_ID() > 0 ? new MInvoice(this.getCtx(), allocationLine.getC_Invoice_ID(), this.get_TrxName()) : null;
                isSOTrxInvoice = invoice.isSOTrx();
            }
            MBPartner partner = new MBPartner(this.getCtx(), allocationLine.getC_BPartner_ID(), this.get_TrxName());
            DB.getDatabase().forUpdate(partner, 0);
            BigDecimal allocationAmount = allocationLine.getAmount().add(allocationLine.getDiscountAmt()).add(allocationLine.getWriteOffAmt());
            BigDecimal openBalanceDifference = Env.ZERO;
            MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
            boolean paymentProcessed = false;
            boolean paymentIsReceipt = false;
            if (allocationLine.getC_Payment_ID() > 0) {
                int conversionTypeId = 0;
                Timestamp paymentDate = null;
                MPayment payment = new MPayment(this.getCtx(), allocationLine.getC_Payment_ID(), this.get_TrxName());
                conversionTypeId = payment.getC_ConversionType_ID();
                paymentDate = payment.getDateAcct();
                paymentProcessed = payment.isProcessed();
                paymentIsReceipt = payment.isReceipt();
                if (paymentProcessed) {
                    if (invoice != null) {
                        BigDecimal amount = MConversionRate.convertBase(this.getCtx(), allocationLine.getWriteOffAmt().add(allocationLine.getDiscountAmt()), this.getC_Currency_ID(), paymentDate, conversionTypeId, this.getAD_Client_ID(), this.getAD_Org_ID());
                        if (amount == null) {
                            this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingAllocationCurrencyToBaseCurrency", this.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), conversionTypeId, paymentDate, this.get_TrxName());
                            throw new AdempiereException(this.processMsg);
                        }
                        openBalanceDifference = openBalanceDifference.add(amount);
                    } else {
                        BigDecimal amount = MConversionRate.convertBase(this.getCtx(), allocationAmount, this.getC_Currency_ID(), paymentDate, conversionTypeId, this.getAD_Client_ID(), this.getAD_Org_ID());
                        if (amount == null) {
                            this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingAllocationCurrencyToBaseCurrency", this.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), conversionTypeId, paymentDate, this.get_TrxName());
                            throw new AdempiereException(this.processMsg);
                        }
                        openBalanceDifference = openBalanceDifference.add(amount);
                    }
                } else {
                    BigDecimal allocationAmountBase = MConversionRate.convertBase(this.getCtx(), allocationAmount, this.getC_Currency_ID(), this.getDateAcct(), conversionTypeId, this.getAD_Client_ID(), this.getAD_Org_ID());
                    if (allocationAmountBase == null) {
                        this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingAllocationCurrencyToBaseCurrency", this.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), conversionTypeId, this.getDateAcct(), this.get_TrxName());
                        throw new AdempiereException(this.processMsg);
                    }
                    openBalanceDifference = openBalanceDifference.add(allocationAmountBase);
                }
            } else if (invoice != null) {
                BigDecimal amount = MConversionRate.convertBase(this.getCtx(), allocationLine.getWriteOffAmt().add(allocationLine.getDiscountAmt()), this.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                if (amount == null) {
                    this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingAllocationCurrencyToBaseCurrency", this.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), invoice.getC_ConversionType_ID(), invoice.getDateAcct(), this.get_TrxName());
                    throw new AdempiereException(this.processMsg);
                }
                openBalanceDifference = openBalanceDifference.add(amount);
            }
            if (invoice != null && (this.getC_Currency_ID() != client.getC_Currency_ID() || this.getC_Currency_ID() != invoice.getC_Currency_ID())) {
                if (this.getC_Currency_ID() != invoice.getC_Currency_ID() && (allocationAmount = MConversionRate.convert(this.getCtx(), allocationAmount, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID())) == null) {
                    this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingAllocationCurrencyToInvoiceCurrency", this.getC_Currency_ID(), invoice.getC_Currency_ID(), invoice.getC_ConversionType_ID(), this.getDateAcct(), this.get_TrxName());
                    throw new AdempiereException(this.processMsg);
                }
                BigDecimal invoiceAmountAccounted = MConversionRate.convertBase(this.getCtx(), invoice.getGrandTotal(), invoice.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                if (invoiceAmountAccounted == null) {
                    this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingInvoiceCurrencyToBaseCurrency", invoice.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), invoice.getC_ConversionType_ID(), invoice.getDateAcct(), this.get_TrxName());
                    throw new AdempiereException(this.processMsg);
                }
                BigDecimal allocationAmountAccounted = MConversionRate.convertBase(this.getCtx(), allocationAmount, invoice.getC_Currency_ID(), this.getDateAcct(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                if (allocationAmountAccounted == null) {
                    this.processMsg = MConversionRate.getErrorMessage(this.getCtx(), "ErrorConvertingInvoiceCurrencyToBaseCurrency", invoice.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), invoice.getC_ConversionType_ID(), this.getDateAcct(), this.get_TrxName());
                    throw new AdempiereException(this.processMsg);
                }
                if (allocationAmount.compareTo(invoice.getGrandTotal()) == 0) {
                    openBalanceDifference = openBalanceDifference.add(invoiceAmountAccounted).subtract(allocationAmountAccounted);
                } else {
                    double multiplier = allocationAmount.doubleValue() / invoice.getGrandTotal().doubleValue();
                    if ((openBalanceDifference = openBalanceDifference.add(invoiceAmountAccounted = invoiceAmountAccounted.multiply(BigDecimal.valueOf(multiplier))).subtract(allocationAmountAccounted)).abs().compareTo(TOLERANCE) < 0) {
                        openBalanceDifference = Env.ZERO;
                    }
                    int precision = MCurrency.getStdPrecision(this.getCtx(), client.getC_Currency_ID());
                    if (openBalanceDifference.scale() > precision) {
                        openBalanceDifference = openBalanceDifference.setScale(precision, 4);
                    }
                }
            }
            if ((newBalance = partner.getTotalOpenBalance()) == null) {
                newBalance = Env.ZERO;
            }
            BigDecimal originalBalance = new BigDecimal(newBalance.toString());
            if (openBalanceDifference.signum() != 0) {
                newBalance = isReverse ? newBalance.add(openBalanceDifference) : newBalance.subtract(openBalanceDifference);
            }
            BigDecimal newCreditAmount = BigDecimal.ZERO;
            if (isSOTrxInvoice || invoice == null && paymentIsReceipt && paymentProcessed) {
                if (invoice == null) {
                    openBalanceDifference = openBalanceDifference.negate();
                }
                newCreditAmount = partner.getSO_CreditUsed();
                newCreditAmount = isReverse ? (newCreditAmount == null ? openBalanceDifference : newCreditAmount.add(openBalanceDifference)) : (newCreditAmount == null ? openBalanceDifference.negate() : newCreditAmount.subtract(openBalanceDifference));
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("TotalOpenBalance=" + partner.getTotalOpenBalance() + "(" + openBalanceDifference + ", Credit=" + partner.getSO_CreditUsed() + "->" + newCreditAmount + ", Balance=" + partner.getTotalOpenBalance() + " -> " + newBalance);
                }
                partner.setSO_CreditUsed(newCreditAmount);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("TotalOpenBalance=" + partner.getTotalOpenBalance() + "(" + openBalanceDifference + ", Balance=" + partner.getTotalOpenBalance() + " -> " + newBalance);
            }
            if (newBalance.compareTo(originalBalance) != 0) {
                partner.setTotalOpenBalance(newBalance);
            }
            partner.setSOCreditStatus();
            if (!partner.save(this.get_TrxName())) {
                this.processMsg = "Could not update Business Partner";
                throw new AdempiereException(this.processMsg);
            }
        });
        return true;
    }

    @Override
    public void setReversal(boolean reversal) {
        this.isReversal = reversal;
    }

    @Override
    public boolean isReversal() {
        return this.isReversal;
    }

    public static MAllocationHdr copyFrom(MAllocationHdr allocationHdrFrom, Timestamp dateAcct, Timestamp dateTrx, String trxName) {
        MAllocationHdr allocationHdrTo = new MAllocationHdr(allocationHdrFrom.getCtx(), 0, trxName);
        PO.copyValues(allocationHdrFrom, allocationHdrTo, allocationHdrFrom.getAD_Client_ID(), allocationHdrFrom.getAD_Org_ID());
        allocationHdrTo.set_ValueNoCheck("DocumentNo", null);
        allocationHdrTo.setDocStatus("DR");
        allocationHdrTo.setDocAction("CO");
        allocationHdrTo.setDateTrx(dateAcct);
        allocationHdrTo.setDateAcct(dateTrx);
        allocationHdrTo.setIsManual(false);
        allocationHdrTo.setIsApproved(false);
        allocationHdrTo.setPosted(false);
        allocationHdrTo.setProcessed(false);
        allocationHdrTo.saveEx();
        if (allocationHdrTo.copyLinesFrom(allocationHdrFrom) == 0) {
            throw new AdempiereException("Could not create Allocation Lines");
        }
        return allocationHdrTo;
    }

    public int copyLinesFrom(MAllocationHdr allocationHdrFrom) {
        if (this.isProcessed() || this.isPosted() || allocationHdrFrom == null) {
            return 0;
        }
        AtomicInteger lines = new AtomicInteger();
        List<MAllocationLine> allocationLines = Arrays.asList(allocationHdrFrom.getLines(false));
        allocationLines.stream().forEach(allocationLineFrom -> {
            MPayment reversal;
            MPayment payment;
            MAllocationLine allocationLineTo = new MAllocationLine(this.getCtx(), 0, allocationLineFrom.get_TrxName());
            PO.copyValues(allocationLineFrom, allocationLineTo, allocationLineFrom.getAD_Client_ID(), allocationLineFrom.getAD_Org_ID());
            allocationLineTo.setC_AllocationHdr_ID(this.getC_AllocationHdr_ID());
            allocationLineTo.setParent(this);
            allocationLineTo.set_ValueNoCheck("C_AllocationLine_ID", I_ZERO);
            if (allocationLineTo.getC_Payment_ID() != 0 && "RE".equals((payment = new MPayment(this.getCtx(), allocationLineTo.getC_Payment_ID(), this.get_TrxName())).getDocStatus()) && (reversal = (MPayment)payment.getReversal()) != null) {
                allocationLineTo.setPaymentInfo(reversal.getC_Payment_ID(), 0);
            }
            allocationLineTo.saveEx();
            if (allocationHdrFrom.isReversal()) {
                allocationLineTo.setReversalLine_ID(allocationLineFrom.get_ID());
                allocationLineTo.saveEx();
                allocationLineFrom.setReversalLine_ID(allocationLineTo.get_ID());
                allocationLineFrom.saveEx();
            }
            lines.updateAndGet(count -> count + 1);
        });
        if (allocationLines.size() != lines.get()) {
            this.log.log(Level.WARNING, "Line difference - From=" + allocationLines.size() + " <> Saved=" + lines.get());
        }
        return lines.get();
    }
}

