/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.JFrame;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.ColorEditor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class VColor
extends CButton
implements VEditor,
ActionListener {
    private static final long serialVersionUID = 3881508174949938138L;
    private GridTab m_mTab;
    private boolean m_mandatory;
    private CompiereColor m_cc = null;
    private Object m_value;
    private static CLogger log = CLogger.getCLogger(VColor.class);
    private GridField m_mField = null;

    public VColor(GridTab mTab, boolean mandatory, boolean isReadOnly) {
        this.m_mTab = mTab;
        this.setMandatory(mandatory);
        this.setReadWrite(!isReadOnly);
        this.addActionListener(this);
    }

    @Override
    public void dispose() {
        this.m_mTab = null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setBackground(boolean error) {
    }

    @Override
    public void setValue(Object value) {
        log.config("Value=" + value);
        this.m_value = value;
        this.m_cc = this.getAdempiereColor();
        this.setText(this.getDisplay());
        if (this.m_cc != null) {
            this.setBackgroundColor(this.m_cc);
        } else {
            this.setOpaque(false);
            this.putClientProperty("CompiereBackground", null);
        }
        this.repaint();
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        if (this.m_cc == null) {
            return "-/-";
        }
        return " ";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
            this.setBackground(false);
        }
    }

    @Override
    public void setField(GridField mField) {
        mField.setValueNoFire(false);
        this.m_mField = mField;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    private CompiereColor getAdempiereColor() {
        Integer AD_Color_ID = (Integer)this.m_mTab.getValue("AD_Color_ID");
        log.fine("AD_Color_ID=" + AD_Color_ID);
        CompiereColor cc = null;
        String ColorType = (String)this.m_mTab.getValue("ColorType");
        if (ColorType == null) {
            log.fine("No ColorType");
            return null;
        }
        if (ColorType.equals("F")) {
            cc = new CompiereColor(this.getColor(true), true);
        } else if (ColorType.equals("G")) {
            Integer RepeatDistance = (Integer)this.m_mTab.getValue("RepeatDistance");
            String StartPoint = (String)this.m_mTab.getValue("StartPoint");
            int repeatDistance = RepeatDistance == null ? 0 : RepeatDistance;
            int startPoint = StartPoint == null ? 0 : Integer.parseInt(StartPoint);
            cc = new CompiereColor(this.getColor(true), this.getColor(false), startPoint, repeatDistance);
        } else if (ColorType.equals("L")) {
            BigDecimal LineWidth = (BigDecimal)this.m_mTab.getValue("LineWidth");
            BigDecimal LineDistance = (BigDecimal)this.m_mTab.getValue("LineDistance");
            int lineWidth = LineWidth == null ? 0 : LineWidth.intValue();
            int lineDistance = LineDistance == null ? 0 : LineDistance.intValue();
            cc = new CompiereColor(this.getColor(false), this.getColor(true), lineWidth, lineDistance);
        } else if (ColorType.equals("T")) {
            Integer AD_Image_ID = (Integer)this.m_mTab.getValue("AD_Image_ID");
            String url = this.getURL(AD_Image_ID);
            if (url == null) {
                return null;
            }
            BigDecimal ImageAlpha = (BigDecimal)this.m_mTab.getValue("ImageAlpha");
            float compositeAlpha = ImageAlpha == null ? 0.7f : ImageAlpha.floatValue();
            cc = new CompiereColor(url, this.getColor(true), compositeAlpha);
        } else {
            return null;
        }
        log.fine("AdempiereColor=" + cc);
        return cc;
    }

    private Color getColor(boolean primary) {
        String add = primary ? "" : "_1";
        Integer Red = (Integer)this.m_mTab.getValue("Red" + add);
        Integer Green = (Integer)this.m_mTab.getValue("Green" + add);
        Integer Blue = (Integer)this.m_mTab.getValue("Blue" + add);
        int red = Red == null ? 0 : Red;
        int green = Green == null ? 0 : Green;
        int blue = Blue == null ? 0 : Blue;
        return new Color(red, green, blue);
    }

    private String getURL(Integer AD_Image_ID) {
        if (AD_Image_ID == null || AD_Image_ID == 0) {
            return null;
        }
        String retValue = null;
        String sql = "SELECT ImageURL FROM AD_Image WHERE AD_Image_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Image_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return retValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CompiereColor cc = ColorEditor.showDialog((JFrame)Env.getParent(this), this.m_cc);
        if (cc == null) {
            log.info("VColor.actionPerformed - no color");
            return;
        }
        this.setBackgroundColor(cc);
        this.repaint();
        this.m_mTab.setValue("ColorType", (Object)cc.getType());
        if (cc.isFlat()) {
            this.setColor(cc.getFlatColor(), true);
        } else if (cc.isGradient()) {
            this.setColor(cc.getGradientUpperColor(), true);
            this.setColor(cc.getGradientLowerColor(), false);
            this.m_mTab.setValue("RepeatDistance", (Object)new BigDecimal(cc.getGradientRepeatDistance()));
            this.m_mTab.setValue("StartPoint", (Object)String.valueOf(cc.getGradientStartPoint()));
        } else if (cc.isLine()) {
            this.setColor(cc.getLineBackColor(), true);
            this.setColor(cc.getLineColor(), false);
            this.m_mTab.getValue("LineWidth");
            this.m_mTab.getValue("LineDistance");
        } else if (cc.isTexture()) {
            this.setColor(cc.getTextureTaintColor(), true);
            this.m_mTab.setValue("ImageAlpha", (Object)new BigDecimal(cc.getTextureCompositeAlpha()));
        }
        this.m_cc = cc;
    }

    private void setColor(Color c, boolean primary) {
        String add = primary ? "" : "_1";
        this.m_mTab.setValue("Red" + add, (Object)new BigDecimal(c.getRed()));
        this.m_mTab.setValue("Green" + add, (Object)new BigDecimal(c.getGreen()));
        this.m_mTab.setValue("Blue" + add, (Object)new BigDecimal(c.getBlue()));
    }
}

