/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VLocation;
import org.compiere.grid.ed.VString;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public final class VBPartner
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -4130643780412193122L;
    private int m_WindowNo;
    private MBPartner m_partner = null;
    private MBPartnerLocation m_pLocation = null;
    private MUser m_user = null;
    private boolean m_readOnly = false;
    private Insets m_labelInsets = new Insets(2, 15, 2, 0);
    private Insets m_fieldInsets = new Insets(2, 5, 2, 10);
    private GridBagConstraints m_gbc = new GridBagConstraints();
    private int m_line;
    private Object[] m_greeting;
    private Object[] m_bpGroup;
    private static CLogger log = CLogger.getCLogger(VBPartner.class);
    private VString fValue;
    private VString fName;
    private VString fName2;
    private VString fTaxId;
    private VString fContact;
    private VString fTitle;
    private VString fPhone;
    private VString fFax;
    private VString fPhone2;
    private VString fEMail;
    private VLocation fAddress;
    private JComboBox fGreetingBP;
    private JComboBox fGreetingC;
    private JComboBox fBPGroup;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();

    public VBPartner(Frame frame, int WindowNo) {
        super(frame, Msg.translate(Env.getCtx(), "C_BPartner_ID"), true);
        this.m_WindowNo = WindowNo;
        this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MBPartner.Table_ID, 0, false);
        log.info("R/O=" + this.m_readOnly);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.initBPartner();
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.southPanel.setLayout(this.southLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.mainLayout.setVgap(5);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.confirmPanel.addActionListener(this);
    }

    private void initBPartner() {
        this.m_greeting = this.fillGreeting();
        this.m_bpGroup = this.fillBPGroup();
        this.m_gbc.anchor = 18;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = 0;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.weightx = 0.0;
        this.m_gbc.weighty = 0.0;
        this.m_gbc.fill = 2;
        this.m_gbc.ipadx = 0;
        this.m_gbc.ipady = 0;
        this.m_line = 0;
        this.fValue = new VString("Value", true, false, true, 30, 60, "", null);
        this.fValue.addActionListener(this);
        this.createLine(this.fValue, "Value", true);
        this.fGreetingBP = new JComboBox<Object>(this.m_greeting);
        this.createLine(this.fGreetingBP, "Greeting", false);
        this.fBPGroup = new JComboBox<Object>(this.m_bpGroup);
        this.createLine(this.fBPGroup, "BP_Group", false);
        this.fName = new VString("Name", true, false, true, 30, 60, "", null);
        this.fName.addActionListener(this);
        this.createLine(this.fName, "Name", false).setFontBold(true);
        this.fName2 = new VString("Name2", false, false, true, 30, 60, "", null);
        this.createLine(this.fName2, "Name2", false);
        this.fTaxId = new VString("TaxID", false, false, true, 30, 60, "", null);
        this.createLine(this.fTaxId, "TaxID", false);
        this.fContact = new VString("Contact", false, false, true, 30, 60, "", null);
        this.createLine(this.fContact, "Contact", true).setFontBold(true);
        this.fGreetingC = new JComboBox<Object>(this.m_greeting);
        this.createLine(this.fGreetingC, "Greeting", false);
        this.fTitle = new VString("Title", false, false, true, 30, 60, "", null);
        this.createLine(this.fTitle, "Title", false);
        this.fEMail = new VString("EMail", false, false, true, 30, 40, "", null);
        this.createLine(this.fEMail, "EMail", false);
        boolean ro = this.m_readOnly;
        if (!ro) {
            boolean bl = ro = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MBPartnerLocation.Table_ID, 0, false);
        }
        if (!ro) {
            ro = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MLocation.Table_ID, 0, false);
        }
        this.fAddress = new VLocation("C_Location_ID", false, ro, true, new MLocationLookup(Env.getCtx(), this.m_WindowNo));
        this.fAddress.setValue(null);
        this.createLine(this.fAddress, "C_Location_ID", true).setFontBold(true);
        this.fPhone = new VString("Phone", false, false, true, 30, 40, "", null);
        this.createLine(this.fPhone, "Phone", true);
        this.fPhone2 = new VString("Phone2", false, false, true, 30, 40, "", null);
        this.createLine(this.fPhone2, "Phone2", false);
        this.fFax = new VString("Fax", false, false, true, 30, 40, "", null);
        this.createLine(this.fFax, "Fax", false);
        this.fName.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        this.fBPGroup.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
    }

    private CLabel createLine(JComponent field, String title, boolean addSpace) {
        if (addSpace) {
            this.m_gbc.gridy = this.m_line++;
            this.m_gbc.gridx = 1;
            this.m_gbc.insets = this.m_fieldInsets;
            this.centerPanel.add(Box.createHorizontalStrut(6), this.m_gbc);
        }
        this.m_gbc.gridy = this.m_line++;
        this.m_gbc.gridx = 0;
        this.m_gbc.insets = this.m_labelInsets;
        this.m_gbc.fill = 2;
        CLabel label = new CLabel(Msg.translate(Env.getCtx(), title));
        this.centerPanel.add((Component)label, this.m_gbc);
        this.m_gbc.gridx = 1;
        this.m_gbc.insets = this.m_fieldInsets;
        this.m_gbc.fill = 2;
        this.centerPanel.add((Component)field, this.m_gbc);
        if (this.m_readOnly) {
            field.setEnabled(false);
        }
        return label;
    }

    private Object[] fillGreeting() {
        String sql = "SELECT C_Greeting_ID, Name FROM C_Greeting WHERE IsActive='Y' ORDER BY 2";
        sql = MRole.getDefault().addAccessSQL(sql, "C_Greeting", false, false);
        return DB.getKeyNamePairs(sql, true);
    }

    private KeyNamePair getGreeting(int key) {
        for (int i = 0; i < this.m_greeting.length; ++i) {
            KeyNamePair p = (KeyNamePair)this.m_greeting[i];
            if (p.getKey() != key) continue;
            return p;
        }
        return new KeyNamePair(-1, " ");
    }

    private Object[] fillBPGroup() {
        String sql = "SELECT C_BP_Group_ID, Name FROM C_BP_Group WHERE IsActive='Y' ORDER BY 2";
        sql = MRole.getDefault().addAccessSQL(sql, "C_BP_Group", false, false);
        return DB.getKeyNamePairs(sql, true);
    }

    private KeyNamePair getBPGroup(int key) {
        for (int i = 0; i < this.m_bpGroup.length; ++i) {
            KeyNamePair p = (KeyNamePair)this.m_bpGroup[i];
            if (p.getKey() != key) continue;
            return p;
        }
        return new KeyNamePair(-1, " ");
    }

    public boolean loadBPartner(int C_BPartner_ID) {
        log.config("C_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID == 0) {
            this.m_partner = null;
            this.m_pLocation = null;
            this.m_user = null;
            return true;
        }
        this.m_partner = new MBPartner(Env.getCtx(), C_BPartner_ID, null);
        if (this.m_partner.get_ID() == 0) {
            ADialog.error(this.m_WindowNo, this, "BPartnerNotFound");
            return false;
        }
        this.fValue.setText(this.m_partner.getValue());
        this.fGreetingBP.setSelectedItem(this.getGreeting(this.m_partner.getC_Greeting_ID()));
        this.fName.setText(this.m_partner.getName());
        this.fName2.setText(this.m_partner.getName2());
        this.fTaxId.setText(this.m_partner.getTaxID());
        this.fBPGroup.setSelectedItem(this.getBPGroup(this.m_partner.getC_BP_Group_ID()));
        this.m_pLocation = this.m_partner.getLocation(Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_BPartner_Location_ID"));
        if (this.m_pLocation != null) {
            int location = this.m_pLocation.getC_Location_ID();
            this.fAddress.setValue(new Integer(location));
            this.fPhone.setText(this.m_pLocation.getPhone());
            this.fPhone2.setText(this.m_pLocation.getPhone2());
            this.fFax.setText(this.m_pLocation.getFax());
        }
        this.m_user = this.m_partner.getContact(Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "AD_User_ID"));
        if (this.m_user != null) {
            this.fGreetingC.setSelectedItem(this.getGreeting(this.m_user.getC_Greeting_ID()));
            this.fContact.setText(this.m_user.getName());
            this.fTitle.setText(this.m_user.getTitle());
            this.fEMail.setText(this.m_user.getEMail());
            this.fPhone.setText(this.m_user.getPhone());
            this.fPhone2.setText(this.m_user.getPhone2());
            this.fFax.setText(this.m_user.getFax());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_readOnly) {
            this.dispose();
        } else if (e.getSource() == this.fValue) {
            if (this.fName.getText() == null || this.fName.getText().length() == 0) {
                this.fName.setText(this.fValue.getText());
            }
        } else if (e.getSource() == this.fName) {
            if (this.fContact.getText() == null || this.fContact.getText().length() == 0) {
                this.fContact.setText(this.fName.getText());
            }
        } else if (e.getActionCommand().equals("Ok") && this.actionSave()) {
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private boolean actionSave() {
        String value;
        log.config("");
        if (this.fName.getText().equals("")) {
            this.fName.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        this.fName.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        if (this.m_partner == null) {
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            this.m_partner = MBPartner.getTemplate(Env.getCtx(), AD_Client_ID);
            this.m_partner.setAD_Org_ID(Env.getAD_Org_ID(Env.getCtx()));
            boolean isSOTrx = !"N".equals(Env.getContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx"));
            this.m_partner.setIsCustomer(isSOTrx);
            this.m_partner.setIsVendor(!isSOTrx);
        }
        if ((value = this.fValue.getText()) == null || value.length() == 0) {
            value = DB.getDocumentNo(Env.getAD_Client_ID(Env.getCtx()), "C_BPartner", null, (PO)this.m_partner);
            this.fValue.setText(value);
        }
        this.m_partner.setValue(this.fValue.getText());
        this.m_partner.setName(this.fName.getText());
        this.m_partner.setName2(this.fName2.getText());
        this.m_partner.setTaxID(this.fTaxId.getText());
        KeyNamePair p = (KeyNamePair)this.fGreetingBP.getSelectedItem();
        if (p != null && p.getKey() > 0) {
            this.m_partner.setC_Greeting_ID(p.getKey());
        } else {
            this.m_partner.setC_Greeting_ID(0);
        }
        p = (KeyNamePair)this.fBPGroup.getSelectedItem();
        if (p != null && p.getKey() > 0) {
            this.m_partner.setC_BP_Group_ID(p.getKey());
        } else {
            this.m_partner.setC_BP_Group_ID(0);
        }
        if (this.m_partner.save()) {
            log.fine("C_BPartner_ID=" + this.m_partner.getC_BPartner_ID());
        } else {
            ADialog.error(this.m_WindowNo, this, "BPartnerNotSaved");
        }
        if (this.m_pLocation == null) {
            this.m_pLocation = new MBPartnerLocation(this.m_partner);
        }
        if (this.fAddress.getC_Location_ID() > 0) {
            this.m_pLocation.setC_Location_ID(this.fAddress.getC_Location_ID());
            this.m_pLocation.setEMail(this.fEMail.getText());
            this.m_pLocation.setPhone(this.fPhone.getText());
            this.m_pLocation.setPhone2(this.fPhone2.getText());
            this.m_pLocation.setFax(this.fFax.getText());
            if (this.m_pLocation.save()) {
                log.fine("C_BPartner_Location_ID=" + this.m_pLocation.getC_BPartner_Location_ID());
            } else {
                ADialog.error(this.m_WindowNo, this, "BPartnerNotSaved", Msg.translate(Env.getCtx(), "C_BPartner_Location_ID"));
            }
        } else {
            MOrg org = new MOrg(Env.getCtx(), this.m_partner.getAD_Org_ID(), null);
            MOrgInfo info = org.getInfo();
            if (info.getC_Location_ID() > 0) {
                this.generatePartnerLocation(info.getC_Location_ID());
            } else {
                throw new AdempiereException("No se pudo obtener localizaci\u00f3n para la organizaci\u00f3n " + org.getName());
            }
        }
        String contact = this.fContact.getText();
        String email = this.fEMail.getText();
        if (this.m_user == null && (contact.length() > 0 || email.length() > 0)) {
            this.m_user = new MUser(this.m_partner);
        }
        if (this.m_user != null) {
            if (contact.length() == 0) {
                contact = this.fName.getText();
            }
            this.m_user.setName(contact);
            this.m_user.setEMail(email);
            this.m_user.setTitle(this.fTitle.getText());
            p = (KeyNamePair)this.fGreetingC.getSelectedItem();
            if (p != null && p.getKey() > 0) {
                this.m_user.setC_Greeting_ID(p.getKey());
            } else {
                this.m_user.setC_Greeting_ID(0);
            }
            this.m_user.setPhone(this.fPhone.getText());
            this.m_user.setPhone2(this.fPhone2.getText());
            this.m_user.setFax(this.fFax.getText());
            if (this.m_user.save()) {
                log.fine("AD_User_ID=" + this.m_user.getAD_User_ID());
            } else {
                ADialog.error(this.m_WindowNo, this, "BPartnerNotSaved", Msg.translate(Env.getCtx(), "AD_User_ID"));
            }
        }
        return true;
    }

    private void generatePartnerLocation(int locationID) {
        if (locationID > 0) {
            MLocation locationOrg = new MLocation(Env.getCtx(), locationID, null);
            MLocation locationBP = new MLocation(Env.getCtx(), 0, null);
            locationBP.setC_Country_ID(locationOrg.getC_Country_ID());
            locationBP.setCity(locationOrg.getCity());
            locationBP.setC_City_ID(locationOrg.getC_City_ID());
            locationBP.setRegionName(locationOrg.getRegionName());
            locationBP.setC_Region_ID(locationOrg.getC_Region_ID());
            locationBP.saveEx();
            MBPartnerLocation bpLocation = new MBPartnerLocation(Env.getCtx(), 0, null);
            bpLocation.setC_BPartner_ID(this.m_partner.get_ID());
            if (locationBP.getCity() != null) {
                bpLocation.setName(locationBP.getCity());
            } else {
                bpLocation.setName("--");
            }
            bpLocation.setC_Location_ID(locationBP.get_ID());
            bpLocation.saveEx();
        }
    }

    public int getC_BPartner_ID() {
        if (this.m_partner == null) {
            return 0;
        }
        return this.m_partner.getC_BPartner_ID();
    }
}

