/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.adempiere.controller.SortTabController;
import org.adempiere.util.ListElement;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.grid.APanelTab;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VSortTab
extends CPanel
implements APanelTab {
    private static final long serialVersionUID = -2133358506913610514L;
    static CLogger log = CLogger.getCLogger(VSortTab.class);
    private int windowNo;
    private SortTabController sortTabController;
    private APanel m_aPanel = null;
    private GridBagLayout mainLayout = new GridBagLayout();
    private CLabel noLabel = new CLabel();
    private CLabel yesLabel = new CLabel();
    private CButton bAdd = new CButton();
    private CButton bRemove = new CButton();
    private CButton bUp = new CButton();
    private CButton bDown = new CButton();
    private DefaultListModel<ListElement> noModel = new DefaultListModel<ListElement>(){
        private static final long serialVersionUID = 2171680655634744697L;

        @Override
        public void addElement(ListElement obj) {
            Object[] elements = this.toArray();
            Arrays.sort(elements);
            int index = Arrays.binarySearch(elements, obj);
            if (index < 0) {
                index = -1 * index - 1;
            }
            if (index > elements.length) {
                super.addElement(obj);
            } else {
                super.add(index, obj);
            }
        }

        @Override
        public void add(int index, ListElement obj) {
            this.addElement(obj);
        }
    };
    private DefaultListModel<ListElement> yesModel = new DefaultListModel();
    private DefaultListCellRenderer listRenderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = -101524191283634472L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof ListElement && !((ListElement)value).isUpdateable()) {
                Font f = c.getFont();
                c.setFont(f.deriveFont(f.getStyle() | 2));
                c.setFocusable(false);
            }
            return c;
        }
    };
    private JList noList = new JList<ListElement>(this.noModel);
    private JList yesList = new JList<ListElement>(this.yesModel);
    private JScrollPane noPane = new JScrollPane(this.noList);
    private JScrollPane yesPane = new JScrollPane(this.yesList);

    public VSortTab(int windowNo, int tableId, int columnSortOrderId, int columnSortYesNoId) {
        log.config("SortOrder=" + columnSortOrderId + ", SortYesNo=" + columnSortYesNoId);
        this.windowNo = windowNo;
        try {
            this.sortTabController = new SortTabController(windowNo, tableId, columnSortOrderId, columnSortYesNoId){

                @Override
                public void addItem(ListElement item) {
                    if (item.isYes()) {
                        VSortTab.this.yesModel.addElement(item);
                    } else {
                        VSortTab.this.noModel.addElement(item);
                    }
                }
            };
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.noLabel.setText(Msg.getMsg(Env.getCtx(), "Available"));
        this.yesLabel.setText(Msg.getMsg(Env.getCtx(), "Sequence"));
        for (MouseMotionListener mml : this.noList.getMouseMotionListeners()) {
            this.noList.removeMouseMotionListener(mml);
        }
        for (MouseMotionListener mml : this.yesList.getMouseMotionListeners()) {
            this.yesList.removeMouseMotionListener(mml);
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p2;
                JList list;
                int index;
                if (me.getClickCount() > 1 && (index = (list = (JList)me.getComponent()).locationToIndex(p2 = me.getPoint())) > -1 && list.getCellBounds(index, index).contains(p2)) {
                    VSortTab.this.migrateValueAcrossLists(me);
                }
            }
        };
        this.yesList.addMouseListener(mouseListener);
        this.noList.addMouseListener(mouseListener);
        this.yesList.setCellRenderer(this.listRenderer);
        this.noList.setCellRenderer(this.listRenderer);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VSortTab.this.migrateValueAcrossLists(ae);
            }
        };
        this.bAdd.setIcon(Env.getImageIcon("Detail24.gif"));
        this.bAdd.setMargin(new Insets(2, 2, 2, 2));
        this.bAdd.addActionListener(actionListener);
        this.bRemove.setIcon(Env.getImageIcon("Parent24.gif"));
        this.bRemove.setMargin(new Insets(2, 2, 2, 2));
        this.bRemove.addActionListener(actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addMouseListener(crossListMouseListener);
        this.yesList.addMouseMotionListener(crossListMouseListener);
        this.noList.addMouseListener(crossListMouseListener);
        this.noList.addMouseMotionListener(crossListMouseListener);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VSortTab.this.migrateValueWithinYesList(ae);
            }
        };
        this.bUp.setIcon(Env.getImageIcon("Previous24.gif"));
        this.bUp.setMargin(new Insets(2, 2, 2, 2));
        this.bUp.addActionListener(actionListener);
        this.bDown.setIcon(Env.getImageIcon("Next24.gif"));
        this.bDown.setMargin(new Insets(2, 2, 2, 2));
        this.bDown.addActionListener(actionListener);
        MouseMotionAdapter yesListMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                Point p2;
                JList list = (JList)me.getComponent();
                int index = list.locationToIndex(p2 = me.getPoint());
                if (index > -1 && list.getCellBounds(index, index).contains(p2)) {
                    VSortTab.this.migrateValueWithinYesList(me);
                }
            }
        };
        this.yesList.addMouseMotionListener(yesListMouseMotionListener);
        this.yesList.setSelectionMode(2);
        this.noList.setSelectionMode(2);
        this.add((Component)this.noLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yesLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bDown, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.noPane, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.yesPane, new GridBagConstraints(2, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bUp, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    @Override
    public void loadData() {
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        this.sortTabController.loadData();
        this.setIsChanged(false);
        this.bAdd.setEnabled(this.sortTabController.isReadWrite());
        this.bRemove.setEnabled(this.sortTabController.isReadWrite());
        this.bUp.setEnabled(this.sortTabController.isReadWrite());
        this.bDown.setEnabled(this.sortTabController.isReadWrite());
        this.yesList.setEnabled(this.sortTabController.isReadWrite());
        this.noList.setEnabled(this.sortTabController.isReadWrite());
    }

    private void setIsChanged(boolean value) {
        if (this.m_aPanel != null) {
            this.m_aPanel.aSave.setEnabled(value);
            this.m_aPanel.aIgnore.setEnabled(value);
        }
    }

    void migrateValueAcrossLists(AWTEvent event) {
        Object source = event.getSource();
        List selObjects = source == this.bAdd || source == this.noList ? this.noList.getSelectedValuesList() : this.yesList.getSelectedValuesList();
        for (ListElement itemSelected : selObjects) {
            if (itemSelected == null || !itemSelected.isUpdateable()) continue;
            if (source == this.bAdd || source == this.noList) {
                this.noModel.removeElement(itemSelected);
                this.yesModel.addElement(itemSelected);
                this.yesList.setSelectedValue(itemSelected, true);
            } else {
                this.yesModel.removeElement(itemSelected);
                this.noModel.addElement(itemSelected);
                this.noList.setSelectedValue(itemSelected, true);
            }
            this.setIsChanged(true);
        }
    }

    void migrateValueWithinYesList(AWTEvent event) {
        Object[] selObjects = this.yesList.getSelectedValues();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        boolean change = false;
        Object source = event.getSource();
        if (source == this.bUp) {
            for (int i = 0; i < length; ++i) {
                ListElement selObject = (ListElement)selObjects[i];
                int index = indices[i];
                if (index == 0) break;
                ListElement newObject = this.yesModel.getElementAt(index - 1);
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt(newObject, index);
                    this.yesModel.setElementAt(selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            for (int i = length - 1; i >= 0; --i) {
                ListElement selObject = (ListElement)selObjects[i];
                int index = indices[i];
                if (index >= this.yesModel.size() - 1) break;
                ListElement newObject = this.yesModel.getElementAt(index + 1);
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt(newObject, index);
                    this.yesModel.setElementAt(selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    continue;
                }
                break;
            }
        } else if (source != this.yesList) {
            log.severe("Unknown source: " + source);
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            this.setIsChanged(true);
        }
    }

    @Override
    public void registerAPanel(APanel panel) {
        this.m_aPanel = panel;
    }

    @Override
    public void saveData() {
        if (!this.m_aPanel.aSave.isEnabled()) {
            return;
        }
        log.fine("");
        String info = this.sortTabController.saveData(Collections.list(this.noModel.elements()), Collections.list(this.yesModel.elements()));
        if (info == null) {
            this.setIsChanged(false);
        } else {
            ADialog.error(this.windowNo, null, "SaveError", info);
        }
    }

    @Override
    public void unregisterPanel() {
        this.saveData();
        this.m_aPanel = null;
    }

    private class DragListener
    extends MouseInputAdapter {
        private String cursorName = "/org/compiere/images/DragCursor32.gif";
        private JList startList = null;
        private DefaultListModel startModel = null;
        private Object selObject = null;
        private boolean moved = false;
        private Cursor customCursor;

        public DragListener() {
            URL url = VSortTab.class.getResource(this.cursorName);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(url);
            this.customCursor = toolkit.createCustomCursor(image, new Point(0, 0), "Howdy");
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Point p2;
            JList list = (JList)me.getComponent();
            int index = list.locationToIndex(p2 = me.getPoint());
            if (index > -1 && list.getCellBounds(index, index).contains(p2)) {
                this.startList = list;
                this.startModel = list == VSortTab.this.noList ? VSortTab.this.noModel : VSortTab.this.yesModel;
                this.selObject = list.getModel().getElementAt(index);
            }
            if (list == VSortTab.this.noList) {
                VSortTab.this.yesList.clearSelection();
            } else {
                VSortTab.this.noList.clearSelection();
            }
            this.moved = false;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (this.selObject == null || !((ListElement)this.selObject).isUpdateable()) {
                this.moved = false;
                return;
            }
            this.moved = true;
            if (VSortTab.this.getCursor() != this.customCursor) {
                VSortTab.this.setCursor(this.customCursor);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (this.startModel != null && this.moved) {
                int index;
                Point p2 = me.getPoint();
                JList endList = VSortTab.this.yesList;
                DefaultListModel endModel = VSortTab.this.yesModel;
                if (me.getComponent() == VSortTab.this.yesList) {
                    if (!VSortTab.this.yesList.contains(p2)) {
                        endList = VSortTab.this.noList;
                        endModel = VSortTab.this.noModel;
                    }
                } else {
                    if (VSortTab.this.noList.contains(p2)) {
                        VSortTab.this.setCursor(Cursor.getDefaultCursor());
                        this.moved = false;
                        return;
                    }
                    p2 = SwingUtilities.convertPoint(VSortTab.this.noList, p2, VSortTab.this.yesList);
                }
                if ((index = endList.locationToIndex(p2)) > -1) {
                    this.startModel.removeElement(this.selObject);
                    endModel.add(index, this.selObject);
                    this.startList.clearSelection();
                    endList.clearSelection();
                    endList.setSelectedValue(this.selObject, true);
                    VSortTab.this.setIsChanged(true);
                }
            }
            this.startList = null;
            this.startModel = null;
            this.selObject = null;
            this.moved = false;
            VSortTab.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

