/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.cm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class StringUtil {
    public static StringBuffer replace(StringBuffer original, String search, String replace) {
        return StringUtil.doReplace(original, search, replace, false, true);
    }

    public static String replace(String original, String search, String replace) {
        if (original == null) {
            original = "";
        }
        return StringUtil.doReplace(new StringBuffer(original), search, replace, false, true).toString();
    }

    public static String replace(String original, char search, String replace) {
        if (original == null) {
            original = "";
        }
        return StringUtil.doReplace(new StringBuffer(original), search, replace, true).toString();
    }

    public static StringBuffer replace(StringBuffer original, String search, String replace, boolean ignoreCase, boolean allOccurences) {
        return StringUtil.doReplace(original, search, replace, ignoreCase, allOccurences);
    }

    public static String replace(String original, String search, String replace, boolean ignoreCase, boolean allOccurences) {
        if (original == null) {
            original = "";
        }
        return StringUtil.replace(new StringBuffer(original), search, replace, ignoreCase, allOccurences).toString();
    }

    public static StringBuffer replaceOne(StringBuffer original, String search, String replace) {
        if (original.toString().indexOf(search) >= 0) {
            original.replace(original.toString().indexOf(search), original.toString().indexOf(search) + search.length(), replace);
        }
        return original;
    }

    public static String replaceOne(String original, String search, String replace) {
        StringBuffer toriginal = new StringBuffer(original);
        if (toriginal.toString().indexOf(search) >= 0) {
            toriginal.replace(toriginal.toString().indexOf(search), toriginal.toString().indexOf(search) + search.length(), replace);
        }
        return toriginal.toString();
    }

    public static StringBuffer replaceRegex(StringBuffer original, String regex, String replace, boolean CASE_INSENSITIVE) {
        int flags = 0;
        if (CASE_INSENSITIVE) {
            flags = 2;
        }
        Pattern p2 = Pattern.compile(regex, flags);
        Matcher m = p2.matcher(original);
        StringBuffer newSB = new StringBuffer();
        boolean result = m.find();
        while (result) {
            m.appendReplacement(newSB, replace);
            result = m.find();
        }
        m.appendTail(newSB);
        return newSB;
    }

    public static String replaceRegex(String original, String regex, String replace, boolean CASE_INSENSITIVE) {
        return StringUtil.replaceRegex(new StringBuffer(original), regex, replace, CASE_INSENSITIVE).toString();
    }

    private static StringBuffer doReplace(StringBuffer original, String alt, String neu, boolean ignoreCase, boolean allOccurences) {
        int position = -1;
        if (alt == null) {
            alt = "";
        }
        if (neu == null) {
            neu = "";
        }
        if (original == null) {
            original = new StringBuffer("");
        }
        int altNeuDiff = neu.length() - alt.length();
        if (neu.lastIndexOf(alt) >= altNeuDiff) {
            altNeuDiff = neu.lastIndexOf(alt) + 1;
        }
        if (ignoreCase) {
            position = original.toString().toLowerCase().indexOf(alt.toLowerCase());
            while (position >= 0) {
                original.replace(position, position + alt.length(), neu);
                position = original.toString().toLowerCase().indexOf(alt.toLowerCase(), position + altNeuDiff);
            }
        } else {
            position = original.toString().indexOf(alt);
            while (position >= 0) {
                original.replace(position, position + alt.length(), neu);
                position = original.toString().indexOf(alt, position + altNeuDiff);
            }
        }
        return original;
    }

    private static StringBuffer doReplace(StringBuffer original, char alt, String neu, boolean allOccurences) {
        int position = -1;
        if (original == null) {
            original = new StringBuffer("");
        }
        int altNeuDiff = neu.length() - 1;
        if (neu.lastIndexOf(alt) >= altNeuDiff) {
            altNeuDiff = neu.lastIndexOf(alt) + 1;
        }
        position = original.toString().indexOf(alt);
        while (position >= 0) {
            original.replace(position, position + 1, neu);
            position = original.toString().indexOf(alt, position + altNeuDiff);
        }
        return original;
    }

    public static String[] split(String searchIn, String splitter) {
        String[] results = new String[StringUtil.count(searchIn, splitter) + 1];
        int position = 0;
        int i = 0;
        while (searchIn.indexOf(splitter, position) >= 0) {
            results[i] = searchIn.substring(position, searchIn.indexOf(splitter, position + 2));
            position = searchIn.indexOf(splitter, position) + 1;
            ++i;
        }
        results[results.length - 1] = searchIn.substring(position);
        return results;
    }

    public static String remove(String original, String toBeRemoved, boolean ignoreCase) {
        String thisResult = null;
        if (!toBeRemoved.equals("") && toBeRemoved != null) {
            thisResult = StringUtil.replace(original, toBeRemoved, "", ignoreCase, true);
        }
        return thisResult;
    }

    public static String getNextWord(String tempStr) {
        String word = "";
        word = tempStr.indexOf(32) >= 0 ? tempStr.substring(0, tempStr.indexOf(32)) : tempStr;
        return word;
    }

    public static String removeSpecialChar(String tempStr) {
        if (tempStr != null) {
            tempStr = StringUtil.replace(tempStr, ",", "", true, true);
            tempStr = StringUtil.replace(tempStr, ".", "", true, true);
            tempStr = StringUtil.replace(tempStr, "!", "", true, true);
            tempStr = StringUtil.replace(tempStr, "?", "", true, true);
            tempStr = StringUtil.replace(tempStr, "'", "", true, true);
            tempStr = StringUtil.replace(tempStr, ":", "", true, true);
            tempStr = StringUtil.replace(tempStr, "(", "", true, true);
            tempStr = StringUtil.replace(tempStr, ")", "", true, true);
            tempStr = StringUtil.replace(tempStr, "+", "", true, true);
            tempStr = StringUtil.replace(tempStr, "-", "", true, true);
            tempStr = StringUtil.replace(tempStr, ">", "", true, true);
            tempStr = StringUtil.replace(tempStr, "<", "", true, true);
            tempStr = StringUtil.replace(tempStr, "/", "", true, true);
            while (tempStr.indexOf("  ") > 0) {
                tempStr = StringUtil.replace(tempStr, "  ", " ", true, true);
            }
            tempStr = StringUtil.replace(tempStr, "\t", " ", true, true);
        }
        return tempStr;
    }

    public static int count(String orig, String find) {
        int retVal = 0;
        int pos = 0;
        while (orig.indexOf(find, pos) > 0) {
            pos = orig.indexOf(find, pos) + 1;
            ++retVal;
        }
        return retVal;
    }

    public static String crc(String tempStr) throws IOException {
        int c;
        Adler32 inChecker = new Adler32();
        CheckedInputStream in = null;
        in = new CheckedInputStream(new ByteArrayInputStream(tempStr.getBytes()), inChecker);
        while ((c = in.read()) != -1) {
            c = 0;
        }
        String myCheckSum = "" + inChecker.getValue();
        return myCheckSum;
    }
}

