/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.wf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.compiere.apps.wf.WFLayoutManager;
import org.compiere.apps.wf.WFLine;
import org.compiere.apps.wf.WFNode;
import org.compiere.apps.wf.WFPanel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;

public class WFContentPanel
extends CPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = 4868946962536126669L;
    private WFPanel m_parent = null;
    private static CLogger log = CLogger.getCLogger(WFContentPanel.class);
    private ArrayList<WFNode> m_nodes = new ArrayList();
    private ArrayList<WFLine> m_lines = new ArrayList();
    private Point m_draggedStart = null;
    private WFNode m_draggedNode = null;
    private boolean m_dragged = false;
    private boolean m_readWrite = false;
    private MWorkflow m_wf = null;
    private JPopupMenu m_NewPopupMenu = new JPopupMenu();
    private CMenuItem m_NewMenuNode = new CMenuItem(Msg.getMsg(Env.getCtx(), "CreateNewNode"));
    private JPopupMenu m_LinePopupMenu = null;

    public WFContentPanel(WFPanel parent) {
        super(new WFLayoutManager());
        this.m_parent = parent;
        this.m_NewPopupMenu.add(this.m_NewMenuNode);
        this.m_NewMenuNode.addActionListener(this);
    }

    public void setReadWrite(boolean readWrite) {
        this.m_readWrite = readWrite;
        if (this.m_readWrite) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
        }
    }

    public void setWorkflow(MWorkflow wf) {
        this.m_wf = wf;
    }

    @Override
    public void removeAll() {
        this.m_nodes.clear();
        this.m_lines.clear();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
        }
        super.removeAll();
    }

    public Component add(Component comp, boolean rw) {
        if (comp instanceof WFLine) {
            this.m_lines.add((WFLine)comp);
            return comp;
        }
        if (comp instanceof WFNode) {
            this.m_nodes.add((WFNode)comp);
            comp.addMouseListener(this);
            if (this.m_readWrite && rw) {
                comp.addMouseMotionListener(this);
            }
        }
        return super.add(comp);
    }

    protected void createLines() {
        log.fine("Lines #" + this.m_lines.size());
        for (int i = 0; i < this.m_lines.size(); ++i) {
            WFLine line = this.m_lines.get(i);
            Rectangle from = this.findBounds(line.getAD_WF_Node_ID());
            Rectangle to = this.findBounds(line.getAD_WF_Next_ID());
            line.setFromTo(from, to);
        }
    }

    private Rectangle findBounds(int AD_WF_Node_ID) {
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            WFNode node = this.m_nodes.get(i);
            if (node.getAD_WF_Node_ID() != AD_WF_Node_ID) continue;
            return node.getBounds();
        }
        return null;
    }

    @Override
    public Component getComponentAt(Point p2) {
        return this.getComponentAt(p2.x, p2.y);
    }

    @Override
    public Component getComponentAt(int x, int y) {
        Component comp = super.getComponentAt(x, y);
        if (comp instanceof WFNode) {
            return comp;
        }
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            int yy;
            int xx;
            WFNode node = this.m_nodes.get(i);
            if (!node.contains(xx = x - node.getX(), yy = y - node.getY())) continue;
            return node;
        }
        return comp;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        block9: {
            block7: {
                int AD_Client_ID;
                block8: {
                    if (!this.m_readWrite || !SwingUtilities.isRightMouseButton(e)) break block7;
                    AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
                    if (e.getSource() != this || this.m_wf == null) break block8;
                    this.m_NewPopupMenu.show(this, e.getX(), e.getY());
                    break block9;
                }
                if (!(e.getSource() instanceof WFNode)) break block9;
                MWFNode node = ((WFNode)e.getSource()).getModel();
                this.m_LinePopupMenu = new JPopupMenu(node.getName());
                if (node.getAD_Client_ID() == AD_Client_ID) {
                    String title = Msg.getMsg(Env.getCtx(), "DeleteNode") + ": " + node.getName();
                    this.addMenuItem(this.m_LinePopupMenu, title, node, -1);
                    this.m_LinePopupMenu.addSeparator();
                }
                MWFNode[] nodes = this.m_wf.getNodes(true, AD_Client_ID);
                MWFNodeNext[] lines = node.getTransitions(AD_Client_ID);
                for (int n = 0; n < nodes.length; ++n) {
                    MWFNode nn = nodes[n];
                    if (nn.getAD_WF_Node_ID() == node.getAD_WF_Node_ID()) continue;
                    boolean found = false;
                    for (int i = 0; i < lines.length; ++i) {
                        MWFNodeNext line = lines[i];
                        if (nn.getAD_WF_Node_ID() != line.getAD_WF_Next_ID()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    String title = Msg.getMsg(Env.getCtx(), "AddLine") + ": " + node.getName() + " -> " + nn.getName();
                    this.addMenuItem(this.m_LinePopupMenu, title, node, nn.getAD_WF_Node_ID());
                }
                this.m_LinePopupMenu.addSeparator();
                for (int i = 0; i < lines.length; ++i) {
                    MWFNodeNext line = lines[i];
                    if (line.getAD_Client_ID() != AD_Client_ID) continue;
                    MWFNode next = MWFNode.get(Env.getCtx(), line.getAD_WF_Next_ID());
                    String title = Msg.getMsg(Env.getCtx(), "DeleteLine") + ": " + node.getName() + " -> " + next.getName();
                    this.addMenuItem(this.m_LinePopupMenu, title, line);
                }
                this.m_LinePopupMenu.show(this, e.getX(), e.getY());
                break block9;
            }
            if (e.getSource() instanceof WFNode) {
                WFNode selected = (WFNode)e.getSource();
                log.fine(selected.toString());
                for (int i = 0; i < this.m_nodes.size(); ++i) {
                    WFNode node = this.m_nodes.get(i);
                    if (selected.getAD_WF_Node_ID() == node.getAD_WF_Node_ID()) {
                        node.setSelected(true);
                        continue;
                    }
                    node.setSelected(false);
                }
            }
        }
        this.m_dragged = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof WFNode) {
            WFNode node = (WFNode)e.getSource();
            if (node.isEditable()) {
                this.m_draggedNode = node;
                this.m_draggedStart = SwingUtilities.convertPoint(this.m_draggedNode, e.getX(), e.getY(), this);
            } else {
                this.m_dragged = false;
                this.m_draggedNode = null;
                this.m_draggedStart = null;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((this.m_draggedNode == null || e.getSource() != this.m_draggedNode) && e.getSource() instanceof WFNode) {
            WFNode node = (WFNode)e.getSource();
            if (node.isEditable()) {
                this.m_draggedNode = node;
            }
            this.m_draggedStart = null;
        }
        if (this.m_draggedNode != null) {
            this.m_dragged = true;
            if (this.m_draggedStart == null) {
                this.m_draggedStart = SwingUtilities.convertPoint(this.m_draggedNode, e.getX(), e.getY(), this);
            }
            Point mousePosition = SwingUtilities.convertPoint(this.m_draggedNode, e.getX(), e.getY(), this);
            int xDelta = mousePosition.x - this.m_draggedStart.x;
            int yDelta = mousePosition.y - this.m_draggedStart.y;
            Point newLocation = this.m_draggedNode.getLocation();
            newLocation.x += xDelta;
            if (newLocation.x < 0) {
                newLocation.x = 0;
            }
            newLocation.y += yDelta;
            if (newLocation.y < 0) {
                newLocation.y = 0;
            }
            this.m_draggedNode.setLocation(newLocation.x, newLocation.y);
            this.m_draggedStart = mousePosition;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_dragged = false;
        this.m_draggedNode = null;
        this.m_draggedStart = null;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < this.m_lines.size(); ++i) {
            WFLine line = this.m_lines.get(i);
            line.paint(g);
        }
        if (this.m_dragged && this.m_draggedNode != null) {
            Point loc = this.m_draggedNode.getLocation();
            String text = "(" + loc.x + "," + loc.y + ")";
            Graphics2D g2D = (Graphics2D)g;
            Font font = new Font("Dialog", 0, 10);
            g2D.setColor(Color.magenta);
            TextLayout layout = new TextLayout(text, font, g2D.getFontRenderContext());
            loc.x += this.m_draggedNode.getWidth();
            loc.y = (int)((float)loc.y + layout.getAscent());
            layout.draw(g2D, loc.x, loc.y);
        }
    }

    private void addMenuItem(JPopupMenu menu, String title, MWFNode node, int AD_WF_NodeTo_ID) {
        WFPopupItem item = new WFPopupItem(title, node, AD_WF_NodeTo_ID);
        menu.add(item);
        item.addActionListener(this);
    }

    private void addMenuItem(JPopupMenu menu, String title, MWFNodeNext line) {
        WFPopupItem item = new WFPopupItem(title, line);
        menu.add(item);
        item.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.toString());
        if (e.getSource() == this.m_NewMenuNode) {
            log.info("Create New Node");
            String nameLabel = Util.cleanAmp(Msg.getMsg(Env.getCtx(), "Name"));
            String name = JOptionPane.showInputDialog(this, nameLabel, Msg.getMsg(Env.getCtx(), "CreateNewNode"), 3);
            if (name != null && name.length() > 0) {
                int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
                MWFNode node = new MWFNode(this.m_wf, name, name);
                node.setClientOrg(AD_Client_ID, 0);
                node.saveEx();
                this.m_parent.load(this.m_wf.getAD_Workflow_ID(), true);
            }
        } else if (e.getSource() instanceof WFPopupItem) {
            WFPopupItem item = (WFPopupItem)e.getSource();
            item.execute();
        }
    }

    class WFPopupItem
    extends JMenuItem {
        private static final long serialVersionUID = 4634863991042969718L;
        private MWFNode m_node;
        private MWFNodeNext m_line;
        private int m_AD_WF_NodeTo_ID;

        public WFPopupItem(String title, MWFNode node, int AD_WF_NodeTo_ID) {
            super(title);
            this.m_node = node;
            this.m_AD_WF_NodeTo_ID = AD_WF_NodeTo_ID;
        }

        public WFPopupItem(String title, MWFNodeNext line) {
            super(title);
            this.m_line = line;
        }

        public void execute() {
            if (this.m_node != null && this.m_AD_WF_NodeTo_ID > 0) {
                int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
                MWFNodeNext newLine = new MWFNodeNext(this.m_node, this.m_AD_WF_NodeTo_ID);
                newLine.setClientOrg(AD_Client_ID, 0);
                newLine.saveEx();
                log.info("Add Line to " + this.m_node + " -> " + newLine);
                WFContentPanel.this.m_parent.load(WFContentPanel.this.m_wf.getAD_Workflow_ID(), true);
            } else if (this.m_node != null && this.m_AD_WF_NodeTo_ID == -1) {
                log.info("Delete Node: " + this.m_node);
                this.m_node.delete(false);
                WFContentPanel.this.m_parent.load(WFContentPanel.this.m_wf.getAD_Workflow_ID(), true);
            } else if (this.m_line != null) {
                log.info("Delete Line: " + this.m_line);
                this.m_line.delete(false);
                WFContentPanel.this.m_parent.load(WFContentPanel.this.m_wf.getAD_Workflow_ID(), true);
            } else {
                log.severe("No Action??");
            }
        }
    }
}

