/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoCashLine
extends Info {
    private static final long serialVersionUID = -3315036454469996930L;
    private int fieldID = 0;
    private CLabel lCash_ID = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private VLookup fCash_ID;
    private CLabel lCashBook_ID = new CLabel(Msg.translate(Env.getCtx(), "C_CashBook_ID"));
    private VLookup fCashBook_ID;
    private CLabel lInvoice_ID = new CLabel(Msg.translate(Env.getCtx(), "C_Invoice_ID"));
    private VLookup fInvoice_ID;
    private CLabel lPayment_ID = new CLabel(Msg.translate(Env.getCtx(), "C_Payment_ID"));
    private VLookup fPayment_ID;
    private CLabel lCharge_ID = new CLabel(Msg.translate(Env.getCtx(), "C_Charge_ID"));
    private VLookup fCharge_ID;
    private CLabel lBankAccount_ID = new CLabel(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
    private VLookup fBankAccount_ID;
    private VCheckBox cbAbsolute = new VCheckBox();
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "StatementDate"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-  ");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "Amount"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("-  ");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private static String s_From = "C_CashLine cl INNER JOIN C_Cash c ON (cl.C_Cash_ID=c.C_Cash_ID)";
    private static String s_Order = "2,3,cl.Line";
    private static final Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "cl.C_CashLine_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_CashBook_ID"), "(SELECT cb.Name FROM C_CashBook cb WHERE cb.C_CashBook_ID=c.C_CashBook_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Cash_ID"), "c.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "StatementDate"), "c.StatementDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "Line"), "cl.Line", Integer.class), new Info_Column(Msg.translate(Env.getCtx(), "CashType"), "(SELECT arl.Name AS list_value FROM AD_Ref_List arl, AD_Reference ar WHERE arl.AD_Reference_ID = ar.AD_Reference_ID AND ar.Name = 'C_Cash Trx Type' AND arl.Value = cl.CashType)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Amount"), "cl.Amount", BigDecimal.class, true, true, null), new Info_Column(Msg.translate(Env.getCtx(), "C_Invoice_ID"), "(SELECT i.DocumentNo||'_'||" + DB.TO_CHAR("i.DateInvoiced", 15, Env.getAD_Language(Env.getCtx())) + "||'_'||" + DB.TO_CHAR("i.GrandTotal", 12, Env.getAD_Language(Env.getCtx())) + " FROM C_Invoice i WHERE i.C_Invoice_ID=cl.C_Invoice_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Payment_ID"), "(SELECT p.DocumentNo||'_'||" + DB.TO_CHAR("p.DateTrx", 15, Env.getAD_Language(Env.getCtx())) + "||'_'||" + DB.TO_CHAR("p.PayAmt", 12, Env.getAD_Language(Env.getCtx())) + " FROM C_Payment p WHERE p.C_Payment_ID=cl.C_Payment_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Charge_ID"), "(SELECT ca.Name FROM C_Charge ca WHERE ca.C_Charge_ID=cl.C_Charge_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BankAccount_ID"), "(SELECT b.Name||' '||ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=cl.C_BankAccount_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DiscountAmt"), "cl.DiscountAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "WriteOffAmt"), "cl.WriteOffAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "cl.Description", String.class)};

    @Deprecated
    protected InfoCashLine(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    protected InfoCashLine(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "cl", "C_CashLine_ID", multiSelection, saveResults, whereClause);
        this.log.info("InfoCashLine");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoCashLine"));
        StringBuffer where = new StringBuffer("cl.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_CashLine.", "cl."));
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.setShowTotals(true);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fCash_ID;
        if (this.autoQuery() || record_id != 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.fCash_ID = new VLookup("C_Cash_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, this.p_TabNo, MColumn.getColumn_ID("C_Cash", "C_Cash_ID"), 30));
        this.lCash_ID.setLabelFor(this.fCash_ID);
        this.fCash_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fCash_ID.addActionListener(this);
        this.fCashBook_ID = new VLookup("C_CashBook_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_Cash", "C_CashBook_ID"), 19));
        this.lCashBook_ID.setLabelFor(this.fCashBook_ID);
        this.fCashBook_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fCashBook_ID.addActionListener(this);
        this.fInvoice_ID = new VLookup("C_Invoice_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_CashLine", "C_Invoice_ID"), 30));
        this.lInvoice_ID.setLabelFor(this.fInvoice_ID);
        this.fInvoice_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fInvoice_ID.addActionListener(this);
        this.fPayment_ID = new VLookup("C_Payment_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_CashLine", "C_Payment_ID"), 30));
        this.lPayment_ID.setLabelFor(this.fPayment_ID);
        this.fPayment_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fPayment_ID.addActionListener(this);
        this.fBankAccount_ID = new VLookup("C_BankAccount_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_CashLine", "C_BankAccount_ID"), 19));
        this.lBankAccount_ID.setLabelFor(this.fBankAccount_ID);
        this.fBankAccount_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBankAccount_ID.addActionListener(this);
        this.fCharge_ID = new VLookup("C_Charge_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_CashLine", "C_Charge_ID"), 19));
        this.fCharge_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fCharge_ID.addActionListener(this);
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.fDateFrom.addActionListener(this);
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.fDateTo.addActionListener(this);
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.fAmtFrom.addActionListener(this);
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.fAmtTo.addActionListener(this);
        this.cbAbsolute.setText(Msg.translate(Env.getCtx(), "AbsoluteAmt"));
        this.cbAbsolute.setName("AbsoluteAmt");
        this.cbAbsolute.setToolTipText(Msg.getMsg(Env.getCtx(), "AbsoluteAmt"));
        this.cbAbsolute.setSelected(false);
        this.cbAbsolute.addActionListener(this);
        CPanel amtPanel = new CPanel();
        CPanel datePanel = new CPanel();
        amtPanel.setLayout(new ALayout(0, 0, true));
        amtPanel.add((Component)this.fAmtFrom, new ALayoutConstraint(0, 0));
        amtPanel.add((Component)this.lAmtTo, null);
        amtPanel.add((Component)this.fAmtTo, null);
        datePanel.setLayout(new ALayout(0, 0, true));
        datePanel.add((Component)this.fDateFrom, new ALayoutConstraint(0, 0));
        datePanel.add((Component)this.lDateTo, null);
        datePanel.add((Component)this.fDateTo, null);
        this.p_criteriaGrid.setLayout(new ALayout());
        this.p_criteriaGrid.add((Component)this.lCashBook_ID, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fCashBook_ID, null);
        this.p_criteriaGrid.add((Component)this.lCash_ID, null);
        this.p_criteriaGrid.add((Component)this.fCash_ID, null);
        this.p_criteriaGrid.add((Component)this.lInvoice_ID, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fInvoice_ID, null);
        this.p_criteriaGrid.add((Component)this.lPayment_ID, null);
        this.p_criteriaGrid.add((Component)this.fPayment_ID, null);
        this.p_criteriaGrid.add((Component)this.lBankAccount_ID, new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fBankAccount_ID, null);
        this.p_criteriaGrid.add((Component)this.lDateFrom, null);
        this.p_criteriaGrid.add((Component)datePanel, null);
        this.p_criteriaGrid.add((Component)this.lCharge_ID, new ALayoutConstraint(3, 0));
        this.p_criteriaGrid.add((Component)this.fCharge_ID, null);
        this.p_criteriaGrid.add((Component)this.lAmtFrom, null);
        this.p_criteriaGrid.add((Component)amtPanel, null);
        this.p_criteriaGrid.add((Component)this.cbAbsolute, new ALayoutConstraint(3, 5));
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
        } else if (value == null || value.length() <= 0) {
            String id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_CashLine_ID", true);
            if (id != null && id.length() != 0 && new Integer(id) > 0) {
                this.fieldID = new Integer(id);
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Cash_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fCash_ID.setValue((int)new Integer(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Invoice_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fInvoice_ID.setValue((int)new Integer(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Payment_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fPayment_ID.setValue((int)new Integer(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_CashBook_ID")) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fCashBook_ID.setValue((int)new Integer(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BankAccount_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fBankAccount_ID.setValue((int)new Integer(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Charge_ID", true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fCharge_ID.setValue((int)new Integer(id));
            }
        }
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoCashLine.zoom");
        Integer C_CashLine_ID = record_ID;
        if (C_CashLine_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_CashLine");
        query.setZoomTableName("C_CashLine");
        query.setZoomColumnName("C_CashLine_ID");
        query.setZoomValue(C_CashLine_ID);
        query.addRestriction("C_CashLine_ID", "=", C_CashLine_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Cash", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND cl.C_CashLine_ID = ?");
        }
        if (this.fCash_ID.getValue() != null) {
            sql.append(" AND c.C_Cash_ID=?");
        }
        if (this.fCashBook_ID.getValue() != null) {
            sql.append(" AND c.C_CashBook_ID=?");
        }
        if (this.fBankAccount_ID.getValue() != null) {
            sql.append(" AND cl.C_BankAccount_ID=?");
        }
        if (this.fCharge_ID.getValue() != null) {
            sql.append(" AND cl.C_Charge_ID=?");
        }
        if (this.fInvoice_ID.getValue() != null && this.fPayment_ID.getValue() == null) {
            sql.append(" AND cl.C_Invoice_ID=?");
        } else if (this.fInvoice_ID.getValue() == null && this.fPayment_ID.getValue() != null) {
            sql.append(" AND cl.C_Payment_ID=?");
        } else if (this.fInvoice_ID.getValue() != null && this.fPayment_ID.getValue() != null) {
            sql.append(" AND (cl.C_Invoice_ID=?");
            sql.append(" OR cl.C_Payment_ID=?)");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(c.StatementDate, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(c.StatementDate, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(c.StatementDate, 'DD') BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (this.cbAbsolute.isSelected()) {
                sql.append(" AND ABS(cl.Amount)");
            } else {
                sql.append(" AND cl.Amount");
            }
            if (from == null && to != null) {
                sql.append(" <=?");
            } else if (from != null && to == null) {
                sql.append(" >=?");
            } else if (from != null && to != null) {
                if (((BigDecimal)from).compareTo((BigDecimal)to) == 0) {
                    sql.append(" =?");
                } else {
                    sql.append(" BETWEEN ? AND ?");
                }
            }
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        Integer i;
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
        }
        if (this.fCash_ID.getValue() != null) {
            i = (Integer)this.fCash_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("Cash Journal=" + i);
        }
        if (this.fCashBook_ID.getValue() != null) {
            i = (Integer)this.fCashBook_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("CashBook=" + i);
        }
        if (this.fBankAccount_ID.getValue() != null) {
            i = (Integer)this.fBankAccount_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("BankAccount=" + i);
        }
        if (this.fCharge_ID.getValue() != null) {
            i = (Integer)this.fCharge_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("Charge=" + i);
        }
        if (this.fInvoice_ID.getValue() != null) {
            i = (Integer)this.fInvoice_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("Invoice=" + i);
        }
        if (this.fPayment_ID.getValue() != null) {
            i = (Integer)this.fPayment_ID.getValue();
            pstmt.setInt(index++, i);
            this.log.fine("Payment=" + i);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (this.cbAbsolute.isSelected()) {
                if (from != null) {
                    from = ((BigDecimal)from).abs();
                }
                if (to != null) {
                    to = ((BigDecimal)to).abs();
                }
            }
            this.log.fine("Amt From=" + from + ", To=" + to + ", Absolute=" + this.cbAbsolute.isSelected());
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                if (((BigDecimal)from).compareTo((BigDecimal)to) == 0) {
                    pstmt.setBigDecimal(index++, (BigDecimal)from);
                } else {
                    pstmt.setBigDecimal(index++, (BigDecimal)from);
                    pstmt.setBigDecimal(index++, (BigDecimal)to);
                }
            }
        }
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fAmtFrom.hasChanged() || this.fAmtTo.hasChanged() || this.fBankAccount_ID.hasChanged() || this.fCash_ID.hasChanged() || this.fCashBook_ID.hasChanged() || this.fCharge_ID.hasChanged() || this.fDateFrom.hasChanged() || this.fDateTo.hasChanged() || this.fInvoice_ID.hasChanged() || this.fPayment_ID.hasChanged() || this.cbAbsolute.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fAmtFrom.set_oldValue();
        this.fAmtTo.set_oldValue();
        this.fBankAccount_ID.set_oldValue();
        this.fCash_ID.set_oldValue();
        this.fCashBook_ID.set_oldValue();
        this.fCharge_ID.set_oldValue();
        this.fDateFrom.set_oldValue();
        this.fDateTo.set_oldValue();
        this.fInvoice_ID.set_oldValue();
        this.fPayment_ID.set_oldValue();
        this.cbAbsolute.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        Object nullObject = null;
        this.fAmtFrom.setValue(nullObject);
        this.fAmtTo.setValue(nullObject);
        this.fBankAccount_ID.setValue(null);
        this.fCash_ID.setValue(null);
        this.fCashBook_ID.setValue(null);
        this.fCharge_ID.setValue(null);
        this.fDateFrom.setValue(null);
        this.fDateTo.setValue(null);
        this.fInvoice_ID.setValue(null);
        this.fPayment_ID.setValue(null);
        this.cbAbsolute.setSelected(false);
    }
}

