/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.apps.search.InvoiceHistory;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLocation;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InfoBPartner
extends Info
implements PropertyChangeListener,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 5550733934685665946L;
    private boolean m_isSOTrx = false;
    private boolean m_isSOMatch = true;
    private int m_AD_User_ID_index = -1;
    private int m_C_BPartner_Location_ID_index = -1;
    private static String s_From = "C_BPartner";
    private static String s_Order = "C_BPartner.Value";
    private static Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "C_BPartner.C_BPartner_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Value"), "C_BPartner.Value", String.class), new Info_Column("Raz\u00f3n Social", "C_BPartner.Name", String.class), new Info_Column("Nombre Fantas\u00eda", "C_BPartner.Name2", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BP_Group_ID"), "(SELECT bpg.Name FROM C_BP_Group bpg WHERE bpg.C_BP_Group_ID = C_BPartner.C_BP_Group_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "TotalOpenBalance"), "C_BPartner.TotalOpenBalance", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "SO_CreditAvailable"), "C_BPartner.SO_CreditLimit-C_BPartner.SO_CreditUsed AS SO_CreditAvailable", BigDecimal.class, true, true, null), new Info_Column(Msg.translate(Env.getCtx(), "SO_CreditUsed"), "C_BPartner.SO_CreditUsed", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Revenue"), "C_BPartner.ActualLifetimeValue", BigDecimal.class)};
    private int fieldID = 0;
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel labelName2 = new CLabel();
    private CTextField fieldName2 = new CTextField(10);
    private CLabel labelContact = new CLabel();
    private CTextField fieldContact = new CTextField(10);
    private CLabel labelEMail = new CLabel();
    private CTextField fieldEMail = new CTextField(10);
    private CLabel labelPostal = new CLabel();
    private CTextField fieldPostal = new CTextField(10);
    private CLabel labelPhone = new CLabel();
    private CTextField fieldPhone = new CTextField(10);
    private VCheckBox checkAND = new VCheckBox();
    private VCheckBox checkCustomer = new VCheckBox();
    private CPanel tablePanel = new CPanel();
    private CTabbedPane jTab = new CTabbedPane();
    private MiniTable contactTbl = new MiniTable();
    private MiniTable addressTbl = new MiniTable();
    private String m_sqlContact;
    private String m_sqlAddress;
    private int m_C_BPartner_ID = 0;
    private static int ADDRESS_INDEX;

    @Deprecated
    public InfoBPartner(Frame frame, boolean modal, int WindowNo, String value, boolean isSOTrx, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, isSOTrx, true, multiSelection, true, whereClause);
    }

    public InfoBPartner(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean isSOTrx, boolean isSOMatch, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "C_BPartner", "C_BPartner_ID", multiSelection, saveResults, whereClause);
        this.log.info(value);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoBPartner"));
        this.m_isSOTrx = isSOTrx;
        this.m_isSOMatch = isSOMatch;
        StringBuffer where = new StringBuffer();
        where.append("C_BPartner.IsSummary='N' AND C_BPartner.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.setShowTotals(true);
        this.statInit();
        this.initInfo(record_id, value);
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText("Raz\u00f3n Social");
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.labelName2.setText("Nombre Fantas\u00eda");
        this.fieldName2.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName2.addActionListener(this);
        this.labelContact.setText(Msg.getMsg(Env.getCtx(), "Contact"));
        this.fieldContact.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldContact.addActionListener(this);
        this.labelEMail.setText(Msg.getMsg(Env.getCtx(), "EMail"));
        this.fieldEMail.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldEMail.addActionListener(this);
        this.labelPostal.setText(Msg.getMsg(Env.getCtx(), "Postal"));
        this.fieldPostal.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldPostal.addActionListener(this);
        this.labelPhone.setText(Msg.translate(Env.getCtx(), "Phone"));
        this.fieldPhone.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldPhone.addActionListener(this);
        this.checkAND.setText(Msg.getMsg(Env.getCtx(), "SearchAND"));
        this.checkAND.setToolTipText(Msg.getMsg(Env.getCtx(), "SearchANDInfo"));
        this.checkAND.setSelected(true);
        this.checkAND.addActionListener(this);
        if (this.m_isSOTrx) {
            this.checkCustomer.setText(Msg.getMsg(Env.getCtx(), "OnlyCustomers"));
        } else {
            this.checkCustomer.setText(Msg.getMsg(Env.getCtx(), "OnlyVendors"));
        }
        this.checkCustomer.setSelected(this.m_isSOMatch);
        this.checkCustomer.addActionListener(this);
        this.p_criteriaGrid.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fieldValue, null);
        this.p_criteriaGrid.add((Component)this.labelContact, null);
        this.p_criteriaGrid.add((Component)this.fieldContact, null);
        this.p_criteriaGrid.add((Component)this.checkCustomer, null);
        this.p_criteriaGrid.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fieldName, null);
        this.p_criteriaGrid.add((Component)this.labelName2, null);
        this.p_criteriaGrid.add((Component)this.fieldName2, null);
        this.p_criteriaGrid.add((Component)this.checkAND, null);
        this.p_criteriaGrid.add((Component)this.labelEMail, new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fieldEMail, null);
        this.p_criteriaGrid.add((Component)this.labelPostal, null);
        this.p_criteriaGrid.add((Component)this.fieldPostal, null);
        this.p_criteriaGrid.add((Component)this.labelPhone, null);
        this.p_criteriaGrid.add((Component)this.fieldPhone, null);
        ColumnInfo[] s_layoutContact = new ColumnInfo[]{new ColumnInfo(" ", "AD_User_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_Greeting_ID"), "(SELECT g.Greeting from C_Greeting g WHERE g.C_Greeting_ID = AD_User.C_Greeting_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Title"), "Title", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_Location_ID"), "(SELECT a.Name from C_BPartner_Location a WHERE AD_User.C_BPartner_Location_ID=a.C_BPartner_Location_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone"), "Phone", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone2"), "Phone2", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Fax"), "Fax", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "EMail"), "EMail", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LastContact"), "LastContact", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LastResult"), "LastResult", String.class)};
        String s_sqlFrom = "AD_User";
        String s_sqlWhere = "C_BPartner_ID = ?  and IsActive = 'Y'";
        this.m_sqlContact = this.contactTbl.prepareTable(s_layoutContact, s_sqlFrom, s_sqlWhere, false, "AD_User");
        this.contactTbl.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.contactTbl.setRowSelectionAllowed(true);
        this.contactTbl.setMultiSelection(false);
        this.contactTbl.addMouseListener(this);
        this.contactTbl.setShowTotals(false);
        this.contactTbl.autoSize();
        this.contactTbl.setBackground(new ColorUIResource(251, 248, 241));
        this.contactTbl.setForeground(new ColorUIResource(251, 0, 0));
        ColumnInfo[] s_layoutAddress = new ColumnInfo[]{new ColumnInfo(" ", "l.C_BPartner_Location_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "l.Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone"), "l.Phone", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone2"), "l.Phone2", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Fax"), "l.Fax", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Address"), "a.Address1", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsShipTo"), "l.IsShipTo", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsBillTo"), "l.IsBillTo", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsRemitTo"), "l.IsRemitTo", Boolean.class), new ColumnInfo(Msg.translate(Env.getCtx(), "IsPayFrom"), "l.IsPayFrom", Boolean.class)};
        ADDRESS_INDEX = 5;
        String s_locationFrom = "C_BPartner_Location l LEFT OUTER JOIN C_Location a ON (l.C_Location_ID=a.C_Location_ID)";
        String s_locationWhere = "l.C_BPartner_ID = ? and l.IsActive = 'Y'";
        this.m_sqlAddress = this.addressTbl.prepareTable(s_layoutAddress, s_locationFrom, s_locationWhere, false, "l");
        this.addressTbl.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.addressTbl.setRowSelectionAllowed(true);
        this.addressTbl.setMultiSelection(false);
        this.addressTbl.addMouseListener(this);
        this.addressTbl.setShowTotals(false);
        this.addressTbl.autoSize();
        this.addressTbl.setBackground(new ColorUIResource(251, 248, 241));
        this.addressTbl.setForeground(new ColorUIResource(251, 0, 0));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Contact"), new JScrollPane(this.contactTbl));
        this.jTab.addTab(Msg.translate(Env.getCtx(), "Location"), new JScrollPane(this.addressTbl));
        this.jTab.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 250 : 105));
        this.tablePanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.jTab, "Center");
        this.p_detailTaskPane.setTitle(Msg.translate(Env.getCtx(), "ContactAndAddress"));
        this.p_detailTaskPane.add((Component)this.tablePanel, (Object)"Center");
        this.p_detailTaskPane.setVisible(true);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        for (int i = 0; i < s_Layout.length; ++i) {
            if (s_Layout[i].getIDcolSQL().indexOf("AD_User_ID") != -1) {
                this.m_AD_User_ID_index = i;
            }
            if (s_Layout[i].getIDcolSQL().indexOf("C_BPartner_Location_ID") == -1) continue;
            this.m_C_BPartner_Location_ID_index = i;
        }
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
        } else if (value != null && value.length() > 0) {
            if (!value.matches(".*\\D+.*")) {
                this.fieldValue.setText(value);
            } else if (MSysConfig.getBooleanValue("UY_SET_NAME2_BP_SEARCH", false, Env.getAD_Client_ID(Env.getCtx()))) {
                this.fieldName2.setText(value);
            } else {
                this.fieldName.setText(value);
            }
        } else {
            String bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
            if (bp != null && bp.length() != 0) {
                this.fieldID = new Integer(bp);
            }
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                InfoBPartner.this.log.finest(InfoBPartner.this.m_sqlContact);
                try {
                    pstmt = DB.prepareStatement(InfoBPartner.this.m_sqlContact, null);
                    pstmt.setInt(1, InfoBPartner.this.m_C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    InfoBPartner.this.contactTbl.loadTable(rs);
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        InfoBPartner.this.log.log(Level.WARNING, InfoBPartner.this.m_sqlContact, e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                InfoBPartner.this.log.finest(InfoBPartner.this.m_sqlAddress);
                try {
                    pstmt = DB.prepareStatement(InfoBPartner.this.m_sqlAddress, null);
                    pstmt.setInt(1, InfoBPartner.this.m_C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    InfoBPartner.this.addressTbl.loadTable(rs);
                    rs.close();
                }
                catch (Exception e) {
                    InfoBPartner.this.log.log(Level.WARNING, InfoBPartner.this.m_sqlContact, e);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                String trxName = Trx.createTrxName();
                for (int row = 0; row < InfoBPartner.this.addressTbl.getRowCount(); ++row) {
                    int loc_id = 0;
                    Object loc_data = InfoBPartner.this.addressTbl.getValueAt(row, InfoBPartner.this.addressTbl.getKeyColumnIndex());
                    if (loc_data != null && loc_data instanceof IDColumn) {
                        IDColumn dataColumn = (IDColumn)loc_data;
                        loc_id = dataColumn.getRecord_ID();
                    }
                    MLocation loc = MLocation.getBPLocation(Env.getCtx(), loc_id, trxName);
                    InfoBPartner.this.addressTbl.setValueAt(loc.toString(), row, ADDRESS_INDEX);
                }
                Trx.get(trxName, false).close();
                InfoBPartner.this.addressTbl.autoSize();
            }
        });
    }

    @Override
    protected void recordSelected(int key) {
        this.m_C_BPartner_ID = this.getSelectedRowKey();
        this.refresh();
        this.p_detailTaskPane.setCollapsed(false);
    }

    @Override
    protected void noRecordSelected() {
        this.m_C_BPartner_ID = 0;
        this.p_detailTaskPane.setCollapsed(true);
    }

    @Override
    protected String getSQLWhere() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            list.add("C_BPartner.C_BPartner_ID = ?");
        }
        if (InfoBPartner.isValidSQLText(this.fieldValue)) {
            list.add("UPPER(C_BPartner.Value) LIKE ?");
        }
        if (InfoBPartner.isValidSQLText(this.fieldName)) {
            list.add("UPPER(C_BPartner.Name) LIKE ?");
        }
        if (InfoBPartner.isValidSQLText(this.fieldName2)) {
            list.add("UPPER(C_BPartner.Name2) LIKE ?");
        }
        if (InfoBPartner.isValidSQLText(this.fieldContact)) {
            list.add("C_BPartner.C_BPartner_ID IN (SELECT C_BPartner_ID from AD_User c WHERE UPPER(c.Name) LIKE ?)");
        }
        if (InfoBPartner.isValidSQLText(this.fieldEMail)) {
            list.add("C_BPartner.C_BPartner_ID IN (SELECT C_BPartner_ID from AD_User c WHERE UPPER(c.EMail) LIKE ?)");
        }
        if (InfoBPartner.isValidSQLText(this.fieldPhone)) {
            list.add("C_BPartner.C_BPartner_ID IN (SELECT C_BPartner_ID from AD_User c WHERE UPPER(c.Phone) LIKE ?)");
        }
        if (InfoBPartner.isValidSQLText(this.fieldPostal)) {
            list.add("C_BPartner_ID IN (Select C_BPartner_ID FROM C_BPartner_Location bpl, C_Location l where l.C_Location_ID = bpl.C_Location_ID AND UPPER(Postal) LIKE ?)");
        }
        StringBuffer sql = new StringBuffer();
        int size = list.size();
        if (size == 1) {
            sql.append(" AND ").append((String)list.get(0));
        } else if (size > 1) {
            boolean AND = this.checkAND.isSelected();
            sql.append(" AND ");
            if (!AND) {
                sql.append("(");
            }
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sql.append(AND ? " AND " : " OR ");
                }
                sql.append((String)list.get(i));
            }
            if (!AND) {
                sql.append(")");
            }
        }
        if (this.checkCustomer.isSelected()) {
            sql.append(" AND ");
            if (this.m_isSOTrx) {
                sql.append("C_BPartner.IsCustomer='Y'");
            } else {
                sql.append("C_BPartner.IsVendor='Y'");
            }
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
            this.log.fine("Record ID: " + this.fieldID);
        }
        if (InfoBPartner.isValidSQLText(this.fieldValue)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldValue));
            this.log.fine("Value: " + this.fieldValue.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldName)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldName));
            this.log.fine("Name: " + this.fieldName.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldName2)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldName2));
            this.log.fine("Name2: " + this.fieldName2.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldContact)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldContact));
            this.log.fine("Contact: " + this.fieldContact.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldEMail)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldEMail));
            this.log.fine("EMail: " + this.fieldEMail.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldPhone)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldPhone));
            this.log.fine("Phone: " + this.fieldPhone.getText());
        }
        if (InfoBPartner.isValidSQLText(this.fieldPostal)) {
            pstmt.setString(index++, InfoBPartner.getSQLText(this.fieldPostal));
            this.log.fine("Postal: " + this.fieldPostal);
        }
    }

    @Override
    public void saveSelectionDetail() {
        Object data;
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        int AD_User_ID = 0;
        int C_BPartner_Location_ID = 0;
        if (this.m_AD_User_ID_index != -1 && (data = this.p_table.getModel().getValueAt(row, this.m_AD_User_ID_index)) instanceof KeyNamePair) {
            AD_User_ID = ((KeyNamePair)data).getKey();
        }
        if (this.m_C_BPartner_Location_ID_index != -1 && (data = this.p_table.getModel().getValueAt(row, this.m_C_BPartner_Location_ID_index)) instanceof KeyNamePair) {
            C_BPartner_Location_ID = ((KeyNamePair)data).getKey();
        }
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "C_BPartner_ID", ID == null ? "0" : ID.toString());
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "AD_User_ID", String.valueOf(AD_User_ID));
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "C_BPartner_Location_ID", String.valueOf(C_BPartner_Location_ID));
    }

    @Override
    protected void showHistory(int record_id) {
        this.log.info("");
        int C_BPartner_ID = record_id;
        if (C_BPartner_ID <= 0) {
            return;
        }
        InvoiceHistory ih = new InvoiceHistory(this, C_BPartner_ID, 0, 0, 0);
        ih.setVisible(true);
        ih = null;
    }

    @Override
    protected boolean hasHistory() {
        return true;
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoBPartner.zoom");
        Integer C_BPartner_ID = record_ID;
        if (C_BPartner_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_BPartner");
        query.addRestriction("C_BPartner_ID", "=", C_BPartner_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_BPartner", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    protected void set_isSOTrx(boolean trx) {
        this.m_isSOTrx = trx;
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fieldValue.hasChanged() || this.fieldName.hasChanged() || this.fieldName2.hasChanged() || this.fieldContact.hasChanged() || this.fieldEMail.hasChanged() || this.fieldPostal.hasChanged() || this.fieldPhone.hasChanged() || this.checkAND.hasChanged() || this.checkCustomer.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fieldValue.set_oldValue();
        this.fieldName.set_oldValue();
        this.fieldName2.set_oldValue();
        this.fieldContact.set_oldValue();
        this.fieldEMail.set_oldValue();
        this.fieldPostal.set_oldValue();
        this.fieldPhone.set_oldValue();
        this.checkAND.set_oldValue();
        this.checkCustomer.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        this.fieldValue.setValue("");
        this.fieldName.setValue("");
        this.fieldName2.setValue("");
        this.fieldContact.setValue("");
        this.fieldEMail.setValue("");
        this.fieldPostal.setValue("");
        this.fieldPhone.setValue("");
        this.checkCustomer.setSelected(this.m_isSOMatch);
        this.checkAND.setSelected(true);
    }
}

