/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.myJTree;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class VTreeBOM
extends CPanel
implements FormPanel,
ActionListener,
ListSelectionListener,
PropertyChangeListener,
VetoableChangeListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private myJTree m_tree;
    private static CLogger log = CLogger.getCLogger(VTreeBOM.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CPanel southPanel = new CPanel();
    private CPanel southPanel2 = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private FlowLayout southLayout2 = new FlowLayout();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct;
    private CCheckBox implosion = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private CLabel spacer = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane dataPane = new JScrollPane();
    private JScrollPane treePane = new JScrollPane();
    private DefaultTreeSelectionModel treeSelect = new DefaultTreeSelectionModel();
    private CCheckBox treeExpand = new CCheckBox();
    private CTextField treeSearch = new CTextField(10);
    private CLabel treeSearchLabel = new CLabel();
    private String m_search = "";
    private Enumeration<?> m_nodeEn;
    private Enumeration<?> m_childEn;
    private DefaultMutableTreeNode m_selectedNode;
    private int m_selected_id = 0;
    private MouseListener mouseListener = new VTreeBOM_mouseAdapter(this);
    private KeyListener keyListener = new VTreeBOM_keyAdapter(this);
    public static final String NODE_SELECTION = "NodeSelected";
    private DefaultMutableTreeNode m_root = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected StatusBar statusBar = new StatusBar();
    private MiniTable tableBOM = new MiniTable();
    private Vector<Vector<Object>> dataBOM = new Vector();
    private Vector<String> columnNames;
    private final int DIVIDER_LOCATION = 300;
    private boolean reload = false;
    private Language language = Language.getLoginLanguage();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mBOM;
    private CMenuItem mImplosion;
    private MLookup m_fieldProduct;

    public Properties getCtx() {
        return Env.getCtx();
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", ex);
        }
    }

    private void preInit() throws Exception {
        this.m_fieldProduct = MLookupFactory.get(this.getCtx(), this.m_WindowNo, MColumn.getColumn_ID("M_Product", "M_Product_ID"), 30, this.language, "M_Product_ID", 0, false, " M_Product.IsSummary = 'N'");
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, this.m_fieldProduct){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                VTreeBOM.this.action_loadBOM();
            }
        };
        this.implosion.addActionListener(this);
        this.splitPane.add((Component)this.dataPane, "right");
        this.splitPane.add((Component)this.treePane, "left");
    }

    private void loadTableBOM() {
        this.columnNames = new Vector(18);
        this.columnNames.add(Msg.translate(this.getCtx(), "Select"));
        this.columnNames.add(Msg.translate(this.getCtx(), "IsActive"));
        this.columnNames.add(Msg.translate(this.getCtx(), "Line"));
        this.columnNames.add(Msg.translate(this.getCtx(), "M_Product_ID"));
        this.columnNames.add(Msg.translate(this.getCtx(), "C_UOM_ID"));
        this.columnNames.add(Msg.translate(this.getCtx(), "QtyBOM"));
        this.tableBOM.getModel().removeTableModelListener(this);
        this.tableBOM.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(this.dataBOM, this.columnNames);
        model.addTableModelListener(this);
        this.tableBOM.setModel(model);
        this.tableBOM.setColumnClass(0, Boolean.class, false);
        this.tableBOM.setColumnClass(1, Boolean.class, false);
        this.tableBOM.setColumnClass(2, Integer.class, false);
        this.tableBOM.setColumnClass(3, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(4, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(5, BigDecimal.class, false);
        this.tableBOM.setMultiSelection(false);
        this.tableBOM.setColumnVisibility(this.tableBOM.getColumn(0), false);
        this.tableBOM.autoSize();
    }

    private void jbInit() {
        this.setLayout(this.mainLayout);
        this.setPreferredSize(new Dimension(640, 480));
        this.labelProduct.setText(Msg.getElement(this.getCtx(), "M_Product_ID"));
        this.implosion.setText(Msg.getElement(this.getCtx(), "Implosion"));
        this.treeInfo.setText("    ");
        this.spacer.setText("    ");
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.labelProduct, null);
        this.northPanel.add((Component)this.fieldProduct, null);
        this.northPanel.add((Component)this.implosion, null);
        this.northPanel.add((Component)this.spacer, null);
        this.northPanel.add((Component)this.spacer, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.treeExpand.setText(Msg.getMsg(Env.getCtx(), "ExpandTree"));
        this.treeExpand.setActionCommand("Expand");
        this.treeExpand.addMouseListener(this.mouseListener);
        this.treeExpand.addActionListener(this);
        this.treeSearchLabel.setText(Msg.getMsg(Env.getCtx(), "TreeSearch") + " ");
        this.treeSearchLabel.setLabelFor(this.treeSearch);
        this.treeSearchLabel.setToolTipText(Msg.getMsg(Env.getCtx(), "TreeSearchText"));
        this.treeSearch.setBackground(AdempierePLAF.getInfoBackground());
        this.treeSearch.addKeyListener(this.keyListener);
        this.add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.confirmPanel.addActionListener(this);
        this.southPanel.add((Component)this.confirmPanel, "South");
        this.southPanel2.setLayout(this.southLayout2);
        this.southLayout2.setAlignment(0);
        this.southPanel.add((Component)this.southPanel2, "North");
        this.southPanel2.add((Component)this.treeExpand, null);
        this.southPanel2.add((Component)this.spacer, null);
        this.southPanel2.add((Component)this.treeSearchLabel, null);
        this.southPanel2.add((Component)this.treeSearch, null);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(300);
        this.mBOM = new CMenuItem(Msg.getMsg(Env.getCtx(), "BOM"), Env.getImageIcon("Detail16.gif"));
        this.mBOM.addActionListener(this);
        this.popupMenu.add(this.mBOM);
        this.mImplosion = new CMenuItem(Msg.getMsg(Env.getCtx(), "Implosion"), Env.getImageIcon("Parent16.gif"));
        this.mImplosion.addActionListener(this);
        this.popupMenu.add(this.mImplosion);
    }

    protected void keyPressed(KeyEvent e) {
        if (e.getSource() instanceof myJTree || e.getSource() == this.treeSearch && e.getModifiers() != 0) {
            TreePath tp = this.m_tree.getSelectionPath();
            if (tp == null) {
                ADialog.beep();
            } else {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
                this.setSelectedNode(tn);
            }
        } else if (e.getSource() == this.treeSearch) {
            String search = this.treeSearch.getText();
            boolean found = false;
            if (this.m_nodeEn != null && !this.m_nodeEn.hasMoreElements()) {
                this.m_search = "";
            }
            if (!search.equals(this.m_search)) {
                this.m_nodeEn = this.m_root.preorderEnumeration();
                this.m_search = search;
            }
            while (!found && this.m_nodeEn != null && this.m_nodeEn.hasMoreElements()) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)this.m_nodeEn.nextElement();
                Vector nodeInfo = (Vector)nd.getUserObject();
                String uoName = ((KeyNamePair)nodeInfo.elementAt(3)).getName();
                if (uoName.toUpperCase().indexOf(search.toUpperCase()) == -1) continue;
                found = true;
                TreePath treePath = new TreePath(nd.getPath());
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.makeVisible(treePath);
                this.m_tree.scrollPathToVisible(treePath);
            }
            if (!found) {
                ADialog.beep();
            }
        }
    }

    private void setSelectedNode(DefaultMutableTreeNode nd) {
        log.config("Node = " + nd);
        this.m_selectedNode = nd;
        this.firePropertyChange(NODE_SELECTION, null, nd);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.info("VAllocation.vetoableChange - " + name + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("M_Product_ID") && this.fieldProduct != null) {
            this.action_loadBOM();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mBOM) {
            this.fieldProduct.setValue(this.m_selected_id);
            if (this.implosion.isSelected()) {
                this.implosion.doClick();
            }
        }
        if (e.getSource() == this.mImplosion) {
            this.fieldProduct.setValue(this.m_selected_id);
            if (!this.implosion.isSelected()) {
                this.implosion.doClick();
            }
        }
        if (e.getSource() == this.implosion) {
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Ok")) {
            this.action_loadBOM();
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() instanceof JCheckBox && e.getActionCommand().equals("Expand")) {
            this.expandTree();
        }
    }

    private void action_loadBOM() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.reload = false;
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return;
        }
        MProduct M_Product = MProduct.get(this.getCtx(), M_Product_ID);
        this.treeInfo.setText("    Current Selection: " + M_Product.getValue());
        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(M_Product.isActive()));
        line.add(new Integer(0));
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(M_Product.getC_UOM_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(Env.ONE);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(line);
        this.m_root = (DefaultMutableTreeNode)parent.getRoot();
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MProductBOM bomline : this.getParentBOMs(M_Product_ID)) {
                this.addParent(bomline, parent);
            }
            this.m_tree = new myJTree(parent);
            this.m_tree.addMouseListener(this.mouseListener);
        } else {
            for (MProductBOM bom : this.getChildBOMs(M_Product_ID, true)) {
                this.addChild(bom, parent);
            }
            this.m_tree = new myJTree(parent);
            this.m_tree.addMouseListener(this.mouseListener);
        }
        this.m_tree.addTreeSelectionListener(this);
        this.treePane.getViewport().add((Component)this.m_tree, null);
        this.loadTableBOM();
        this.dataPane.getViewport().add((Component)this.tableBOM, null);
        this.splitPane.setDividerLocation(300);
        this.m_frame.setCursor(Cursor.getDefaultCursor());
    }

    private void action_reloadBOM() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.reload = true;
        int M_Product_ID = this.m_selected_id;
        if (M_Product_ID == 0) {
            return;
        }
        MProduct M_Product = MProduct.get(this.getCtx(), M_Product_ID);
        this.treeInfo.setText("    Current Selection: " + M_Product.getValue());
        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(M_Product.isActive()));
        line.add(new Integer(0));
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(M_Product.getC_UOM_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(Env.ONE);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(line);
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MProductBOM bomline : this.getParentBOMs(M_Product_ID)) {
                this.addParent(bomline, parent);
            }
        } else {
            for (MProductBOM bom : this.getChildBOMs(M_Product_ID, true)) {
                this.addChild(bom, parent);
            }
        }
        this.loadTableBOM();
        this.m_frame.setCursor(Cursor.getDefaultCursor());
    }

    public void addChild(MProductBOM bomline, DefaultMutableTreeNode parent) {
        MProduct M_Product = MProduct.get(this.getCtx(), bomline.getM_ProductBOM_ID());
        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(bomline.isActive()));
        line.add(new Integer(bomline.getLine()));
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(M_Product.getC_UOM_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(bomline.getBOMQty() != null ? bomline.getBOMQty() : new BigDecimal(0));
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(line);
        parent.add(child);
        if (this.m_selected_id == bomline.getM_Product_ID() || this.getM_Product_ID() == bomline.getM_Product_ID()) {
            this.dataBOM.add(line);
        }
        if (this.reload) {
            return;
        }
        for (MProductBOM bom : this.getChildBOMs(bomline.getM_ProductBOM_ID(), false)) {
            this.addChild(bom, child);
        }
    }

    public void addParent(MProductBOM bom, DefaultMutableTreeNode parent) {
        MProduct M_Product = MProduct.get(this.getCtx(), bom.getM_Product_ID());
        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(M_Product.isActive()));
        line.add(new Integer(bom.getLine()));
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getValue().concat("_").concat(M_Product.getName()));
        line.add(pp);
        MUOM u = new MUOM(M_Product.getCtx(), M_Product.getC_UOM_ID(), M_Product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(M_Product.getC_UOM_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(bom.getBOMQty() != null ? bom.getBOMQty() : new BigDecimal(0));
        this.dataBOM.add(line);
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(line);
        parent.add(child);
        if (this.reload) {
            return;
        }
        for (MProductBOM bomline : this.getParentBOMs(bom.getM_Product_ID())) {
            this.addParent(bomline, child);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.m_selectedNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (this.m_selectedNode == null) {
            return;
        }
        Vector nodeInfo = (Vector)this.m_selectedNode.getUserObject();
        this.m_selected_id = ((KeyNamePair)nodeInfo.elementAt(3)).getKey();
        this.action_reloadBOM();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    private void expandTree() {
        if (this.treeExpand.isSelected()) {
            for (int row = 0; row < this.m_tree.getRowCount(); ++row) {
                this.m_tree.expandRow(row);
            }
        } else {
            for (int row = this.m_tree.getRowCount(); row > 0; --row) {
                this.m_tree.collapseRow(row);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    private boolean isImplosion() {
        return this.implosion.isSelected();
    }

    private int getM_Product_ID() {
        Integer Product = (Integer)this.fieldProduct.getValue();
        if (Product == null) {
            return 0;
        }
        return Product;
    }

    private List<MProductBOM> getChildBOMs(int M_Product_ID, boolean onlyActiveRecords) {
        String filter = "M_Product_ID=?" + (onlyActiveRecords ? " AND IsActive='Y'" : "");
        return new Query(this.getCtx(), "M_Product_BOM", filter, null).setParameters(M_Product_ID).list();
    }

    private List<MProductBOM> getParentBOMs(int M_Product_ID) {
        String filter = "M_ProductBOM_ID=?";
        return new Query(this.getCtx(), "M_Product_BOM", filter, null).setParameters(M_Product_ID).list();
    }

    class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int id, String name, String description, boolean isSummary, String imageIndicator) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.isSummary = isSummary;
            this.imageIndicator = imageIndicator;
        }

        public String toString() {
            String retValue = this.name;
            if (this.description != null && this.description.length() > 0) {
                retValue = retValue + " (" + this.description + ")";
            }
            return retValue;
        }
    }

    class VTreeBOM_keyAdapter
    extends KeyAdapter {
        VTreeBOM m_adaptee;

        VTreeBOM_keyAdapter(VTreeBOM adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.m_adaptee.keyPressed(e);
            }
        }
    }

    final class VTreeBOM_mouseAdapter
    extends MouseAdapter {
        private VTreeBOM m_adaptee;

        VTreeBOM_mouseAdapter(VTreeBOM adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            } else {
                this.m_adaptee.popupMenu.setVisible(false);
            }
        }
    }
}

