/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

@Deprecated
public class PayPrint {
    public int windowNo = 0;
    public int bankAccountId = -1;
    public String paymentExportClass = null;
    public int paySelectionId = 0;
    public List<MPaySelectionCheck> paySelectionChecks = new ArrayList<MPaySelectionCheck>();
    public MPaymentBatch paymentBatch = null;
    public static CLogger log = CLogger.getCLogger(PayPrint.class);
    public String bank;
    public String currency;
    public BigDecimal balance;
    public String noPayments;
    public Integer documentNo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPaySelectInfo(int paySelectionId) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block6: {
            this.bankAccountId = -1;
            String sql = "SELECT ps.C_BankAccount_ID, (b.Name || ' ' || ba.AccountNo) AS BankName, c.ISO_Code, CurrentBalance, dt.IsPayrollPayment, ba.PaymentExportClass, ba.PayrollPaymentExportClass FROM C_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_DocType dt ON(dt.C_DocType_ID = ps.C_DocType_ID) WHERE ps.C_PaySelection_ID=? AND ps.DocStatus IN('CO', 'CL') AND ba.IsActive='Y'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, paySelectionId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.bankAccountId = rs.getInt("C_BankAccount_ID");
                    this.bank = rs.getString("BankName");
                    this.currency = rs.getString("ISO_Code");
                    this.balance = rs.getBigDecimal("CurrentBalance");
                    String isPayrollPayment = rs.getString("IsPayrollPayment");
                    String payrollExportClass = rs.getString("PayrollPaymentExportClass");
                    this.paymentExportClass = rs.getString("PaymentExportClass");
                    if (!Util.isEmpty(isPayrollPayment) && isPayrollPayment.equals("Y") && !Util.isEmpty(payrollExportClass)) {
                        this.paymentExportClass = payrollExportClass;
                    }
                    break block6;
                }
                this.bankAccountId = -1;
                this.bank = "";
                this.currency = "";
                this.balance = Env.ZERO;
                this.paymentExportClass = null;
                log.log(Level.SEVERE, "No active BankAccount for C_PaySelection_ID=" + paySelectionId);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
    }

    public ArrayList<ValueNamePair> loadPaymentRule(int paySelectionId) {
        ArrayList<ValueNamePair> data = new ArrayList<ValueNamePair>();
        int AD_Reference_ID = 195;
        Language language = Language.getLanguage(Env.getAD_Language(Env.getCtx()));
        MLookupInfo info = MLookupFactory.getLookup_List(language, AD_Reference_ID);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_PaySelectionCheck WHERE C_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, paySelectionId);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                data.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (data.size() == 0) {
            log.config("PaySel=" + paySelectionId + ", BAcct=" + this.bankAccountId + " - " + sql);
        }
        return data;
    }

    public String loadPaymentRuleInfo(int paySelectionId, String paymentRule) {
        Integer paymentCount = new Query(Env.getCtx(), "C_PaySelectionCheck", "C_PaySelection_ID=?", null).setClient_ID().setParameters(paySelectionId).count();
        this.noPayments = String.valueOf(paymentCount);
        String msg = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append("CurrentNext").append(" FROM ").append("C_BankAccountDoc").append(" WHERE ").append("C_BankAccount_ID").append("=? AND ").append("PaymentRule").append("=? AND ").append("IsActive").append("=?");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.bankAccountId);
        parameters.add(paymentRule);
        parameters.add(true);
        this.documentNo = DB.getSQLValueEx(null, sql.toString(), parameters.toArray());
        if (this.documentNo == -1) {
            log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.bankAccountId + " AND PaymentRule=" + paymentRule);
            msg = "VPayPrintNoDoc";
        }
        return msg;
    }

    protected String getValidationCode() {
        return "C_PaySelection.DocStatus = 'CO' AND C_PaySelection.C_BankAccount_ID IS NOT NULL AND EXISTS(SELECT 1 FROM C_PaySelectionCheck psc \t\t\t\tLEFT JOIN C_Payment p ON(p.C_Payment_ID = psc.C_Payment_ID) \t\t\t\tWHERE psc.C_PaySelection_ID = C_PaySelection.C_PaySelection_ID \t\t\t\tAND (psc.C_Payment_ID IS NULL OR p.DocStatus NOT IN('CO', 'CL')))";
    }
}

