/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRMA;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InvoiceGen
extends GenForm {
    private static CLogger log = CLogger.getCLogger(InvoiceGen.class);
    public Object m_AD_Org_ID = null;
    public Object m_C_BPartner_ID = null;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("InvGenerateInfo");
        this.setReportEngineType(2);
        this.setAskPrintMsg("PrintInvoices");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("C_Order_ID");
        miniTable.addColumn("AD_Org_ID");
        miniTable.addColumn("C_DocType_ID");
        miniTable.addColumn("DocumentNo");
        miniTable.addColumn("C_BPartner_ID");
        miniTable.addColumn("POReference");
        miniTable.addColumn("DateOrdered");
        miniTable.addColumn("TotalLines");
        miniTable.setMultiSelection(true);
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
        miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "POReference"));
        miniTable.setColumnClass(6, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
        miniTable.setColumnClass(7, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        miniTable.autoSize();
    }

    private String getOrderSQL() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer("SELECT C_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, ic.POReference, DateOrdered, TotalLines FROM C_Invoice_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND ic.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MOrder.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append("C_Order_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        return sql.toString();
    }

    private String getRMASql() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT rma.M_RMA_ID, org.Name, dt.Name, rma.DocumentNo, bp.Name, rma.Created, rma.Amt ");
        sql.append("FROM M_RMA rma INNER JOIN AD_Org org ON rma.AD_Org_ID=org.AD_Org_ID ");
        sql.append("INNER JOIN C_DocType dt ON rma.C_DocType_ID=dt.C_DocType_ID ");
        sql.append("INNER JOIN C_BPartner bp ON rma.C_BPartner_ID=bp.C_BPartner_ID ");
        sql.append("INNER JOIN M_InOut io ON rma.InOut_ID=io.M_InOut_ID ");
        sql.append("WHERE rma.DocStatus='CO' ");
        sql.append("AND dt.DocBaseType = 'SOO' ");
        sql.append("AND rma.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND rma.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND bp.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MRMA.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            sql.append(" AND rma.M_RMA_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY org.Name, bp.Name, rma.Created ");
        return sql.toString();
    }

    public void executeQuery(KeyNamePair docTypeKNPair, IMiniTable miniTable) {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = "";
        sql = docTypeKNPair.getKey() == MOrder.Table_ID ? this.getOrderSQL() : this.getRMASql();
        int row = 0;
        miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                miniTable.setRowCount(row + 1);
                miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                miniTable.setValueAt(rs.getString(2), row, 1);
                miniTable.setValueAt(rs.getString(3), row, 2);
                miniTable.setValueAt(rs.getString(4), row, 3);
                miniTable.setValueAt(rs.getString(5), row, 4);
                miniTable.setValueAt(rs.getString(6), row, 5);
                miniTable.setValueAt(rs.getTimestamp(7), row, 6);
                miniTable.setValueAt(rs.getBigDecimal(8), row, 7);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        miniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    public String generate(IStatusBar statusBar, KeyNamePair docTypeKNPair, String docActionSelected) {
        String info = "";
        String trxName = Trx.createTrxName("IVG");
        Trx trx = Trx.get(trxName, true);
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InvGenerateGen"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int AD_Process_ID = 0;
        AD_Process_ID = docTypeKNPair.getKey() == MRMA.Table_ID ? 52002 : 134;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            info = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            return info;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.getSelection()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg;
                info = msg = "No Invoices";
                log.config(msg);
                trx.rollback();
                return info;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg;
            info = msg = "No Invoices";
            log.config(msg);
            trx.rollback();
            return info;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        para.setParameter("Selection", "Y");
        if (!para.save()) {
            String msg;
            info = msg = "No Selection Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        para = new MPInstancePara(instance, 20);
        para.setParameter("DocAction", docActionSelected);
        if (!para.save()) {
            String msg;
            info = msg = "No DocAction Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        this.setTrx(trx);
        this.setProcessInfo(pi);
        return info;
    }
}

