/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Date;
import org.compiere.print.CPaper;
import org.compiere.print.PrintUtil;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PrintScreenPainter
implements Pageable,
Printable {
    private Window m_element;

    public PrintScreenPainter(Window element) {
        this.m_element = element;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        CPaper paper = new CPaper(false);
        return paper.getPageFormat();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        String header = Msg.getMsg(Env.getCtx(), "PrintScreen") + " - " + DisplayType.getDateFormat(16).format(new Date());
        int y = g2.getFontMetrics().getHeight();
        g2.drawString(header, 0, y);
        g2.translate(0, 2 * y);
        double xRatio = pageFormat.getImageableWidth() / (double)this.m_element.getSize().width;
        double yRatio = (pageFormat.getImageableHeight() - (double)(2 * y)) / (double)this.m_element.getSize().height;
        double ratio = Math.min(Math.min(xRatio, yRatio), 1.0);
        g2.scale(ratio, ratio);
        this.m_element.printAll(g2);
        return 0;
    }

    public static void printScreen(Window element) {
        PrintUtil.print(new PrintScreenPainter(element), null, "PrintScreen", 1, false);
    }
}

