/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.Request;
import org.compiere.model.MQuery;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class ARequest
extends Request
implements ActionListener {
    private JPopupMenu popupMenu = new JPopupMenu("RequestMenu");
    private CMenuItem newMenuItem = null;
    private CMenuItem activeMenuItem = null;
    private CMenuItem allMenuItem = null;
    private GraphicsConfiguration graphicsConfiguration = null;
    private ArrayList<CMenuItem> menuItems = new ArrayList();
    protected static CLogger log = CLogger.getCLogger(ARequest.class);

    public ARequest(JComponent invoker, int tableId, int recordId, int partnerId) {
        log.config("AD_Table_ID=" + tableId + ", Record_ID=" + recordId);
        this.tableId = tableId;
        this.recordId = recordId;
        this.partnerId = partnerId;
        this.getRequests(invoker);
    }

    private void getRequests(JComponent invoker) {
        Long unprocessingCount;
        this.newMenuItem = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestNew"));
        this.newMenuItem.setIcon(Env.getImageIcon("New16.gif"));
        this.popupMenu.add(this.newMenuItem).addActionListener(this);
        this.graphicsConfiguration = invoker.getGraphicsConfiguration();
        this.buildWhereClause();
        Long processingCount = this.getProcessingCount();
        if (processingCount > 0L) {
            this.activeMenuItem = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestActive") + " (" + processingCount + ")");
            this.popupMenu.add(this.activeMenuItem).addActionListener(this);
        }
        if ((unprocessingCount = Long.valueOf(this.getUnprocessingCount())) > 0L) {
            this.allMenuItem = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestAll") + " (" + (processingCount + unprocessingCount) + ")");
            this.popupMenu.add(this.allMenuItem).addActionListener(this);
        }
        this.fillRequestList();
        if (invoker.isShowing()) {
            this.popupMenu.show(invoker, 0, invoker.getHeight());
        }
    }

    private void fillRequestList() {
        if (this.getCount() == 0) {
            return;
        }
        this.popupMenu.addSeparator();
        this.getRequestList().entrySet().stream().forEach(requestEntry -> {
            ValueNamePair requetInfo = (ValueNamePair)requestEntry.getValue();
            CMenuItem requestInfoMenu = new CMenuItem(requetInfo.getName());
            requestInfoMenu.setName((String)requestEntry.getKey());
            this.menuItems.add(requestInfoMenu);
            this.popupMenu.add(requestInfoMenu).addActionListener(this);
        });
        this.popupMenu.addSeparator();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MQuery query = null;
        if (actionEvent.getSource() == this.activeMenuItem) {
            query = new MQuery("");
            String where = "(" + this.whereClause + ") AND Processed='N'";
            query.addRestriction(where);
            query.setRecordCount(0);
        } else if (actionEvent.getSource() == this.allMenuItem) {
            query = new MQuery("");
            query.addRestriction(this.whereClause.toString());
            query.setRecordCount(0);
        } else if (actionEvent.getSource() == this.newMenuItem) {
            query = new MQuery("");
            query.addRestriction("1=2");
            query.setRecordCount(0);
        } else if (this.menuItems.contains(actionEvent.getSource())) {
            CMenuItem menuItem = (CMenuItem)actionEvent.getSource();
            query = new MQuery("");
            String where = "(" + this.whereClause + ") AND R_Request_ID=" + menuItem.getName();
            query.addRestriction(where);
            query.setRecordCount(0);
        }
        int windowId = 232;
        AWindow window = new AWindow(this.graphicsConfiguration);
        if (!window.initWindow(windowId, query)) {
            return;
        }
        AEnv.addToWindowManager(window);
        if (actionEvent.getSource() == this.newMenuItem) {
            this.defineGridTab(window.getAPanel().getCurrentTab());
        }
        AEnv.showCenterScreen(window);
        window = null;
    }
}

