/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.Preference;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.model.MRole;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public final class ADialogDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 5670261006862936363L;
    public static int A_OK = 0;
    public static int A_CANCEL = 1;
    public static int A_CLOSE = -1;
    private int m_returnCode = A_CLOSE;
    private static CLogger log = CLogger.getCLogger(ADialogDialog.class);
    private static Icon i_inform = Env.getImageIcon("Inform32.gif");
    private static Icon i_warn = Env.getImageIcon("Warn32.gif");
    private static Icon i_question = Env.getImageIcon("Question32.gif");
    private static Icon i_error = Env.getImageIcon("Error32.gif");
    private JMenuBar menuBar = new JMenuBar();
    private JMenu mFile = AEnv.getMenu("File");
    private CMenuItem mEMail = new CMenuItem();
    private CMenuItem mPrintScreen = new CMenuItem();
    private CMenuItem mScreenShot = new CMenuItem();
    private CMenuItem mEnd = new CMenuItem();
    private CMenuItem mPreference = new CMenuItem();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel westPanel = new CPanel();
    private CLabel iconLabel = new CLabel();
    private GridBagLayout westLayout = new GridBagLayout();
    private CTextPane info = new CTextPane();
    private GridBagLayout infoLayout = new GridBagLayout();
    private CPanel infoPanel = new CPanel();

    public ADialogDialog(Frame frame, String title, String message, int messageType) {
        super(frame, title, frame != null);
        this.common(message, messageType);
        AEnv.showCenterWindow(frame, this);
    }

    public ADialogDialog(Dialog dialog, String title, String message, int messageType) {
        super(dialog, title, dialog != null);
        this.common(message, messageType);
        AEnv.showCenterWindow(dialog, this);
    }

    private void common(String message, int messageType) {
        try {
            this.setInfoMessage(message);
            this.jbInit();
            this.setInfoIcon(messageType);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "ADialogDialog.common - " + ex.getMessage());
        }
        this.getRootPane().setDefaultButton(this.confirmPanel.getOKButton());
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.confirmPanel.getOKButton().requestFocusInWindow();
        }
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.menuBar);
        this.mEMail.setIcon(Env.getImageIcon("EMailSupport16.gif"));
        this.mEMail.setText(Msg.getMsg(Env.getCtx(), "EMailSupport"));
        this.mEMail.addActionListener(this);
        this.mPrintScreen.setIcon(Env.getImageIcon("PrintScreen16.gif"));
        this.mPrintScreen.setText(Msg.getMsg(Env.getCtx(), "PrintScreen"));
        this.mPrintScreen.setAccelerator(KeyStroke.getKeyStroke(154, 0));
        this.mPrintScreen.addActionListener(this);
        this.mScreenShot.setIcon(Env.getImageIcon("ScreenShot16.gif"));
        this.mScreenShot.setText(Msg.getMsg(Env.getCtx(), "ScreenShot"));
        this.mScreenShot.setAccelerator(KeyStroke.getKeyStroke(154, 1));
        this.mScreenShot.addActionListener(this);
        this.mPreference.setIcon(Env.getImageIcon("Preference16.gif"));
        this.mPreference.setText(Msg.getMsg(Env.getCtx(), "Preference"));
        this.mPreference.addActionListener(this);
        this.mEnd.setIcon(Env.getImageIcon("End16.gif"));
        this.mEnd.setText(Msg.getMsg(Env.getCtx(), "End"));
        this.mEnd.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.mEnd.addActionListener(this);
        this.westPanel.setLayout(this.westLayout);
        this.westPanel.setName("westPanel");
        this.westPanel.setRequestFocusEnabled(false);
        this.infoPanel.setLayout(this.infoLayout);
        this.infoPanel.setName("infoPanel");
        this.infoPanel.setRequestFocusEnabled(false);
        this.getContentPane().add((Component)this.confirmPanel, "South");
        this.getContentPane().add((Component)this.westPanel, "West");
        this.westPanel.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.infoPanel, "Center");
        this.infoPanel.add((Component)this.info, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.menuBar.add(this.mFile);
        this.mFile.add(this.mPrintScreen);
        this.mFile.add(this.mScreenShot);
        this.mFile.addSeparator();
        this.mFile.add(this.mEMail);
        if (MRole.getDefault().isShowPreference()) {
            this.mFile.add(this.mPreference);
        }
        this.mFile.addSeparator();
        this.mFile.add(this.mEnd);
        this.confirmPanel.addActionListener(this);
    }

    private void setInfoMessage(String message) {
        StringBuffer sb = new StringBuffer(message.length() + 20);
        sb.append("<b>");
        String html = Util.maskHTML(message);
        char[] chars = html.toCharArray();
        boolean first = true;
        int paras = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n') {
                if (first) {
                    sb.append("</b>");
                    first = false;
                }
                if (paras > 1) {
                    sb.append("<br>");
                } else {
                    sb.append("<p>");
                }
                ++paras;
                continue;
            }
            sb.append(c);
        }
        this.info.setText(sb.toString());
        Dimension size = this.info.getPreferredSize();
        size.width = 450;
        size.height = (Math.max(paras, message.length() / 60) + 1) * 30;
        size.height = Math.min(size.height, 600);
        this.info.setPreferredSize(size);
        this.info.setRequestFocusEnabled(false);
        this.info.setReadWrite(false);
        this.info.setOpaque(false);
        this.info.setBorder(null);
        this.info.setCaretPosition(0);
    }

    private void setInfoIcon(int messageType) {
        this.confirmPanel.getCancelButton().setVisible(false);
        switch (messageType) {
            case 0: {
                this.iconLabel.setIcon(i_error);
                break;
            }
            case 1: {
                this.iconLabel.setIcon(i_inform);
                break;
            }
            case 3: {
                this.confirmPanel.getCancelButton().setVisible(true);
                this.iconLabel.setIcon(i_question);
                break;
            }
            case 2: {
                this.iconLabel.setIcon(i_warn);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.m_returnCode = A_OK;
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel") || e.getSource() == this.mEnd) {
            this.m_returnCode = A_CANCEL;
            this.dispose();
        } else if (e.getSource() == this.mPrintScreen) {
            this.printScreen();
        } else if (e.getSource() == this.mEMail) {
            String title = this.getTitle();
            String text = this.info.getText();
            this.dispose();
            ADialog.createSupportEMail(this, title, text);
        } else if (e.getSource() == this.mPreference && MRole.getDefault().isShowPreference()) {
            Preference p2 = new Preference(null, 0);
            p2.setVisible(true);
        }
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }

    private void printScreen() {
        PrintScreenPainter.printScreen(this);
    }
}

