/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductInfo {
    private int m_M_Product_ID = 0;
    private String m_trxName = null;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private String m_productType = null;
    private String m_ProductCategory = null;
    private boolean m_isBOM = false;
    private boolean m_isStocked = true;
    private int m_C_RevenueRecognition_ID = 0;
    private int m_C_UOM_ID = 0;
    private BigDecimal m_qty = Env.ZERO;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public ProductInfo(int M_Product_ID, String trxName) {
        this.m_trxName = trxName;
        this.init(M_Product_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int M_Product_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block5: {
            this.m_M_Product_ID = M_Product_ID;
            if (this.m_M_Product_ID == 0) {
                return;
            }
            String sql = "SELECT p.ProductType, pc.Value, p.C_RevenueRecognition_ID,p.C_UOM_ID, p.AD_Client_ID,p.AD_Org_ID, p.IsBOM, p.IsStocked FROM M_Product_Category pc INNER JOIN M_Product p ON (pc.M_Product_Category_ID=p.M_Product_Category_ID) WHERE p.M_Product_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                this.m_productType = rs.getString(1);
                this.m_ProductCategory = rs.getString(2);
                this.m_C_RevenueRecognition_ID = rs.getInt(3);
                this.m_C_UOM_ID = rs.getInt(4);
                this.m_AD_Client_ID = rs.getInt(5);
                this.m_AD_Org_ID = rs.getInt(6);
                this.m_isBOM = "Y".equals(rs.getString(7));
                this.m_isStocked = "Y".equals(rs.getString(8));
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public boolean isProduct() {
        return "I".equals(this.m_productType);
    }

    public boolean isBOM() {
        return this.m_isBOM;
    }

    public boolean isStocked() {
        return this.m_isStocked;
    }

    public boolean isService() {
        return "S".equals(this.m_productType);
    }

    public String getProductCategory() {
        return this.m_ProductCategory;
    }

    public boolean isRevenueRecognition() {
        return this.m_C_RevenueRecognition_ID != 0;
    }

    public int getC_RevenueRecognition_ID() {
        return this.m_C_RevenueRecognition_ID;
    }

    public int getC_UOM_ID() {
        return this.m_C_UOM_ID;
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public void setQty(BigDecimal qty, int C_UOM_ID) {
        this.m_qty = MUOMConversion.convert(C_UOM_ID, this.m_C_UOM_ID, qty, true);
        if (qty != null && this.m_qty == null) {
            this.log.severe("Conversion error - set to " + qty);
            this.m_qty = qty;
        }
    }

    public BigDecimal getQty() {
        return this.m_qty;
    }

    private BigDecimal updateCosts(MAcctSchema as, boolean create) {
        if (create) {
            StringBuffer sql = new StringBuffer("INSERT INTO M_Product_Costing (M_Product_ID,C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy, CurrentCostPrice,CostStandard,FutureCostPrice, CostStandardPOQty,CostStandardPOAmt,CostStandardCumQty,CostStandardCumAmt, CostAverage,CostAverageCumQty,CostAverageCumAmt, PriceLastPO,PriceLastInv, TotalInvQty,TotalInvAmt) VALUES (");
            sql.append(this.m_M_Product_ID).append(",").append(as.getC_AcctSchema_ID()).append(",").append(this.m_AD_Client_ID).append(",").append(this.m_AD_Org_ID).append(",").append("'Y',SysDate,0,SysDate,0, 0,0,0,  0,0,0,0,  0,0,0,  0,0,  0,0)");
            int no = DB.executeUpdate(sql.toString(), this.m_trxName);
            if (no == 1) {
                this.log.fine("CostingCreated");
            }
        }
        String costSource = "PriceList-PO";
        BigDecimal costs = this.getPriceList(as, true);
        if (costs == null || costs.compareTo(Env.ZERO) == 0) {
            costSource = "PO Cost";
            costs = this.getPOCost(as);
        }
        if (costs == null || costs.compareTo(Env.ZERO) == 0) {
            costSource = "PriceList";
            costs = this.getPriceList(as, false);
        }
        if (costs == null || costs.compareTo(Env.ZERO) == 0) {
            costSource = "Not Found";
            costs = new BigDecimal("1");
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing ");
        sql.append("SET CurrentCostPrice=").append(costs).append(" WHERE M_Product_ID=").append(this.m_M_Product_ID).append(" AND C_AcctSchema_ID=").append(as.getC_AcctSchema_ID());
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        if (no == 1) {
            this.log.fine(costSource + " - " + costs);
        }
        return costs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPriceList(MAcctSchema as, boolean onlyPOPriceList) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal PriceLimit;
        BigDecimal PriceStd;
        BigDecimal PriceList;
        int C_Currency_ID;
        block9: {
            StringBuffer sql = new StringBuffer("SELECT pl.C_Currency_ID, pp.PriceList, pp.PriceStd, pp.PriceLimit FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pl.M_PriceList_ID = plv.M_PriceList_ID AND plv.M_PriceList_Version_ID = pp.M_PriceList_Version_ID AND pp.M_Product_ID=?");
            if (onlyPOPriceList) {
                sql.append(" AND pl.IsSOPriceList='N'");
            }
            sql.append(" ORDER BY pl.IsSOPriceList ASC, plv.ValidFrom DESC");
            C_Currency_ID = 0;
            PriceList = null;
            PriceStd = null;
            PriceLimit = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, this.m_M_Product_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block9;
                C_Currency_ID = rs.getInt(1);
                PriceList = rs.getBigDecimal(2);
                PriceStd = rs.getBigDecimal(3);
                PriceLimit = rs.getBigDecimal(4);
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (C_Currency_ID == 0) {
            return null;
        }
        BigDecimal price = PriceLimit;
        if (price == null || price.compareTo(Env.ZERO) == 0) {
            price = PriceStd;
        }
        if (price == null || price.compareTo(Env.ZERO) == 0) {
            price = PriceList;
        }
        if (price != null && price.compareTo(Env.ZERO) != 0) {
            price = MConversionRate.convert(as.getCtx(), price, C_Currency_ID, as.getC_Currency_ID(), as.getAD_Client_ID(), 0);
        }
        return price;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPOCost(MAcctSchema as) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal PriceLastPO;
        BigDecimal PricePO;
        BigDecimal PriceList;
        int C_Currency_ID;
        block8: {
            String sql = "SELECT C_Currency_ID, PriceList,PricePO,PriceLastPO FROM M_Product_PO WHERE M_Product_ID=? ORDER BY IsCurrentVendor DESC";
            C_Currency_ID = 0;
            PriceList = null;
            PricePO = null;
            PriceLastPO = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block8;
                C_Currency_ID = rs.getInt(1);
                PriceList = rs.getBigDecimal(2);
                PricePO = rs.getBigDecimal(3);
                PriceLastPO = rs.getBigDecimal(4);
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (C_Currency_ID == 0) {
            return null;
        }
        BigDecimal cost = PriceLastPO;
        if (cost == null || cost.compareTo(Env.ZERO) == 0) {
            cost = PricePO;
        }
        if (cost == null || cost.compareTo(Env.ZERO) == 0) {
            cost = PriceList;
        }
        if (cost != null && cost.compareTo(Env.ZERO) != 0) {
            cost = MConversionRate.convert(as.getCtx(), cost, C_Currency_ID, as.getC_Currency_ID(), this.m_AD_Client_ID, this.m_AD_Org_ID);
        }
        return cost;
    }
}

