/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_A_Asset;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationExp;
import org.compiere.util.Env;

public class Doc_DepreciationEntry
extends Doc {
    private String postingType = null;
    private int acctSchemaId = 0;

    public Doc_DepreciationEntry(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MDepreciationEntry.class, resultSet, null, string);
    }

    @Override
    protected String loadDocumentDetails() {
        MDepreciationEntry mDepreciationEntry = (MDepreciationEntry)this.getPO();
        this.postingType = mDepreciationEntry.getPostingType();
        this.acctSchemaId = mDepreciationEntry.getC_AcctSchema_ID();
        return null;
    }

    private DocLine createLine(MDepreciationExp mDepreciationExp) {
        if (!mDepreciationExp.isProcessed()) {
            return null;
        }
        DocLine docLine = new DocLine(mDepreciationExp, this);
        return docLine;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        return bigDecimal;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        ArrayList<Fact> arrayList = new ArrayList<Fact>();
        if (mAcctSchema.getC_AcctSchema_ID() != this.acctSchemaId) {
            return arrayList;
        }
        Fact fact = new Fact(this, mAcctSchema, this.postingType);
        MDepreciationEntry mDepreciationEntry = (MDepreciationEntry)this.getPO();
        Iterator<MDepreciationExp> iterator = mDepreciationEntry.getLinesIterator(false);
        while (iterator.hasNext()) {
            FactLine[] factLineArray;
            MDepreciationExp mDepreciationExp = iterator.next();
            I_A_Asset i_A_Asset = mDepreciationExp.getA_Asset();
            DocLine docLine = this.createLine(mDepreciationExp);
            BigDecimal bigDecimal = mDepreciationExp.getExpense();
            MAccount mAccount = MAccount.getValidCombination(this.getCtx(), mDepreciationExp.getDR_Account_ID(), this.getTrxName());
            MAccount mAccount2 = MAccount.getValidCombination(this.getCtx(), mDepreciationExp.getCR_Account_ID(), this.getTrxName());
            for (FactLine factLine : factLineArray = FactUtil.createSimpleOperation(fact, docLine, mAccount, mAccount2, mAcctSchema.getC_Currency_ID(), bigDecimal, false)) {
                StringBuilder stringBuilder = new StringBuilder(factLine.getDescription() != null ? factLine.getDescription() : "");
                stringBuilder.append(" ").append(i_A_Asset.getValue()).append(" ").append(i_A_Asset.getName());
                factLine.setDescription(stringBuilder.toString());
                factLine.setC_Project_ID(i_A_Asset.getC_Project_ID());
                factLine.setC_Activity_ID(i_A_Asset.getC_Activity_ID());
                factLine.setC_BPartner_ID(i_A_Asset.getC_BPartner_ID());
                factLine.setLocationFromBPartner(i_A_Asset.getC_BPartner_Location_ID(), true);
            }
        }
        arrayList.add(fact);
        return arrayList;
    }
}

