/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.Doc_AllocationTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Node;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.openup.core.model.MUYPayReceipt;

public class Doc_AllocationHdr
extends Doc {
    private static final BigDecimal TOLERANCE = new BigDecimal(0.02);
    private ArrayList<Fact> m_facts = null;
    ArrayList<Fact> factsElim = new ArrayList();
    private BigDecimal amtNCDef = Env.ZERO;
    private boolean ncSOTrx = true;

    public Doc_AllocationHdr(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MAllocationHdr.class, rs, "CMA", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        this.setDateDoc(alloc.getDateTrx());
        this.p_lines = this.loadLines(alloc);
        this.setInfoNCDef(alloc);
        return null;
    }

    private void setInfoNCDef(MAllocationHdr alloc) {
        String sql = "select coalesce(sum(l.amount),0) from c_allocationline l join c_invoice i on l.c_invoice_id = i.c_invoice_id join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where d.docbasetype in ('DRC','DPC') and c_allocationhdr_id = " + alloc.getC_AllocationHdr_ID();
        this.amtNCDef = DB.getSQLValueBDEx(alloc.get_TrxName(), sql, new Object[0]);
        sql = "select l.c_invoice_id from c_allocationline l join c_invoice i on l.c_invoice_id = i.c_invoice_id join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where d.docbasetype in ('DRC','DPC') and c_allocationhdr_id = " + alloc.getC_AllocationHdr_ID();
        int invoiceID = DB.getSQLValueEx(alloc.get_TrxName(), sql, new Object[0]);
        if (invoiceID > 0) {
            MInvoice inv = new MInvoice(alloc.getCtx(), invoiceID, alloc.get_TrxName());
            this.ncSOTrx = inv.isSOTrx();
        }
    }

    private DocLine[] loadLines(MAllocationHdr alloc) {
        ArrayList<DocLine_Allocation> list = new ArrayList<DocLine_Allocation>();
        MAllocationLine[] lines = alloc.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MAllocationLine line = lines[i];
            DocLine_Allocation docLine = new DocLine_Allocation(line, (Doc)this);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                int C_ConversionType_ID = payment.getC_ConversionType_ID();
                docLine.setC_ConversionType_ID(C_ConversionType_ID);
            }
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.m_facts = new ArrayList();
        Fact fact = new Fact(this, as, "A");
        Fact factForRGL = new Fact(this, as, "A");
        boolean isInterOrg = this.isInterOrg(as);
        for (int i = 0; i < this.p_lines.length; ++i) {
            MDocType docInv;
            X_C_Invoice invoice;
            MPayment payment;
            MAccount payAcct;
            MAccount bpAcct;
            BigDecimal payAllocationAccounted;
            BigDecimal payAllocationSource;
            BigDecimal allocationAccountedForRGL;
            BigDecimal allocationSourceForRGL;
            BigDecimal allocationSource;
            DocLine_Allocation line;
            block85: {
                FactLine flForRGL;
                FactLine fl;
                BigDecimal allocationAccounted;
                block86: {
                    block83: {
                        block84: {
                            line = (DocLine_Allocation)this.p_lines[i];
                            this.setC_BPartner_ID(line.getC_BPartner_ID());
                            if (line.getC_Payment_ID() != 0 && line.getC_Invoice_ID() == 0 && line.getC_Order_ID() == 0 && line.getC_CashLine_ID() == 0 && line.getC_BPartner_ID() == 0 && Env.ZERO.compareTo(line.getDiscountAmt()) == 0 && Env.ZERO.compareTo(line.getWriteOffAmt()) == 0) continue;
                            allocationSourceForRGL = allocationSource = line.getAmtSource().add(line.getDiscountAmt()).add(line.getWriteOffAmt());
                            allocationAccounted = Env.ZERO;
                            allocationAccountedForRGL = Env.ZERO;
                            payAllocationSource = line.getAmtSource();
                            payAllocationAccounted = Env.ZERO;
                            fl = null;
                            flForRGL = null;
                            bpAcct = null;
                            payAcct = null;
                            payment = null;
                            if (line.getC_Payment_ID() != 0) {
                                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                            }
                            invoice = null;
                            if (line.getC_Invoice_ID() != 0) {
                                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                            }
                            if (invoice != null) break block83;
                            if (line.getC_Invoice_ID() != 0 || line.getC_Payment_ID() != 0 || line.getC_Charge_ID() == 0) break block84;
                            fl = fact.createLine(line, line.getChargeAccount(as, line.getAmtSource()), this.getC_Currency_ID(), line.getAmtSource());
                            break block85;
                        }
                        if (line.getC_Invoice_ID() == 0 && line.getC_Payment_ID() != 0) {
                            payAcct = this.getPaymentAcct(as, line.getC_Payment_ID());
                            fl = fact.createLine(line, payAcct, this.getC_Currency_ID(), line.getAmtSource());
                            if (fl != null && payment != null) {
                                fl.setAD_Org_ID(payment.getAD_Org_ID());
                                payAllocationAccounted = fl.getAcctBalance();
                            }
                            break block85;
                        } else {
                            this.p_Error = "Cannot determine SO/PO";
                            this.log.log(Level.SEVERE, this.p_Error);
                            return null;
                        }
                    }
                    if (!invoice.isSOTrx()) break block86;
                    MDocType docTypeInvoice = new MDocType(this.getCtx(), invoice.getC_DocType_ID(), this.getTrxName());
                    if (line.getC_Payment_ID() != 0) {
                        payAcct = this.getPaymentAcct(as, line.getC_Payment_ID());
                    } else if (line.getC_CashLine_ID() != 0) {
                        payAcct = this.getCashAcct(as, line.getC_CashLine_ID());
                    }
                    MAccount acct_receivable = this.getAccount(1, as);
                    if (!as.isPostIfClearingEqual() && payAcct != null && payAcct.equals(acct_receivable) && !isInterOrg) {
                        allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                    } else if (line.getC_Payment_ID() != 0) {
                        fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), line.getAmtSource(), null);
                        if (fl != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                            payAllocationAccounted = fl.getAcctBalance();
                        }
                    } else if (line.getC_CashLine_ID() != 0) {
                        fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), line.getAmtSource(), null);
                        MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                        if (fl != null && cashLine.get_ID() != 0) {
                            fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                        }
                    }
                    if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(30, as), this.getC_Currency_ID(), line.getDiscountAmt(), null)) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), line.getWriteOffAmt(), null)) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (as.isAccrual()) {
                        bpAcct = this.getAccount(1, as);
                        if (docTypeInvoice.getDocBaseType() != null && docTypeInvoice.getDocBaseType().equalsIgnoreCase("DRI")) {
                            int acctID = DB.getSQLValueEx(this.getTrxName(), "select C_Receivable_Long_2_Acct from c_acctschema_default where ad_client_id = " + this.getAD_Client_ID(), new Object[0]);
                            if (acctID <= 0) throw new AdempiereException("No se encontro cuenta 'Documentos Diferidos por Cobrar' en esquema contable por defecto");
                            bpAcct = MAccount.get(this.getCtx(), acctID);
                        }
                        if ((fl = allocationSource.signum() >= 0 ? fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSource) : fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSource.negate(), null)) != null) {
                            allocationAccounted = fl.getAcctBalance().negate();
                        }
                        if (fl != null && invoice != null) {
                            fl.setAD_Org_ID(invoice.getAD_Org_ID());
                        }
                        if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSourceForRGL)) != null) {
                            allocationAccountedForRGL = flForRGL.getAcctBalance().negate();
                        }
                        break block85;
                    } else {
                        allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                    }
                    break block85;
                }
                MDocType docTypeInvoice = new MDocType(this.getCtx(), invoice.getC_DocType_ID(), this.getTrxName());
                Object acct_payment_select = null;
                if (line.getC_Payment_ID() != 0) {
                    payAcct = this.getPaymentAcct(as, line.getC_Payment_ID());
                } else if (line.getC_CashLine_ID() != 0) {
                    payAcct = this.getCashAcct(as, line.getC_CashLine_ID());
                }
                MAccount acct_liability = this.getAccount(2, as);
                boolean isUsingClearing = true;
                allocationSourceForRGL = allocationSourceForRGL.negate();
                if (!as.isPostIfClearingEqual() && payAcct != null && payAcct.equals(acct_liability) && !isInterOrg) {
                    allocationSource = line.getDiscountAmt().add(line.getWriteOffAmt());
                    isUsingClearing = false;
                }
                allocationSource = allocationSource.negate();
                if (as.isAccrual()) {
                    bpAcct = this.getAccount(2, as);
                    if (docTypeInvoice.getDocBaseType() != null && docTypeInvoice.getDocBaseType().equalsIgnoreCase("DPI")) {
                        int acctID = DB.getSQLValueEx(this.getTrxName(), "select C_Receivable_Long_Acct from c_acctschema_default where ad_client_id = " + this.getAD_Client_ID(), new Object[0]);
                        if (acctID <= 0) throw new AdempiereException("No se encontro cuenta 'Documentos Diferidos por Pagar' en esquema contable por defecto");
                        bpAcct = MAccount.get(this.getCtx(), acctID);
                    }
                    if ((fl = allocationSource.signum() >= 0 ? fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSource, null) : fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSource.negate())) != null) {
                        allocationAccounted = fl.getAcctBalance();
                    }
                    if (fl != null && invoice != null) {
                        fl.setAD_Org_ID(invoice.getAD_Org_ID());
                    }
                    if ((flForRGL = factForRGL.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSourceForRGL, null)) != null) {
                        allocationAccountedForRGL = flForRGL.getAcctBalance();
                    }
                } else {
                    allocationAccountedForRGL = allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                }
                if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(31, as), this.getC_Currency_ID(), null, line.getDiscountAmt().negate())) != null && payment != null) {
                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                }
                if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), null, line.getWriteOffAmt().negate())) != null && payment != null) {
                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                }
                if (isUsingClearing && line.getC_Payment_ID() != 0) {
                    fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), null, line.getAmtSource().negate());
                    if (fl != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                        payAllocationAccounted = fl.getAcctBalance();
                    }
                } else if (isUsingClearing && line.getC_CashLine_ID() != 0) {
                    fl = fact.createLine((DocLine)line, payAcct, this.getC_Currency_ID(), null, line.getAmtSource().negate());
                    MCashLine cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                    if (fl != null && cashLine.get_ID() != 0) {
                        fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                    }
                }
            }
            if (invoice != null && payment != null) {
                if (invoice.getDateAcct().compareTo(payment.getDateAcct()) != 0 || invoice.getC_Currency_ID() != payment.getC_Currency_ID()) {
                    String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL AND C_Tax_ID > 0";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        pstmt = DB.prepareStatement(sql, this.getTrxName());
                        pstmt.setInt(1, line.getC_Invoice_ID());
                        pstmt.setInt(2, as.getC_AcctSchema_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal currentyGainLossAmount;
                            BigDecimal percent;
                            MFactAcct factAcct = new MFactAcct(this.getCtx(), rs, fact.get_TrxName());
                            MTax tax = new MTax(Env.getCtx(), factAcct.getC_Tax_ID(), null);
                            String columnDebit = invoice.isSOTrx() ? "T_Liability_Acct" : "T_Receivables_Acct";
                            String sqlDebitTax = "SELECT C_ValidCombination_ID FROM C_ValidCombination WHERE C_ValidCombination_ID=( SELECT " + columnDebit + " FROM C_Tax_Acct WHERE C_Tax_ID=?)";
                            int accountDebitId = DB.getSQLValue(tax.get_TrxName(), sqlDebitTax, tax.get_ID());
                            MAccount accountDebitTax = MAccount.getValidCombination(this.getCtx(), accountDebitId, this.getTrxName());
                            MAccount gain = MAccount.getValidCombination(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct(), this.getTrxName());
                            MAccount loss = MAccount.getValidCombination(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct(), this.getTrxName());
                            int precision = as.getStdPrecision();
                            boolean debit = false;
                            BigDecimal invoiceSourceAmountTax = factAcct.getAmtSourceDr().add(factAcct.getAmtSourceCr());
                            MUYPayReceipt pr = null;
                            if (payment.get_ValueAsInt("UY_PayReceipt_ID") > 0) {
                                pr = new MUYPayReceipt(this.getCtx(), payment.get_ValueAsInt("UY_PayReceipt_ID"), this.getTrxName());
                                percent = MConversionRate.getRateDoc(rs.getInt("C_Currency_ID"), as.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), MUYPayReceipt.Table_ID, pr.get_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                            } else {
                                percent = MConversionRate.getRate(rs.getInt("C_Currency_ID"), as.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                            }
                            if (percent == null) {
                                percent = Env.ZERO;
                            }
                            int convTypeID = 0;
                            convTypeID = line.getC_ConversionType_ID() > 0 ? line.getC_ConversionType_ID() : invoice.getC_ConversionType_ID();
                            BigDecimal invoiceAmtSource = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), convTypeID, invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                            invoiceSourceAmountTax = invoiceSourceAmountTax.multiply(invoiceAmtSource).divide(invoice.getGrandTotal(), precision, 4);
                            BigDecimal invoiceRate = MConversionRate.getRate(rs.getInt("C_Currency_ID"), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                            BigDecimal invoiceAmountTax = invoiceSourceAmountTax.multiply(invoiceRate).setScale(precision, 4);
                            invoiceSourceAmountTax = invoiceSourceAmountTax.multiply(percent).setScale(precision, 4);
                            BigDecimal paymentAmountTax = null;
                            paymentAmountTax = pr != null ? MConversionRate.convertDoc(this.getCtx(), invoiceSourceAmountTax, factAcct.getC_Currency_ID(), as.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), MUYPayReceipt.Table_ID, pr.get_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID()) : MConversionRate.convert(this.getCtx(), invoiceSourceAmountTax, factAcct.getC_Currency_ID(), as.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                            if (paymentAmountTax.signum() == 0 || factAcct.getAmtAcctDr().add(factAcct.getAmtAcctCr()).signum() <= 0 && factAcct.getAmtAcctCr().add(factAcct.getAmtAcctDr()).signum() <= 0 || (currentyGainLossAmount = invoiceSourceAmountTax.subtract(invoiceAmountTax).setScale(precision, 4)).signum() == 0) continue;
                            FactLine debitFactLineTax = fact.createLine(null, accountDebitTax, invoice.getC_Currency_ID(), Env.ZERO, Env.ZERO);
                            if (invoice.isSOTrx()) {
                                debitFactLineTax.setAmtAcctCr(currentyGainLossAmount);
                            } else {
                                debitFactLineTax.setAmtAcctDr(currentyGainLossAmount);
                                debit = true;
                            }
                            debitFactLineTax.setLine_ID(factAcct.getLine_ID());
                            debitFactLineTax.setAD_Org_ID(factAcct.getAD_Org_ID());
                            debitFactLineTax.setC_Period_ID(factAcct.getC_Period_ID());
                            debitFactLineTax.setC_Tax_ID(factAcct.getC_Tax_ID());
                            debitFactLineTax.setC_Project_ID(factAcct.getC_Project_ID());
                            debitFactLineTax.setC_Activity_ID(factAcct.getC_Activity_ID());
                            debitFactLineTax.setAmtSourceCr(BigDecimal.ZERO);
                            debitFactLineTax.setAmtSourceDr(BigDecimal.ZERO);
                            debitFactLineTax.saveEx();
                            FactLine currentyGainLoss = fact.createLine(null, currentyGainLossAmount.signum() > 0 ? gain : loss, as.getC_Currency_ID(), Env.ZERO, Env.ZERO);
                            if (debit) {
                                currentyGainLoss.setAmtAcctCr(currentyGainLossAmount);
                            } else {
                                currentyGainLoss.setAmtAcctDr(currentyGainLossAmount);
                            }
                            currentyGainLoss.setLine_ID(factAcct.getLine_ID());
                            currentyGainLoss.setAD_Org_ID(factAcct.getAD_Org_ID());
                            String descriptionLine = currentyGainLoss.getDescription() + " Ajuste de Impuesto por tipo de cambio";
                            currentyGainLoss.setAmtSourceCr(BigDecimal.ZERO);
                            currentyGainLoss.setAmtSourceDr(BigDecimal.ZERO);
                            currentyGainLoss.setDescription(descriptionLine);
                            currentyGainLoss.setC_Period_ID(factAcct.getC_Period_ID());
                            currentyGainLoss.setC_Tax_ID(factAcct.getC_Tax_ID());
                            currentyGainLoss.setC_Project_ID(factAcct.getC_Project_ID());
                            currentyGainLoss.setC_Activity_ID(factAcct.getC_Activity_ID());
                            currentyGainLoss.saveEx();
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                    }
                    finally {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
            } else if (invoice != null && payment == null && this.amtNCDef.compareTo(Env.ZERO) != 0 && invoice.isSOTrx() == this.ncSOTrx && !(docInv = (MDocType)invoice.getC_DocTypeTarget()).getDocBaseType().equals("DRC") && !docInv.getDocBaseType().equals("DPC")) {
                BigDecimal amount = allocationSource;
                if (this.amtNCDef.compareTo(Env.ZERO) < 0) {
                    this.amtNCDef = this.amtNCDef.negate();
                }
                if (amount.compareTo(this.amtNCDef) > 0) {
                    amount = this.amtNCDef;
                }
                String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL AND C_Tax_ID > 0";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, this.getTrxName());
                    pstmt.setInt(1, line.getC_Invoice_ID());
                    pstmt.setInt(2, as.getC_AcctSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal currentyGainLossAmount;
                        MFactAcct factAcct = new MFactAcct(this.getCtx(), rs, fact.get_TrxName());
                        MTax tax = new MTax(Env.getCtx(), factAcct.getC_Tax_ID(), null);
                        String columnDebit = invoice.isSOTrx() ? "T_Liability_Acct" : "T_Receivables_Acct";
                        String sqlDebitTax = "SELECT C_ValidCombination_ID FROM C_ValidCombination WHERE C_ValidCombination_ID=( SELECT " + columnDebit + " FROM C_Tax_Acct WHERE C_Tax_ID=?)";
                        int accountDebitId = DB.getSQLValue(tax.get_TrxName(), sqlDebitTax, tax.get_ID());
                        MAccount accountDebitTax = MAccount.getValidCombination(this.getCtx(), accountDebitId, this.getTrxName());
                        MAccount gain = MAccount.getValidCombination(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct(), this.getTrxName());
                        MAccount loss = MAccount.getValidCombination(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct(), this.getTrxName());
                        int precision = as.getStdPrecision();
                        boolean debit = false;
                        BigDecimal invoiceSourceAmountTax = factAcct.getAmtSourceDr().add(factAcct.getAmtSourceCr());
                        BigDecimal percent = MConversionRate.getRate(rs.getInt("C_Currency_ID"), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                        if (percent == null) {
                            percent = Env.ZERO;
                        }
                        int convTypeID = 0;
                        convTypeID = line.getC_ConversionType_ID() > 0 ? line.getC_ConversionType_ID() : invoice.getC_ConversionType_ID();
                        BigDecimal invoiceAmtSource = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), convTypeID, invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                        invoiceSourceAmountTax = invoiceSourceAmountTax.multiply(invoiceAmtSource).divide(invoice.getGrandTotal(), precision, 4);
                        BigDecimal invoiceRate = MConversionRate.getRate(rs.getInt("C_Currency_ID"), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                        BigDecimal invoiceAmountTax = invoiceSourceAmountTax.multiply(invoiceRate).setScale(precision, 4);
                        invoiceSourceAmountTax = invoiceSourceAmountTax.multiply(percent).setScale(precision, 4);
                        BigDecimal paymentAmountTax = MConversionRate.convert(this.getCtx(), invoiceSourceAmountTax, factAcct.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
                        if (paymentAmountTax.signum() == 0 || factAcct.getAmtAcctDr().add(factAcct.getAmtAcctCr()).signum() <= 0 && factAcct.getAmtAcctCr().add(factAcct.getAmtAcctDr()).signum() <= 0 || (currentyGainLossAmount = invoiceSourceAmountTax.subtract(invoiceAmountTax).setScale(precision, 4)).signum() == 0) continue;
                        FactLine debitFactLineTax = fact.createLine(null, accountDebitTax, invoice.getC_Currency_ID(), Env.ZERO, Env.ZERO);
                        if (invoice.isSOTrx()) {
                            debitFactLineTax.setAmtAcctCr(currentyGainLossAmount);
                        } else {
                            debitFactLineTax.setAmtAcctDr(currentyGainLossAmount);
                            debit = true;
                        }
                        debitFactLineTax.setLine_ID(factAcct.getLine_ID());
                        debitFactLineTax.setAD_Org_ID(factAcct.getAD_Org_ID());
                        debitFactLineTax.setC_Period_ID(factAcct.getC_Period_ID());
                        debitFactLineTax.setC_Tax_ID(factAcct.getC_Tax_ID());
                        debitFactLineTax.setC_Project_ID(factAcct.getC_Project_ID());
                        debitFactLineTax.setC_Activity_ID(factAcct.getC_Activity_ID());
                        debitFactLineTax.setAmtSourceCr(BigDecimal.ZERO);
                        debitFactLineTax.setAmtSourceDr(BigDecimal.ZERO);
                        debitFactLineTax.saveEx();
                        FactLine currentyGainLoss = fact.createLine(null, currentyGainLossAmount.signum() > 0 ? gain : loss, as.getC_Currency_ID(), Env.ZERO, Env.ZERO);
                        if (debit) {
                            currentyGainLoss.setAmtAcctCr(currentyGainLossAmount);
                        } else {
                            currentyGainLoss.setAmtAcctDr(currentyGainLossAmount);
                        }
                        currentyGainLoss.setLine_ID(factAcct.getLine_ID());
                        currentyGainLoss.setAD_Org_ID(factAcct.getAD_Org_ID());
                        String descriptionLine = currentyGainLoss.getDescription() + " Ajuste de Impuesto por tipo de cambio";
                        currentyGainLoss.setAmtSourceCr(BigDecimal.ZERO);
                        currentyGainLoss.setAmtSourceDr(BigDecimal.ZERO);
                        currentyGainLoss.setDescription(descriptionLine);
                        currentyGainLoss.setC_Period_ID(factAcct.getC_Period_ID());
                        currentyGainLoss.setC_Tax_ID(factAcct.getC_Tax_ID());
                        currentyGainLoss.setC_Project_ID(factAcct.getC_Project_ID());
                        currentyGainLoss.setC_Activity_ID(factAcct.getC_Activity_ID());
                        currentyGainLoss.saveEx();
                    }
                    this.amtNCDef = this.amtNCDef.subtract(amount);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                }
                finally {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            if (invoice != null && as.isTaxCorrection()) {
                BigDecimal taxCorrectionAmt = Env.ZERO;
                if (as.isTaxCorrectionDiscount()) {
                    taxCorrectionAmt = line.getDiscountAmt();
                }
                if (as.isTaxCorrectionWriteOff()) {
                    taxCorrectionAmt = taxCorrectionAmt.add(line.getWriteOffAmt());
                }
                if (taxCorrectionAmt.signum() != 0 && !this.createTaxCorrection(as, fact, line, this.getAccount(invoice.isSOTrx() ? 30 : 31, as), this.getAccount(32, as), invoice.isSOTrx())) {
                    this.p_Error = "Cannot create Tax correction";
                    return null;
                }
            }
            int payCurrency = this.getC_Currency_ID();
            if (payment != null) {
                payCurrency = payment.getC_Currency_ID();
            }
            if (invoice == null && payment == null || this.getC_Currency_ID() == as.getC_Currency_ID() && this.getC_Currency_ID() == line.getInvoiceC_Currency_ID() && this.getC_Currency_ID() == payCurrency) continue;
            this.p_Error = this.createRealizedGainLoss(line, as, fact, bpAcct, payAcct, (MInvoice)invoice, payment, allocationSourceForRGL, allocationAccountedForRGL, payAllocationSource, payAllocationAccounted);
            if (this.p_Error == null) continue;
            return null;
        }
        if (!as.isPostIfClearingEqual() && this.p_lines.length > 0 && !isInterOrg) {
            boolean allEquals = true;
            FactLine[] factlines = fact.getLines();
            BigDecimal netBalance = Env.ZERO;
            FactLine prevFactLine = null;
            for (FactLine factLine : factlines) {
                netBalance = netBalance.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
                if (prevFactLine != null && !this.equalFactLineIDs(prevFactLine, factLine)) {
                    allEquals = false;
                    break;
                }
                prevFactLine = factLine;
            }
            if (netBalance.compareTo(Env.ZERO) == 0 && allEquals) {
                for (FactLine factline : factlines) {
                    fact.remove(factline);
                }
            }
        }
        this.setC_BPartner_ID(0);
        this.m_facts.add(fact);
        if (!fact.isAcctBalanced()) {
            this.createRealizedGLEntry(as, fact);
        }
        MAllocationHdr allocation = (MAllocationHdr)this.getPO();
        int bp_ID = DB.getSQLValue(this.getTrxName(), "SELECT MAX(C_BPartner_ID) FROM C_AllocationLine WHERE C_AllocationHdr_ID=?", allocation.getC_AllocationHdr_ID());
        MBPartner bp = MBPartner.get(this.getCtx(), bp_ID);
        if (bp.getAD_OrgBP_ID_Int() <= 0) return this.m_facts;
        if (!MClient.get(this.getCtx(), this.getAD_Client_ID()).get_ValueAsBoolean("PostAutoConsolElims")) return this.m_facts;
        this.factsElim.add(fact);
        this.createElimEntry(allocation, bp.getAD_OrgBP_ID_Int());
        return this.m_facts;
    }

    private void createElimEntry(MAllocationHdr allocation, int counterOrg_ID) {
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), this.getTrxName());
        MClientInfo ci = client.getInfo();
        int AD_Tree_ID = ci.getAD_Tree_Org_ID();
        MTree tree = new MTree(this.getCtx(), AD_Tree_ID, this.get_TableName());
        MOrg orgElim = this.getElimOrg(tree, allocation.getAD_Org_ID(), counterOrg_ID);
        if (orgElim != null) {
            MOrg consolOrg = MOrg.get(this.getCtx(), orgElim.get_ValueAsInt("ConsolAdjOrg"));
            if (consolOrg.get_ID() == 0) {
                return;
            }
            for (int f = 0; f < this.factsElim.size(); ++f) {
                FactLine[] lines;
                Fact fact = this.factsElim.get(f);
                for (FactLine line : lines = fact.getLines()) {
                    FactLine lineElim = line.reverse(line.getDescription() + "-Elim Entry");
                    lineElim.set_ValueOfColumn("ElimEntry", (Object)"Y");
                    lineElim.setAD_Org_ID(consolOrg.get_ID());
                    fact.add(lineElim);
                }
            }
        }
    }

    private MOrg getElimOrg(MTree tree, int org1, int org2) {
        MOrg elimOrg = null;
        MTree_Node node1 = MTree_Node.get(tree, org1);
        MTree_Node node2 = MTree_Node.get(tree, org2);
        ArrayList<MTree_Node> nodes1 = new ArrayList<MTree_Node>();
        ArrayList<MTree_Node> nodes2 = new ArrayList<MTree_Node>();
        nodes2.add(node2);
        nodes1.add(node1);
        while (node1.getParent_ID() != 0) {
            nodes1.add(MTree_Node.get(tree, node1.getParent_ID()));
            node1 = MTree_Node.get(tree, node1.getParent_ID());
        }
        while (node2.getParent_ID() != 0) {
            nodes2.add(MTree_Node.get(tree, node2.getParent_ID()));
            node2 = MTree_Node.get(tree, node2.getParent_ID());
        }
        for (MTree_Node node : nodes1) {
            if (!nodes2.contains(node)) continue;
            elimOrg = MOrg.get(this.getCtx(), node.getNode_ID());
            break;
        }
        return elimOrg;
    }

    private void createRealizedGLEntry(MAcctSchema as, Fact fact) {
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal diff = fact.getAcctBalance();
        FactLine fl = new FactLine(this.getCtx(), this.get_Table_ID(), this.get_ID(), 0, this.getTrxName());
        fl = fact.createLine(fl.getDocLine(), loss, gain, as.getC_Currency_ID(), diff.negate());
        fl.setDocumentInfo(this, null);
        fl.setAmtSource(as.getC_Currency_ID(), Env.ZERO, Env.ZERO);
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        if (this.p_lines.length <= 0) {
            return false;
        }
        int startorg = this.p_lines[0].getAD_Org_ID();
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine_Allocation line = (DocLine_Allocation)this.p_lines[i];
            int orgpayment = startorg;
            MPayment payment = null;
            if (line.getC_Payment_ID() != 0) {
                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                orgpayment = payment.getAD_Org_ID();
            }
            int orginvoice = startorg;
            MInvoice invoice = null;
            if (line.getC_Invoice_ID() != 0) {
                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.getTrxName());
                orginvoice = invoice.getAD_Org_ID();
            }
            int orgcashline = startorg;
            MCashLine cashline = null;
            if (line.getC_CashLine_ID() != 0) {
                cashline = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                orgcashline = cashline.getAD_Org_ID();
            }
            int orgorder = startorg;
            MOrder order = null;
            if (line.getC_Order_ID() != 0) {
                order = new MOrder(this.getCtx(), line.getC_Order_ID(), this.getTrxName());
                orgorder = order.getAD_Org_ID();
            }
            if (line.getAD_Org_ID() == startorg && orgpayment == startorg && orginvoice == startorg && orgcashline == startorg && orgorder == startorg) continue;
            return true;
        }
        return false;
    }

    private boolean equalFactLineIDs(FactLine prevFactLine, FactLine factLine) {
        return factLine.getA_Asset_ID() == prevFactLine.getA_Asset_ID() && factLine.getAccount_ID() == prevFactLine.getAccount_ID() && factLine.getAD_Client_ID() == prevFactLine.getAD_Client_ID() && factLine.getAD_Org_ID() == prevFactLine.getAD_Org_ID() && factLine.getAD_OrgTrx_ID() == prevFactLine.getAD_OrgTrx_ID() && factLine.getC_AcctSchema_ID() == prevFactLine.getC_AcctSchema_ID() && factLine.getC_Activity_ID() == prevFactLine.getC_Activity_ID() && factLine.getC_BPartner_ID() == prevFactLine.getC_BPartner_ID() && factLine.getC_Campaign_ID() == prevFactLine.getC_Campaign_ID() && factLine.getC_Currency_ID() == prevFactLine.getC_Currency_ID() && factLine.getC_LocFrom_ID() == prevFactLine.getC_LocFrom_ID() && factLine.getC_LocTo_ID() == prevFactLine.getC_LocTo_ID() && factLine.getC_Period_ID() == prevFactLine.getC_Period_ID() && factLine.getC_Project_ID() == prevFactLine.getC_Project_ID() && factLine.getC_ProjectPhase_ID() == prevFactLine.getC_ProjectPhase_ID() && factLine.getC_ProjectTask_ID() == prevFactLine.getC_ProjectTask_ID() && factLine.getC_SalesRegion_ID() == prevFactLine.getC_SalesRegion_ID() && factLine.getC_SubAcct_ID() == prevFactLine.getC_SubAcct_ID() && factLine.getC_Tax_ID() == prevFactLine.getC_Tax_ID() && factLine.getC_UOM_ID() == prevFactLine.getC_UOM_ID() && factLine.getGL_Budget_ID() == prevFactLine.getGL_Budget_ID() && factLine.getGL_Category_ID() == prevFactLine.getGL_Category_ID() && factLine.getM_Locator_ID() == prevFactLine.getM_Locator_ID() && factLine.getM_Product_ID() == prevFactLine.getM_Product_ID() && factLine.getUserElement1_ID() == prevFactLine.getUserElement1_ID() && factLine.getUserElement2_ID() == prevFactLine.getUserElement2_ID() && factLine.getUser1_ID() == prevFactLine.getUser1_ID() && factLine.getUser2_ID() == prevFactLine.getUser2_ID() && factLine.getUser3_ID() == prevFactLine.getUser3_ID() && factLine.getUser4_ID() == prevFactLine.getUser4_ID();
    }

    private BigDecimal createCashBasedAcct(MAcctSchema as, Fact fact, MInvoice invoice, BigDecimal allocationSource) {
        BigDecimal allocationAccounted = Env.ZERO;
        double percent = invoice.getGrandTotal().doubleValue() / allocationSource.doubleValue();
        if (percent > 0.99 && percent < 1.01) {
            percent = 1.0;
        }
        this.log.config("Multiplier=" + percent + " - GrandTotal=" + invoice.getGrandTotal() + " - Allocation Source=" + allocationSource);
        Doc_Invoice docInvoice = (Doc_Invoice)Doc.get(new MAcctSchema[]{as}, MInvoice.Table_ID, invoice.getC_Invoice_ID(), this.getTrxName());
        docInvoice.loadDocumentDetails();
        allocationAccounted = docInvoice.createFactCash(as, fact, new BigDecimal(percent));
        this.log.config("Allocation Accounted=" + allocationAccounted);
        if (as.isCreatePOCommitment() && !invoice.isSOTrx()) {
            MInvoiceLine[] lines = invoice.getLines();
            for (int i = 0; i < lines.length; ++i) {
                Fact factC = Doc_Order.getCommitmentRelease(as, this, lines[i].getQtyInvoiced(), lines[i].getC_InvoiceLine_ID(), new BigDecimal(percent));
                if (factC == null) {
                    return null;
                }
                this.m_facts.add(factC);
            }
        }
        return allocationAccounted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MAccount getPaymentAcct(MAcctSchema as, int C_Payment_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int accountType;
        block6: {
            this.setC_BankAccount_ID(0);
            accountType = 10;
            String sql = "SELECT p.C_BankAccount_ID, d.DocBaseType, p.IsReceipt, p.IsPrepayment FROM C_Payment p INNER JOIN C_DocType d ON (p.C_DocType_ID=d.C_DocType_ID) WHERE C_Payment_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, C_Payment_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                this.setC_BankAccount_ID(rs.getInt(1));
                if ("APP".equals(rs.getString(2)) || "DRP".equals(rs.getString(2))) {
                    accountType = 12;
                }
                if (!"Y".equals(rs.getString(4))) break block6;
                accountType = "Y".equals(rs.getString(3)) ? 13 : 14;
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.getC_BankAccount_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_Payment_ID=" + C_Payment_ID);
            return null;
        }
        return this.getAccount(accountType, as);
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createRealizedGainLoss(DocLine line, MAcctSchema as, Fact fact, MAccount invAcct, MAccount payAcct, MInvoice invoice, MPayment payment, BigDecimal allocationSource, BigDecimal allocationAccounted, BigDecimal payAllocationSource, BigDecimal payAllocationAccounted) {
        FactLine fl;
        String d2;
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        BigDecimal invoiceDifference = Env.ZERO;
        BigDecimal paymentDifference = Env.ZERO;
        String invoiceDescription = "";
        String paymentDescription = "";
        if (invoice != null && invoice.getGrandTotal().signum() != 0) {
            BigDecimal invoiceSource = null;
            BigDecimal invoiceAccounted = null;
            sql = "SELECT " + (invoice.isSOTrx() ? "SUM(AmtSourceDr), SUM(AmtAcctDr)" : "SUM(AmtSourceCr), SUM(AmtAcctCr)") + " FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND PostingType='A'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, invoice.getC_Invoice_ID());
                pstmt.setInt(2, as.getC_AcctSchema_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    invoiceSource = rs.getBigDecimal(1);
                    invoiceAccounted = rs.getBigDecimal(2);
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (invoiceSource == null || invoiceAccounted == null) {
                return "Gain/Loss - Invoice not posted yet";
            }
            String description = "Invoice=(" + invoice.getC_Currency_ID() + ")" + invoiceSource + "/" + invoiceAccounted + " - Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "/" + allocationAccounted;
            this.log.fine(description);
            if (this.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                BigDecimal allocationSourceNew;
                int convTypeID = invoice.getC_ConversionType_ID();
                if (line.getC_ConversionType_ID() > 0) {
                    convTypeID = line.getC_ConversionType_ID();
                }
                if ((allocationSourceNew = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), convTypeID, invoice.getAD_Client_ID(), invoice.getAD_Org_ID())) == null) {
                    return "Gain/Loss - No Conversion from Allocation->Invoice";
                }
                d2 = "Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "->(" + invoice.getC_Currency_ID() + ")" + allocationSourceNew;
                this.log.fine(d2);
                description = description + " - " + d2;
                allocationSource = allocationSourceNew;
            }
            if (allocationSource.compareTo(invoiceSource) == 0) {
                invoiceDifference = invoiceAccounted.subtract(allocationAccounted);
                String d22 = "(full) = " + invoiceDifference;
                this.log.fine(d22);
                invoiceDescription = invoiceDescription + " - " + d22;
            } else {
                double multiplier = allocationSource.doubleValue() / invoiceSource.doubleValue();
                invoiceDifference = (invoiceAccounted = invoiceAccounted.multiply(new BigDecimal(multiplier))).subtract(allocationAccounted);
                if (invoiceDifference.abs().compareTo(TOLERANCE) < 0) {
                    invoiceDifference = Env.ZERO;
                }
                int precision = as.getStdPrecision();
                if (invoiceDifference.scale() > precision) {
                    invoiceDifference = invoiceDifference.setScale(precision, 4);
                }
                String d23 = "(partial) = " + invoiceDifference + " - Multiplier=" + multiplier;
                this.log.fine(d23);
                invoiceDescription = invoiceDescription + " - " + d23;
            }
        }
        if (payment != null && payment.getPayAmt().signum() != 0) {
            if (!payment.isReceipt()) {
                payAllocationSource = payAllocationSource.negate();
                payAllocationAccounted = payAllocationAccounted.negate();
            }
            BigDecimal paymentSource = null;
            BigDecimal paymentAccounted = null;
            sql = "SELECT " + (payment.isReceipt() ? "SUM(AmtSourceCr), SUM(AmtAcctCr)" : "SUM(AmtSourceDr), SUM(AmtAcctDr)") + " FROM Fact_Acct WHERE AD_Table_ID=335 AND Record_ID=? AND C_AcctSchema_ID=? AND PostingType='A'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, payment.getC_Payment_ID());
                pstmt.setInt(2, as.getC_AcctSchema_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    paymentSource = rs.getBigDecimal(1);
                    paymentAccounted = rs.getBigDecimal(2);
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (paymentSource == null || paymentAccounted == null) {
                return "Gain/Loss - Payment not posted yet";
            }
            paymentDescription = paymentDescription + "Payment=(" + MCurrency.getISO_Code(this.getCtx(), payment.getC_Currency_ID()) + ")" + paymentSource + "/" + paymentAccounted + " - Allocation=(" + MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID()) + ")" + payAllocationSource + "/" + payAllocationAccounted;
            this.log.fine(paymentDescription);
            if (this.getC_Currency_ID() != payment.getC_Currency_ID()) {
                BigDecimal payAllocationSourceNew = MConversionRate.convert(this.getCtx(), payAllocationSource, this.getC_Currency_ID(), payment.getC_Currency_ID(), this.getDateAcct(), payment.getC_ConversionType_ID(), payment.getAD_Client_ID(), payment.getAD_Org_ID());
                if (payAllocationSourceNew == null) {
                    return "Gain/Loss - No Conversion from Allocation->Payment";
                }
                String d24 = "Allocation=(" + MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID()) + ")" + payAllocationSource + "->(" + MCurrency.getISO_Code(this.getCtx(), payment.getC_Currency_ID()) + ")" + payAllocationSourceNew;
                this.log.fine(d24);
                paymentDescription = paymentDescription + " - " + d24;
                payAllocationSource = payAllocationSourceNew;
            }
            if (payAllocationSource.compareTo(paymentSource) == 0) {
                paymentDifference = paymentAccounted.subtract(payAllocationAccounted);
                String d25 = "(full) = " + paymentDifference;
                this.log.fine(d25);
                paymentDescription = paymentDescription + " - " + d25;
            } else {
                double multiplier = payAllocationSource.doubleValue() / paymentSource.doubleValue();
                paymentDifference = (paymentAccounted = paymentAccounted.multiply(new BigDecimal(multiplier))).subtract(payAllocationAccounted);
                if (paymentDifference.abs().compareTo(TOLERANCE) < 0) {
                    paymentDifference = Env.ZERO;
                }
                int precision = as.getStdPrecision();
                if (paymentDifference.scale() > precision) {
                    paymentDifference = paymentDifference.setScale(precision, 4);
                }
                d2 = "(partial) = " + paymentDifference + " - Multiplier=" + multiplier;
                this.log.fine(d2);
                paymentDescription = paymentDescription + " - " + d2;
            }
        }
        if (invoiceDifference.signum() == 0 && paymentDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal glAmt = Env.ZERO;
        if (invoiceDifference.signum() != 0) {
            fl = null;
            if (invoice.isSOTrx()) {
                fl = fact.createLine(line, invAcct, as.getC_Currency_ID(), invoiceDifference.negate());
                fl.setDescription(invoiceDescription);
                glAmt = invoiceDifference;
            } else {
                fl = fact.createLine(line, invAcct, as.getC_Currency_ID(), invoiceDifference);
                fl.setDescription(invoiceDescription);
                glAmt = invoiceDifference.negate();
            }
            fl.setC_Currency_ID(invoice.getC_Currency_ID());
            fl.setAmtSourceCr(BigDecimal.ZERO);
            fl.setAmtSourceDr(BigDecimal.ZERO);
        }
        if (paymentDifference.signum() != 0) {
            fl = null;
            if (payment.isReceipt()) {
                fl = fact.createLine(line, payAcct, as.getC_Currency_ID(), paymentDifference);
                fl.setDescription(paymentDescription);
                glAmt = glAmt.subtract(paymentDifference);
            } else {
                fl = fact.createLine(line, payAcct, as.getC_Currency_ID(), paymentDifference.negate());
                fl.setDescription(paymentDescription);
                glAmt = glAmt.add(paymentDifference);
            }
            fl.setC_Currency_ID(payment.getC_Currency_ID());
            fl.setAmtSourceCr(BigDecimal.ZERO);
            fl.setAmtSourceDr(BigDecimal.ZERO);
        }
        if (glAmt.signum() != 0) {
            fl = fact.createLine(line, loss, gain, as.getC_Currency_ID(), glAmt);
            String description = invoiceDescription;
            if (!Util.isEmpty(invoiceDescription)) {
                description = description + "\n";
            }
            description = description + paymentDescription;
            fl.setDescription(description);
            fl.setAmtSourceCr(BigDecimal.ZERO);
            fl.setAmtSourceDr(BigDecimal.ZERO);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTaxCorrection(MAcctSchema as, Fact fact, DocLine_Allocation line, MAccount DiscountAccount, MAccount WriteOffAccoint, boolean isSOTrx) {
        this.log.info(line.toString());
        BigDecimal discount = Env.ZERO;
        if (as.isTaxCorrectionDiscount()) {
            discount = line.getDiscountAmt();
        }
        BigDecimal writeOff = Env.ZERO;
        if (as.isTaxCorrectionWriteOff()) {
            writeOff = line.getWriteOffAmt();
        }
        Doc_AllocationTax tax = new Doc_AllocationTax(DiscountAccount, discount, WriteOffAccoint, writeOff, isSOTrx);
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, line.getC_Invoice_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tax.addInvoiceFact(new MFactAcct(this.getCtx(), rs, fact.get_TrxName()));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (tax.getLineCount() == 0) {
            this.log.warning("Invoice not posted yet - " + line);
            return false;
        }
        if (tax.getLineCount() < 2) {
            return true;
        }
        return tax.createEntries(as, fact, line);
    }
}

