/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compiere.Adempiere;
import org.compiere.acct.AcctViewerData;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.search.Info;
import org.compiere.grid.ed.VDate;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.Query;
import org.compiere.report.core.RModel;
import org.compiere.report.core.RModelExcelExporter;
import org.compiere.report.core.ResultTable;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CFrame;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTabbedPane;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class AcctViewer
extends CFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -6160970582569467185L;
    private AcctViewerData accountViewerData = null;
    private ImageIcon findIcon = new ImageIcon(Adempiere.class.getResource("images/Find16.gif"));
    private static CLogger log = CLogger.getCLogger(AcctViewer.class);
    private CPanel mainPanel = new CPanel();
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel query = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CScrollPane result = new CScrollPane();
    private ResultTable table = new ResultTable();
    private CPanel southPanel = new CPanel();
    private CButton bQuery = new CButton();
    private CButton bPrint = new CButton();
    private CButton bExport = new CButton();
    private CButton bZoom = new CButton();
    private CLabel statusLine = new CLabel();
    private BorderLayout southLayout = new BorderLayout();
    private BorderLayout queryLayout = new BorderLayout();
    private CPanel selectionPanel = new CPanel();
    private CPanel displayPanel = new CPanel();
    private TitledBorder displayBorder;
    private TitledBorder selectionBorder;
    private GridBagLayout displayLayout = new GridBagLayout();
    private CCheckBox displayQty = new CCheckBox();
    private CCheckBox displaySourceAmt = new CCheckBox();
    private CCheckBox displayDocumentInfo = new CCheckBox();
    private CLabel lSort = new CLabel();
    private CComboBox sortBy1 = new CComboBox();
    private CComboBox sortBy2 = new CComboBox();
    private CComboBox sortBy3 = new CComboBox();
    private CCheckBox group1 = new CCheckBox();
    private CCheckBox group2 = new CCheckBox();
    private CCheckBox group3 = new CCheckBox();
    private CLabel lGroup = new CLabel();
    private GridBagLayout selectionLayout = new GridBagLayout();
    private CComboBox selAcctSchema = new CComboBox();
    private CComboBox selPostingType = new CComboBox();
    private CCheckBox selDocument = new CCheckBox();
    private CComboBox selTable = new CComboBox();
    private CButton selRecord = new CButton();
    private CLabel lOrg = new CLabel();
    private CComboBox selOrg = new CComboBox();
    private CLabel lAcct = new CLabel();
    private CButton selAcct = new CButton();
    private CLabel lDate = new CLabel();
    private CLabel lacctSchema = new CLabel();
    private CLabel lpostingType = new CLabel();
    private VDate selDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private VDate selDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lsel1 = new CLabel();
    private CLabel lsel2 = new CLabel();
    private CLabel lsel3 = new CLabel();
    private CLabel lsel4 = new CLabel();
    private CLabel lsel5 = new CLabel();
    private CLabel lsel6 = new CLabel();
    private CLabel lsel7 = new CLabel();
    private CLabel lsel8 = new CLabel();
    private CLabel lsel9 = new CLabel();
    private CLabel lsel10 = new CLabel();
    private CLabel lsel11 = new CLabel();
    private CLabel lsel12 = new CLabel();
    private CLabel lsel13 = new CLabel();
    private CButton sel1 = new CButton();
    private CButton sel2 = new CButton();
    private CButton sel3 = new CButton();
    private CButton sel4 = new CButton();
    private CButton sel5 = new CButton();
    private CButton sel6 = new CButton();
    private CButton sel7 = new CButton();
    private CButton sel8 = new CButton();
    private CButton sel9 = new CButton();
    private CButton sel10 = new CButton();
    private CButton sel11 = new CButton();
    private CButton sel12 = new CButton();
    private CButton sel13 = new CButton();
    private CButton bRePost = new CButton();
    private CCheckBox forcePost = new CCheckBox();
    private CComboBox sortBy4 = new CComboBox();
    private CCheckBox group4 = new CCheckBox();

    public AcctViewer() {
        this(0, 0, 0);
    }

    public AcctViewer(int clientId, int tableId, int recordId) {
        super(Msg.getMsg(Env.getCtx(), "AcctViewer"));
        log.info("AD_Table_ID=" + tableId + ", Record_ID=" + recordId);
        this.setDefaultCloseOperation(2);
        this.accountViewerData = new AcctViewerData(Env.getCtx(), Env.createWindowNo(this), clientId, tableId);
        AEnv.addToWindowManager(this);
        try {
            this.jbInit();
            this.dynInit(tableId, recordId);
            AEnv.showCenterScreen(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
            this.dispose();
        }
    }

    private void jbInit() throws Exception {
        ImageIcon imageIcon = new ImageIcon(Adempiere.class.getResource("images/InfoAccount16.gif"));
        this.setIconImage(imageIcon.getImage());
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.mainPanel.setLayout(this.mainLayout);
        this.selectionPanel.setLayout(this.selectionLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.selectionBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg(Env.getCtx(), "Selection"));
        this.selectionPanel.setBorder(this.selectionBorder);
        this.lacctSchema.setLabelFor(this.selAcctSchema);
        this.lacctSchema.setText(Msg.translate(Env.getCtx(), "C_AcctSchema_ID"));
        this.lpostingType.setLabelFor(this.selPostingType);
        this.lpostingType.setText(Msg.translate(Env.getCtx(), "PostingType"));
        this.selDocument.setText(Msg.getMsg(Env.getCtx(), "SelectDocument"));
        this.selDocument.addActionListener(this);
        this.lOrg.setLabelFor(this.selOrg);
        this.lOrg.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.lAcct.setLabelFor(this.selAcct);
        this.lAcct.setText(Msg.translate(Env.getCtx(), "Account_ID"));
        this.lDate.setLabelFor(this.selDateFrom);
        this.lDate.setText(Msg.translate(Env.getCtx(), "DateAcct"));
        this.lsel1.setLabelFor(this.sel1);
        this.lsel2.setLabelFor(this.sel2);
        this.lsel3.setLabelFor(this.sel3);
        this.lsel4.setLabelFor(this.sel4);
        this.lsel5.setLabelFor(this.sel5);
        this.lsel6.setLabelFor(this.sel6);
        this.lsel7.setLabelFor(this.sel7);
        this.lsel8.setLabelFor(this.sel8);
        this.lsel9.setLabelFor(this.sel9);
        this.lsel10.setLabelFor(this.sel10);
        this.lsel11.setLabelFor(this.sel11);
        this.lsel12.setLabelFor(this.sel12);
        this.lsel13.setLabelFor(this.sel13);
        this.displayBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg(Env.getCtx(), "Display"));
        this.displayPanel.setBorder(this.displayBorder);
        this.displayPanel.setLayout(this.displayLayout);
        this.displayQty.setText(Msg.getMsg(Env.getCtx(), "DisplayQty"));
        this.displaySourceAmt.setText(Msg.getMsg(Env.getCtx(), "DisplaySourceInfo"));
        this.displayDocumentInfo.setText(Msg.getMsg(Env.getCtx(), "DisplayDocumentInfo"));
        this.displayDocumentInfo.setSelected(true);
        this.displayDocumentInfo.addActionListener(this);
        this.lSort.setText(Msg.getMsg(Env.getCtx(), "SortBy"));
        this.lGroup.setText(Msg.getMsg(Env.getCtx(), "GroupBy"));
        this.displayPanel.add((Component)this.displaySourceAmt, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.displayDocumentInfo, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.lSort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group1, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group2, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.lGroup, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.displayQty, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy3, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group3, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.sortBy4, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.displayPanel.add((Component)this.group4, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lacctSchema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectionPanel.add((Component)this.selAcctSchema, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDocument, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.selTable, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.selRecord, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.selectionPanel.add((Component)this.lpostingType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selPostingType, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lDate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDateFrom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selDateTo, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lOrg, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selOrg, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lAcct, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.selAcct, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel2, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel3, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel1, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel2, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel3, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel4, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel4, new GridBagConstraints(1, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel5, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel5, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel6, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel6, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel7, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel7, new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel8, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel8, new GridBagConstraints(1, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel9, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel9, new GridBagConstraints(1, 14, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel10, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel10, new GridBagConstraints(1, 15, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel11, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel11, new GridBagConstraints(1, 16, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel12, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel12, new GridBagConstraints(1, 17, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.lsel13, new GridBagConstraints(0, 18, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.selectionPanel.add((Component)this.sel13, new GridBagConstraints(1, 18, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.queryLayout.setHgap(5);
        this.queryLayout.setVgap(5);
        this.query.setLayout(this.queryLayout);
        this.query.add((Component)this.selectionPanel, "Center");
        this.query.add((Component)this.displayPanel, "East");
        this.tabbedPane.add((Component)this.query, Msg.getMsg(Env.getCtx(), "ViewerQuery"));
        this.tabbedPane.add((Component)this.result, Msg.getMsg(Env.getCtx(), "ViewerResult"));
        this.tabbedPane.addChangeListener(this);
        this.result.getViewport().add((Component)this.table, null);
        this.southLayout.setHgap(5);
        this.southLayout.setVgap(5);
        this.southPanel.setLayout(this.southLayout);
        this.statusLine.setForeground(Color.blue);
        this.statusLine.setBorder(BorderFactory.createLoweredBevelBorder());
        this.southPanel.add((Component)this.statusLine, "Center");
        this.bRePost.setText(Msg.getMsg(Env.getCtx(), "RePost"));
        this.bRePost.setToolTipText(Msg.getMsg(Env.getCtx(), "RePostInfo"));
        this.bRePost.addActionListener(this);
        this.bRePost.setVisible(false);
        this.forcePost.setText(Msg.getMsg(Env.getCtx(), "Force"));
        this.forcePost.setToolTipText(Msg.getMsg(Env.getCtx(), "ForceInfo"));
        this.forcePost.setVisible(false);
        CPanel leftSide = new CPanel(new FlowLayout(3, 0, 0));
        leftSide.add(this.bRePost);
        leftSide.add(this.forcePost);
        this.southPanel.add((Component)leftSide, "West");
        this.bQuery.setIcon(Env.getImageIcon("Refresh16.gif"));
        this.bQuery.setToolTipText(Msg.getMsg(Env.getCtx(), "Refresh"));
        this.bQuery.addActionListener(this);
        this.bPrint.setIcon(Env.getImageIcon("Print16.gif"));
        this.bPrint.setToolTipText(Msg.getMsg(Env.getCtx(), "Print"));
        this.bPrint.addActionListener(this);
        this.bExport.setIcon(Env.getImageIcon("Export16.gif"));
        this.bExport.setToolTipText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.setVisible(this.displayDocumentInfo.isSelected());
        this.bExport.addActionListener(this);
        this.bZoom.setIcon(Env.getImageIcon("Zoom16.gif"));
        this.bZoom.setToolTipText(Msg.getMsg(Env.getCtx(), "Zoom"));
        this.bZoom.setVisible(this.displayDocumentInfo.isSelected());
        this.bZoom.addActionListener(this);
        CPanel rightSide = new CPanel(new FlowLayout(4, 0, 0));
        rightSide.add(this.bZoom);
        rightSide.add(this.bExport);
        rightSide.add(this.bPrint);
        rightSide.add(this.bQuery);
        this.southPanel.add((Component)rightSide, "East");
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    private void dynInit(int tableId, int recordId) {
        this.accountViewerData.fillAcctSchema(this.selAcctSchema);
        this.selAcctSchema.addActionListener(this);
        this.actionAcctSchema();
        this.accountViewerData.fillTable(this.selTable);
        this.selTable.addActionListener(this);
        this.selRecord.setIcon(this.findIcon);
        this.selRecord.addActionListener(this);
        this.selRecord.setText("");
        this.accountViewerData.fillPostingType(this.selPostingType);
        this.accountViewerData.fillOrg(this.selOrg);
        this.selAcct.setActionCommand("Account_ID");
        this.selAcct.addActionListener(this);
        this.selAcct.setText("");
        this.selAcct.setIcon(this.findIcon);
        boolean haveDocument = tableId != 0 && recordId != 0;
        this.selDocument.setSelected(haveDocument);
        this.actionDocument();
        this.actionTable();
        this.statusLine.setText(" " + Msg.getMsg(Env.getCtx(), "ViewerOptions"));
        if (haveDocument) {
            this.accountViewerData.AD_Table_ID = tableId;
            this.accountViewerData.Record_ID = recordId;
            this.actionQuery();
            String keyColumn = this.selRecord.getActionCommand();
            String tableName = keyColumn.substring(0, keyColumn.length() - 3);
            String selectSQL = keyColumn + "=" + recordId;
            this.accountViewerData.buttonRecordID.put(keyColumn, recordId);
            this.selRecord.setText(this.accountViewerData.getButtonText(tableName, keyColumn, selectSQL));
        }
        this.displayQty.setValue(Character.valueOf('Y'));
    }

    @Override
    public void dispose() {
        if (this.accountViewerData != null) {
            this.accountViewerData.dispose();
        }
        this.accountViewerData = null;
        super.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean visible = this.accountViewerData.documentQuery && this.tabbedPane.getSelectedIndex() == 1;
        this.bRePost.setVisible(visible);
        this.bExport.setVisible(this.tabbedPane.getSelectedIndex() == 1);
        if (Ini.isPropertyBool("ShowAdvanced")) {
            this.forcePost.setVisible(visible);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.displayDocumentInfo) {
            if (this.displayDocumentInfo.isSelected()) {
                this.bZoom.setVisible(true);
            } else {
                this.bZoom.setVisible(false);
            }
        }
        if (source == this.selAcctSchema) {
            this.actionAcctSchema();
        } else if (source == this.bQuery) {
            this.actionQuery();
        } else if (source == this.selDocument) {
            this.actionDocument();
        } else if (source == this.selTable) {
            this.actionTable();
        } else if (source == this.bRePost) {
            this.actionRePost();
        } else if (source == this.bPrint) {
            PrintScreenPainter.printScreen(this);
        } else if (source == this.bZoom) {
            this.actionZoom();
        } else if (source == this.bExport) {
            this.exportExcel();
        } else if (source instanceof CButton) {
            this.actionButton((CButton)source);
        }
    }

    private void actionAcctSchema() {
        KeyNamePair keyNamePair = (KeyNamePair)this.selAcctSchema.getSelectedItem();
        if (keyNamePair == null) {
            return;
        }
        this.accountViewerData.C_AcctSchema_ID = keyNamePair.getKey();
        this.accountViewerData.ASchema = MAcctSchema.get(Env.getCtx(), this.accountViewerData.C_AcctSchema_ID);
        log.info(this.accountViewerData.ASchema.toString());
        this.sortBy1.removeAllItems();
        this.sortBy2.removeAllItems();
        this.sortBy3.removeAllItems();
        this.sortBy4.removeAllItems();
        this.sortAddItem(new ValueNamePair("", ""));
        this.sortAddItem(new ValueNamePair("DateAcct", Msg.translate(Env.getCtx(), "DateAcct")));
        this.sortAddItem(new ValueNamePair("DateTrx", Msg.translate(Env.getCtx(), "DateTrx")));
        this.sortAddItem(new ValueNamePair("C_Period_ID", Msg.translate(Env.getCtx(), "C_Period_ID")));
        CLabel[] labels = new CLabel[]{this.lsel1, this.lsel2, this.lsel3, this.lsel4, this.lsel5, this.lsel6, this.lsel7, this.lsel8, this.lsel9, this.lsel10, this.lsel11, this.lsel12, this.lsel13};
        CButton[] buttons = new CButton[]{this.sel1, this.sel2, this.sel3, this.sel4, this.sel5, this.sel6, this.sel7, this.sel8, this.sel9, this.sel10, this.sel11, this.sel12, this.sel13};
        int selectionIndex = 0;
        MAcctSchemaElement[] elements = this.accountViewerData.ASchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length && selectionIndex < labels.length; ++i) {
            MAcctSchemaElement acctSchemaElement = elements[i];
            String columnName = acctSchemaElement.getColumnName();
            String displayColumnName = acctSchemaElement.getDisplayColumnName();
            displayColumnName = columnName.equals("User1_ID") || columnName.equals("User2_ID") || columnName.equals("User3_ID") || columnName.equals("User4_ID") ? acctSchemaElement.getName() : acctSchemaElement.getDisplayColumnName();
            this.sortAddItem(new ValueNamePair(columnName, Msg.translate(Env.getCtx(), displayColumnName)));
            if (acctSchemaElement.isElementType("OO") || acctSchemaElement.isElementType("AC")) continue;
            labels[selectionIndex].setText(Msg.translate(Env.getCtx(), displayColumnName));
            labels[selectionIndex].setVisible(true);
            buttons[selectionIndex].setActionCommand(columnName);
            buttons[selectionIndex].addActionListener(this);
            buttons[selectionIndex].setIcon(this.findIcon);
            buttons[selectionIndex].setText("");
            buttons[selectionIndex].setVisible(true);
            ++selectionIndex;
        }
        while (selectionIndex < labels.length) {
            labels[selectionIndex].setVisible(false);
            buttons[selectionIndex++].setVisible(false);
        }
    }

    private void sortAddItem(ValueNamePair valueNamePair) {
        this.sortBy1.addItem(valueNamePair);
        this.sortBy2.addItem(valueNamePair);
        this.sortBy3.addItem(valueNamePair);
        this.sortBy4.addItem(valueNamePair);
    }

    private void actionQuery() {
        StringBuffer para = new StringBuffer();
        this.accountViewerData.C_AcctSchema_ID = 0;
        this.accountViewerData.AD_Org_ID = 0;
        KeyNamePair keyNamePair = (KeyNamePair)this.selAcctSchema.getSelectedItem();
        if (keyNamePair != null) {
            this.accountViewerData.C_AcctSchema_ID = keyNamePair.getKey();
        }
        para.append("C_AcctSchema_ID=").append(this.accountViewerData.C_AcctSchema_ID);
        ValueNamePair vp = (ValueNamePair)this.selPostingType.getSelectedItem();
        this.accountViewerData.PostingType = vp.getValue();
        para.append(", PostingType=").append(this.accountViewerData.PostingType);
        this.accountViewerData.documentQuery = this.selDocument.isSelected();
        para.append(", DocumentQuery=").append(this.accountViewerData.documentQuery);
        if (this.selDocument.isSelected()) {
            if (this.accountViewerData.AD_Table_ID == 0 || this.accountViewerData.Record_ID == 0) {
                return;
            }
            para.append(", AD_Table_ID=").append(this.accountViewerData.AD_Table_ID).append(", Record_ID=").append(this.accountViewerData.Record_ID);
        } else {
            this.accountViewerData.DateFrom = (Timestamp)this.selDateFrom.getValue();
            para.append(", DateFrom=").append(this.accountViewerData.DateFrom);
            this.accountViewerData.DateTo = (Timestamp)this.selDateTo.getValue();
            para.append(", DateTo=").append(this.accountViewerData.DateTo);
            keyNamePair = (KeyNamePair)this.selOrg.getSelectedItem();
            if (keyNamePair != null) {
                this.accountViewerData.AD_Org_ID = keyNamePair.getKey();
            }
            para.append(", AD_Org_ID=").append(this.accountViewerData.AD_Org_ID);
            Iterator<String> it = this.accountViewerData.whereInfo.values().iterator();
            while (it.hasNext()) {
                para.append(", ").append((Object)it.next());
            }
        }
        this.accountViewerData.displayQty = this.displayQty.isSelected();
        para.append(" - Display Qty=").append(this.accountViewerData.displayQty);
        this.accountViewerData.displaySourceAmt = this.displaySourceAmt.isSelected();
        para.append(", Source=").append(this.accountViewerData.displaySourceAmt);
        this.accountViewerData.displayDocumentInfo = this.displayDocumentInfo.isSelected();
        para.append(", Doc=").append(this.accountViewerData.displayDocumentInfo);
        this.accountViewerData.sortBy1 = ((ValueNamePair)this.sortBy1.getSelectedItem()).getValue();
        this.accountViewerData.group1 = this.group1.isSelected();
        para.append(" - Sorting: ").append(this.accountViewerData.sortBy1).append("/").append(this.accountViewerData.group1);
        this.accountViewerData.sortBy2 = ((ValueNamePair)this.sortBy2.getSelectedItem()).getValue();
        this.accountViewerData.group2 = this.group2.isSelected();
        para.append(", ").append(this.accountViewerData.sortBy2).append("/").append(this.accountViewerData.group2);
        this.accountViewerData.sortBy3 = ((ValueNamePair)this.sortBy3.getSelectedItem()).getValue();
        this.accountViewerData.group3 = this.group3.isSelected();
        para.append(", ").append(this.accountViewerData.sortBy3).append("/").append(this.accountViewerData.group3);
        this.accountViewerData.sortBy4 = ((ValueNamePair)this.sortBy4.getSelectedItem()).getValue();
        this.accountViewerData.group4 = this.group4.isSelected();
        para.append(", ").append(this.accountViewerData.sortBy4).append("/").append(this.accountViewerData.group4);
        this.bQuery.setEnabled(false);
        this.statusLine.setText(" " + Msg.getMsg(Env.getCtx(), "Processing"));
        log.config(para.toString());
        Thread.yield();
        this.tabbedPane.setSelectedIndex(1);
        this.table.setModel(this.accountViewerData.query());
        this.bQuery.setEnabled(true);
        this.statusLine.setText(" " + Msg.getMsg(Env.getCtx(), "ViewerOptions"));
    }

    private void actionDocument() {
        boolean isDocumentSelected = this.selDocument.isSelected();
        this.selTable.setEnabled(isDocumentSelected);
        this.selRecord.setEnabled(isDocumentSelected);
        this.selDateFrom.setReadWrite(!isDocumentSelected);
        this.selDateTo.setReadWrite(!isDocumentSelected);
        this.selOrg.setEnabled(!isDocumentSelected);
        this.selAcct.setEnabled(!isDocumentSelected);
        this.sel1.setEnabled(!isDocumentSelected);
        this.sel2.setEnabled(!isDocumentSelected);
        this.sel3.setEnabled(!isDocumentSelected);
        this.sel4.setEnabled(!isDocumentSelected);
        this.sel5.setEnabled(!isDocumentSelected);
        this.sel6.setEnabled(!isDocumentSelected);
        this.sel7.setEnabled(!isDocumentSelected);
        this.sel8.setEnabled(!isDocumentSelected);
    }

    private void actionTable() {
        ValueNamePair valueNamePair = (ValueNamePair)this.selTable.getSelectedItem();
        this.accountViewerData.AD_Table_ID = this.accountViewerData.tableInfo.get(valueNamePair.getValue());
        log.config(valueNamePair.getValue() + " = " + this.accountViewerData.AD_Table_ID);
        this.accountViewerData.Record_ID = 0;
        this.selRecord.setText("");
        this.selRecord.setActionCommand(valueNamePair.getValue() + "_ID");
    }

    private int actionButton(CButton button) {
        String lookupcolumnname;
        String tableName;
        MAcctSchemaElement et;
        MAcctSchemaElement ase;
        String keyColumn = button.getActionCommand();
        log.info(keyColumn);
        String whereClause = "(IsSummary='N' OR IsSummary IS NULL)";
        String lookupColumn = keyColumn;
        int record_id = this.accountViewerData.getButtonRecordID(keyColumn);
        if (keyColumn.equals("Account_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.accountViewerData.ASchema.getAcctSchemaElement("AC");
            if (ase != null) {
                whereClause = whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User1_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.accountViewerData.ASchema.getAcctSchemaElement("U1");
            if (ase != null) {
                whereClause = whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User2_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.accountViewerData.ASchema.getAcctSchemaElement("U2");
            if (ase != null) {
                whereClause = whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User3_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.accountViewerData.ASchema.getAcctSchemaElement("U3");
            if (ase != null) {
                whereClause = whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("User4_ID")) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.accountViewerData.ASchema.getAcctSchemaElement("U4");
            if (ase != null) {
                whereClause = whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("M_Product_ID")) {
            whereClause = "";
        }
        if (lookupColumn.equals("UserElement1_ID")) {
            et = (MAcctSchemaElement)new Query(Env.getCtx(), "C_AcctSchema_Element", "elementtype = 'X1' ", null).setClient_ID().firstOnly();
            tableName = et.getAD_Column().getAD_Table().getTableName();
            lookupColumn = lookupcolumnname = tableName + "_ID";
            whereClause = "";
        }
        if (lookupColumn.equals("UserElement2_ID")) {
            et = (MAcctSchemaElement)new Query(Env.getCtx(), "C_AcctSchema_Element", "elementtype = 'X2' ", null).setClient_ID().firstOnly();
            tableName = et.getAD_Column().getAD_Table().getTableName();
            lookupColumn = lookupcolumnname = tableName + "_ID";
            whereClause = "";
        } else if (this.selDocument.isSelected()) {
            whereClause = "";
        }
        record_id = button == this.selRecord ? this.accountViewerData.Record_ID : this.accountViewerData.getButtonRecordID(keyColumn);
        String tableName2 = lookupColumn.substring(0, lookupColumn.length() - 3);
        Info info = Info.create(this, true, this.accountViewerData.WindowNo, tableName2, lookupColumn, record_id, "", false, true, whereClause);
        if (!info.loadedOK()) {
            info.dispose();
            info = null;
            button.setText("");
            this.accountViewerData.whereInfo.put(keyColumn, "");
            this.accountViewerData.buttonRecordID.put(keyColumn, null);
            return 0;
        }
        info.setVisible(true);
        boolean isCancelled = info.isCancelled();
        boolean isOK = info.isOk();
        Integer key = 0;
        if (isCancelled && !isOK) {
            key = 0;
            if (button == this.selRecord) {
                this.accountViewerData.Record_ID = key;
            } else {
                this.accountViewerData.whereInfo.put(keyColumn, "");
                this.accountViewerData.buttonRecordID.put(keyColumn, (int)key);
            }
            button.setText("");
        } else if (!isCancelled && isOK) {
            String selectSQL = info.getSelectedSQL();
            key = (Integer)info.getSelectedKey();
            log.config(keyColumn + " - " + key);
            if (button == this.selRecord) {
                this.accountViewerData.Record_ID = key;
            } else {
                this.accountViewerData.whereInfo.put(keyColumn, keyColumn + "=" + key);
                this.accountViewerData.buttonRecordID.put(keyColumn, (int)key);
            }
            button.setText(this.accountViewerData.getButtonText(tableName2, lookupColumn, selectSQL));
            this.pack();
        } else if (!(isCancelled ^ isOK)) {
            if (button == this.selRecord) {
                this.accountViewerData.Record_ID = key;
                key = this.accountViewerData.Record_ID;
            } else {
                key = this.accountViewerData.getButtonRecordID(keyColumn);
            }
        }
        info = null;
        return key;
    }

    private void actionZoom() {
        if (this.displayDocumentInfo.isSelected() && this.table.getSelectedRow() >= 0) {
            RModel model = this.accountViewerData.getRModel();
            int columnTableId = model.getColumnIndex("AD_Table_ID");
            int columnRecordId = model.getColumnIndex("Record_ID");
            if (columnRecordId >= 0 && columnRecordId >= 0) {
                KeyNamePair tableKeyPair = (KeyNamePair)this.table.getValueAt(this.table.getSelectedRow(), columnTableId);
                Integer recordId = (Integer)this.table.getValueAt(this.table.getSelectedRow(), columnRecordId);
                if (tableKeyPair != null && recordId != null) {
                    AEnv.zoom(tableKeyPair.getKey(), recordId);
                }
            }
        }
    }

    private void actionRePost() {
        if (this.accountViewerData.documentQuery && this.accountViewerData.AD_Table_ID != 0 && this.accountViewerData.Record_ID != 0 && ADialog.ask(this.accountViewerData.WindowNo, this, "PostImmediate?")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean force = this.forcePost.isSelected();
            String error = AEnv.postImmediate(this.accountViewerData.WindowNo, this.accountViewerData.AD_Client_ID, this.accountViewerData.AD_Table_ID, this.accountViewerData.Record_ID, force);
            this.setCursor(Cursor.getDefaultCursor());
            if (error != null) {
                ADialog.error(0, this, "PostingError-N", error);
            }
            this.actionQuery();
        }
    }

    private void exportExcel() {
        block3: {
            RModel model = this.table.getRModel();
            if (model == null) {
                return;
            }
            try {
                RModelExcelExporter exporter = new RModelExcelExporter(model);
                exporter.export(null, null);
            }
            catch (Exception e) {
                ADialog.error(0, this, "Error", e.getLocalizedMessage());
                if (!CLogMgt.isLevelFinest()) break block3;
                e.printStackTrace();
            }
        }
    }
}

