/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA.exceptions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ArhRuntimeException
extends AdempiereException {
    private static final long serialVersionUID = -100343773302909791L;
    private HashMap<String, Object> m_info = new HashMap();

    public ArhRuntimeException() {
    }

    public ArhRuntimeException(String string) {
        super(string);
    }

    public ArhRuntimeException(Properties properties, String string) {
        this(string);
    }

    public ArhRuntimeException(Throwable throwable) {
        super(throwable);
    }

    public ArhRuntimeException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Override
    public String getLocalizedMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = Env.getCtx();
        String string = this.getMessage();
        if (string != null && string.length() > 0) {
            stringBuffer.append(Msg.parseTranslation(properties, string));
        } else {
            string = null;
        }
        if (this.m_info.size() > 0) {
            Iterator<String> iterator = this.m_info.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Object object = this.m_info.get(string2);
                if (n == 0) {
                    if (string != null) {
                        stringBuffer.append(" (");
                    }
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Msg.parseTranslation(properties, string2));
                String string3 = this.getStringValue(object);
                if (object != null && string3.length() > 0) {
                    stringBuffer.append(" ").append(string3);
                }
                ++n;
            }
            if (n > 0 && string != null) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public void saveError(CLogger cLogger) {
        cLogger.saveError("Error", this.getLocalizedMessage());
    }

    public ArhRuntimeException addInfo(String string, boolean bl) {
        return this.addInfo(string, (Object)bl);
    }

    public ArhRuntimeException addInfo(String string) {
        return this.addInfo(string, "");
    }

    public ArhRuntimeException addInfo(String string, Object object) {
        if (string == null) {
            return this;
        }
        this.m_info.put(string, object);
        return this;
    }

    public ArhRuntimeException addField(String string, Object object) {
        this.addInfo("@" + string + "@ =", object);
        return this;
    }

    public boolean hasInfo() {
        return !this.m_info.isEmpty();
    }

    private String getStringValue(Object object) {
        String string = null;
        if (object == null) {
            string = "-";
        } else if (object instanceof Boolean) {
            string = Msg.getMsg(Env.getCtx(), (Boolean)object != false ? "Yes" : "No");
        } else if (object instanceof Timestamp) {
            SimpleDateFormat simpleDateFormat = DisplayType.getDateFormat();
            string = simpleDateFormat.format((Timestamp)object);
        } else {
            string = object.toString();
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage();
    }
}

