/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MConversionRate;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.compiere.util.Login;

class Base {
    Base() {
    }

    public static void test() {
        System.out.println("** Before Init **");
        Base.getMemoryUsed();
        Properties ctx = Login.initTest(false);
        System.gc();
        System.out.println("** Before Creation **");
        long start = Base.getMemoryUsed();
        int AD_Window_ID = 102;
        long startTime = System.currentTimeMillis();
        GridWindowVO vo = GridWindowVO.create(Env.getCtx(), 1, AD_Window_ID);
        GridWindow w = new GridWindow(vo);
        long endDef = System.currentTimeMillis();
        System.out.println("Load Definition Time in ms = " + String.valueOf(endDef - startTime));
        w.query();
        long endData = System.currentTimeMillis();
        System.out.println("Load Data Time in ms = " + String.valueOf(endData - startTime));
        w.loadCompete();
        long endDataComplete = System.currentTimeMillis();
        System.out.println("Load Data Complete Time in ms = " + String.valueOf(endDataComplete - startTime));
        w.getTab(0).navigate(0);
        System.out.println("** Before Dispose **");
        Base.getMemoryUsed();
        w.dispose();
        System.out.println("** Before GC **");
        Base.getMemoryUsed();
        w = null;
        System.gc();
        System.out.println("** After GC **");
        Base.getMemoryUsed();
        System.gc();
        System.out.println("** Final **");
        long complete = System.currentTimeMillis();
        System.out.println("Complete Time in ms = " + String.valueOf(complete - startTime));
        long end = Base.getMemoryUsed();
        System.out.println("Memory increase in kB = End-Start=" + String.valueOf((end - start) / 1024L));
        Base.listThreads();
        System.out.println("API Test");
        System.out.println("64.72=" + MConversionRate.convert(ctx, new BigDecimal(100.0), 116, 100, 0, 0));
        System.out.println("0.647169=" + MConversionRate.getRate(116, 100, null, 0, 0, 0));
        System.out.println("12.5=" + MUOMConversion.convert(101, 102, new BigDecimal(100.0), true));
    }

    private static long getMemoryUsed() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        System.out.println("Memory used in kB = Total(" + String.valueOf(total / 1024L) + ")-Free(" + String.valueOf(free / 1024L) + ") = " + String.valueOf(used / 1024L));
        System.out.println("Active Threads=" + Thread.activeCount());
        return used;
    }

    private static void sleep() {
        System.out.println(".. sleeping-ini .. -> " + Thread.activeCount());
        Thread.yield();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(".. sleeping-end .. -> " + Thread.activeCount());
    }

    private static void listThreads() {
        Thread[] list = new Thread[Thread.activeCount()];
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            System.out.println("Thread " + i + " - " + list[i].toString());
        }
    }

    public static void main(String[] args) {
        Base.test();
        Env.exitEnv(0);
    }
}

