/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.Adempiere;
import org.compiere.model.MEXPFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.w3c.dom.Document;

public class ModelExporter
extends SvrProcess {
    protected int p_AD_Client_ID = 0;
    protected int p_C_DocType_ID = 0;
    protected int p_Record_ID = 0;
    protected int p_EXP_Format_ID = 0;
    protected String p_FileName = "";
    int AD_Table_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] paras;
        this.p_Record_ID = this.getRecord_ID();
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        }
        this.AD_Table_ID = this.getTable_ID();
        StringBuffer sb = new StringBuffer("AD_Table_ID=").append(this.AD_Table_ID);
        sb.append("; Record_ID=").append(this.getRecord_ID());
        for (ProcessInfoParameter para : paras = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("EXP_Format_ID")) {
                this.p_EXP_Format_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("FileName")) {
                this.p_FileName = (String)para.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_EXP_Format_ID == 0) {
            this.p_EXP_Format_ID = this.p_Record_ID;
        }
        if (this.p_FileName == null) {
            String fileNameOr;
            this.p_FileName = fileNameOr = Ini.findAdempiereHome() + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "ExportFile.xml";
        }
        this.log.info(sb.toString());
    }

    @Override
    protected String doIt() throws Exception {
        ExportHelper expHelper = new ExportHelper(this.getCtx(), this.p_AD_Client_ID);
        MEXPFormat exportFormat = new MEXPFormat(this.getCtx(), this.p_EXP_Format_ID, this.get_TrxName());
        File file = new File(this.p_FileName);
        Document doc = expHelper.exportRecord(exportFormat, "", 0, "M", (Integer)5);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("method", "xml");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult dest2 = new StreamResult(writer);
        aTransformer.transform(src, dest2);
        try {
            StreamResult dest = new StreamResult(file);
            aTransformer.transform(src, dest);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return "Exported";
    }

    public static void main(String[] args) {
        CLogMgt.setLoggerLevel(Level.INFO, null);
        CLogMgt.setLevel(Level.INFO);
        Adempiere.startupEnvironment(true);
        ProcessInfo pi = new ProcessInfo("Test Import Model", 1000000);
        pi.setAD_Client_ID(11);
        pi.setAD_User_ID(100);
        ModelExporter modelExporter = new ModelExporter();
        modelExporter.startProcess(Env.getCtx(), pi, null);
    }
}

