/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.process.YearEndClosingAbstract;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class YearEndClosing
extends YearEndClosingAbstract {
    @Override
    protected String doIt() throws Exception {
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName());
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        BigDecimal balance = Env.ZERO;
        journalBatch.setAD_Org_ID(this.getOrgId());
        journalBatch.setDateAcct(this.getDateAcct());
        journalBatch.setDateDoc(this.getDateAcct());
        journalBatch.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing") + this.getDateAcct());
        journalBatch.setC_DocType_ID(this.getDocTypeId());
        journalBatch.setDocumentNo(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing") + this.getDateAcct());
        journalBatch.setGL_Category_ID(this.getCategoryId());
        journalBatch.setControlAmt(Env.ZERO);
        journalBatch.setC_Currency_ID(as.getC_Currency_ID());
        journalBatch.set_ValueOfColumn("IsYearEndClosing", (Object)true);
        journalBatch.saveEx();
        String whereClause = "accounttype in ('E', 'R')  and ISSUMMARY = 'N' ";
        List sourceAccounts = new Query(this.getCtx(), "C_ElementValue", whereClause, this.get_TrxName()).setOrderBy("value").list();
        for (MElementValue sourceAccount : sourceAccounts) {
            balance = this.searchBalance(sourceAccount.getC_ElementValue_ID());
            if (balance.signum() == 0) continue;
            this.createJournal(as, journalBatch, sourceAccount, balance);
        }
        return Msg.getMsg(Env.getAD_Language(this.getCtx()), "DocumentNo") + ": " + journalBatch.getDocumentNo();
    }

    private Boolean createJournal(MAcctSchema as, MJournalBatch journalBatch, MElementValue sourceAccount, BigDecimal balance) {
        MJournal journal = new MJournal(journalBatch);
        if (journal == null) {
            return false;
        }
        journal.setC_Currency_ID(as.getC_Currency_ID());
        journal.setC_AcctSchema_ID(as.get_ID());
        journal.setC_ConversionType_ID(114);
        journal.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Year-end Closing") + sourceAccount.getValue() + " " + sourceAccount.getName());
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setGL_Category_ID(this.getCategoryId());
        journal.saveEx();
        if (!this.createLines(journal, sourceAccount, balance).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean createLines(MJournal journal, MElementValue sourceAccount, BigDecimal balance) {
        if (balance.signum() == 0) {
            return true;
        }
        MJournalLine debit = new MJournalLine(journal);
        MJournalLine credit = new MJournalLine(journal);
        if (sourceAccount.getAccountType().equals("R")) {
            debit.setAccount_ID(sourceAccount.getC_ElementValue_ID());
            debit.setAmtSourceDr(balance.negate());
            debit.setDescription(sourceAccount.getName());
            debit.saveEx();
            credit.setAccount_ID(this.getTargetAccountId());
            credit.setAmtSourceCr(balance.negate());
            credit.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Target"));
            credit.saveEx();
        } else {
            credit.setAccount_ID(sourceAccount.getC_ElementValue_ID());
            credit.setAmtSourceCr(balance);
            credit.setDescription(sourceAccount.getName());
            credit.saveEx();
            debit.setAccount_ID(this.getTargetAccountId());
            debit.setAmtSourceDr(balance);
            debit.setDescription(Msg.getMsg(Env.getAD_Language(this.getCtx()), "Target"));
            debit.saveEx();
        }
        return true;
    }

    private BigDecimal searchBalance(int cElementvalueID) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.getDateAcct());
        parameters.add(this.getDateAcct());
        parameters.add(Env.getAD_Client_ID(this.getCtx()));
        parameters.add(cElementvalueID);
        String whereClause = " DATEACCT between Firstof(?,  'YY') AND ?  AND AD_CLIENT_ID = ? AND ACCOUNT_ID = ? AND PostingType = 'A' AND AD_Org_ID = " + this.getOrgId();
        BigDecimal balance = new Query(this.getCtx(), "Fact_Acct", whereClause, this.get_TrxName()).setParameters(parameters).aggregate("amtacctdr - amtacctcr", "SUM");
        return balance;
    }
}

