/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.process.GardenWorldCleanUp;
import org.compiere.process.MigrationFromXML;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdate;
import org.compiere.process.SequenceCheck;
import org.compiere.process.SynchronizeTerminology;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;

public class MigrationLoader {
    private static CLogger log = CLogger.getCLogger(MigrationLoader.class);

    public static void main(String[] args) {
        boolean clean_arg = false;
        boolean force_arg = false;
        if (args != null) {
            for (String arg : args) {
                if (Util.isEmpty(arg)) continue;
                if (arg.equals("clean")) {
                    clean_arg = true;
                    continue;
                }
                if (!arg.equals("force")) continue;
                force_arg = true;
            }
        }
        Adempiere.startupEnvironment(false);
        CLogMgt.setLevel(Level.CONFIG);
        if (!DB.isConnected()) {
            log.info("No DB Connection");
            System.exit(1);
        }
        Ini.setProperty("LogMigrationScript", false);
        String fileName = Adempiere.getAdempiereHome() + File.separator + "migration";
        boolean apply = true;
        boolean failOnError = true;
        boolean clean = clean_arg;
        Properties context = Env.getCtx();
        try {
            ProcessInfo processInfo = ProcessBuilder.create(context).process(MigrationFromXML.class).withTitle("Import Migration from XML").withParameter("FailOnError", failOnError).withParameter("FilePathOrName", fileName).withParameter("Apply", apply).withParameter("IsForce", force_arg).withParameter("Clean", clean).execute();
            log.log(Level.CONFIG, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            if (failOnError && processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            processInfo = ProcessBuilder.create(context).process(SequenceCheck.class).withTitle("Sequence Check").execute();
            log.log(Level.CONFIG, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            processInfo = ProcessBuilder.create(context).process(SynchronizeTerminology.class).withTitle("Synchronize Terminology").withParameter("IsCreateElement", false).withParameter("IsDeletingUnusedElement", false).execute();
            log.log(Level.CONFIG, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            processInfo = ProcessBuilder.create(context).process(RoleAccessUpdate.class).withTitle("Role Access Update").withParameter("AD_Client_ID", 0).executeUsingSystemRole();
            log.log(Level.CONFIG, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            processInfo = ProcessBuilder.create(context).process(GardenWorldCleanUp.class).withTitle("Updating Garden World").executeUsingSystemRole();
            log.log(Level.CONFIG, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
        }
        catch (AdempiereException e) {
            e.printStackTrace();
        }
    }
}

