/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.util;

import java.lang.reflect.Constructor;
import org.adempiere.pos.service.CPOS;
import org.adempiere.pos.util.POSGenericTicketHandler;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public abstract class POSTicketHandler {
    private CPOS pos;
    protected static CLogger log = CLogger.getCLogger(POSTicketHandler.class);
    private static CCache<String, POSTicketHandler> s_cache = new CCache("POSTicketHandler", 40, 5);

    public POSTicketHandler(CPOS cPOS) {
        this.pos = cPOS;
    }

    public CPOS getPOS() {
        return this.pos;
    }

    public void setPOS(CPOS cPOS) {
        this.pos = cPOS;
    }

    public static POSTicketHandler getTicketHandler(CPOS cPOS) {
        if (cPOS == null) {
            log.severe("Not have POS");
            return null;
        }
        String string = cPOS.getTicketHandlerClassName();
        if (string == null || string.trim().length() == 0) {
            log.fine("Get from GenericTicketHandlerClass");
            return new POSGenericTicketHandler(cPOS);
        }
        POSTicketHandler pOSTicketHandler = null;
        pOSTicketHandler = s_cache.get(string);
        if (pOSTicketHandler != null) {
            pOSTicketHandler.setPOS(cPOS);
            return pOSTicketHandler;
        }
        try {
            Class<?> clazz = Class.forName(string);
            for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null && clazz2 != POSTicketHandler.class; clazz2 = clazz2.getSuperclass()) {
            }
            Constructor<?> constructor = null;
            constructor = clazz.getDeclaredConstructor(CPOS.class);
            pOSTicketHandler = (POSTicketHandler)constructor.newInstance(cPOS);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        if (pOSTicketHandler != null) {
            s_cache.put(string, pOSTicketHandler);
        }
        return pOSTicketHandler;
    }

    public abstract void printTicket();

    public abstract void openDrawer();

    public abstract void showMessage(String var1);
}

