/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.service;

import java.math.BigDecimal;
import org.compiere.model.MImage;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.util.Env;

public class ProductInfo {
    public String value;
    public String name;
    public String description;
    public String uomSymbol;
    public String productCategoryName;
    public String productTaxCategory;
    public BigDecimal priceStd;
    public BigDecimal priceList;
    public BigDecimal priceLimit;
    public byte[] imageData;

    public ProductInfo(int n, BigDecimal bigDecimal, int n2, int n3, int n4) {
        MProduct mProduct = MProduct.get(Env.getCtx(), n);
        MProductPricing mProductPricing = new MProductPricing(n, n4, bigDecimal, true, null);
        mProductPricing.setM_PriceList_ID(n3);
        mProductPricing.calculatePrice();
        this.value = mProduct.getValue();
        this.name = mProduct.getName();
        this.description = mProduct.getDescription();
        this.uomSymbol = mProduct.getC_UOM().getUOMSymbol();
        this.productCategoryName = mProduct.getM_Product_Category().getName();
        this.productTaxCategory = mProduct.getC_TaxCategory().getName();
        this.priceStd = mProductPricing.getPriceStd();
        this.priceList = mProductPricing.getPriceList();
        this.priceLimit = mProductPricing.getPriceLimit();
        MImage mImage = this.getImage(n2);
        this.imageData = mImage != null ? mImage.getData() : null;
    }

    public MImage getImage(int n) {
        if (n != 0) {
            MImage mImage = MImage.get(Env.getCtx(), n);
            return mImage;
        }
        return null;
    }
}

